/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.AppOpsManager;
import android.app.Dialog;
import android.app.NotificationManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageInstaller;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.text.TextUtils;
import android.util.Log;
import android.util.TypedValue;
import com.google.android.gms.R;
import com.google.android.gms.common.ErrorDialogFragment;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.SupportErrorDialogFragment;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.internal.zzm;
import com.google.android.gms.common.zzc;
import com.google.android.gms.common.zzd;
import com.google.android.gms.internal.zzkz;
import com.google.android.gms.internal.zzlk;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public final class GooglePlayServicesUtil {
    @Deprecated
    public static final int GOOGLE_PLAY_SERVICES_VERSION_CODE = GooglePlayServicesUtil.zzml();
    public static boolean zzVS = false;
    public static boolean zzVT = false;
    private static int zzVU = -1;
    private static final Object zzoW = new Object();
    private static String zzVV = null;
    private static Integer zzVW = null;
    static final AtomicBoolean zzVX = new AtomicBoolean();

    private GooglePlayServicesUtil() {
    }

    private static int zzml() {
        return 7571000;
    }

    @Deprecated
    public static int isGooglePlayServicesAvailable(Context context) {
        Resources resources;
        if (com.google.android.gms.common.internal.zzd.zzZR) {
            return 0;
        }
        PackageManager packageManager = context.getPackageManager();
        try {
            resources = context.getResources();
            resources.getString(R.string.common_google_play_services_unknown_issue);
        }
        catch (Throwable throwable) {
            Log.e((String)"GooglePlayServicesUtil", (String)"The Google Play services resources were not found. Check your project configuration to ensure that the resources are included.");
        }
        if (!"com.google.android.gms".equals(context.getPackageName())) {
            GooglePlayServicesUtil.zzaa(context);
        }
        try {
            resources = packageManager.getPackageInfo("com.google.android.gms", 64);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.w((String)"GooglePlayServicesUtil", (String)"Google Play services is missing.");
            return 1;
        }
        zzd zzd2 = zzd.zzmn();
        if (zzkz.zzbP(resources.versionCode) || zzkz.zzai(context)) {
            if (zzd2.zza((PackageInfo)resources, zzc.zzbk.zzVR) == null) {
                Log.w((String)"GooglePlayServicesUtil", (String)"Google Play services signature invalid.");
                return 9;
            }
        } else {
            try {
                PackageInfo packageInfo = packageManager.getPackageInfo("com.android.vending", 64);
                zzc.zza zza2 = zzd2.zza(packageInfo, zzc.zzbk.zzVR);
                if (zza2 == null) {
                    Log.w((String)"GooglePlayServicesUtil", (String)"Google Play Store signature invalid.");
                    return 9;
                }
                if (zzd2.zza((PackageInfo)resources, zza2) == null) {
                    Log.w((String)"GooglePlayServicesUtil", (String)"Google Play services signature invalid.");
                    return 9;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                if (GooglePlayServicesUtil.zzh(context, "com.android.vending")) {
                    Log.w((String)"GooglePlayServicesUtil", (String)"Google Play Store is updating.");
                    if (zzd2.zza((PackageInfo)resources, zzc.zzbk.zzVR) == null) {
                        Log.w((String)"GooglePlayServicesUtil", (String)"Google Play services signature invalid.");
                        return 9;
                    }
                }
                Log.w((String)"GooglePlayServicesUtil", (String)"Google Play Store is neither installed nor updating.");
                return 9;
            }
        }
        int n = zzkz.zzbN(GOOGLE_PLAY_SERVICES_VERSION_CODE);
        int n2 = zzkz.zzbN(resources.versionCode);
        if (n2 < n) {
            Log.w((String)"GooglePlayServicesUtil", (String)("Google Play services out of date.  Requires " + GOOGLE_PLAY_SERVICES_VERSION_CODE + " but found " + resources.versionCode));
            return 2;
        }
        ApplicationInfo applicationInfo = resources.applicationInfo;
        if (applicationInfo == null) {
            try {
                applicationInfo = packageManager.getApplicationInfo("com.google.android.gms", 0);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                Log.wtf((String)"GooglePlayServicesUtil", (String)"Google Play services missing when getting application info.");
                nameNotFoundException.printStackTrace();
                return 1;
            }
        }
        if (!applicationInfo.enabled) {
            return 3;
        }
        return 0;
    }

    @Deprecated
    public static void zzY(Context context) throws GooglePlayServicesRepairableException, GooglePlayServicesNotAvailableException {
        int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable(context);
        if (n != 0) {
            Intent intent = GooglePlayServicesUtil.zzaT(n);
            Log.e((String)"GooglePlayServicesUtil", (String)("GooglePlayServices not available due to error " + n));
            if (intent == null) {
                throw new GooglePlayServicesNotAvailableException(n);
            }
            throw new GooglePlayServicesRepairableException(n, "Google Play Services not available", intent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zzaa(Context context) {
        Integer n;
        Object object = zzoW;
        synchronized (object) {
            block11: {
                if (zzVV == null) {
                    zzVV = context.getPackageName();
                    try {
                        ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
                        Bundle bundle = applicationInfo.metaData;
                        if (bundle != null) {
                            zzVW = bundle.getInt("com.google.android.gms.version");
                            break block11;
                        }
                        zzVW = null;
                    }
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        Log.wtf((String)"GooglePlayServicesUtil", (String)"This should never happen.", (Throwable)nameNotFoundException);
                    }
                } else if (!zzVV.equals(context.getPackageName())) {
                    throw new IllegalArgumentException("isGooglePlayServicesAvailable should only be called with Context from your application's package. A previous call used package '" + zzVV + "' and this call used package '" + context.getPackageName() + "'.");
                }
            }
            n = zzVW;
        }
        if (n == null) {
            throw new IllegalStateException("A required meta-data tag in your app's AndroidManifest.xml does not exist.  You must have the following declaration within the <application> element:     <meta-data android:name=\"com.google.android.gms.version\" android:value=\"@integer/google_play_services_version\" />");
        }
        if (n != GOOGLE_PLAY_SERVICES_VERSION_CODE) {
            throw new IllegalStateException("The meta-data tag in your app's AndroidManifest.xml does not have the right value.  Expected " + GOOGLE_PLAY_SERVICES_VERSION_CODE + " but" + " found " + n + ".  You must have the" + " following declaration within the <application> element: " + "    <meta-data android:name=\"" + "com.google.android.gms.version" + "\" android:value=\"@integer/google_play_services_version\" />");
        }
    }

    public static boolean zzd(Context context, int n) {
        return GooglePlayServicesUtil.zza(context, n, "com.google.android.gms") && GooglePlayServicesUtil.zzb(context.getPackageManager(), "com.google.android.gms");
    }

    public static boolean zza(Context context, int n, String string2) {
        if (zzlk.zzoX()) {
            AppOpsManager appOpsManager = (AppOpsManager)context.getSystemService("appops");
            try {
                appOpsManager.checkPackage(n, string2);
                return true;
            }
            catch (SecurityException securityException) {
                return false;
            }
        }
        PackageManager packageManager = context.getPackageManager();
        String[] stringArray = packageManager.getPackagesForUid(n);
        if (string2 != null && stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string2.equals(stringArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public static boolean zzb(PackageManager packageManager, String string2) {
        return zzd.zzmn().zzb(packageManager, string2);
    }

    @Deprecated
    public static Intent zzaT(int n) {
        switch (n) {
            case 1: 
            case 2: {
                return zzm.zzcg("com.google.android.gms");
            }
            case 42: {
                return zzm.zznX();
            }
            case 3: {
                return zzm.zzce("com.google.android.gms");
            }
        }
        return null;
    }

    public static boolean zzmm() {
        if (zzVS) {
            return zzVT;
        }
        return "user".equals(Build.TYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean zzb(PackageManager packageManager) {
        Object object = zzoW;
        synchronized (object) {
            if (zzVU == -1) {
                try {
                    PackageInfo packageInfo = packageManager.getPackageInfo("com.google.android.gms", 64);
                    zzVU = zzd.zzmn().zza(packageInfo, zzc.zzVK[1]) != null ? 1 : 0;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    zzVU = 0;
                }
            }
        }
        return zzVU != 0;
    }

    public static boolean zzc(PackageManager packageManager) {
        return GooglePlayServicesUtil.zzb(packageManager) || !GooglePlayServicesUtil.zzmm();
    }

    @Deprecated
    public static Dialog getErrorDialog(int errorCode, Activity activity, int requestCode) {
        return GooglePlayServicesUtil.getErrorDialog(errorCode, activity, requestCode, null);
    }

    @Deprecated
    public static Dialog getErrorDialog(int errorCode, Activity activity, int requestCode, DialogInterface.OnCancelListener cancelListener) {
        return GooglePlayServicesUtil.zza(errorCode, activity, null, requestCode, cancelListener);
    }

    private static Dialog zza(int n, Activity activity, Fragment fragment, int n2, DialogInterface.OnCancelListener onCancelListener) {
        String string2;
        String string3;
        Object object;
        if (n == 0) {
            return null;
        }
        if (zzkz.zzai((Context)activity) && n == 2) {
            n = 42;
        }
        AlertDialog.Builder builder = null;
        if (zzlk.zzoU()) {
            object = new TypedValue();
            activity.getTheme().resolveAttribute(16843529, object, true);
            string3 = activity.getResources().getResourceEntryName(object.resourceId);
            if ("Theme.Dialog.Alert".equals(string3)) {
                builder = new AlertDialog.Builder((Context)activity, 5);
            }
        }
        if (builder == null) {
            builder = new AlertDialog.Builder((Context)activity);
        }
        object = GooglePlayServicesUtil.zzad((Context)activity);
        builder.setMessage((CharSequence)zzf.zzb((Context)activity, n, (String)object));
        if (onCancelListener != null) {
            builder.setOnCancelListener(onCancelListener);
        }
        string3 = GooglePlayServicesUtil.zzaT(n);
        zzg zzg2 = fragment == null ? new zzg(activity, (Intent)string3, n2) : new zzg(fragment, (Intent)string3, n2);
        String string4 = zzf.zzh((Context)activity, n);
        if (string4 != null) {
            builder.setPositiveButton((CharSequence)string4, (DialogInterface.OnClickListener)zzg2);
        }
        if ((string2 = zzf.zzg((Context)activity, n)) != null) {
            builder.setTitle((CharSequence)string2);
        }
        return builder.create();
    }

    public static boolean showErrorDialogFragment(int errorCode, Activity activity, Fragment fragment, int requestCode, DialogInterface.OnCancelListener cancelListener) {
        boolean bl;
        Dialog dialog = GooglePlayServicesUtil.zza(errorCode, activity, fragment, requestCode, cancelListener);
        if (dialog == null) {
            return false;
        }
        try {
            bl = activity instanceof FragmentActivity;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            bl = false;
        }
        if (bl) {
            FragmentManager fragmentManager = ((FragmentActivity)activity).getSupportFragmentManager();
            SupportErrorDialogFragment supportErrorDialogFragment = SupportErrorDialogFragment.newInstance(dialog, cancelListener);
            supportErrorDialogFragment.show(fragmentManager, "GooglePlayServicesErrorDialog");
        } else if (zzlk.zzoR()) {
            android.app.FragmentManager fragmentManager = activity.getFragmentManager();
            ErrorDialogFragment errorDialogFragment = ErrorDialogFragment.newInstance(dialog, cancelListener);
            errorDialogFragment.show(fragmentManager, "GooglePlayServicesErrorDialog");
        } else {
            throw new RuntimeException("This Activity does not support Fragments.");
        }
        return true;
    }

    @Deprecated
    public static void zzac(Context context) {
        if (zzVX.getAndSet(true)) {
            return;
        }
        try {
            NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
            notificationManager.cancel(10436);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @Deprecated
    public static boolean isUserRecoverableError(int errorCode) {
        switch (errorCode) {
            case 1: 
            case 2: 
            case 3: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    public static Resources getRemoteResource(Context context) {
        try {
            return context.getPackageManager().getResourcesForApplication("com.google.android.gms");
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    public static Context getRemoteContext(Context context) {
        try {
            return context.createPackageContext("com.google.android.gms", 3);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    public static String zzad(Context context) {
        String string2 = context.getApplicationInfo().name;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            ApplicationInfo applicationInfo;
            string2 = context.getPackageName();
            PackageManager packageManager = context.getApplicationContext().getPackageManager();
            try {
                applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 0);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                applicationInfo = null;
            }
            if (applicationInfo != null) {
                string2 = packageManager.getApplicationLabel(applicationInfo).toString();
            }
        }
        return string2;
    }

    @Deprecated
    public static boolean zze(Context context, int n) {
        if (n == 18) {
            return true;
        }
        if (n == 1) {
            return GooglePlayServicesUtil.zzh(context, "com.google.android.gms");
        }
        return false;
    }

    public static boolean zzh(Context context, String string2) {
        if (zzlk.zzoZ()) {
            List list = context.getPackageManager().getPackageInstaller().getAllSessions();
            for (PackageInstaller.SessionInfo sessionInfo : list) {
                if (!string2.equals(sessionInfo.getAppPackageName())) continue;
                return true;
            }
        } else {
            PackageManager packageManager = context.getPackageManager();
            try {
                if (packageManager.getApplicationInfo((String)string2, (int)8192).enabled) {
                    return true;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }
        return false;
    }
}

