/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.ICancelToken;
import com.google.android.gms.common.internal.zzu;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;

public abstract class AbstractPendingResult<R extends Result>
implements PendingResult<R> {
    private final Object zzWb = new Object();
    protected final CallbackHandler<R> mHandler;
    private final CountDownLatch zzoD = new CountDownLatch(1);
    private final ArrayList<PendingResult.BatchCallback> zzWc = new ArrayList();
    private ResultCallback<R> zzWd;
    private volatile R zzWe;
    private volatile boolean zzWf;
    private boolean zzL;
    private boolean zzWg;
    private ICancelToken zzWh;

    protected AbstractPendingResult(Looper looper) {
        this.mHandler = new CallbackHandler(looper);
    }

    public final boolean isReady() {
        return this.zzoD.getCount() == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setResultCallback(ResultCallback<R> callback) {
        zzu.zza(!this.zzWf, "Result has already been consumed.");
        Object object = this.zzWb;
        synchronized (object) {
            if (this.isCanceled()) {
                return;
            }
            if (this.isReady()) {
                this.mHandler.sendResultCallback(callback, this.zzmo());
            } else {
                this.zzWd = callback;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.zzWb;
        synchronized (object) {
            if (this.zzL || this.zzWf) {
                return;
            }
            if (this.zzWh != null) {
                try {
                    this.zzWh.cancel();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            AbstractPendingResult.zzb(this.zzWe);
            this.zzWd = null;
            this.zzL = true;
            this.zza(this.createFailedResult(Status.zzXT));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCanceled() {
        Object object = this.zzWb;
        synchronized (object) {
            return this.zzL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setResult(R result) {
        Object object = this.zzWb;
        synchronized (object) {
            if (this.zzWg || this.zzL) {
                AbstractPendingResult.zzb(result);
                return;
            }
            zzu.zza(!this.isReady(), "Results have already been set");
            zzu.zza(!this.zzWf, "Result has already been consumed");
            this.zza(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void forceFailureUnlessReady(Status status) {
        Object object = this.zzWb;
        synchronized (object) {
            if (!this.isReady()) {
                this.setResult(this.createFailedResult(status));
                this.zzWg = true;
            }
        }
    }

    protected abstract R createFailedResult(Status var1);

    protected void onResultConsumed() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private R zzmo() {
        R r;
        Object object = this.zzWb;
        synchronized (object) {
            zzu.zza(!this.zzWf, "Result has already been consumed.");
            zzu.zza(this.isReady(), "Result is not ready.");
            r = this.zzWe;
            this.zzWe = null;
            this.zzWd = null;
            this.zzWf = true;
        }
        this.onResultConsumed();
        return r;
    }

    private void zza(R r) {
        this.zzWe = r;
        this.zzWh = null;
        this.zzoD.countDown();
        Status status = this.zzWe.getStatus();
        if (this.zzWd != null) {
            this.mHandler.removeTimeoutMessages();
            if (!this.zzL) {
                this.mHandler.sendResultCallback(this.zzWd, this.zzmo());
            }
        }
        for (PendingResult.BatchCallback batchCallback : this.zzWc) {
            batchCallback.zzs(status);
        }
        this.zzWc.clear();
    }

    static void zzb(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)((Object)result)).release();
            }
            catch (RuntimeException runtimeException) {
                Log.w((String)"AbstractPendingResult", (String)("Unable to release " + result), (Throwable)runtimeException);
            }
        }
    }

    public static class CallbackHandler<R extends Result>
    extends Handler {
        public CallbackHandler() {
            this(Looper.getMainLooper());
        }

        public CallbackHandler(Looper looper) {
            super(looper);
        }

        public void sendResultCallback(ResultCallback<R> callback, R result) {
            this.sendMessage(this.obtainMessage(1, new Pair(callback, result)));
        }

        public void removeTimeoutMessages() {
            this.removeMessages(2);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Pair pair = (Pair)msg.obj;
                    this.deliverResultCallback((ResultCallback)pair.first, (Result)pair.second);
                    return;
                }
                case 2: {
                    AbstractPendingResult abstractPendingResult = (AbstractPendingResult)msg.obj;
                    abstractPendingResult.forceFailureUnlessReady(Status.zzXS);
                    return;
                }
            }
            Log.wtf((String)"AbstractPendingResult", (String)"Don't know how to handle this message.");
        }

        protected void deliverResultCallback(ResultCallback<R> callback, R result) {
            try {
                callback.onResult(result);
            }
            catch (RuntimeException runtimeException) {
                AbstractPendingResult.zzb(result);
                throw runtimeException;
            }
        }
    }
}

