/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.accounts.Account;
import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.common.api.zzg;
import com.google.android.gms.common.api.zzm;
import com.google.android.gms.common.api.zzn;
import com.google.android.gms.common.internal.zze;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.internal.zzpq;
import com.google.android.gms.internal.zzps;
import com.google.android.gms.internal.zzpt;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public interface GoogleApiClient {
    public <A extends Api.Client, R extends Result, T extends zza.zza<R, A>> T zza(T var1);

    public <A extends Api.Client, T extends zza.zza<? extends Result, A>> T zzb(T var1);

    public Looper getLooper();

    public void connect();

    public void disconnect();

    public boolean isConnected();

    public boolean isConnecting();

    public void registerConnectionCallbacks(ConnectionCallbacks var1);

    public void unregisterConnectionCallbacks(ConnectionCallbacks var1);

    public void registerConnectionFailedListener(OnConnectionFailedListener var1);

    public void unregisterConnectionFailedListener(OnConnectionFailedListener var1);

    public void dump(String var1, FileDescriptor var2, PrintWriter var3, String[] var4);

    public static final class Builder {
        private Account zzMY;
        private final Set<Scope> zzWv = new HashSet<Scope>();
        private int zzWw;
        private View zzWx;
        private String zzOe;
        private String zzOd;
        private final Map<Api<?>, zze.zza> zzWy = new HashMap();
        private final Context mContext;
        private final Map<Api<?>, Api.ApiOptions> zzWz = new HashMap();
        private FragmentActivity zzWA;
        private int zzWB = -1;
        private int zzWC = -1;
        private OnConnectionFailedListener zzWD;
        private Looper zzWt;
        private Api.zza<? extends zzps, zzpt> zzWE;
        private final Set<ConnectionCallbacks> zzWF = new HashSet<ConnectionCallbacks>();
        private final Set<OnConnectionFailedListener> zzWG = new HashSet<OnConnectionFailedListener>();
        private zzpt.zza zzWH = new zzpt.zza();

        public Builder(Context context) {
            this.mContext = context;
            this.zzWt = context.getMainLooper();
            this.zzOe = context.getPackageName();
            this.zzOd = context.getClass().getName();
            this.zzWE = zzpq.zzNY;
        }

        public Builder addConnectionCallbacks(ConnectionCallbacks listener) {
            this.zzWF.add(listener);
            return this;
        }

        public Builder addOnConnectionFailedListener(OnConnectionFailedListener listener) {
            this.zzWG.add(listener);
            return this;
        }

        public Builder addApi(Api<? extends Api.ApiOptions.NotRequiredOptions> api) {
            this.zzWz.put(api, null);
            this.zzWv.addAll(api.zzmr());
            return this;
        }

        public zze zzmx() {
            return new zze(this.zzMY, this.zzWv, this.zzWy, this.zzWw, this.zzWx, this.zzOe, this.zzOd, this.zzWH.zzyc());
        }

        public GoogleApiClient build() {
            zzu.zzb(!this.zzWz.isEmpty(), (Object)"must call addApi() to add at least one API");
            if (this.zzWB >= 0) {
                return this.zzmy();
            }
            if (this.zzWC >= 0) {
                return this.zzmz();
            }
            return new zzg(this.mContext, this.zzWt, this.zzmx(), this.zzWE, this.zzWz, this.zzWF, this.zzWG, -1, -1);
        }

        private GoogleApiClient zzmy() {
            zzm zzm2 = zzm.zza(this.zzWA);
            zzg zzg2 = new zzg(this.mContext.getApplicationContext(), this.zzWt, this.zzmx(), this.zzWE, this.zzWz, this.zzWF, this.zzWG, this.zzWB, -1);
            zzm2.zza(this.zzWB, zzg2, this.zzWD);
            return zzg2;
        }

        private GoogleApiClient zzmz() {
            zzn zzn2 = zzn.zzb(this.zzWA);
            GoogleApiClient googleApiClient = zzn2.zzbc(this.zzWC);
            if (googleApiClient == null) {
                googleApiClient = new zzg(this.mContext.getApplicationContext(), this.zzWt, this.zzmx(), this.zzWE, this.zzWz, this.zzWF, this.zzWG, -1, this.zzWC);
            }
            zzn2.zza(this.zzWC, googleApiClient, this.zzWD);
            return googleApiClient;
        }
    }

    public static interface ConnectionProgressReportCallbacks {
        public void onReportServiceBinding(ConnectionResult var1);

        public void onReportAccountValidation(ConnectionResult var1);
    }

    public static interface ServerAuthCodeCallbacks {
        public CheckResult onCheckServerAuthorization(String var1, Set<Scope> var2);

        public boolean onUploadServerAuthCode(String var1, String var2);

        public static class CheckResult {
            private boolean zzWI;
            private Set<Scope> zzWJ;

            public boolean zzmA() {
                return this.zzWI;
            }

            public Set<Scope> zzmB() {
                return this.zzWJ;
            }
        }
    }

    public static interface OnConnectionFailedListener {
        public void onConnectionFailed(ConnectionResult var1);
    }

    public static interface ConnectionCallbacks {
        public void onConnected(Bundle var1);

        public void onConnectionSuspended(int var1);
    }
}

