/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.PendingIntent;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.zzk;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzt;

public final class Status
implements Result,
SafeParcelable {
    public static final Status zzXP = new Status(0);
    public static final Status zzXQ = new Status(14);
    public static final Status zzXR = new Status(8);
    public static final Status zzXS = new Status(15);
    public static final Status zzXT = new Status(16);
    public static final Parcelable.Creator<Status> CREATOR = new zzk();
    private final int zzCY;
    private final int zzTS;
    private final String zzXU;
    private final PendingIntent mPendingIntent;

    Status(int versionCode, int statusCode, String statusMessage, PendingIntent pendingIntent) {
        this.zzCY = versionCode;
        this.zzTS = statusCode;
        this.zzXU = statusMessage;
        this.mPendingIntent = pendingIntent;
    }

    public Status(int statusCode) {
        this(statusCode, null);
    }

    public Status(int statusCode, String statusMessage) {
        this(1, statusCode, statusMessage, null);
    }

    public Status(int statusCode, String statusMessage, PendingIntent pendingIntent) {
        this(1, statusCode, statusMessage, pendingIntent);
    }

    PendingIntent zzmT() {
        return this.mPendingIntent;
    }

    public String getStatusMessage() {
        return this.zzXU;
    }

    int getVersionCode() {
        return this.zzCY;
    }

    public boolean hasResolution() {
        return this.mPendingIntent != null;
    }

    public boolean isSuccess() {
        return this.zzTS <= 0;
    }

    public int getStatusCode() {
        return this.zzTS;
    }

    public PendingIntent getResolution() {
        return this.mPendingIntent;
    }

    public int hashCode() {
        return zzt.hashCode(this.zzCY, this.zzTS, this.zzXU, this.mPendingIntent);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Status)) {
            return false;
        }
        Status status = (Status)obj;
        return this.zzCY == status.zzCY && this.zzTS == status.zzTS && zzt.equal(this.zzXU, status.zzXU) && zzt.equal(this.mPendingIntent, status.mPendingIntent);
    }

    private String zzmU() {
        if (this.zzXU != null) {
            return this.zzXU;
        }
        return CommonStatusCodes.getStatusCodeString(this.zzTS);
    }

    public String toString() {
        return zzt.zzt(this).zzg("statusCode", this.zzmU()).zzg("resolution", this.mPendingIntent).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zzk.zza(this, out, flags);
    }

    @Override
    public Status getStatus() {
        return this;
    }
}

