/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.common.api.zzg;
import com.google.android.gms.common.api.zzh;
import com.google.android.gms.common.internal.IAccountAccessor;
import com.google.android.gms.common.internal.ResolveAccountResponse;
import com.google.android.gms.common.internal.zze;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.internal.zzps;
import com.google.android.gms.internal.zzpt;
import com.google.android.gms.signin.internal.AuthAccountResult;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;

public class zze
implements zzh {
    private final zzg zzWK;
    private final Lock zzWL;
    private final Context mContext;
    private ConnectionResult zzWM;
    private int zzWN;
    private int zzWO = 0;
    private boolean zzWP = false;
    private int zzWQ;
    private final Bundle zzWR = new Bundle();
    private final Set<Api.ClientKey> zzWS = new HashSet<Api.ClientKey>();
    private zzps zzWT;
    private int zzWU;
    private boolean zzWV;
    private boolean zzWW;
    private IAccountAccessor zzWX;
    private boolean zzWY;
    private boolean zzWZ;
    private final com.google.android.gms.common.internal.zze zzXa;
    private final Map<Api<?>, Integer> zzXb;
    private final Api.zza<? extends zzps, zzpt> zzWE;

    public zze(zzg zzg2, com.google.android.gms.common.internal.zze zze2, Map<Api<?>, Integer> map, Api.zza<? extends zzps, zzpt> zza2, Lock lock, Context context) {
        this.zzWK = zzg2;
        this.zzXa = zze2;
        this.zzXb = map;
        this.zzWE = zza2;
        this.zzWL = lock;
        this.mContext = context;
    }

    @Override
    public String getName() {
        return "CONNECTING";
    }

    @Override
    public void begin() {
        this.zzWK.zzXn.zznU();
        this.zzWK.zzXv.clear();
        this.zzWP = false;
        this.zzWV = false;
        this.zzWM = null;
        this.zzWO = 0;
        this.zzWU = 2;
        this.zzWW = false;
        this.zzWY = false;
        int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable(this.mContext);
        if (n != 0) {
            final ConnectionResult connectionResult = new ConnectionResult(n, null);
            this.zzWK.zzXs.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    zze.this.zzWL.lock();
                    try {
                        zze.this.zzd(connectionResult);
                    }
                    finally {
                        zze.this.zzWL.unlock();
                    }
                }
            });
            return;
        }
        boolean bl = false;
        HashMap<Api.Client, zzc> hashMap = new HashMap<Api.Client, zzc>();
        for (Api<?> object : this.zzXb.keySet()) {
            Api.Client client = this.zzWK.zzXu.get(object.zzms());
            int n2 = this.zzXb.get(object);
            bl |= object.zzmp().getPriority() == 1;
            if (client.requiresSignIn()) {
                this.zzWV = true;
                if (n2 < this.zzWU) {
                    this.zzWU = n2;
                }
                if (n2 != 0) {
                    this.zzWS.add(object.zzms());
                }
            }
            hashMap.put(client, new zzc(this, object, n2));
        }
        if (bl) {
            this.zzWV = false;
        }
        if (this.zzWV) {
            this.zzXa.zza(this.zzWK.getSessionId());
            zzd zzd2 = new zzd();
            this.zzWT = this.zzWE.zza(this.mContext, this.zzWK.getLooper(), this.zzXa, this.zzXa.zznB(), zzd2, zzd2);
            this.zzWT.connect();
        }
        this.zzWQ = this.zzWK.zzXu.size();
        for (Api.Client client : this.zzWK.zzXu.values()) {
            client.connect((GoogleApiClient.ConnectionProgressReportCallbacks)hashMap.get(client));
        }
    }

    private boolean zzmC() {
        --this.zzWQ;
        if (this.zzWQ > 0) {
            return false;
        }
        if (this.zzWQ < 0) {
            Log.wtf((String)"GoogleApiClientConnecting", (String)"GoogleApiClient received too many callbacks for the given step. Clients may be in an unexpected state; GoogleApiClient will now disconnect.");
            this.zzd(new ConnectionResult(8, null));
            return false;
        }
        if (this.zzWM != null) {
            this.zzd(this.zzWM);
            return false;
        }
        return true;
    }

    private void zzmD() {
        if (this.zzWV) {
            this.zzmE();
        } else {
            this.zzmG();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zza(ResolveAccountResponse resolveAccountResponse) {
        ConnectionResult connectionResult = resolveAccountResponse.zzoa();
        this.zzWL.lock();
        try {
            if (!this.zzaW(0)) {
                return;
            }
            if (connectionResult.isSuccess()) {
                this.zzWX = resolveAccountResponse.zznZ();
                this.zzWW = true;
                this.zzWY = resolveAccountResponse.zzob();
                this.zzWZ = resolveAccountResponse.zzoc();
                this.zzmE();
            } else if (this.zzc(connectionResult)) {
                this.zzmI();
                if (this.zzWQ == 0) {
                    this.zzmG();
                }
            } else {
                this.zzd(connectionResult);
            }
        }
        finally {
            this.zzWL.unlock();
        }
    }

    private void zzmE() {
        if (this.zzWW && this.zzWQ == 0) {
            this.zzWO = 1;
            this.zzWQ = this.zzWK.zzXu.size();
            for (Api.ClientKey<?> clientKey : this.zzWK.zzXu.keySet()) {
                if (this.zzWK.zzXv.containsKey(clientKey)) {
                    if (!this.zzmC()) continue;
                    this.zzmF();
                    continue;
                }
                this.zzWK.zzXu.get(clientKey).validateAccount(this.zzWX);
            }
        }
    }

    private void zzmF() {
        this.zzWO = 2;
        this.zzWK.zzXw = this.zzmJ();
        this.zzWT.zza(this.zzWX, this.zzWK.zzXw, new zza(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zza(ConnectionResult connectionResult) {
        this.zzWL.lock();
        try {
            if (!this.zzaW(2)) {
                return;
            }
            if (connectionResult.isSuccess()) {
                this.zzmG();
            } else if (this.zzc(connectionResult)) {
                this.zzmI();
                this.zzmG();
            } else {
                this.zzd(connectionResult);
            }
        }
        finally {
            this.zzWL.unlock();
        }
    }

    private void zzmG() {
        Set<Scope> set = this.zzWK.zzXw;
        if (set.isEmpty()) {
            set = this.zzmJ();
        }
        this.zzWO = 3;
        this.zzWQ = this.zzWK.zzXu.size();
        for (Api.ClientKey<?> clientKey : this.zzWK.zzXu.keySet()) {
            if (this.zzWK.zzXv.containsKey(clientKey)) {
                if (!this.zzmC()) continue;
                this.zzmH();
                continue;
            }
            this.zzWK.zzXu.get(clientKey).getRemoteService(this.zzWX, set);
        }
    }

    @Override
    public void onConnected(Bundle connectionHint) {
        if (!this.zzaW(3)) {
            return;
        }
        if (connectionHint != null) {
            this.zzWR.putAll(connectionHint);
        }
        if (this.zzmC()) {
            this.zzmH();
        }
    }

    @Override
    public void zza(ConnectionResult connectionResult, Api<?> api, int n) {
        if (!this.zzaW(3)) {
            return;
        }
        this.zzb(connectionResult, api, n);
        if (this.zzmC()) {
            this.zzmH();
        }
    }

    private void zzmH() {
        this.zzWK.zzmN();
        if (this.zzWT != null) {
            if (this.zzWY) {
                this.zzWT.zza(this.zzWX, this.zzWZ);
            }
            this.zzT(false);
        }
        for (Api.ClientKey<?> clientKey : this.zzWK.zzXv.keySet()) {
            Api.Client client = this.zzWK.zzXu.get(clientKey);
            client.disconnect();
        }
        if (this.zzWP) {
            this.zzWP = false;
            this.zzaV(-1);
        } else {
            Bundle bundle = this.zzWR.isEmpty() ? null : this.zzWR;
            this.zzWK.zzXn.zzg(bundle);
        }
    }

    @Override
    public <A extends Api.Client, R extends Result, T extends zza.zza<R, A>> T zza(T t) {
        this.zzWK.zzXo.add(t);
        return t;
    }

    @Override
    public <A extends Api.Client, T extends zza.zza<? extends Result, A>> T zzb(T t) {
        throw new IllegalStateException("GoogleApiClient is not connected yet.");
    }

    @Override
    public void connect() {
        this.zzWP = false;
    }

    @Override
    public void zzaV(int n) {
        if (n == -1) {
            Iterator iterator = this.zzWK.zzXo.iterator();
            while (iterator.hasNext()) {
                zzg.zze zze2 = (zzg.zze)iterator.next();
                if (zze2.zzmv() == 1) continue;
                zze2.cancel();
                iterator.remove();
            }
            this.zzWK.zzmK();
            if (this.zzWM == null && !this.zzWK.zzXo.isEmpty()) {
                this.zzWP = true;
                return;
            }
            this.zzWK.zzXv.clear();
            this.zzWM = null;
            this.zzT(true);
        }
        this.zzWK.zze(this.zzWM);
    }

    @Override
    public void onConnectionSuspended(int cause) {
        this.zzd(new ConnectionResult(8, null));
    }

    private void zzb(ConnectionResult connectionResult, Api<?> api, int n) {
        int n2;
        if (n != 2 && this.zza(n2 = api.zzmp().getPriority(), n, connectionResult)) {
            this.zzWM = connectionResult;
            this.zzWN = n2;
        }
        this.zzWK.zzXv.put(api.zzms(), connectionResult);
    }

    private boolean zza(int n, int n2, ConnectionResult connectionResult) {
        if (n2 == 1 && !zze.zzb(connectionResult)) {
            return false;
        }
        return this.zzWM == null || n < this.zzWN;
    }

    private static boolean zzb(ConnectionResult connectionResult) {
        if (connectionResult.hasResolution()) {
            return true;
        }
        return GooglePlayServicesUtil.zzaT(connectionResult.getErrorCode()) != null;
    }

    private void zzmI() {
        this.zzWV = false;
        this.zzWK.zzXw.clear();
        for (Api.ClientKey clientKey : this.zzWS) {
            if (this.zzWK.zzXv.containsKey(clientKey)) continue;
            this.zzWK.zzXv.put(clientKey, new ConnectionResult(17, null));
        }
    }

    private boolean zzc(ConnectionResult connectionResult) {
        return this.zzWU == 2 || this.zzWU == 1 && !connectionResult.hasResolution();
    }

    private void zzd(ConnectionResult connectionResult) {
        this.zzWP = false;
        this.zzWK.zzXw.clear();
        this.zzWM = connectionResult;
        this.zzT(!connectionResult.hasResolution());
        this.zzaV(3);
        if (!this.zzWK.zzmO() || !GooglePlayServicesUtil.zze(this.mContext, connectionResult.getErrorCode())) {
            this.zzWK.zzmR();
            this.zzWK.zzXn.zzh(connectionResult);
        }
        this.zzWK.zzXn.zznT();
    }

    private void zzT(boolean bl) {
        if (this.zzWT != null) {
            if (this.zzWT.isConnected()) {
                if (bl) {
                    this.zzWT.zzxY();
                }
                this.zzWT.disconnect();
            }
            this.zzWX = null;
        }
    }

    private Set<Scope> zzmJ() {
        HashSet<Scope> hashSet = new HashSet<Scope>(this.zzXa.zznv());
        Map<Api<?>, zze.zza> map = this.zzXa.zznx();
        for (Api<?> api : map.keySet()) {
            if (this.zzWK.zzXv.containsKey(api.zzms())) continue;
            hashSet.addAll(map.get(api).zzWJ);
        }
        return hashSet;
    }

    private boolean zzaW(int n) {
        if (this.zzWO != n) {
            Log.wtf((String)"GoogleApiClientConnecting", (String)("GoogleApiClient connecting is in step " + this.zzaX(this.zzWO) + " but received callback for step " + this.zzaX(n)));
            this.zzd(new ConnectionResult(8, null));
            return false;
        }
        return true;
    }

    private String zzaX(int n) {
        switch (n) {
            case 0: {
                return "STEP_GETTING_SERVICE_BINDINGS";
            }
            case 1: {
                return "STEP_VALIDATING_ACCOUNT";
            }
            case 2: {
                return "STEP_AUTHENTICATING";
            }
            case 3: {
                return "STEP_GETTING_REMOTE_SERVICE";
            }
        }
        return "UNKNOWN";
    }

    private static class zza
    extends com.google.android.gms.signin.internal.zzb {
        private final WeakReference<zze> zzXe;

        zza(zze zze2) {
            this.zzXe = new WeakReference<zze>(zze2);
        }

        @Override
        public void zza(final ConnectionResult connectionResult, AuthAccountResult authAccountResult) {
            final zze zze2 = (zze)this.zzXe.get();
            if (zze2 == null) {
                return;
            }
            ((zze)zze2).zzWK.zzXs.post(new Runnable(){

                @Override
                public void run() {
                    zze2.zza(connectionResult);
                }
            });
        }
    }

    private static class zzc
    implements GoogleApiClient.ConnectionProgressReportCallbacks {
        private final WeakReference<zze> zzXe;
        private final Api<?> zzXk;
        private final int zzXl;

        public zzc(zze zze2, Api<?> api, int n) {
            this.zzXe = new WeakReference<zze>(zze2);
            this.zzXk = api;
            this.zzXl = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReportServiceBinding(ConnectionResult result) {
            zze zze2 = (zze)this.zzXe.get();
            if (zze2 == null) {
                return;
            }
            zzu.zza(Looper.myLooper() == zze2.zzWK.getLooper(), "onReportServiceBinding must be called on the GoogleApiClient handler thread");
            zze2.zzWL.lock();
            try {
                if (!zze2.zzaW(0)) {
                    return;
                }
                if (!result.isSuccess()) {
                    zze2.zzb(result, this.zzXk, this.zzXl);
                }
                if (zze2.zzmC()) {
                    zze2.zzmD();
                }
            }
            finally {
                zze2.zzWL.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReportAccountValidation(ConnectionResult result) {
            zze zze2 = (zze)this.zzXe.get();
            if (zze2 == null) {
                return;
            }
            zzu.zza(Looper.myLooper() == zze2.zzWK.getLooper(), "onReportAccountValidation must be called on the GoogleApiClient handler thread");
            zze2.zzWL.lock();
            try {
                if (!zze2.zzaW(1)) {
                    return;
                }
                if (!result.isSuccess()) {
                    zze2.zzb(result, this.zzXk, this.zzXl);
                }
                if (zze2.zzmC()) {
                    zze2.zzmF();
                }
            }
            finally {
                zze2.zzWL.unlock();
            }
        }
    }

    private class zzd
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener {
        private zzd() {
        }

        @Override
        public void onConnected(Bundle connectionHint) {
            zze.this.zzWT.zza(new zzb(zze.this));
        }

        @Override
        public void onConnectionSuspended(int cause) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onConnectionFailed(ConnectionResult result) {
            zze.this.zzWL.lock();
            try {
                if (zze.this.zzc(result)) {
                    zze.this.zzmI();
                    zze.this.zzmG();
                } else {
                    zze.this.zzd(result);
                }
            }
            finally {
                zze.this.zzWL.unlock();
            }
        }
    }

    private static class zzb
    extends zzq.zza {
        private final WeakReference<zze> zzXe;

        zzb(zze zze2) {
            this.zzXe = new WeakReference<zze>(zze2);
        }

        @Override
        public void zzb(final ResolveAccountResponse resolveAccountResponse) {
            final zze zze2 = (zze)this.zzXe.get();
            if (zze2 == null) {
                return;
            }
            ((zze)zze2).zzWK.zzXs.post(new Runnable(){

                @Override
                public void run() {
                    zze2.zza(resolveAccountResponse);
                }
            });
        }
    }
}

