/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzu;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class zzm
extends Fragment
implements DialogInterface.OnCancelListener {
    private boolean mStarted;
    private boolean zzXV;
    private int zzXW = -1;
    private ConnectionResult zzXX;
    private final Handler zzXY = new Handler(Looper.getMainLooper());
    private final SparseArray<zza> zzXZ = new SparseArray();

    public static zzm zza(FragmentActivity fragmentActivity) {
        zzm zzm2;
        zzu.zzbY("Must be called from main thread of process");
        FragmentManager fragmentManager = fragmentActivity.getSupportFragmentManager();
        try {
            zzm2 = (zzm)fragmentManager.findFragmentByTag("GmsSupportLifecycleFragment");
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("Fragment with tag GmsSupportLifecycleFragment is not a SupportLifecycleFragment", classCastException);
        }
        if (zzm2 == null || zzm2.isRemoving()) {
            zzm2 = new zzm();
            fragmentManager.beginTransaction().add(zzm2, "GmsSupportLifecycleFragment").commit();
            fragmentManager.executePendingTransactions();
        }
        return zzm2;
    }

    public void zza(int n, GoogleApiClient googleApiClient, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        zzu.zzb(googleApiClient, (Object)"GoogleApiClient instance cannot be null");
        zzu.zza(this.zzXZ.indexOfKey(n) < 0, "Already managing a GoogleApiClient with id " + n);
        zza zza2 = new zza(n, googleApiClient, onConnectionFailedListener);
        this.zzXZ.put(n, (Object)zza2);
        if (this.mStarted && !this.zzXV) {
            googleApiClient.connect();
        }
    }

    public void zzbb(int n) {
        zza zza2 = (zza)this.zzXZ.get(n);
        this.zzXZ.remove(n);
        if (zza2 != null) {
            zza2.zzmW();
        }
    }

    public void onCancel(DialogInterface dialogInterface) {
        this.zza(this.zzXW, new ConnectionResult(13, null));
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.zzXV = savedInstanceState.getBoolean("resolving_error", false);
            this.zzXW = savedInstanceState.getInt("failed_client_id", -1);
            if (this.zzXW >= 0) {
                this.zzXX = new ConnectionResult(savedInstanceState.getInt("failed_status"), (PendingIntent)savedInstanceState.getParcelable("failed_resolution"));
            }
        }
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean("resolving_error", this.zzXV);
        if (this.zzXW >= 0) {
            outState.putInt("failed_client_id", this.zzXW);
            outState.putInt("failed_status", this.zzXX.getErrorCode());
            outState.putParcelable("failed_resolution", (Parcelable)this.zzXX.getResolution());
        }
    }

    @Override
    public void onStart() {
        super.onStart();
        this.mStarted = true;
        if (!this.zzXV) {
            for (int i = 0; i < this.zzXZ.size(); ++i) {
                zza zza2 = (zza)this.zzXZ.valueAt(i);
                zza2.zzYb.connect();
            }
        }
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        boolean bl = false;
        switch (requestCode) {
            case 2: {
                if (GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.getActivity()) != 0) break;
                bl = true;
                break;
            }
            case 1: {
                if (resultCode != -1) break;
                bl = true;
            }
        }
        if (bl) {
            this.zzmV();
        } else {
            this.zza(this.zzXW, this.zzXX);
        }
    }

    @Override
    public void onStop() {
        super.onStop();
        this.mStarted = false;
        for (int i = 0; i < this.zzXZ.size(); ++i) {
            zza zza2 = (zza)this.zzXZ.valueAt(i);
            zza2.zzYb.disconnect();
        }
    }

    @Override
    public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
        super.dump(prefix, fd, writer, args);
        for (int i = 0; i < this.zzXZ.size(); ++i) {
            zza zza2 = (zza)this.zzXZ.valueAt(i);
            zza2.dump(prefix, fd, writer, args);
        }
    }

    private void zza(int n, ConnectionResult connectionResult) {
        Log.w((String)"GmsSupportLifecycleFragment", (String)"Unresolved error while connecting client. Stopping auto-manage.");
        zza zza2 = (zza)this.zzXZ.get(n);
        if (zza2 != null) {
            this.zzbb(n);
            GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = zza2.zzYc;
            if (onConnectionFailedListener != null) {
                onConnectionFailedListener.onConnectionFailed(connectionResult);
            }
        }
        this.zzmV();
    }

    private void zzmV() {
        this.zzXV = false;
        this.zzXW = -1;
        this.zzXX = null;
        for (int i = 0; i < this.zzXZ.size(); ++i) {
            zza zza2 = (zza)this.zzXZ.valueAt(i);
            zza2.zzYb.connect();
        }
    }

    private class zza
    implements GoogleApiClient.OnConnectionFailedListener {
        public final int zzYa;
        public final GoogleApiClient zzYb;
        public final GoogleApiClient.OnConnectionFailedListener zzYc;

        public zza(int n, GoogleApiClient googleApiClient, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            this.zzYa = n;
            this.zzYb = googleApiClient;
            this.zzYc = onConnectionFailedListener;
            googleApiClient.registerConnectionFailedListener(this);
        }

        @Override
        public void onConnectionFailed(ConnectionResult result) {
            zzm.this.zzXY.post((Runnable)new zzb(this.zzYa, result));
        }

        public void zzmW() {
            this.zzYb.unregisterConnectionFailedListener(this);
            this.zzYb.disconnect();
        }

        public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
            writer.append(prefix).append("GoogleApiClient #").print(this.zzYa);
            writer.println(":");
            this.zzYb.dump(prefix + "  ", fd, writer, args);
        }
    }

    private class zzb
    implements Runnable {
        private final int zzYe;
        private final ConnectionResult zzYf;

        public zzb(int n, ConnectionResult connectionResult) {
            this.zzYe = n;
            this.zzYf = connectionResult;
        }

        @Override
        public void run() {
            if (!zzm.this.mStarted || zzm.this.zzXV) {
                return;
            }
            zzm.this.zzXV = true;
            zzm.this.zzXW = this.zzYe;
            zzm.this.zzXX = this.zzYf;
            if (this.zzYf.hasResolution()) {
                try {
                    int n = zzm.this.getActivity().getSupportFragmentManager().getFragments().indexOf(zzm.this);
                    int n2 = 1 + (1 + n << 16);
                    this.zzYf.startResolutionForResult(zzm.this.getActivity(), n2);
                }
                catch (IntentSender.SendIntentException sendIntentException) {
                    zzm.this.zzmV();
                }
            } else if (GooglePlayServicesUtil.isUserRecoverableError(this.zzYf.getErrorCode())) {
                GooglePlayServicesUtil.showErrorDialogFragment(this.zzYf.getErrorCode(), zzm.this.getActivity(), zzm.this, 2, zzm.this);
            } else {
                zzm.this.zza(this.zzYe, this.zzYf);
            }
        }
    }
}

