/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzu;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class zzn
extends Fragment
implements DialogInterface.OnCancelListener,
LoaderManager.LoaderCallbacks<ConnectionResult> {
    private boolean zzXV;
    private int zzXW = -1;
    private ConnectionResult zzXX;
    private final Handler zzXY = new Handler(Looper.getMainLooper());
    private final SparseArray<zzb> zzXZ = new SparseArray();

    public static zzn zzb(FragmentActivity fragmentActivity) {
        zzn zzn2;
        zzu.zzbY("Must be called from main thread of process");
        FragmentManager fragmentManager = fragmentActivity.getSupportFragmentManager();
        try {
            zzn2 = (zzn)fragmentManager.findFragmentByTag("GmsSupportLoaderLifecycleFragment");
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("Fragment with tag GmsSupportLoaderLifecycleFragment is not a SupportLoaderLifecycleFragment", classCastException);
        }
        if (zzn2 == null || zzn2.isRemoving()) {
            zzn2 = new zzn();
            fragmentManager.beginTransaction().add(zzn2, "GmsSupportLoaderLifecycleFragment").commit();
            fragmentManager.executePendingTransactions();
        }
        return zzn2;
    }

    public GoogleApiClient zzbc(int n) {
        zza zza2;
        if (this.getActivity() != null && (zza2 = this.zzbd(n)) != null) {
            return zza2.zzYb;
        }
        return null;
    }

    public void zza(int n, GoogleApiClient googleApiClient, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        zzu.zzb(googleApiClient, (Object)"GoogleApiClient instance cannot be null");
        zzu.zza(this.zzXZ.indexOfKey(n) < 0, "Already managing a GoogleApiClient with id " + n);
        zzb zzb2 = new zzb(googleApiClient, onConnectionFailedListener);
        this.zzXZ.put(n, (Object)zzb2);
        if (this.getActivity() != null) {
            LoaderManager.enableDebugLogging(false);
            this.getLoaderManager().initLoader(n, null, this);
        }
    }

    public void zzbb(int n) {
        this.zzXZ.remove(n);
        this.getLoaderManager().destroyLoader(n);
    }

    public void onCancel(DialogInterface dialogInterface) {
        this.zza(this.zzXW, new ConnectionResult(13, null));
    }

    @Override
    public void onAttach(Activity activity) {
        super.onAttach(activity);
        for (int i = 0; i < this.zzXZ.size(); ++i) {
            int n = this.zzXZ.keyAt(i);
            zza zza2 = this.zzbd(n);
            if (zza2 != null) {
                zzb zzb2 = (zzb)this.zzXZ.valueAt(i);
                if (zzb2.zzYb != zza2.zzYb) {
                    this.getLoaderManager().restartLoader(n, null, this);
                    continue;
                }
            }
            this.getLoaderManager().initLoader(n, null, this);
        }
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.zzXV = savedInstanceState.getBoolean("resolving_error", false);
            this.zzXW = savedInstanceState.getInt("failed_client_id", -1);
            if (this.zzXW >= 0) {
                this.zzXX = new ConnectionResult(savedInstanceState.getInt("failed_status"), (PendingIntent)savedInstanceState.getParcelable("failed_resolution"));
            }
        }
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean("resolving_error", this.zzXV);
        if (this.zzXW >= 0) {
            outState.putInt("failed_client_id", this.zzXW);
            outState.putInt("failed_status", this.zzXX.getErrorCode());
            outState.putParcelable("failed_resolution", (Parcelable)this.zzXX.getResolution());
        }
    }

    @Override
    public void onStart() {
        super.onStart();
        if (!this.zzXV) {
            for (int i = 0; i < this.zzXZ.size(); ++i) {
                this.getLoaderManager().initLoader(this.zzXZ.keyAt(i), null, this);
            }
        }
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        boolean bl = false;
        switch (requestCode) {
            case 2: {
                if (GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.getActivity()) != 0) break;
                bl = true;
                break;
            }
            case 1: {
                if (resultCode != -1) break;
                bl = true;
            }
        }
        if (bl) {
            this.zzmV();
        } else {
            this.zza(this.zzXW, this.zzXX);
        }
    }

    @Override
    public Loader<ConnectionResult> onCreateLoader(int id2, Bundle args) {
        return new zza((Context)this.getActivity(), ((zzb)this.zzXZ.get((int)id2)).zzYb);
    }

    public void zza(Loader<ConnectionResult> loader, ConnectionResult connectionResult) {
        if (!connectionResult.isSuccess()) {
            this.zzb(loader.getId(), connectionResult);
        }
    }

    @Override
    public void onLoaderReset(Loader<ConnectionResult> loader) {
    }

    zza zzbd(int n) {
        try {
            return (zza)this.getLoaderManager().getLoader(n);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("Unknown loader in SupportLoaderLifecycleFragment", classCastException);
        }
    }

    private void zzb(int n, ConnectionResult connectionResult) {
        if (!this.zzXV) {
            this.zzXV = true;
            this.zzXW = n;
            this.zzXX = connectionResult;
            this.zzXY.post((Runnable)new zzc(n, connectionResult));
        }
    }

    private void zza(int n, ConnectionResult connectionResult) {
        Log.w((String)"GmsSupportLoaderLifecycleFragment", (String)"Unresolved error while connecting client. Stopping auto-manage.");
        zzb zzb2 = (zzb)this.zzXZ.get(n);
        if (zzb2 != null) {
            this.zzbb(n);
            GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = zzb2.zzYc;
            if (onConnectionFailedListener != null) {
                onConnectionFailedListener.onConnectionFailed(connectionResult);
            }
        }
        this.zzmV();
    }

    private void zzmV() {
        this.zzXV = false;
        this.zzXW = -1;
        this.zzXX = null;
        LoaderManager loaderManager = this.getLoaderManager();
        for (int i = 0; i < this.zzXZ.size(); ++i) {
            int n = this.zzXZ.keyAt(i);
            zza zza2 = this.zzbd(n);
            if (zza2 == null || !zza2.zzmX()) continue;
            loaderManager.destroyLoader(n);
            loaderManager.initLoader(n, null, this);
        }
    }

    @Override
    public /* synthetic */ void onLoadFinished(Loader x0, Object x1) {
        this.zza(x0, (ConnectionResult)x1);
    }

    static class zza
    extends Loader<ConnectionResult>
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener {
        public final GoogleApiClient zzYb;
        private boolean zzYg;
        private ConnectionResult zzYh;

        public zza(Context context, GoogleApiClient googleApiClient) {
            super(context);
            this.zzYb = googleApiClient;
        }

        public boolean zzmX() {
            return this.zzYg;
        }

        @Override
        protected void onStartLoading() {
            super.onStartLoading();
            this.zzYb.registerConnectionCallbacks(this);
            this.zzYb.registerConnectionFailedListener(this);
            if (this.zzYh != null) {
                this.deliverResult(this.zzYh);
            }
            if (!(this.zzYb.isConnected() || this.zzYb.isConnecting() || this.zzYg)) {
                this.zzYb.connect();
            }
        }

        @Override
        protected void onStopLoading() {
            this.zzYb.disconnect();
        }

        @Override
        protected void onReset() {
            this.zzYh = null;
            this.zzYg = false;
            this.zzYb.unregisterConnectionCallbacks(this);
            this.zzYb.unregisterConnectionFailedListener(this);
            this.zzYb.disconnect();
        }

        @Override
        public void onConnected(Bundle connectionHint) {
            this.zzYg = false;
            this.zzf(ConnectionResult.zzVG);
        }

        @Override
        public void onConnectionSuspended(int cause) {
        }

        @Override
        public void onConnectionFailed(ConnectionResult result) {
            this.zzYg = true;
            this.zzf(result);
        }

        @Override
        public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
            super.dump(prefix, fd, writer, args);
            this.zzYb.dump(prefix, fd, writer, args);
        }

        private void zzf(ConnectionResult connectionResult) {
            this.zzYh = connectionResult;
            if (this.isStarted() && !this.isAbandoned()) {
                this.deliverResult(connectionResult);
            }
        }
    }

    private static class zzb {
        public final GoogleApiClient zzYb;
        public final GoogleApiClient.OnConnectionFailedListener zzYc;

        private zzb(GoogleApiClient googleApiClient, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            this.zzYb = googleApiClient;
            this.zzYc = onConnectionFailedListener;
        }
    }

    private class zzc
    implements Runnable {
        private final int zzYe;
        private final ConnectionResult zzYf;

        public zzc(int n, ConnectionResult connectionResult) {
            this.zzYe = n;
            this.zzYf = connectionResult;
        }

        @Override
        public void run() {
            if (this.zzYf.hasResolution()) {
                try {
                    int n = zzn.this.getActivity().getSupportFragmentManager().getFragments().indexOf(zzn.this);
                    int n2 = 1 + (1 + n << 16);
                    this.zzYf.startResolutionForResult(zzn.this.getActivity(), n2);
                }
                catch (IntentSender.SendIntentException sendIntentException) {
                    zzn.this.zzmV();
                }
            } else if (GooglePlayServicesUtil.isUserRecoverableError(this.zzYf.getErrorCode())) {
                GooglePlayServicesUtil.showErrorDialogFragment(this.zzYf.getErrorCode(), zzn.this.getActivity(), zzn.this, 2, zzn.this);
            } else {
                zzn.this.zza(this.zzYe, this.zzYf);
            }
        }
    }
}

