/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzu;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public final class zzj
implements Handler.Callback {
    private final zza zzaaC;
    private final ArrayList<GoogleApiClient.ConnectionCallbacks> zzaaD = new ArrayList();
    final ArrayList<GoogleApiClient.ConnectionCallbacks> zzaaE = new ArrayList();
    private final ArrayList<GoogleApiClient.OnConnectionFailedListener> zzaaF = new ArrayList();
    private volatile boolean zzaaG = false;
    private final AtomicInteger zzaaH = new AtomicInteger(0);
    private boolean zzaaI = false;
    private final Handler mHandler;
    private final Object zzqt = new Object();

    public zzj(Looper looper, zza zza2) {
        this.zzaaC = zza2;
        this.mHandler = new Handler(looper, (Handler.Callback)this);
    }

    public void zznT() {
        this.zzaaG = false;
        this.zzaaH.incrementAndGet();
    }

    public void zznU() {
        this.zzaaG = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzg(Bundle bundle) {
        Object object = this.zzqt;
        synchronized (object) {
            zzu.zzU(!this.zzaaI);
            this.mHandler.removeMessages(1);
            this.zzaaI = true;
            zzu.zzU(this.zzaaE.size() == 0);
            ArrayList<GoogleApiClient.ConnectionCallbacks> arrayList = new ArrayList<GoogleApiClient.ConnectionCallbacks>(this.zzaaD);
            int n = this.zzaaH.get();
            for (GoogleApiClient.ConnectionCallbacks connectionCallbacks : arrayList) {
                if (!this.zzaaG || !this.zzaaC.isConnected() || this.zzaaH.get() != n) break;
                if (this.zzaaE.contains(connectionCallbacks)) continue;
                connectionCallbacks.onConnected(bundle);
            }
            this.zzaaE.clear();
            this.zzaaI = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzbu(int n) {
        this.mHandler.removeMessages(1);
        Object object = this.zzqt;
        synchronized (object) {
            this.zzaaI = true;
            ArrayList<GoogleApiClient.ConnectionCallbacks> arrayList = new ArrayList<GoogleApiClient.ConnectionCallbacks>(this.zzaaD);
            int n2 = this.zzaaH.get();
            for (GoogleApiClient.ConnectionCallbacks connectionCallbacks : arrayList) {
                if (!this.zzaaG || this.zzaaH.get() != n2) break;
                if (!this.zzaaD.contains(connectionCallbacks)) continue;
                connectionCallbacks.onConnectionSuspended(n);
            }
            this.zzaaE.clear();
            this.zzaaI = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzh(ConnectionResult connectionResult) {
        this.mHandler.removeMessages(1);
        Object object = this.zzqt;
        synchronized (object) {
            ArrayList<GoogleApiClient.OnConnectionFailedListener> arrayList = new ArrayList<GoogleApiClient.OnConnectionFailedListener>(this.zzaaF);
            int n = this.zzaaH.get();
            for (GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener : arrayList) {
                if (!this.zzaaG || this.zzaaH.get() != n) {
                    return;
                }
                if (!this.zzaaF.contains(onConnectionFailedListener)) continue;
                onConnectionFailedListener.onConnectionFailed(connectionResult);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConnectionCallbacks(GoogleApiClient.ConnectionCallbacks listener) {
        zzu.zzu(listener);
        Object object = this.zzqt;
        synchronized (object) {
            if (this.zzaaD.contains(listener)) {
                Log.w((String)"GmsClientEvents", (String)("registerConnectionCallbacks(): listener " + listener + " is already registered"));
            } else {
                this.zzaaD.add(listener);
            }
        }
        if (this.zzaaC.isConnected()) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(1, (Object)listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterConnectionCallbacks(GoogleApiClient.ConnectionCallbacks listener) {
        zzu.zzu(listener);
        Object object = this.zzqt;
        synchronized (object) {
            boolean bl = this.zzaaD.remove(listener);
            if (!bl) {
                Log.w((String)"GmsClientEvents", (String)("unregisterConnectionCallbacks(): listener " + listener + " not found"));
            } else if (this.zzaaI) {
                this.zzaaE.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener listener) {
        zzu.zzu(listener);
        Object object = this.zzqt;
        synchronized (object) {
            if (this.zzaaF.contains(listener)) {
                Log.w((String)"GmsClientEvents", (String)("registerConnectionFailedListener(): listener " + listener + " is already registered"));
            } else {
                this.zzaaF.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener listener) {
        zzu.zzu(listener);
        Object object = this.zzqt;
        synchronized (object) {
            boolean bl = this.zzaaF.remove(listener);
            if (!bl) {
                Log.w((String)"GmsClientEvents", (String)("unregisterConnectionFailedListener(): listener " + listener + " not found"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleMessage(Message msg) {
        if (msg.what == 1) {
            GoogleApiClient.ConnectionCallbacks connectionCallbacks = (GoogleApiClient.ConnectionCallbacks)msg.obj;
            Object object = this.zzqt;
            synchronized (object) {
                if (this.zzaaG && this.zzaaC.isConnected() && this.zzaaD.contains(connectionCallbacks)) {
                    Bundle bundle = this.zzaaC.zzlM();
                    connectionCallbacks.onConnected(bundle);
                }
            }
            return true;
        }
        Log.wtf((String)"GmsClientEvents", (String)"Don't know how to handle this message.");
        return false;
    }

    public static interface zza {
        public boolean isConnected();

        public Bundle zzlM();
    }
}

