/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.iid.InstanceID;
import com.google.android.gms.iid.zzc;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class GoogleCloudMessaging {
    public static int zzavP = 5000000;
    public static int zzavQ = 6500000;
    public static int zzavR = 7000000;
    static GoogleCloudMessaging zzavS;
    private Context zzpH;
    private PendingIntent zzavT;
    private Map<String, Handler> zzavU;
    private static final AtomicInteger zzavV;
    private final BlockingQueue<Intent> zzavW = new LinkedBlockingQueue<Intent>();
    final Messenger zzavX;

    public static synchronized GoogleCloudMessaging getInstance(Context context) {
        if (zzavS == null) {
            zzavS = new GoogleCloudMessaging();
            GoogleCloudMessaging.zzavS.zzpH = context.getApplicationContext();
        }
        return zzavS;
    }

    public GoogleCloudMessaging() {
        this.zzavU = Collections.synchronizedMap(new HashMap());
        this.zzavX = new Messenger(new Handler(Looper.getMainLooper()){

            public void handleMessage(Message msg) {
                Intent intent;
                if (msg == null || !(msg.obj instanceof Intent)) {
                    Log.w((String)"GCM", (String)"Dropping invalid message");
                }
                if ("com.google.android.c2dm.intent.REGISTRATION".equals((intent = (Intent)msg.obj).getAction())) {
                    GoogleCloudMessaging.this.zzavW.add(intent);
                } else if (!GoogleCloudMessaging.this.zzl(intent)) {
                    intent.setPackage(GoogleCloudMessaging.this.zzpH.getPackageName());
                    GoogleCloudMessaging.this.zzpH.sendBroadcast(intent);
                }
            }
        });
    }

    public void send(String to, String msgId, long timeToLive, Bundle data) throws IOException {
        this.zza(to, msgId, timeToLive, -1, data);
    }

    private void zza(String string2, String string3, long l, int n, Bundle bundle) throws IOException {
        if (string2 == null) {
            throw new IllegalArgumentException("Missing 'to'");
        }
        Intent intent = new Intent("com.google.android.gcm.intent.SEND");
        if (bundle != null) {
            intent.putExtras(bundle);
        }
        this.zzm(intent);
        intent.setPackage(GoogleCloudMessaging.zzas(this.zzpH));
        intent.putExtra("google.to", string2);
        intent.putExtra("google.message_id", string3);
        intent.putExtra("google.ttl", Long.toString(l));
        intent.putExtra("google.delay", Integer.toString(n));
        if (GoogleCloudMessaging.zzas(this.zzpH).contains(".gsf")) {
            Bundle bundle2 = new Bundle();
            for (String string4 : bundle.keySet()) {
                Object object = bundle.get(string4);
                if (!(object instanceof String)) continue;
                bundle2.putString("gcm." + string4, (String)object);
            }
            bundle2.putString("google.to", string2);
            bundle2.putString("google.message_id", string3);
            InstanceID.getInstance(this.zzpH).zzc("GCM", "upstream", bundle2);
            return;
        }
        this.zzpH.sendOrderedBroadcast(intent, "com.google.android.gtalkservice.permission.GTALK_SERVICE");
    }

    private boolean zzl(Intent intent) {
        String string2 = intent.getStringExtra("In-Reply-To");
        if (string2 == null && intent.hasExtra("error")) {
            string2 = intent.getStringExtra("google.message_id");
        }
        Handler handler = null;
        if (string2 != null && (handler = this.zzavU.remove(string2)) != null) {
            Message message = Message.obtain();
            message.obj = intent;
            return handler.sendMessage(message);
        }
        return false;
    }

    private String zztS() {
        return "google.rpc" + String.valueOf(zzavV.getAndIncrement());
    }

    @Deprecated
    public synchronized void unregister() throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException("MAIN_THREAD");
        }
        InstanceID.getInstance(this.zzpH).deleteInstanceID();
    }

    @Deprecated
    public synchronized String register(String ... senderIds) throws IOException {
        String string2 = this.zzc(senderIds);
        Bundle bundle = new Bundle();
        if (GoogleCloudMessaging.zzas(this.zzpH).contains(".gsf")) {
            bundle.putString("legacy.sender", string2);
            return InstanceID.getInstance(this.zzpH).getToken(string2, "GCM", bundle);
        }
        bundle.putString("sender", string2);
        Intent intent = this.zzx(bundle);
        return GoogleCloudMessaging.zza(intent, "registration_id");
    }

    @Deprecated
    Intent zzx(Bundle bundle) throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException("MAIN_THREAD");
        }
        int n = GoogleCloudMessaging.zzat(this.zzpH);
        if (n < 0) {
            throw new IOException("Google Play Services missing");
        }
        if (bundle == null) {
            bundle = new Bundle();
        }
        Intent intent = new Intent("com.google.android.c2dm.intent.REGISTER");
        intent.setPackage(GoogleCloudMessaging.zzas(this.zzpH));
        this.zzm(intent);
        String string2 = this.zztS();
        intent.putExtra("google.message_id", string2);
        intent.putExtras(bundle);
        intent.putExtra("google.messenger", (Parcelable)this.zzavX);
        this.zzpH.startService(intent);
        Intent intent2 = null;
        try {
            intent2 = this.zzavW.poll(30000L, TimeUnit.MILLISECONDS);
            return intent2;
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException.getMessage());
        }
    }

    static String zza(Intent intent, String string2) throws IOException {
        if (intent == null) {
            throw new IOException("SERVICE_NOT_AVAILABLE");
        }
        String string3 = intent.getStringExtra(string2);
        if (string3 != null) {
            return string3;
        }
        String string4 = intent.getStringExtra("error");
        if (string4 != null) {
            throw new IOException(string4);
        }
        throw new IOException("SERVICE_NOT_AVAILABLE");
    }

    String zzc(String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("No senderIds");
        }
        StringBuilder stringBuilder = new StringBuilder(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuilder.append(',').append(stringArray[i]);
        }
        return stringBuilder.toString();
    }

    public String getMessageType(Intent intent) {
        String string2 = intent.getAction();
        if (!"com.google.android.c2dm.intent.RECEIVE".equals(string2)) {
            return null;
        }
        String string3 = intent.getStringExtra("message_type");
        if (string3 != null) {
            return string3;
        }
        return "gcm";
    }

    synchronized void zzm(Intent intent) {
        if (this.zzavT == null) {
            Intent intent2 = new Intent();
            intent2.setPackage("com.google.example.invalidpackage");
            this.zzavT = PendingIntent.getBroadcast((Context)this.zzpH, (int)0, (Intent)intent2, (int)0);
        }
        intent.putExtra("app", (Parcelable)this.zzavT);
    }

    public static String zzas(Context context) {
        return zzc.zzaw(context);
    }

    public static int zzat(Context context) {
        PackageManager packageManager = context.getPackageManager();
        try {
            PackageInfo packageInfo = packageManager.getPackageInfo(GoogleCloudMessaging.zzas(context), 0);
            return packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return -1;
        }
    }

    static {
        zzavV = new AtomicInteger(1);
    }
}

