/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.content.Context;
import android.os.PowerManager;
import android.os.Process;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.ValueCallback;
import android.webkit.WebView;
import android.widget.EditText;
import android.widget.TextView;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.internal.zzbh;
import com.google.android.gms.internal.zzbi;
import com.google.android.gms.internal.zzbj;
import com.google.android.gms.internal.zzgc;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzid;
import com.google.android.gms.internal.zzlk;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

@zzgd
public class zzbk
extends Thread {
    private boolean zzrv;
    private boolean zzam;
    private final Object zzqt;
    private final zzbj zzrw;
    private final zzbi zzrx;
    private final zzgc zzry;
    private final int zzrz;
    private final int zzrj;
    private final int zzrA;
    private final int zzrl;
    private final int zzrB;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.zzam) {
            Object object;
            try {
                if (this.zzcq()) {
                    object = this.zzrw.getActivity();
                    if (object == null) {
                        zzb.zzay("ContentFetchThread: no activity");
                        continue;
                    }
                    this.zza((Activity)object);
                } else {
                    zzb.zzay("ContentFetchTask: sleeping");
                    this.zzcs();
                }
                Thread.sleep(this.zzrz * 1000);
            }
            catch (Throwable throwable) {
                zzb.zzb("Error in ContentFetchTask", throwable);
                this.zzry.zza(throwable, true);
            }
            object = this.zzqt;
            synchronized (object) {
                while (this.zzrv) {
                    try {
                        zzb.zzay("ContentFetchTask: waiting");
                        this.zzqt.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    boolean zzf(final View view) {
        if (view == null) {
            return false;
        }
        view.post(new Runnable(){

            @Override
            public void run() {
                zzbk.this.zzg(view);
            }
        });
        return true;
    }

    void zzg(View view) {
        try {
            zzbh zzbh2 = new zzbh(this.zzrj, this.zzrA, this.zzrl, this.zzrB);
            zza zza2 = this.zza(view, zzbh2);
            zzbh2.zzcm();
            if (zza2.zzrI == 0 && zza2.zzrJ == 0) {
                return;
            }
            if (zza2.zzrJ == 0 && zzbh2.zzcn() == 0) {
                return;
            }
            if (zza2.zzrJ == 0 && this.zzrx.zza(zzbh2)) {
                return;
            }
            this.zzrx.zzc(zzbh2);
        }
        catch (Exception exception) {
            zzb.zzb("Exception in fetchContentOnUIThread", exception);
            this.zzry.zza(exception, true);
        }
    }

    boolean zzr(Context context) {
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        if (powerManager == null) {
            return false;
        }
        return powerManager.isScreenOn();
    }

    boolean zzcq() {
        try {
            Context context = this.zzrw.getContext();
            if (context == null) {
                return false;
            }
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
            if (activityManager == null || keyguardManager == null) {
                return false;
            }
            List list = activityManager.getRunningAppProcesses();
            if (list == null) {
                return false;
            }
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                if (Process.myPid() != runningAppProcessInfo.pid) continue;
                if (!this.zza(runningAppProcessInfo) || keyguardManager.inKeyguardRestrictedInputMode() || !this.zzr(context)) break;
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    boolean zza(ActivityManager.RunningAppProcessInfo runningAppProcessInfo) {
        return runningAppProcessInfo.importance == 100;
    }

    void zza(Activity activity) {
        if (activity == null) {
            return;
        }
        View view = null;
        if (activity.getWindow() != null && activity.getWindow().getDecorView() != null) {
            view = activity.getWindow().getDecorView().findViewById(0x1020002);
        }
        if (view == null) {
            return;
        }
        this.zzf(view);
    }

    zza zza(View view, zzbh zzbh2) {
        if (view == null) {
            return new zza(0, 0);
        }
        if (view instanceof TextView && !(view instanceof EditText)) {
            TextView textView = (TextView)view;
            CharSequence charSequence = textView.getText();
            if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                String string2 = charSequence.toString();
                zzbh2.zzv(string2);
                return new zza(1, 0);
            }
            return new zza(0, 0);
        }
        if (view instanceof WebView && !(view instanceof zzid)) {
            zzbh2.zzcl();
            if (this.zza((WebView)view, zzbh2)) {
                return new zza(0, 1);
            }
            return new zza(0, 0);
        }
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                zza zza2 = this.zza(viewGroup.getChildAt(i), zzbh2);
                n += zza2.zzrI;
                n2 += zza2.zzrJ;
            }
            return new zza(n, n2);
        }
        return new zza(0, 0);
    }

    boolean zza(final WebView webView, final zzbh zzbh2) {
        if (!zzlk.zzoX()) {
            return false;
        }
        zzbh2.zzcl();
        webView.post(new Runnable(){
            ValueCallback<String> zzrE = new ValueCallback<String>(){

                public void zzx(String string2) {
                    zzbk.this.zza(zzbh2, webView, string2);
                }

                public /* synthetic */ void onReceiveValue(Object x0) {
                    this.zzx((String)x0);
                }
            };

            @Override
            public void run() {
                if (webView.getSettings().getJavaScriptEnabled()) {
                    try {
                        webView.evaluateJavascript("(function() { return  {text:document.body.innerText}})();", this.zzrE);
                    }
                    catch (Throwable throwable) {
                        this.zzrE.onReceiveValue((Object)"");
                    }
                }
            }
        });
        return true;
    }

    void zza(zzbh zzbh2, WebView webView, String string2) {
        zzbh2.zzck();
        try {
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                JSONObject jSONObject = new JSONObject(string2);
                String string3 = jSONObject.optString("text");
                if (!TextUtils.isEmpty((CharSequence)webView.getTitle())) {
                    zzbh2.zzu(webView.getTitle() + "\n" + string3);
                } else {
                    zzbh2.zzu(string3);
                }
            }
            if (zzbh2.zzch()) {
                this.zzrx.zzb(zzbh2);
            }
        }
        catch (JSONException jSONException) {
            zzb.zzay("Json string may be malformed.");
        }
        catch (Throwable throwable) {
            zzb.zza("Failed to get webview content.", throwable);
            this.zzry.zza(throwable, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzcs() {
        Object object = this.zzqt;
        synchronized (object) {
            this.zzrv = true;
            zzb.zzay("ContentFetchThread: paused, mPause = " + this.zzrv);
        }
    }

    @zzgd
    class zza {
        final int zzrI;
        final int zzrJ;

        zza(int n, int n2) {
            this.zzrI = n;
            this.zzrJ = n2;
        }
    }
}

