/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Message;
import android.view.View;
import android.view.WindowManager;
import android.webkit.ConsoleMessage;
import android.webkit.GeolocationPermissions;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.WebChromeClient;
import android.webkit.WebStorage;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.google.android.gms.ads.internal.overlay.zzc;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzo;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzid;

@zzgd
public class zzii
extends WebChromeClient {
    private final zzid zzoA;

    protected boolean zza(Context context, String string2, String string3, String string4, JsResult jsResult, JsPromptResult jsPromptResult, boolean bl) {
        try {
            AlertDialog.Builder builder = new AlertDialog.Builder(context);
            builder.setTitle((CharSequence)string2);
            if (bl) {
                zzii.zza(context, builder, string3, string4, jsPromptResult);
            } else {
                zzii.zza(builder, string3, jsResult);
            }
        }
        catch (WindowManager.BadTokenException badTokenException) {
            zzb.zzd("Fail to display Dialog.", badTokenException);
        }
        return true;
    }

    private static void zza(AlertDialog.Builder builder, String string2, final JsResult jsResult) {
        builder.setMessage((CharSequence)string2).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                jsResult.confirm();
            }
        }).setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                jsResult.cancel();
            }
        }).setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                jsResult.cancel();
            }
        }).create().show();
    }

    private static void zza(Context context, AlertDialog.Builder builder, String string2, String string3, final JsPromptResult jsPromptResult) {
        LinearLayout linearLayout = new LinearLayout(context);
        linearLayout.setOrientation(1);
        TextView textView = new TextView(context);
        textView.setText((CharSequence)string2);
        final EditText editText = new EditText(context);
        editText.setText((CharSequence)string3);
        linearLayout.addView((View)textView);
        linearLayout.addView((View)editText);
        builder.setView((View)linearLayout).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                jsPromptResult.confirm(editText.getText().toString());
            }
        }).setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                jsPromptResult.cancel();
            }
        }).setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                jsPromptResult.cancel();
            }
        }).create().show();
    }

    public zzii(zzid zzid2) {
        this.zzoA = zzid2;
    }

    public final boolean onCreateWindow(WebView view, boolean isDialog, boolean isUserGesture, Message resultMsg) {
        WebView.WebViewTransport webViewTransport = (WebView.WebViewTransport)resultMsg.obj;
        WebView webView = new WebView(view.getContext());
        webView.setWebViewClient((WebViewClient)this.zzoA.zzgF());
        webViewTransport.setWebView(webView);
        resultMsg.sendToTarget();
        return true;
    }

    public final void onCloseWindow(WebView webView) {
        if (!(webView instanceof zzid)) {
            zzb.zzaC("Tried to close a WebView that wasn't an AdWebView.");
            return;
        }
        zzc zzc2 = ((zzid)webView).zzgD();
        if (zzc2 == null) {
            zzb.zzaC("Tried to close an AdWebView not associated with an overlay.");
            return;
        }
        zzc2.close();
    }

    public final boolean onConsoleMessage(ConsoleMessage consoleMessage) {
        String string2 = "JS: " + consoleMessage.message() + " (" + consoleMessage.sourceId() + ":" + consoleMessage.lineNumber() + ")";
        if (string2.contains("Application Cache")) {
            return super.onConsoleMessage(consoleMessage);
        }
        switch (consoleMessage.messageLevel()) {
            case ERROR: {
                zzb.zzaz(string2);
                break;
            }
            case WARNING: {
                zzb.zzaC(string2);
                break;
            }
            case LOG: 
            case TIP: {
                zzb.zzaA(string2);
                break;
            }
            case DEBUG: {
                zzb.zzay(string2);
                break;
            }
            default: {
                zzb.zzaA(string2);
            }
        }
        return super.onConsoleMessage(consoleMessage);
    }

    public final void onExceededDatabaseQuota(String url, String databaseIdentifier, long currentQuota, long estimatedSize, long totalUsedQuota, WebStorage.QuotaUpdater quotaUpdater) {
        long l;
        long l2 = 0x500000L - totalUsedQuota;
        if (l2 <= 0L) {
            quotaUpdater.updateQuota(currentQuota);
            return;
        }
        if (currentQuota == 0L) {
            l = estimatedSize <= l2 && estimatedSize <= 0x100000L ? estimatedSize : 0L;
        } else if (estimatedSize == 0L) {
            long l3 = Math.min(131072L, l2);
            l = Math.min(currentQuota + l3, 0x100000L);
        } else {
            long l4 = Math.min(0x100000L - currentQuota, l2);
            l = estimatedSize <= l4 ? currentQuota + estimatedSize : currentQuota;
        }
        quotaUpdater.updateQuota(l);
    }

    public final void onHideCustomView() {
        zzc zzc2 = this.zzoA.zzgD();
        if (zzc2 == null) {
            zzb.zzaC("Could not get ad overlay when hiding custom view.");
            return;
        }
        zzc2.zzer();
    }

    private final Context zzc(WebView webView) {
        if (!(webView instanceof zzid)) {
            return webView.getContext();
        }
        zzid zzid2 = (zzid)webView;
        Activity activity = zzid2.zzgB();
        return activity != null ? activity : zzid2.getContext();
    }

    public final boolean onJsAlert(WebView webView, String url, String message, JsResult result) {
        return this.zza(this.zzc(webView), url, message, null, result, null, false);
    }

    public final boolean onJsBeforeUnload(WebView webView, String url, String message, JsResult result) {
        return this.zza(this.zzc(webView), url, message, null, result, null, false);
    }

    public final boolean onJsConfirm(WebView webView, String url, String message, JsResult result) {
        return this.zza(this.zzc(webView), url, message, null, result, null, false);
    }

    public final boolean onJsPrompt(WebView webView, String url, String message, String defaultValue, JsPromptResult result) {
        return this.zza(this.zzc(webView), url, message, defaultValue, null, result, true);
    }

    public final void onReachedMaxAppCacheSize(long spaceNeeded, long totalUsedQuota, WebStorage.QuotaUpdater quotaUpdater) {
        long l = 0x500000L - totalUsedQuota;
        long l2 = spaceNeeded + 131072L;
        if (l < l2) {
            quotaUpdater.updateQuota(0L);
        } else {
            quotaUpdater.updateQuota(l2);
        }
    }

    public final void onShowCustomView(View view, WebChromeClient.CustomViewCallback customViewCallback) {
        this.zza(view, -1, customViewCallback);
    }

    public final void onGeolocationPermissionsShowPrompt(String origin, GeolocationPermissions.Callback callback) {
        if (callback != null) {
            callback.invoke(origin, this.zzha(), true);
        }
    }

    private final boolean zzha() {
        return zzo.zzbv().zza(this.zzoA.getContext().getPackageManager(), this.zzoA.getContext().getPackageName(), "android.permission.ACCESS_FINE_LOCATION") || zzo.zzbv().zza(this.zzoA.getContext().getPackageManager(), this.zzoA.getContext().getPackageName(), "android.permission.ACCESS_COARSE_LOCATION");
    }

    protected final void zza(View view, int n, WebChromeClient.CustomViewCallback customViewCallback) {
        zzc zzc2 = this.zzoA.zzgD();
        if (zzc2 == null) {
            zzb.zzaC("Could not get ad overlay when showing custom view.");
            customViewCallback.onCustomViewHidden();
            return;
        }
        zzc2.zza(view, customViewCallback);
        zzc2.setRequestedOrientation(n);
    }
}

