/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;

@Beta
@GwtCompatible
public abstract class Converter<A, B>
implements Function<A, B> {
    private final boolean handleNullAutomatically;

    protected Converter() {
        this(true);
    }

    Converter(boolean handleNullAutomatically) {
        this.handleNullAutomatically = handleNullAutomatically;
    }

    protected abstract B doForward(A var1);

    public final B convert(A a) {
        return this.correctedDoForward(a);
    }

    B correctedDoForward(A a) {
        if (this.handleNullAutomatically) {
            return a == null ? null : (B)Preconditions.checkNotNull(this.doForward(a));
        }
        return this.doForward(a);
    }

    @Override
    @Deprecated
    public final B apply(A a) {
        return this.convert(a);
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }
}

