/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.AbstractSetMultimap;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Set;

@GwtCompatible
public final class HashMultimap<K, V>
extends AbstractSetMultimap<K, V> {
    @VisibleForTesting
    transient int expectedValuesPerKey = 2;

    public static <K, V> HashMultimap<K, V> create() {
        return new HashMultimap<K, V>();
    }

    private HashMultimap() {
        super(new HashMap());
    }

    @Override
    Set<V> createCollection() {
        return Sets.newHashSetWithExpectedSize(this.expectedValuesPerKey);
    }
}

