/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.Platform;
import java.util.Collection;

@GwtCompatible
public final class ObjectArrays {
    static final Object[] EMPTY_ARRAY = new Object[0];

    private ObjectArrays() {
    }

    public static <T> T[] newArray(T[] reference, int length) {
        return Platform.newArray(reference, length);
    }

    static <T> T[] arraysCopyOf(T[] original, int newLength) {
        T[] copy = ObjectArrays.newArray(original, newLength);
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    static <T> T[] toArrayImpl(Collection<?> c, T[] array2) {
        int size = c.size();
        if (array2.length < size) {
            array2 = ObjectArrays.newArray(array2, size);
        }
        ObjectArrays.fillArray(c, array2);
        if (array2.length > size) {
            array2[size] = null;
        }
        return array2;
    }

    private static Object[] fillArray(Iterable<?> elements, Object[] array2) {
        int i = 0;
        for (Object element : elements) {
            array2[i++] = element;
        }
        return array2;
    }

    static Object[] checkElementsNotNull(Object ... array2) {
        return ObjectArrays.checkElementsNotNull(array2, array2.length);
    }

    static Object[] checkElementsNotNull(Object[] array2, int length) {
        for (int i = 0; i < length; ++i) {
            ObjectArrays.checkElementNotNull(array2[i], i);
        }
        return array2;
    }

    static Object checkElementNotNull(Object element, int index) {
        if (element == null) {
            throw new NullPointerException("at index " + index);
        }
        return element;
    }
}

