/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ByFunctionOrdering;
import com.google.common.collect.ComparatorOrdering;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.NaturalOrdering;
import com.google.common.collect.ReverseOrdering;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;

@GwtCompatible
public abstract class Ordering<T>
implements Comparator<T> {
    @GwtCompatible
    public static <C extends Comparable> Ordering<C> natural() {
        return NaturalOrdering.INSTANCE;
    }

    @GwtCompatible
    public static <T> Ordering<T> from(Comparator<T> comparator2) {
        return comparator2 instanceof Ordering ? (Ordering<T>)comparator2 : new ComparatorOrdering<T>(comparator2);
    }

    protected Ordering() {
    }

    @GwtCompatible
    public <S extends T> Ordering<S> reverse() {
        return new ReverseOrdering(this);
    }

    @GwtCompatible
    public <F> Ordering<F> onResultOf(Function<F, ? extends T> function) {
        return new ByFunctionOrdering<F, T>(function, this);
    }

    <T2 extends T> Ordering<Map.Entry<T2, ?>> onKeys() {
        return this.onResultOf(Maps.keyFunction());
    }

    @Override
    public abstract int compare(T var1, T var2);

    public <E extends T> ImmutableList<E> immutableSortedCopy(Iterable<E> iterable) {
        Object[] elements;
        for (Object e : elements = Iterables.toArray(iterable)) {
            Preconditions.checkNotNull(e);
        }
        Arrays.sort(elements, this);
        return ImmutableList.asImmutableList(elements);
    }
}

