/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.Ordering;
import com.google.common.collect.SortedIterable;
import java.util.Comparator;
import java.util.SortedSet;

@GwtCompatible
final class SortedIterables {
    public static boolean hasSameComparator(Comparator<?> comparator2, Iterable<?> elements) {
        Comparator<Object> comparator22;
        Preconditions.checkNotNull(comparator2);
        Preconditions.checkNotNull(elements);
        if (elements instanceof SortedSet) {
            comparator22 = SortedIterables.comparator((SortedSet)elements);
        } else if (elements instanceof SortedIterable) {
            comparator22 = ((SortedIterable)elements).comparator();
        } else {
            return false;
        }
        return comparator2.equals(comparator22);
    }

    public static <E> Comparator<? super E> comparator(SortedSet<E> sortedSet) {
        Comparator<E> result = sortedSet.comparator();
        if (result == null) {
            result = Ordering.natural();
        }
        return result;
    }
}

