/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.annotations.Beta;
import com.google.common.hash.Hasher;
import java.io.FilterOutputStream;
import java.io.IOException;

@Beta
public final class HashingOutputStream
extends FilterOutputStream {
    private final Hasher hasher;

    @Override
    public void write(int b) throws IOException {
        this.hasher.putByte((byte)b);
        this.out.write(b);
    }

    @Override
    public void write(byte[] bytes, int off, int len) throws IOException {
        this.hasher.putBytes(bytes, off, len);
        this.out.write(bytes, off, len);
    }
}

