/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.Beta;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.AbstractService;
import com.google.common.util.concurrent.Service;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

@Beta
public abstract class AbstractScheduledService
implements Service {
    private static final Logger logger = Logger.getLogger(AbstractScheduledService.class.getName());
    private final AbstractService delegate = new AbstractService(){
        private final ReentrantLock lock = new ReentrantLock();
        private final Runnable task = new Runnable(){

            @Override
            public void run() {
                lock.lock();
                try {
                    AbstractScheduledService.this.runOneIteration();
                }
                catch (Throwable t) {
                    try {
                        AbstractScheduledService.this.shutDown();
                    }
                    catch (Exception ignored) {
                        logger.log(Level.WARNING, "Error while attempting to shut down the service after failure.", ignored);
                    }
                    this.notifyFailed(t);
                    throw Throwables.propagate(t);
                }
                finally {
                    lock.unlock();
                }
            }
        };
    };

    protected AbstractScheduledService() {
    }

    protected abstract void runOneIteration() throws Exception;

    protected void shutDown() throws Exception {
    }

    protected String serviceName() {
        return this.getClass().getSimpleName();
    }

    public String toString() {
        return this.serviceName() + " [" + (Object)((Object)this.state()) + "]";
    }

    @Override
    public final Service.State state() {
        return this.delegate.state();
    }

    @Beta
    public static abstract class CustomScheduler
    extends Scheduler {

        @Beta
        protected static final class Schedule {
        }
    }

    public static abstract class Scheduler {
        private Scheduler() {
        }
    }
}

