/*
 * Decompiled with CFR 0.152.
 */
package com.irccloud.android;

import android.text.TextUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.irccloud.android.NetworkConnection;
import com.irccloud.android.data.EventsDataSource;
import com.irccloud.android.data.ServersDataSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;

public class CollapsedEventsList {
    public static final int TYPE_NETSPLIT = -1;
    public static final int TYPE_JOIN = 0;
    public static final int TYPE_PART = 1;
    public static final int TYPE_QUIT = 2;
    public static final int TYPE_MODE = 3;
    public static final int TYPE_POPIN = 4;
    public static final int TYPE_POPOUT = 5;
    public static final int TYPE_NICKCHANGE = 6;
    public static final int TYPE_CONNECTIONSTATUS = 7;
    public static final int MODE_OPER = 0;
    public static final int MODE_OWNER = 1;
    public static final int MODE_ADMIN = 2;
    public static final int MODE_OP = 3;
    public static final int MODE_HALFOP = 4;
    public static final int MODE_VOICE = 5;
    public static final int MODE_DEOPER = 6;
    public static final int MODE_DEOWNER = 7;
    public static final int MODE_DEADMIN = 8;
    public static final int MODE_DEOP = 9;
    public static final int MODE_DEHALFOP = 10;
    public static final int MODE_DEVOICE = 11;
    public static final int MODE_COUNT = 12;
    public boolean showChan = false;
    private ArrayList<CollapsedEvent> data = new ArrayList();
    private ServersDataSource.Server server;
    private HashMap<String, String> mode_colors;
    private String[] mode_modes;

    public CollapsedEventsList() {
        this.setServer(null);
    }

    public void setServer(ServersDataSource.Server s) {
        this.server = s;
        if (this.server != null) {
            this.mode_colors = new HashMap<String, String>(){
                {
                    this.put(((CollapsedEventsList)CollapsedEventsList.this).server.MODE_OPER, "E02305");
                    this.put(((CollapsedEventsList)CollapsedEventsList.this).server.MODE_OWNER, "E7AA00");
                    this.put(((CollapsedEventsList)CollapsedEventsList.this).server.MODE_ADMIN, "6500A5");
                    this.put(((CollapsedEventsList)CollapsedEventsList.this).server.MODE_OP, "BA1719");
                    this.put(((CollapsedEventsList)CollapsedEventsList.this).server.MODE_HALFOP, "B55900");
                    this.put(((CollapsedEventsList)CollapsedEventsList.this).server.MODE_VOICED, "25B100");
                }
            };
            this.mode_modes = new String[]{"+" + this.server.MODE_OPER, "+" + this.server.MODE_OWNER, "+" + this.server.MODE_ADMIN, "+" + this.server.MODE_OP, "+" + this.server.MODE_HALFOP, "+" + this.server.MODE_VOICED, "-" + this.server.MODE_OPER, "-" + this.server.MODE_OWNER, "-" + this.server.MODE_ADMIN, "-" + this.server.MODE_OP, "-" + this.server.MODE_HALFOP, "-" + this.server.MODE_VOICED};
        } else {
            this.mode_colors = new HashMap<String, String>(){
                {
                    this.put("Y", "E02305");
                    this.put("q", "E7AA00");
                    this.put("a", "6500A5");
                    this.put("o", "BA1719");
                    this.put("h", "B55900");
                    this.put("v", "25B100");
                }
            };
            this.mode_modes = new String[]{"+Y", "+q", "+a", "+o", "+h", "+v", "-Y", "-q", "-a", "-o", "-h", "-v"};
        }
    }

    public String toString() {
        String out = "CollapsedEventsList {\n";
        for (int i = 0; i < this.data.size(); ++i) {
            out = out + "\t" + this.data.get(i).toString() + "\n";
        }
        out = out + "}";
        return out;
    }

    public boolean addEvent(EventsDataSource.Event event) {
        JsonNode ops;
        String type = event.type;
        if (type.startsWith("you_")) {
            type = type.substring(4);
        }
        if (type.equalsIgnoreCase("joined_channel")) {
            this.addEvent(event.eid, 0, event.nick, null, event.hostmask, event.from_mode, null, event.chan);
        } else if (type.equalsIgnoreCase("parted_channel")) {
            this.addEvent(event.eid, 1, event.nick, null, event.hostmask, event.from_mode, event.msg, event.chan);
        } else if (type.equalsIgnoreCase("quit")) {
            this.addEvent(event.eid, 2, event.nick, null, event.hostmask, event.from_mode, event.msg, event.chan);
        } else if (type.equalsIgnoreCase("nickchange")) {
            this.addEvent(event.eid, 6, event.nick, event.old_nick, null, event.from_mode, null, event.chan);
        } else if (type.equalsIgnoreCase("socket_closed") || type.equalsIgnoreCase("connecting_failed") || type.equalsIgnoreCase("connecting_cancelled")) {
            this.addEvent(event.eid, 7, null, null, null, null, event.msg, null);
        } else if (type.equalsIgnoreCase("user_channel_mode") && (ops = event.ops) != null) {
            CollapsedEvent e = this.findEvent(event.nick, event.chan);
            if (e == null) {
                e = new CollapsedEvent();
                e.type = 3;
                e.hostmask = event.hostmask;
                e.target_mode = event.target_mode;
                e.nick = event.nick;
                e.chan = event.chan;
            }
            JsonNode add = ops.get("add");
            for (int i = 0; i < add.size(); ++i) {
                JsonNode op = add.get(i);
                if (!e.addMode(op.get("mode").asText())) {
                    return false;
                }
                if (e.type == 3) {
                    if (event.from != null && event.from.length() > 0) {
                        e.from_nick = event.from;
                        e.from_mode = event.from_mode;
                        continue;
                    }
                    e.from_nick = event.server;
                    e.from_mode = "__the_server__";
                    continue;
                }
                e.from_mode = event.target_mode;
            }
            JsonNode remove = ops.get("remove");
            for (int i = 0; i < remove.size(); ++i) {
                JsonNode op = remove.get(i);
                if (!e.removeMode(op.get("mode").asText())) {
                    return false;
                }
                if (e.type == 3) {
                    if (event.from != null && event.from.length() > 0) {
                        e.from_nick = event.from;
                        e.from_mode = event.from_mode;
                        continue;
                    }
                    e.from_nick = event.server;
                    e.from_mode = "__the_server__";
                    continue;
                }
                e.from_mode = event.target_mode;
            }
            if (!this.data.contains(e)) {
                this.data.add(e);
            }
        }
        return true;
    }

    public void addEvent(long eid, int type, String nick, String old_nick, String hostmask, String from_mode, String msg, String chan) {
        this.addEvent(eid, type, nick, old_nick, hostmask, from_mode, msg, null, chan);
    }

    public void addEvent(long eid, int type, String nick, String old_nick, String hostmask, String from_mode, String msg, String target_mode, String chan) {
        String[] parts;
        CollapsedEvent e = null;
        if (type < 6) {
            if (this.showChan) {
                if (type == 2) {
                    boolean found = false;
                    for (CollapsedEvent collapsedEvent : this.data) {
                        if (collapsedEvent.type != 0) continue;
                        collapsedEvent.type = 4;
                        found = true;
                    }
                    if (found) {
                        return;
                    }
                } else if (type == 0) {
                    for (CollapsedEvent ev : this.data) {
                        if (ev.type != 2) continue;
                        ev.type = 5;
                        return;
                    }
                }
            }
            if (old_nick != null && type != 3 && (e = this.findEvent(old_nick, chan)) != null) {
                e.nick = nick;
            }
            if (e == null) {
                e = this.findEvent(nick, chan);
            }
            if (e == null) {
                e = new CollapsedEvent();
                e.eid = eid;
                e.type = type;
                e.nick = nick;
                e.old_nick = old_nick;
                e.hostmask = hostmask;
                e.from_mode = from_mode;
                e.msg = msg;
                e.target_mode = target_mode;
                e.chan = chan;
                this.data.add(e);
            } else {
                e.eid = eid;
                if (e.type == 3) {
                    e.type = type;
                    e.msg = msg;
                    e.old_nick = old_nick;
                    e.hostmask = hostmask;
                    if (from_mode != null) {
                        e.from_mode = from_mode;
                    }
                    if (target_mode != null) {
                        e.target_mode = target_mode;
                    }
                } else if (type != e.type && e.type == 6) {
                    e.type = type;
                    e.from_mode = from_mode;
                    e.hostmask = hostmask;
                    e.nick = nick;
                    e.msg = msg;
                } else if (type == 3) {
                    e.from_mode = target_mode;
                } else if (type == 0) {
                    e.type = e.type == 4 ? 0 : 5;
                    e.from_mode = from_mode;
                    e.chan = chan;
                } else if (e.type == 5) {
                    e.type = type;
                } else if (e.type != type) {
                    e.type = 4;
                }
            }
        } else if (type == 6) {
            for (CollapsedEvent e1 : this.data) {
                if (e1.type == 6 && e1.nick.equalsIgnoreCase(old_nick)) {
                    if (e1.old_nick.equalsIgnoreCase(nick)) {
                        this.data.remove(e1);
                    } else {
                        e1.nick = nick;
                    }
                    return;
                }
                if ((e1.type == 0 || e1.type == 5) && e1.nick.equalsIgnoreCase(old_nick)) {
                    e1.old_nick = old_nick;
                    e1.nick = nick;
                    for (CollapsedEvent e2 : this.data) {
                        if (e2.type != 2 && e2.type != 1 || !e2.nick.equalsIgnoreCase(nick)) continue;
                        e1.type = 5;
                        this.data.remove(e2);
                        break;
                    }
                    if (this.data.size() > 0) {
                        return;
                    }
                }
                if (e1.type != 2 && e1.type != 1 || !e1.nick.equalsIgnoreCase(nick)) continue;
                e1.type = 5;
                for (CollapsedEvent e2 : this.data) {
                    if (e2.type != 0 || !e2.nick.equalsIgnoreCase(old_nick)) continue;
                    this.data.remove(e2);
                    break;
                }
                if (this.data.size() <= 0) continue;
                return;
            }
            e = new CollapsedEvent();
            e.eid = eid;
            e.type = type;
            e.nick = nick;
            e.from_mode = from_mode;
            e.old_nick = old_nick;
            e.hostmask = hostmask;
            e.msg = msg;
            e.chan = chan;
            this.data.add(e);
        } else if (type == 7) {
            for (CollapsedEvent e1 : this.data) {
                if (!e1.msg.equals(msg)) continue;
                ++e1.count;
                return;
            }
            e = new CollapsedEvent();
            e.eid = eid;
            e.type = type;
            e.msg = msg;
            e.count = 1;
            this.data.add(e);
        } else {
            e = new CollapsedEvent();
            e.eid = eid;
            e.type = type;
            e.nick = nick;
            e.from_mode = from_mode;
            e.old_nick = old_nick;
            e.hostmask = hostmask;
            e.msg = msg;
            e.chan = chan;
            this.data.add(e);
        }
        if (type == 2 && msg != null && msg.matches("(?:[^\\s:\\/.]+\\.)+[a-z]{2,} (?:[^\\s:\\/.]+\\.)+[a-z]{2,}") && (parts = msg.split(" ")).length > 1 && !parts[0].equals(parts[1])) {
            e.netsplit = true;
            boolean found = false;
            for (CollapsedEvent c : this.data) {
                if (c.type != -1 || !c.msg.equalsIgnoreCase(msg)) continue;
                found = true;
            }
            if (!found && this.data.size() > 1) {
                CollapsedEvent collapsedEvent = new CollapsedEvent();
                collapsedEvent.eid = eid;
                collapsedEvent.type = -1;
                collapsedEvent.msg = msg;
                this.data.add(collapsedEvent);
            }
        }
    }

    public CollapsedEvent findEvent(String nick, String chan) {
        for (CollapsedEvent e : this.data) {
            if (e.nick == null || !e.nick.equalsIgnoreCase(nick) || e.chan != null && !e.chan.equalsIgnoreCase(chan)) continue;
            return e;
        }
        return null;
    }

    public String formatNick(String nick, String from_mode, boolean colorize) {
        ObjectNode PREFIX = null;
        if (this.server != null) {
            PREFIX = this.server.PREFIX;
        }
        if (PREFIX == null) {
            PREFIX = new ObjectMapper().createObjectNode();
            PREFIX.put(this.server != null ? this.server.MODE_OPER : "Y", "!");
            PREFIX.put(this.server != null ? this.server.MODE_OWNER : "q", "~");
            PREFIX.put(this.server != null ? this.server.MODE_ADMIN : "a", "&");
            PREFIX.put(this.server != null ? this.server.MODE_OP : "o", "@");
            PREFIX.put(this.server != null ? this.server.MODE_HALFOP : "h", "%");
            PREFIX.put(this.server != null ? this.server.MODE_VOICED : "v", "+");
        }
        String[] colors = new String[]{"fc009a", "ff1f1a", "d20004", "fd6508", "880019", "c7009c", "804fc4", "5200b7", "123e92", "1d40ff", "108374", "2e980d", "207607", "196d61"};
        String color2 = null;
        if (colorize) {
            String normalizedNick = nick.toLowerCase().replaceAll("[`_]+$", "");
            normalizedNick = normalizedNick.replaceAll("|.*$", "");
            Double hash = 0.0;
            for (int i = 0; i < normalizedNick.length(); ++i) {
                hash = (double)normalizedNick.charAt(i) + (double)((int)hash.longValue() << 6) + (double)((int)hash.longValue() << 16) - hash;
            }
            color2 = colors[(int)Math.abs(hash.longValue() % 14L)];
        }
        StringBuilder output = new StringBuilder();
        boolean showSymbol = false;
        try {
            if (NetworkConnection.getInstance().getUserInfo() != null && NetworkConnection.getInstance().getUserInfo().prefs != null) {
                showSymbol = NetworkConnection.getInstance().getUserInfo().prefs.getBoolean("mode-showsymbol");
            }
        }
        catch (Exception i) {
            // empty catch block
        }
        String mode = "";
        if (from_mode != null && from_mode.length() > 0) {
            mode = from_mode.contains(this.server != null ? this.server.MODE_OPER : "Y") ? (this.server != null ? this.server.MODE_OPER : "Y") : (from_mode.contains(this.server != null ? this.server.MODE_OWNER : "q") ? (this.server != null ? this.server.MODE_OWNER : "q") : (from_mode.contains(this.server != null ? this.server.MODE_ADMIN : "a") ? (this.server != null ? this.server.MODE_ADMIN : "a") : (from_mode.contains(this.server != null ? this.server.MODE_OP : "o") ? (this.server != null ? this.server.MODE_OP : "o") : (from_mode.contains(this.server != null ? this.server.MODE_HALFOP : "h") ? (this.server != null ? this.server.MODE_HALFOP : "h") : (from_mode.contains(this.server != null ? this.server.MODE_VOICED : "v") ? (this.server != null ? this.server.MODE_VOICED : "v") : from_mode.substring(0, 1))))));
        }
        if (mode != null && mode.length() > 0) {
            if (this.mode_colors.containsKey(mode)) {
                output.append("\u0004").append(this.mode_colors.get(mode)).append("\u0002");
            } else {
                output.append("\u0002");
            }
            if (showSymbol) {
                if (PREFIX.has(mode)) {
                    output.append(TextUtils.htmlEncode((String)PREFIX.get(mode).asText()));
                }
            } else {
                output.append("\u2022");
            }
            output.append("\u000f ");
        }
        if (color2 != null) {
            output.append("\u0004").append(color2);
        }
        output.append(nick);
        if (color2 != null) {
            output.append("\u0004");
        }
        return output.toString();
    }

    private String was(CollapsedEvent e) {
        StringBuilder was = new StringBuilder();
        String modes = e.getModes(false);
        if (e.old_nick != null && e.type != 3) {
            was.append("was ").append(e.old_nick);
        }
        if (modes != null && modes.length() > 0) {
            if (was.length() > 0) {
                was.append("; ");
            }
            was.append("\u00031").append(modes).append("\u000f");
        }
        if (was.length() > 0) {
            was.insert(0, " (").append(")");
        }
        return was.toString();
    }

    public String getCollapsedMessage() {
        StringBuilder message = new StringBuilder();
        if (this.data.size() == 0) {
            return null;
        }
        if (this.data.size() == 1 && this.data.get(0).modeCount() < (this.data.get((int)0).type == 3 ? 2 : 1)) {
            CollapsedEvent e = this.data.get(0);
            switch (e.type) {
                case -1: {
                    message.append(e.msg.replace(" ", " \u21ae "));
                    break;
                }
                case 3: {
                    message.append("<b>").append(this.formatNick(e.nick, e.target_mode, false)).append("</b> was ").append(e.getModes(true));
                    if (e.from_nick == null) break;
                    if (e.from_mode != null && e.from_mode.equalsIgnoreCase("__the_server__")) {
                        message.append(" by the server <b>").append(e.from_nick).append("</b>");
                        break;
                    }
                    message.append(" by ").append(this.formatNick(e.from_nick, e.from_mode, false));
                    break;
                }
                case 0: {
                    message.append("\u2192 <b>").append(this.formatNick(e.nick, e.from_mode, false)).append("</b>").append(this.was(e));
                    message.append(" joined");
                    if (this.showChan) {
                        message.append(" ").append(e.chan);
                    }
                    message.append(" (").append(e.hostmask).append(")");
                    break;
                }
                case 1: {
                    message.append("\u2190 <b>").append(this.formatNick(e.nick, e.from_mode, false)).append("</b>").append(this.was(e));
                    message.append(" left");
                    if (this.showChan) {
                        message.append(" ").append(e.chan);
                    }
                    message.append(" (").append(e.hostmask).append(")");
                    if (e.msg == null || e.msg.length() <= 0) break;
                    message.append(": ").append(e.msg);
                    break;
                }
                case 2: {
                    message.append("\u21d0 <b>").append(this.formatNick(e.nick, e.from_mode, false)).append("</b>").append(this.was(e));
                    if (e.hostmask != null) {
                        message.append(" quit (").append(e.hostmask).append(") ");
                    } else {
                        message.append(" quit: ");
                    }
                    if (e.msg == null || e.msg.length() <= 0) break;
                    message.append(e.msg);
                    break;
                }
                case 6: {
                    message.append(e.old_nick).append(" \u2192 <b>").append(this.formatNick(e.nick, e.from_mode, false)).append("</b>");
                    break;
                }
                case 4: {
                    message.append("\u2194 <b>").append(this.formatNick(e.nick, e.from_mode, false)).append("</b>").append(this.was(e));
                    message.append(" popped in");
                    if (!this.showChan) break;
                    message.append(" ").append(e.chan);
                    break;
                }
                case 5: {
                    message.append("\u2194 <b>").append(this.formatNick(e.nick, e.from_mode, false)).append("</b>").append(this.was(e));
                    message.append(" nipped out");
                    if (!this.showChan) break;
                    message.append(" ").append(e.chan);
                    break;
                }
                case 7: {
                    message.append(e.msg);
                    if (e.count <= 1) break;
                    message.append(" (").append(e.count).append("x)");
                }
            }
        } else {
            boolean netsplit = false;
            Collections.sort(this.data, new comparator());
            Iterator<CollapsedEvent> i = this.data.iterator();
            CollapsedEvent last = null;
            CollapsedEvent next = i.next();
            int groupcount = 0;
            while (next != null) {
                CollapsedEvent e = next;
                while ((next = i.hasNext() ? i.next() : null) != null && netsplit && next.netsplit) {
                }
                if (message.length() > 0 && e.type < 6 && (next == null || next.type != e.type) && last != null && last.type == e.type) {
                    if (groupcount == 1) {
                        message.delete(message.length() - 2, message.length()).append(" ");
                    }
                    message.append("and ");
                }
                if (last == null || last.type != e.type) {
                    switch (e.type) {
                        case -1: {
                            netsplit = true;
                            break;
                        }
                        case 3: {
                            if (message.length() > 0) {
                                message.append("\u2022 ");
                            }
                            message.append("\u00031mode:\u000f ");
                            break;
                        }
                        case 0: {
                            message.append("\u2192 ");
                            break;
                        }
                        case 1: {
                            message.append("\u2190 ");
                            break;
                        }
                        case 2: {
                            message.append("\u21d0 ");
                            break;
                        }
                        case 6: {
                            if (message.length() <= 0) break;
                            message.append("\u2022 ");
                            break;
                        }
                        case 4: 
                        case 5: {
                            message.append("\u2194 ");
                            break;
                        }
                    }
                }
                if (e.type == 6) {
                    message.append(e.old_nick).append(" \u2192 <b>").append(this.formatNick(e.nick, e.from_mode, false)).append("</b>");
                    String old_nick = e.old_nick;
                    e.old_nick = null;
                    message.append(this.was(e));
                    e.old_nick = old_nick;
                } else if (e.type == -1) {
                    message.append(e.msg.replace(" ", " \u21ae "));
                } else if (e.type == 7) {
                    message.append(e.msg);
                    if (e.count > 1) {
                        message.append(" (").append(e.count).append("x)");
                    }
                } else if (!this.showChan) {
                    message.append("<b>").append(this.formatNick(e.nick, e.type == 3 ? e.target_mode : e.from_mode, false)).append("</b>").append(this.was(e));
                }
                if (!(next != null && next.type == e.type || this.showChan)) {
                    switch (e.type) {
                        case 0: {
                            message.append(" joined");
                            break;
                        }
                        case 1: {
                            message.append(" left");
                            break;
                        }
                        case 2: {
                            message.append(" quit");
                            break;
                        }
                        case 4: {
                            message.append(" popped in");
                            break;
                        }
                        case 5: {
                            message.append(" nipped out");
                        }
                    }
                } else if (this.showChan && e.type != -1 && e.type != 7) {
                    if (groupcount == 0) {
                        message.append("<b>").append(this.formatNick(e.nick, e.type == 3 ? e.target_mode : e.from_mode, false)).append("</b>").append(this.was(e));
                        switch (e.type) {
                            case 0: {
                                message.append(" joined ");
                                break;
                            }
                            case 1: {
                                message.append(" left ");
                                break;
                            }
                            case 2: {
                                message.append(" quit ");
                                break;
                            }
                            case 4: {
                                message.append(" popped in ");
                                break;
                            }
                            case 5: {
                                message.append(" nipped out ");
                            }
                        }
                    }
                    if (e.type != 2) {
                        message.append(e.chan);
                    }
                }
                if (next != null && next.type == e.type) {
                    if (message.length() > 0) {
                        message.append(", ");
                        ++groupcount;
                    }
                } else if (next != null) {
                    message.append(" ");
                    groupcount = 0;
                }
                last = e;
            }
        }
        return message.toString();
    }

    public void clear() {
        this.data.clear();
    }

    public int size() {
        return this.data.size();
    }

    public class comparator
    implements Comparator<CollapsedEvent> {
        @Override
        public int compare(CollapsedEvent e1, CollapsedEvent e2) {
            if (e1.type == e2.type) {
                if (e1.eid > e2.eid) {
                    return 1;
                }
                return -1;
            }
            if (e1.type > e2.type) {
                return 1;
            }
            return -1;
        }
    }

    public class CollapsedEvent {
        long eid;
        int type;
        boolean[] modes = new boolean[12];
        String nick;
        String old_nick;
        String hostmask;
        String msg;
        String from_mode;
        String from_nick;
        String target_mode;
        String chan;
        boolean netsplit;
        int count;

        public String toString() {
            return "{type: " + this.type + ", nick: " + this.nick + ", old_nick: " + this.old_nick + ", hostmask: " + this.hostmask + ", msg: " + this.msg + "netsplit: " + this.netsplit + "}";
        }

        public int modeCount() {
            int count = 0;
            for (int i = 0; i < 12; ++i) {
                if (!this.modes[i]) continue;
                ++count;
            }
            return count;
        }

        public boolean addMode(String mode) {
            if (mode.equalsIgnoreCase(CollapsedEventsList.this.server != null ? ((CollapsedEventsList)CollapsedEventsList.this).server.MODE_OPER : "Y")) {
                if (this.modes[6]) {
                    this.modes[6] = false;
                } else {
                    this.modes[0] = true;
                }
            } else if (mode.equalsIgnoreCase(CollapsedEventsList.this.server != null ? ((CollapsedEventsList)CollapsedEventsList.this).server.MODE_OWNER : "q")) {
                if (this.modes[7]) {
                    this.modes[7] = false;
                } else {
                    this.modes[1] = true;
                }
            } else if (mode.equalsIgnoreCase(CollapsedEventsList.this.server != null ? ((CollapsedEventsList)CollapsedEventsList.this).server.MODE_ADMIN : "a")) {
                if (this.modes[8]) {
                    this.modes[8] = false;
                } else {
                    this.modes[2] = true;
                }
            } else if (mode.equalsIgnoreCase(CollapsedEventsList.this.server != null ? ((CollapsedEventsList)CollapsedEventsList.this).server.MODE_OP : "o")) {
                if (this.modes[9]) {
                    this.modes[9] = false;
                } else {
                    this.modes[3] = true;
                }
            } else if (mode.equalsIgnoreCase(CollapsedEventsList.this.server != null ? ((CollapsedEventsList)CollapsedEventsList.this).server.MODE_HALFOP : "h")) {
                if (this.modes[10]) {
                    this.modes[10] = false;
                } else {
                    this.modes[4] = true;
                }
            } else if (mode.equalsIgnoreCase(CollapsedEventsList.this.server != null ? ((CollapsedEventsList)CollapsedEventsList.this).server.MODE_VOICED : "v")) {
                if (this.modes[11]) {
                    this.modes[11] = false;
                } else {
                    this.modes[5] = true;
                }
            } else {
                return false;
            }
            if (this.modeCount() == 0) {
                return this.addMode(mode);
            }
            return true;
        }

        public boolean removeMode(String mode) {
            if (mode.equalsIgnoreCase(CollapsedEventsList.this.server != null ? ((CollapsedEventsList)CollapsedEventsList.this).server.MODE_OPER : "Y")) {
                if (this.modes[0]) {
                    this.modes[0] = false;
                } else {
                    this.modes[6] = true;
                }
            } else if (mode.equalsIgnoreCase(CollapsedEventsList.this.server != null ? ((CollapsedEventsList)CollapsedEventsList.this).server.MODE_OWNER : "q")) {
                if (this.modes[1]) {
                    this.modes[1] = false;
                } else {
                    this.modes[7] = true;
                }
            } else if (mode.equalsIgnoreCase(CollapsedEventsList.this.server != null ? ((CollapsedEventsList)CollapsedEventsList.this).server.MODE_ADMIN : "a")) {
                if (this.modes[2]) {
                    this.modes[2] = false;
                } else {
                    this.modes[8] = true;
                }
            } else if (mode.equalsIgnoreCase(CollapsedEventsList.this.server != null ? ((CollapsedEventsList)CollapsedEventsList.this).server.MODE_OP : "o")) {
                if (this.modes[3]) {
                    this.modes[3] = false;
                } else {
                    this.modes[9] = true;
                }
            } else if (mode.equalsIgnoreCase(CollapsedEventsList.this.server != null ? ((CollapsedEventsList)CollapsedEventsList.this).server.MODE_HALFOP : "h")) {
                if (this.modes[4]) {
                    this.modes[4] = false;
                } else {
                    this.modes[10] = true;
                }
            } else if (mode.equalsIgnoreCase(CollapsedEventsList.this.server != null ? ((CollapsedEventsList)CollapsedEventsList.this).server.MODE_VOICED : "v")) {
                if (this.modes[5]) {
                    this.modes[5] = false;
                } else {
                    this.modes[11] = true;
                }
            } else {
                return false;
            }
            if (this.modeCount() == 0) {
                return this.removeMode(mode);
            }
            return true;
        }

        public String getModes(boolean showSymbol) {
            String[] mode_msgs = new String[]{"promoted to oper", "promoted to owner", "promoted to admin", "opped", "halfopped", "voiced", "demoted from oper", "demoted from owner", "demoted from admin", "de-opped", "de-halfopped", "de-voiced"};
            String output = null;
            if (this.modeCount() > 0) {
                output = "";
                for (int i = 0; i < 12; ++i) {
                    if (!this.modes[i]) continue;
                    if (output.length() > 0) {
                        output = output + ", ";
                    }
                    output = output + mode_msgs[i];
                    if (!showSymbol) continue;
                    output = output + " (\u0004" + (String)CollapsedEventsList.this.mode_colors.get(CollapsedEventsList.this.mode_modes[i].substring(1)) + CollapsedEventsList.this.mode_modes[i] + "\u000f)";
                }
            }
            return output;
        }
    }
}

