/*
 * Decompiled with CFR 0.152.
 */
package com.irccloud.android;

import android.annotation.TargetApi;
import android.content.Context;
import android.util.Log;
import com.crashlytics.android.Crashlytics;
import com.squareup.leakcanary.AbstractAnalysisResultService;
import com.squareup.leakcanary.AnalysisResult;
import com.squareup.leakcanary.HeapDump;
import com.squareup.leakcanary.LeakCanary;
import com.squareup.leakcanary.internal.LeakCanaryInternals;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;

public class CrashlyticsLeakService
extends AbstractAnalysisResultService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TargetApi(value=11)
    protected final void onHeapAnalyzed(HeapDump heapDump, AnalysisResult result) {
        String leakInfo = LeakCanary.leakInfo((Context)this, heapDump, result, true);
        if (leakInfo.length() < 4000) {
            Log.d((String)"LeakCanary", (String)leakInfo);
        } else {
            String[] lines;
            for (String line : lines = leakInfo.split("\n")) {
                Log.d((String)"LeakCanary", (String)line);
            }
        }
        if (result.failure == null && (!result.leakFound || result.excludedLeak)) {
            this.afterDefaultHandling(heapDump, result, leakInfo);
            return;
        }
        int maxStoredLeaks = this.getResources().getInteger(2131427331);
        File renamedFile = LeakCanaryInternals.findNextAvailableHprofFile(maxStoredLeaks);
        if (renamedFile == null) {
            Log.e((String)"LeakCanary", (String)("Leak result dropped because we already store " + maxStoredLeaks + " leak traces."));
            this.afterDefaultHandling(heapDump, result, leakInfo);
            return;
        }
        heapDump = heapDump.renameFile(renamedFile);
        File resultFile = LeakCanaryInternals.leakResultFile(renamedFile);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(resultFile);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(heapDump);
            oos.writeObject(result);
        }
        catch (IOException e) {
            Log.e((String)"LeakCanary", (String)"Could not save leak analysis result to disk", (Throwable)e);
            this.afterDefaultHandling(heapDump, result, leakInfo);
            return;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.afterDefaultHandling(heapDump, result, leakInfo);
    }

    private static String classSimpleName(String className) {
        int separator = className.lastIndexOf(46);
        return separator == -1 ? className : className.substring(separator + 1);
    }

    protected void afterDefaultHandling(HeapDump heapDump, AnalysisResult result, String leakInfo) {
        if (!result.leakFound || result.excludedLeak) {
            return;
        }
        Crashlytics.log("*** Memory Leak ***");
        for (String s : leakInfo.split("\n")) {
            Crashlytics.log(s);
        }
        Crashlytics.log("*******************");
        String name = CrashlyticsLeakService.classSimpleName(result.className);
        if (!heapDump.referenceName.equals("")) {
            name = name + "(" + heapDump.referenceName + ")";
        }
        Crashlytics.logException(new Exception(name + " has leaked"));
    }
}

