/*
 * Decompiled with CFR 0.152.
 */
package com.irccloud.android;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.preference.PreferenceManager;
import android.text.Html;
import com.google.android.apps.dashclock.api.DashClockExtension;
import com.google.android.apps.dashclock.api.ExtensionData;
import com.irccloud.android.IRCCloudApplication;
import com.irccloud.android.Notifications;
import com.irccloud.android.activity.MainActivity;
import java.util.ArrayList;

public class DashClock
extends DashClockExtension {
    public static final String REFRESH_INTENT = "com.irccloud.android.dashclock.REFRESH";
    RefreshReceiver receiver;

    @Override
    protected void onInitialize(boolean isReconnect) {
        super.onInitialize(isReconnect);
        if (this.receiver != null) {
            try {
                this.unregisterReceiver(this.receiver);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        IntentFilter intentFilter = new IntentFilter(REFRESH_INTENT);
        this.receiver = new RefreshReceiver();
        this.registerReceiver(this.receiver, intentFilter);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (this.receiver != null) {
            try {
                this.unregisterReceiver(this.receiver);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected void onUpdateData(int reason) {
        int count = Notifications.getInstance().count();
        if (count > 0) {
            if (PreferenceManager.getDefaultSharedPreferences((Context)IRCCloudApplication.getInstance().getApplicationContext()).getBoolean("dashclock_showmsgs", false)) {
                String msg = "";
                ArrayList<Notifications.Notification> msgs = Notifications.getInstance().getMessageNotifications();
                for (Notifications.Notification n : msgs) {
                    if (n.message_type.equals("buffer_me_msg")) {
                        msg = msg + "\u2014 " + n.nick + " " + Html.fromHtml((String)n.message) + "\n";
                        continue;
                    }
                    msg = msg + "<" + n.nick + "> " + Html.fromHtml((String)n.message) + "\n";
                }
                this.publishUpdate(new ExtensionData().visible(true).icon(2130837630).status(String.valueOf(count)).expandedTitle(String.valueOf(count) + " unread highlight" + (count > 1 ? "s" : "")).expandedBody(msg).clickIntent(new Intent(IRCCloudApplication.getInstance().getApplicationContext(), MainActivity.class)));
            } else {
                this.publishUpdate(new ExtensionData().visible(true).icon(2130837630).status(String.valueOf(count)).expandedTitle(String.valueOf(count) + " unread highlight" + (count > 1 ? "s" : "")).clickIntent(new Intent(IRCCloudApplication.getInstance().getApplicationContext(), MainActivity.class)));
            }
        } else {
            this.publishUpdate(null);
        }
    }

    class RefreshReceiver
    extends BroadcastReceiver {
        RefreshReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            DashClock.this.onUpdateData(0);
        }
    }
}

