/*
 * Decompiled with CFR 0.152.
 */
package com.irccloud.android;

import android.app.Activity;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.v4.view.ViewCompat;
import android.support.v7.appcompat.R;

public class DrawerArrowDrawable
extends Drawable {
    private final Paint mPaint = new Paint();
    private static final float ARROW_HEAD_ANGLE = (float)Math.toRadians(45.0);
    private final float mBarThickness;
    private final float mTopBottomArrowSize;
    private final float mBarSize;
    private final float mMiddleArrowSize;
    private final float mBarGap;
    private final boolean mSpin;
    private final Path mPath = new Path();
    private final int mSize;
    private boolean mVerticalMirror = false;
    private float mProgress;
    private final Activity mContext;

    public DrawerArrowDrawable(Activity context) {
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(null, R.styleable.DrawerArrowToggle, 2130771968, 2131296256);
        this.mContext = context;
        this.mPaint.setAntiAlias(true);
        this.mPaint.setColor(typedArray.getColor(0, 0));
        this.mSize = typedArray.getDimensionPixelSize(2, 0);
        this.mBarSize = typedArray.getDimension(6, 0.0f);
        this.mTopBottomArrowSize = typedArray.getDimension(4, 0.0f);
        this.mBarThickness = typedArray.getDimension(7, 0.0f);
        this.mBarGap = typedArray.getDimension(3, 0.0f);
        this.mSpin = typedArray.getBoolean(1, true);
        this.mMiddleArrowSize = typedArray.getDimension(5, 0.0f);
        typedArray.recycle();
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeJoin(Paint.Join.ROUND);
        this.mPaint.setStrokeCap(Paint.Cap.SQUARE);
        this.mPaint.setStrokeWidth(this.mBarThickness);
    }

    boolean isLayoutRtl() {
        return ViewCompat.getLayoutDirection(this.mContext.getWindow().getDecorView()) == 1;
    }

    protected void setVerticalMirror(boolean verticalMirror) {
        this.mVerticalMirror = verticalMirror;
    }

    public void draw(Canvas canvas) {
        Rect bounds = this.getBounds();
        boolean isRtl = this.isLayoutRtl();
        float arrowSize = DrawerArrowDrawable.lerp(this.mBarSize, this.mTopBottomArrowSize, this.mProgress);
        float middleBarSize = DrawerArrowDrawable.lerp(this.mBarSize, this.mMiddleArrowSize, this.mProgress);
        float middleBarCut = DrawerArrowDrawable.lerp(0.0f, this.mBarThickness / 2.0f, this.mProgress);
        float rotation = DrawerArrowDrawable.lerp(0.0f, ARROW_HEAD_ANGLE, this.mProgress);
        float canvasRotate = DrawerArrowDrawable.lerp(isRtl ? 0.0f : -180.0f, isRtl ? 180.0f : 0.0f, this.mProgress);
        float topBottomBarOffset = DrawerArrowDrawable.lerp(this.mBarGap + this.mBarThickness, 0.0f, this.mProgress);
        this.mPath.rewind();
        float arrowEdge = -middleBarSize / 2.0f;
        this.mPath.moveTo(arrowEdge + middleBarCut, 0.0f);
        this.mPath.rLineTo(middleBarSize - middleBarCut, 0.0f);
        float arrowWidth = Math.round((double)arrowSize * Math.cos(rotation));
        float arrowHeight = Math.round((double)arrowSize * Math.sin(rotation));
        this.mPath.moveTo(arrowEdge, topBottomBarOffset);
        this.mPath.rLineTo(arrowWidth, arrowHeight);
        this.mPath.moveTo(arrowEdge, -topBottomBarOffset);
        this.mPath.rLineTo(arrowWidth, -arrowHeight);
        this.mPath.moveTo(0.0f, 0.0f);
        this.mPath.close();
        canvas.save();
        if (this.mSpin) {
            canvas.rotate(canvasRotate * (float)(this.mVerticalMirror ^ isRtl ? -1 : 1), (float)bounds.centerX(), (float)bounds.centerY());
        } else if (isRtl) {
            canvas.rotate(180.0f, (float)bounds.centerX(), (float)bounds.centerY());
        }
        canvas.translate((float)bounds.centerX(), (float)bounds.centerY());
        canvas.drawPath(this.mPath, this.mPaint);
        canvas.restore();
    }

    public void setAlpha(int i) {
        this.mPaint.setAlpha(i);
    }

    public boolean isAutoMirrored() {
        return true;
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.mPaint.setColorFilter(colorFilter);
        this.invalidateSelf();
    }

    public ColorFilter getColorFilter() {
        return this.mPaint.getColorFilter();
    }

    public void setColor(int color2) {
        this.mPaint.setColor(color2);
        this.invalidateSelf();
    }

    public int getColor() {
        return this.mPaint.getColor();
    }

    public int getIntrinsicHeight() {
        return this.mSize;
    }

    public int getIntrinsicWidth() {
        return this.mSize;
    }

    public int getOpacity() {
        return -3;
    }

    public float getProgress() {
        return this.mProgress;
    }

    public void setProgress(float progress) {
        if (progress == 1.0f) {
            this.setVerticalMirror(true);
        } else if (progress == 0.0f) {
            this.setVerticalMirror(false);
        }
        this.mProgress = progress;
        this.invalidateSelf();
    }

    private static float lerp(float a, float b, float t) {
        return a + (b - a) * t;
    }
}

