/*
 * Decompiled with CFR 0.152.
 */
package com.irccloud.android;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.android.gms.gcm.GoogleCloudMessaging;
import com.irccloud.android.ColorFormatter;
import com.irccloud.android.GCMBroadcastReceiver;
import com.irccloud.android.IRCCloudApplication;
import com.irccloud.android.NetworkConnection;
import com.irccloud.android.Notifications;
import com.irccloud.android.data.BuffersDataSource;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONObject;

public class GCMIntentService
extends IntentService {
    private static final Timer GCMTimer = new Timer("GCM-Registration-Timer");

    public GCMIntentService() {
        super("GcmIntentService");
    }

    protected void onHandleIntent(Intent intent) {
        if (intent != null) {
            Bundle extras = intent.getExtras();
            GoogleCloudMessaging gcm = GoogleCloudMessaging.getInstance((Context)this);
            String messageType = gcm.getMessageType(intent);
            if (extras != null && !extras.isEmpty() && !"send_error".equals(messageType) && !"deleted_messages".equals(messageType) && "gcm".equals(messageType)) {
                if (!IRCCloudApplication.getInstance().getApplicationContext().getSharedPreferences("prefs", 0).getBoolean("gcm_registered", false)) {
                    String regId = IRCCloudApplication.getInstance().getApplicationContext().getSharedPreferences("prefs", 0).getString("gcm_reg_id", "");
                    if (regId.length() > 0) {
                        GCMIntentService.scheduleUnregisterTimer(100, regId, false);
                    }
                } else {
                    try {
                        String type = intent.getStringExtra("type");
                        if (type.equalsIgnoreCase("heartbeat_echo")) {
                            NetworkConnection conn = NetworkConnection.getInstance();
                            ObjectMapper mapper = new ObjectMapper();
                            JsonParser parser = mapper.getFactory().createParser(intent.getStringExtra("seenEids"));
                            JsonNode seenEids = (JsonNode)mapper.readTree(parser);
                            Iterator<Map.Entry<String, JsonNode>> iterator = seenEids.fields();
                            while (iterator.hasNext()) {
                                Map.Entry<String, JsonNode> entry = iterator.next();
                                JsonNode eids = entry.getValue();
                                Iterator<Map.Entry<String, JsonNode>> j = eids.fields();
                                while (j.hasNext()) {
                                    Map.Entry<String, JsonNode> eidentry = j.next();
                                    String bid = eidentry.getKey();
                                    long eid = eidentry.getValue().asLong();
                                    if (conn.ready && conn.getState() != 2) {
                                        BuffersDataSource.getInstance().updateLastSeenEid(Integer.valueOf(bid), eid);
                                    }
                                    Notifications.getInstance().deleteOldNotifications(Integer.valueOf(bid), eid);
                                    Notifications.getInstance().updateLastSeenEid(Integer.valueOf(bid), eid);
                                }
                            }
                            parser.close();
                            Notifications.getInstance().showNotifications(null);
                        } else {
                            String network;
                            String chan;
                            int cid = Integer.valueOf(intent.getStringExtra("cid"));
                            int bid = Integer.valueOf(intent.getStringExtra("bid"));
                            long eid = Long.valueOf(intent.getStringExtra("eid"));
                            if (Notifications.getInstance().getNotification(eid) != null) {
                                return;
                            }
                            String from = intent.getStringExtra("from_nick");
                            String msg = intent.getStringExtra("msg");
                            if (msg != null) {
                                msg = ColorFormatter.html_to_spanned(ColorFormatter.irc_to_html(TextUtils.htmlEncode((String)msg))).toString();
                            }
                            if ((chan = intent.getStringExtra("chan")) == null) {
                                chan = "";
                            }
                            String buffer_type = intent.getStringExtra("buffer_type");
                            String server_name = intent.getStringExtra("server_name");
                            if (server_name == null || server_name.length() == 0) {
                                server_name = intent.getStringExtra("server_hostname");
                            }
                            if ((network = Notifications.getInstance().getNetwork(cid)) == null) {
                                Notifications.getInstance().addNetwork(cid, server_name);
                            }
                            Notifications.getInstance().addNotification(cid, bid, eid, from, msg, chan, buffer_type, type);
                            if (from == null || from.length() == 0) {
                                Notifications.getInstance().showNotifications(server_name + ": " + msg);
                            } else if (buffer_type.equals("channel")) {
                                if (type.equals("buffer_me_msg")) {
                                    Notifications.getInstance().showNotifications(chan + ": \u2014 " + from + " " + msg);
                                } else {
                                    Notifications.getInstance().showNotifications(chan + ": <" + from + "> " + msg);
                                }
                            } else if (type.equals("buffer_me_msg")) {
                                Notifications.getInstance().showNotifications("\u2014 " + from + " " + msg);
                            } else {
                                Notifications.getInstance().showNotifications(from + ": " + msg);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Log.w((String)"IRCCloud", (String)"Unable to parse GCM message");
                    }
                }
            }
            GCMBroadcastReceiver.completeWakefulIntent(intent);
        }
    }

    public static void scheduleRegisterTimer(int delay) {
        final int retrydelay = delay < 500 ? 500 : delay;
        GCMTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (!IRCCloudApplication.getInstance().getApplicationContext().getSharedPreferences("prefs", 0).contains("session_key")) {
                    return;
                }
                boolean success = false;
                if (GCMIntentService.getRegistrationId(IRCCloudApplication.getInstance().getApplicationContext()).length() == 0) {
                    try {
                        String oldRegId = IRCCloudApplication.getInstance().getApplicationContext().getSharedPreferences("prefs", 0).getString("gcm_reg_id", "");
                        String regId = GoogleCloudMessaging.getInstance(IRCCloudApplication.getInstance().getApplicationContext()).register("");
                        int appVersion = GCMIntentService.getAppVersion();
                        Log.i((String)"IRCCloud", (String)("Saving regId on app version " + appVersion));
                        SharedPreferences.Editor editor = IRCCloudApplication.getInstance().getApplicationContext().getSharedPreferences("prefs", 0).edit();
                        editor.putString("gcm_reg_id", regId);
                        editor.putInt("gcm_app_version", appVersion);
                        editor.putString("gcm_app_build", Build.FINGERPRINT);
                        editor.remove("gcm_registered");
                        editor.commit();
                        if (oldRegId.length() > 0 && !oldRegId.equals(regId)) {
                            Log.i((String)"IRCCloud", (String)"Unregistering old ID");
                            GCMIntentService.scheduleUnregisterTimer(1000, oldRegId, true);
                        }
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        Log.w((String)"IRCCloud", (String)("Failed to register device ID, will retry in " + retrydelay * 2 / 1000 + " seconds"));
                        GCMIntentService.scheduleRegisterTimer(retrydelay * 2);
                        return;
                    }
                    catch (SecurityException e) {
                        return;
                    }
                }
                Log.i((String)"IRCCloud", (String)"Sending GCM ID to IRCCloud");
                try {
                    JSONObject result = NetworkConnection.getInstance().registerGCM(GCMIntentService.getRegistrationId(IRCCloudApplication.getInstance().getApplicationContext()), IRCCloudApplication.getInstance().getApplicationContext().getSharedPreferences("prefs", 0).getString("session_key", ""));
                    if (result.has("success")) {
                        success = result.getBoolean("success");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (success) {
                    SharedPreferences.Editor editor = IRCCloudApplication.getInstance().getApplicationContext().getSharedPreferences("prefs", 0).edit();
                    editor.putBoolean("gcm_registered", true);
                    editor.commit();
                    Log.d((String)"IRCCloud", (String)"Device successfully registered");
                } else {
                    Log.w((String)"IRCCloud", (String)("Failed to register device ID, will retry in " + retrydelay * 2 / 1000 + " seconds"));
                    GCMIntentService.scheduleRegisterTimer(retrydelay * 2);
                }
            }
        }, delay);
    }

    public static void scheduleUnregisterTimer(int delay, final String regId, final boolean serverOnly) {
        final int retrydelay = delay < 500 ? 500 : delay;
        GCMTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                boolean success = false;
                if (!serverOnly) {
                    try {
                        GoogleCloudMessaging.getInstance(IRCCloudApplication.getInstance().getApplicationContext()).unregister();
                    }
                    catch (IOException e) {
                        Log.w((String)"IRCCloud", (String)("Failed to unregister device ID from GCM, will retry in " + retrydelay * 2 / 1000 + " seconds"));
                        GCMIntentService.scheduleUnregisterTimer(retrydelay * 2, regId, false);
                        return;
                    }
                    catch (SecurityException e) {
                        // empty catch block
                    }
                }
                SharedPreferences.Editor editor = IRCCloudApplication.getInstance().getApplicationContext().getSharedPreferences("prefs", 0).edit();
                String session = null;
                try {
                    session = IRCCloudApplication.getInstance().getApplicationContext().getSharedPreferences("prefs", 0).getString(regId, "");
                    if (session.length() > 0) {
                        JSONObject result = NetworkConnection.getInstance().unregisterGCM(regId, session);
                        if (result.has("message") && result.getString("message").equals("auth")) {
                            success = true;
                        } else if (result.has("success")) {
                            success = result.getBoolean("success");
                        }
                        if (success) {
                            NetworkConnection.getInstance().logout(session);
                        }
                    } else {
                        success = true;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (success) {
                    editor.remove(regId);
                    if (session != null && session.length() > 0 && regId.equals(IRCCloudApplication.getInstance().getApplicationContext().getSharedPreferences("prefs", 0).getString("gcm_reg_id", ""))) {
                        editor.remove("gcm_registered");
                        editor.remove("gcm_reg_id");
                        editor.remove("gcm_app_version");
                    }
                    Log.d((String)"IRCCloud", (String)"Device successfully unregistered");
                } else {
                    Log.w((String)"IRCCloud", (String)("Failed to unregister device ID from IRCCloud, will retry in " + retrydelay * 2 / 1000 + " seconds"));
                    GCMIntentService.scheduleUnregisterTimer(retrydelay * 2, regId, true);
                }
                editor.commit();
            }
        }, delay);
    }

    private static int getAppVersion() {
        try {
            Context context = IRCCloudApplication.getInstance().getApplicationContext();
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            return packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException("Could not get package name: " + (Object)((Object)e));
        }
    }

    public static String getRegistrationId(Context context) {
        int currentVersion;
        SharedPreferences prefs = context.getSharedPreferences("prefs", 0);
        String registrationId = prefs.getString("gcm_reg_id", "");
        if (registrationId.length() == 0) {
            Log.i((String)"IRCCloud", (String)"Registration not found.");
            return "";
        }
        int registeredVersion = prefs.getInt("gcm_app_version", Integer.MIN_VALUE);
        if (registeredVersion != (currentVersion = GCMIntentService.getAppVersion())) {
            Log.i((String)"IRCCloud", (String)"App version changed.");
            return "";
        }
        String build = prefs.getString("gcm_app_build", "");
        if (!Build.FINGERPRINT.equals(build)) {
            Log.i((String)"IRCCloud", (String)"OS version changed.");
            return "";
        }
        return registrationId;
    }
}

