/*
 * Decompiled with CFR 0.152.
 */
package com.irccloud.android;

import android.net.SSLCertificateSocketFactory;
import android.os.Build;
import android.util.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.ParseException;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ClientConnectionOperator;
import org.apache.http.conn.OperatedClientConnection;
import org.apache.http.conn.scheme.LayeredSocketFactory;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.StrictHostnameVerifier;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.DefaultClientConnection;
import org.apache.http.impl.conn.DefaultClientConnectionOperator;
import org.apache.http.impl.conn.DefaultResponseParser;
import org.apache.http.impl.conn.SingleClientConnManager;
import org.apache.http.io.HttpMessageParser;
import org.apache.http.io.SessionInputBuffer;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.message.BasicLineParser;
import org.apache.http.message.LineParser;
import org.apache.http.message.ParserCursor;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.CharArrayBuffer;

public class GingerbreadImageProxy
implements Runnable {
    private static final String LOG_TAG = GingerbreadImageProxy.class.getName();
    private int port = 0;
    private boolean isRunning = false;
    private ServerSocket socket;
    private Thread thread;

    public int getPort() {
        return this.port;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void init() {
        try {
            this.socket = new ServerSocket(this.port, 0, InetAddress.getByAddress(new byte[]{127, 0, 0, 1}));
            this.socket.setSoTimeout(5000);
            this.port = this.socket.getLocalPort();
        }
        catch (UnknownHostException e) {
            Log.e((String)LOG_TAG, (String)"Error initializing server", (Throwable)e);
        }
        catch (IOException e) {
            Log.e((String)LOG_TAG, (String)"Error initializing server", (Throwable)e);
        }
    }

    public void start() {
        if (this.socket == null) {
            throw new IllegalStateException("Cannot start proxy; it has not been initialized.");
        }
        this.isRunning = true;
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void stop() {
        this.isRunning = false;
        if (this.thread == null) {
            throw new IllegalStateException("Cannot stop proxy; it has not been started.");
        }
        this.thread.interrupt();
        try {
            this.thread.join(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.thread = null;
    }

    @Override
    public void run() {
        while (this.isRunning) {
            try {
                Socket client = this.socket.accept();
                if (client == null) continue;
                HttpRequest request = this.readRequest(client);
                if (!this.isRunning) continue;
                this.processRequest(request, client);
            }
            catch (SocketTimeoutException client) {
            }
            catch (IOException e) {
                Log.e((String)LOG_TAG, (String)"Error connecting to client", (Throwable)e);
            }
        }
    }

    private HttpRequest readRequest(Socket client) {
        String firstLine;
        BasicHttpRequest request = null;
        String range = null;
        String ua = null;
        try {
            InputStream is = client.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is), 8192);
            firstLine = reader.readLine();
            String line = null;
            do {
                if ((line = reader.readLine()) != null && line.toLowerCase().startsWith("range: ")) {
                    range = line.substring(7);
                }
                if (line == null || !line.toLowerCase().startsWith("user-agent: ")) continue;
                ua = line.substring(12);
            } while (line != null && reader.ready());
        }
        catch (IOException e) {
            Log.e((String)LOG_TAG, (String)"Error parsing request", (Throwable)e);
            return request;
        }
        if (firstLine == null) {
            Log.i((String)LOG_TAG, (String)"Proxy client closed connection without a request.");
            return request;
        }
        StringTokenizer st = new StringTokenizer(firstLine);
        String method = st.nextToken();
        String uri = st.nextToken();
        String realUri = uri.substring(1);
        request = new BasicHttpRequest(method, realUri, new ProtocolVersion("HTTP", 1, 1));
        if (range != null) {
            request.addHeader("Range", range);
        }
        if (ua != null) {
            request.addHeader("User-Agent", ua);
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRequest(HttpRequest request, Socket client) throws IllegalStateException, IOException {
        if (request == null) {
            return;
        }
        String url = request.getRequestLine().getUri();
        DefaultHttpClient seed = new DefaultHttpClient();
        SchemeRegistry registry = new SchemeRegistry();
        registry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        registry.register(new Scheme("https", (SocketFactory)new TlsSniSocketFactory(), 443));
        MyClientConnManager mgr = new MyClientConnManager(seed.getParams(), registry);
        DefaultHttpClient http = new DefaultHttpClient((ClientConnectionManager)mgr, seed.getParams());
        HttpGet method = new HttpGet(url);
        for (Header h : request.getAllHeaders()) {
            method.addHeader(h);
        }
        HttpResponse realResponse = null;
        try {
            realResponse = http.execute((HttpUriRequest)method);
        }
        catch (ClientProtocolException e) {
            Log.e((String)LOG_TAG, (String)"Error downloading", (Throwable)e);
        }
        catch (IOException e) {
            Log.e((String)LOG_TAG, (String)"Error downloading", (Throwable)e);
        }
        if (realResponse == null) {
            return;
        }
        if (!this.isRunning) {
            return;
        }
        InputStream data = realResponse.getEntity().getContent();
        StatusLine line = realResponse.getStatusLine();
        BasicHttpResponse response = new BasicHttpResponse(line);
        response.setHeaders(realResponse.getAllHeaders());
        StringBuilder httpString = new StringBuilder();
        httpString.append(response.getStatusLine().toString());
        httpString.append("\n");
        for (Header h : response.getAllHeaders()) {
            httpString.append(h.getName()).append(": ").append(h.getValue()).append("\n");
        }
        httpString.append("\n");
        try {
            int readBytes;
            byte[] buffer = httpString.toString().getBytes();
            client.getOutputStream().write(buffer, 0, buffer.length);
            byte[] buff = new byte[8192];
            while (this.isRunning && (readBytes = data.read(buff, 0, buff.length)) != -1) {
                client.getOutputStream().write(buff, 0, readBytes);
            }
        }
        catch (Exception e) {
            Log.e((String)"", (String)e.getMessage(), (Throwable)e);
        }
        finally {
            mgr.shutdown();
            client.close();
        }
        this.stop();
    }

    public static class TlsSniSocketFactory
    implements LayeredSocketFactory {
        private static final String TAG = "SNISocketFactory";
        static final HostnameVerifier hostnameVerifier = new StrictHostnameVerifier();

        public Socket connectSocket(Socket s, String host, int port, InetAddress localAddress, int localPort, HttpParams params) throws IOException {
            return null;
        }

        public Socket createSocket() throws IOException {
            return null;
        }

        public boolean isSecure(Socket s) throws IllegalArgumentException {
            if (s instanceof SSLSocket) {
                return ((SSLSocket)s).isConnected();
            }
            return false;
        }

        public Socket createSocket(Socket plainSocket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
            if (autoClose) {
                plainSocket.close();
            }
            SSLCertificateSocketFactory sslSocketFactory = (SSLCertificateSocketFactory)SSLCertificateSocketFactory.getDefault((int)0);
            SSLSocket ssl = (SSLSocket)sslSocketFactory.createSocket(InetAddress.getByName(host), port);
            ssl.setEnabledProtocols(ssl.getSupportedProtocols());
            if (Build.VERSION.SDK_INT >= 17) {
                sslSocketFactory.setHostname((Socket)ssl, host);
            } else {
                try {
                    Method setHostnameMethod = ssl.getClass().getMethod("setHostname", String.class);
                    setHostnameMethod.invoke((Object)ssl, host);
                }
                catch (Exception e) {
                    Log.w((String)TAG, (String)"SNI not useable", (Throwable)e);
                }
            }
            SSLSession session = ssl.getSession();
            if (!hostnameVerifier.verify(host, session)) {
                throw new SSLPeerUnverifiedException("Cannot verify hostname: " + host);
            }
            return ssl;
        }
    }

    class MyClientConnManager
    extends SingleClientConnManager {
        private MyClientConnManager(HttpParams params, SchemeRegistry schreg) {
            super(params, schreg);
        }

        protected ClientConnectionOperator createConnectionOperator(SchemeRegistry sr) {
            return new MyClientConnectionOperator(sr);
        }
    }

    class MyClientConnectionOperator
    extends DefaultClientConnectionOperator {
        public MyClientConnectionOperator(SchemeRegistry sr) {
            super(sr);
        }

        public OperatedClientConnection createConnection() {
            return new MyClientConnection();
        }
    }

    class MyClientConnection
    extends DefaultClientConnection {
        MyClientConnection() {
        }

        protected HttpMessageParser createResponseParser(SessionInputBuffer buffer, HttpResponseFactory responseFactory, HttpParams params) {
            return new DefaultResponseParser(buffer, (LineParser)new IcyLineParser(), responseFactory, params);
        }
    }

    private class IcyLineParser
    extends BasicLineParser {
        private static final String ICY_PROTOCOL_NAME = "ICY";

        private IcyLineParser() {
        }

        public boolean hasProtocolVersion(CharArrayBuffer buffer, ParserCursor cursor) {
            int index;
            boolean superFound = super.hasProtocolVersion(buffer, cursor);
            if (superFound) {
                return true;
            }
            int protolength = ICY_PROTOCOL_NAME.length();
            if (buffer.length() < protolength) {
                return false;
            }
            if (index < 0) {
                index = buffer.length() - protolength;
            } else if (index == 0) {
                for (index = cursor.getPos(); index < buffer.length() && HTTP.isWhitespace((char)buffer.charAt(index)); ++index) {
                }
            }
            return index + protolength <= buffer.length() && buffer.substring(index, index + protolength).equals(ICY_PROTOCOL_NAME);
        }

        public ProtocolVersion parseProtocolVersion(CharArrayBuffer buffer, ParserCursor cursor) throws ParseException {
            if (buffer == null) {
                throw new IllegalArgumentException("Char array buffer may not be null");
            }
            if (cursor == null) {
                throw new IllegalArgumentException("Parser cursor may not be null");
            }
            int protolength = ICY_PROTOCOL_NAME.length();
            int indexFrom = cursor.getPos();
            int indexTo = cursor.getUpperBound();
            this.skipWhitespace(buffer, cursor);
            int i = cursor.getPos();
            if (i + protolength + 4 > indexTo) {
                throw new ParseException("Not a valid protocol version: " + buffer.substring(indexFrom, indexTo));
            }
            if (!buffer.substring(i, i + protolength).equals(ICY_PROTOCOL_NAME)) {
                return super.parseProtocolVersion(buffer, cursor);
            }
            cursor.updatePos(i + protolength);
            return this.createProtocolVersion(1, 0);
        }

        public StatusLine parseStatusLine(CharArrayBuffer buffer, ParserCursor cursor) throws ParseException {
            return super.parseStatusLine(buffer, cursor);
        }
    }
}

