/*
 * Decompiled with CFR 0.152.
 */
package com.irccloud.android;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.Environment;
import android.preference.PreferenceManager;
import com.crashlytics.android.Crashlytics;
import com.irccloud.android.BuildConfig;
import com.irccloud.android.ColorFormatter;
import com.irccloud.android.CrashlyticsLeakService;
import com.irccloud.android.NetworkConnection;
import com.irccloud.android.data.BuffersDataSource;
import com.irccloud.android.data.ChannelsDataSource;
import com.irccloud.android.data.EventsDataSource;
import com.irccloud.android.data.ServersDataSource;
import com.irccloud.android.data.UsersDataSource;
import com.squareup.leakcanary.AndroidExcludedRefs;
import com.squareup.leakcanary.ExcludedRefs;
import com.squareup.leakcanary.LeakCanary;
import com.squareup.leakcanary.RefWatcher;
import io.fabric.sdk.android.Fabric;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IRCCloudApplication
extends Application {
    private static final int RINGTONE_VERSION = 1;
    private static IRCCloudApplication instance = null;
    private NetworkConnection conn = null;
    private ServersDataSource s = null;
    private BuffersDataSource b = null;
    private ChannelsDataSource c = null;
    private UsersDataSource u = null;
    private EventsDataSource e = null;
    private RefWatcher refWatcher;

    public static IRCCloudApplication getInstance() {
        if (instance != null) {
            return instance;
        }
        return new IRCCloudApplication();
    }

    public static RefWatcher getRefWatcher(Context context) {
        return IRCCloudApplication.getInstance().refWatcher;
    }

    public void onCreate() {
        SharedPreferences prefs;
        block17: {
            SharedPreferences.Editor editor;
            super.onCreate();
            prefs = PreferenceManager.getDefaultSharedPreferences((Context)this.getApplicationContext());
            if (BuildConfig.DEBUG && prefs.getBoolean("detect_leaks", true)) {
                ExcludedRefs excludedRefs = AndroidExcludedRefs.createAndroidDefaults().thread("WebViewCoreThread").thread("CookieSyncManager").instanceField("android.webkit.WebViewCore", "mContext").instanceField("android.sec.clipboard.ClipboardUIManager", "mContext").instanceField("android.widget.Editor$Blink", "this$0").build();
                this.refWatcher = LeakCanary.install(this, CrashlyticsLeakService.class, excludedRefs);
            } else {
                this.refWatcher = RefWatcher.DISABLED;
            }
            instance = this;
            Fabric.with((Context)this, new Crashlytics());
            System.setProperty("http.keepAlive", "false");
            this.conn = NetworkConnection.getInstance();
            this.s = ServersDataSource.getInstance();
            this.b = BuffersDataSource.getInstance();
            this.c = ChannelsDataSource.getInstance();
            this.u = UsersDataSource.getInstance();
            this.e = EventsDataSource.getInstance();
            ColorFormatter.init();
            if (prefs.contains("notify")) {
                editor = prefs.edit();
                editor.putString("notify_type", prefs.getBoolean("notify", true) ? "1" : "0");
                editor.remove("notify");
                editor.commit();
            }
            if (prefs.contains("notify_sound")) {
                editor = prefs.edit();
                if (!prefs.getBoolean("notify_sound", true)) {
                    editor.putString("notify_ringtone", "");
                }
                editor.remove("notify_sound");
                editor.commit();
            }
            if (prefs.contains("notify_lights")) {
                editor = prefs.edit();
                if (!prefs.getBoolean("notify_lights", true)) {
                    editor.putString("notify_led_color", "0");
                }
                editor.remove("notify_lights");
                editor.commit();
            }
            if (prefs.getInt("ringtone_version", 0) < 1) {
                File path = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_NOTIFICATIONS);
                File file = new File(path, "IRCCloud.mp3");
                try {
                    path.mkdirs();
                    InputStream is = this.getResources().openRawResource(2131099648);
                    FileOutputStream os = new FileOutputStream(file);
                    byte[] data = new byte[is.available()];
                    is.read(data);
                    ((OutputStream)os).write(data);
                    is.close();
                    ((OutputStream)os).close();
                    MediaScannerConnection.scanFile((Context)this, (String[])new String[]{file.toString()}, null, (MediaScannerConnection.OnScanCompletedListener)new MediaScannerConnection.OnScanCompletedListener(){

                        public void onScanCompleted(String path, Uri uri) {
                            SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)IRCCloudApplication.this.getApplicationContext());
                            SharedPreferences.Editor editor = prefs.edit();
                            if (!prefs.contains("notify_ringtone")) {
                                editor.putString("notify_ringtone", uri.toString());
                            }
                            editor.putInt("ringtone_version", 1);
                            editor.commit();
                        }
                    });
                }
                catch (IOException e) {
                    if (prefs.contains("notify_ringtone")) break block17;
                    SharedPreferences.Editor editor2 = prefs.edit();
                    editor2.putString("notify_ringtone", "content://settings/system/notification_sound");
                    editor2.commit();
                }
            }
        }
        if (prefs.contains("notify_pebble")) {
            try {
                int pebbleVersion = this.getPackageManager().getPackageInfo((String)"com.getpebble.android", (int)0).versionCode;
                if (pebbleVersion >= 553) {
                    SharedPreferences.Editor editor = prefs.edit();
                    editor.remove("notify_pebble");
                    editor.commit();
                }
            }
            catch (Exception pebbleVersion) {
                // empty catch block
            }
        }
        if (prefs.contains("acra.enable")) {
            SharedPreferences.Editor editor = prefs.edit();
            editor.remove("acra.enable");
            editor.commit();
        }
        if ((prefs = this.getSharedPreferences("prefs", 0)).getString("host", "www.irccloud.com").equals("www.irccloud.com") && !prefs.contains("path") && prefs.contains("session_key")) {
            Crashlytics.log(4, "IRCCloud", "Migrating path from session key");
            SharedPreferences.Editor editor = prefs.edit();
            editor.putString("path", "/websocket/" + prefs.getString("session_key", "").charAt(0));
            editor.commit();
        }
        if (prefs.contains("host") && prefs.getString("host", "").equals("www.irccloud.com")) {
            Crashlytics.log(4, "IRCCloud", "Migrating host");
            SharedPreferences.Editor editor = prefs.edit();
            editor.putString("host", "api.irccloud.com");
            editor.commit();
        }
        NetworkConnection.IRCCLOUD_HOST = prefs.getString("host", "api.irccloud.com");
        NetworkConnection.IRCCLOUD_PATH = prefs.getString("path", "/");
    }

    public void onLowMemory() {
        super.onLowMemory();
        if (!NetworkConnection.getInstance().isVisible()) {
            Crashlytics.log(3, "IRCCloud", "Received low memory warning in the background, cleaning backlog in all buffers");
            for (BuffersDataSource.Buffer b : BuffersDataSource.getInstance().getBuffers()) {
                if (b.scrolledUp) continue;
                EventsDataSource.getInstance().pruneEvents(b.bid);
            }
        }
    }
}

