/*
 * Decompiled with CFR 0.152.
 */
package com.irccloud.android;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.StringWriter;
import org.json.JSONObject;

public class IRCCloudJSONObject {
    JsonNode o;
    int cid = -1;
    int bid = -1;
    long eid = -1L;
    String type = null;

    public IRCCloudJSONObject() {
        this.o = new ObjectMapper().createObjectNode();
    }

    public IRCCloudJSONObject(JsonNode object) {
        this.o = object;
    }

    public IRCCloudJSONObject(String message) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            this.o = mapper.readValue(message, JsonNode.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public IRCCloudJSONObject(JSONObject object) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            this.o = mapper.readValue(object.toString(), JsonNode.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int cid() {
        if (this.cid == -1 && this.o.has("cid")) {
            this.cid = this.o.get("cid").asInt();
        }
        return this.cid;
    }

    public int bid() {
        if (this.bid == -1 && this.o.has("bid")) {
            this.bid = this.o.get("bid").asInt();
        }
        return this.bid;
    }

    public long eid() {
        if (this.eid == -1L && this.o.has("eid")) {
            this.eid = this.o.get("eid").asLong();
        }
        return this.eid;
    }

    public String type() {
        if (this.type == null) {
            this.type = this.o.has("type") ? this.o.get("type").asText() : "undefined";
        }
        return this.type;
    }

    public boolean has(String name) {
        return this.o.has(name) && !this.o.get(name).isNull();
    }

    public boolean getBoolean(String name) {
        return this.o.path(name).asBoolean(false);
    }

    public int getInt(String name) {
        return this.o.path(name).asInt(-1);
    }

    public long getLong(String name) {
        return this.o.path(name).asLong(-1L);
    }

    public String getString(String name) {
        return this.o.path(name).asText();
    }

    public JsonNode getJsonNode(String name) {
        return this.o.path(name);
    }

    public ObjectNode getJsonObject(String name) {
        try {
            return (ObjectNode)this.getJsonNode(name);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public JsonNode getObject() {
        return this.o;
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        StringWriter writer = new StringWriter();
        try {
            mapper.writeValue(writer, (Object)this.o);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return writer.toString();
    }
}

