/*
 * Decompiled with CFR 0.152.
 */
package com.irccloud.android;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Proxy;
import android.net.TrafficStats;
import android.net.wifi.WifiManager;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Looper;
import android.preference.PreferenceManager;
import android.util.Log;
import android.view.WindowManager;
import com.codebutler.android_websockets.WebSocketClient;
import com.crashlytics.android.Crashlytics;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.irccloud.android.BuildConfig;
import com.irccloud.android.ColorFormatter;
import com.irccloud.android.GCMIntentService;
import com.irccloud.android.IRCCloudApplication;
import com.irccloud.android.IRCCloudJSONObject;
import com.irccloud.android.Notifications;
import com.irccloud.android.data.BuffersDataSource;
import com.irccloud.android.data.ChannelsDataSource;
import com.irccloud.android.data.EventsDataSource;
import com.irccloud.android.data.ServersDataSource;
import com.irccloud.android.data.UsersDataSource;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class NetworkConnection {
    private static final String TAG = "IRCCloud";
    private static NetworkConnection instance = null;
    public static final int WEBSOCKET_TAG = 330807;
    public static final int BACKLOG_TAG = 11845894;
    public static final int STATE_DISCONNECTED = 0;
    public static final int STATE_CONNECTING = 1;
    public static final int STATE_CONNECTED = 2;
    public static final int STATE_DISCONNECTING = 3;
    private int state = 0;
    private WebSocketClient client = null;
    private UserInfo userInfo = null;
    private final ArrayList<IRCEventHandler> handlers = new ArrayList();
    public String session = null;
    private volatile int last_reqid = 0;
    private static final Timer shutdownTimer = new Timer("shutdown-timer");
    private static final Timer idleTimer = new Timer("websocket-idle-timer");
    public long idle_interval = 1000L;
    private volatile int failCount = 0;
    private long reconnect_timestamp = 0L;
    public String useragent = null;
    private String streamId = null;
    private int accrued = 0;
    private boolean backlog = false;
    int currentBid = -1;
    long firstEid = -1L;
    public JSONObject config = null;
    private ObjectMapper mapper = new ObjectMapper();
    public static final int EVENT_CONNECTIVITY = 0;
    public static final int EVENT_USERINFO = 1;
    public static final int EVENT_MAKESERVER = 2;
    public static final int EVENT_MAKEBUFFER = 3;
    public static final int EVENT_DELETEBUFFER = 4;
    public static final int EVENT_BUFFERMSG = 5;
    public static final int EVENT_HEARTBEATECHO = 6;
    public static final int EVENT_CHANNELINIT = 7;
    public static final int EVENT_CHANNELTOPIC = 8;
    public static final int EVENT_JOIN = 9;
    public static final int EVENT_PART = 10;
    public static final int EVENT_NICKCHANGE = 11;
    public static final int EVENT_QUIT = 12;
    public static final int EVENT_MEMBERUPDATES = 13;
    public static final int EVENT_USERCHANNELMODE = 14;
    public static final int EVENT_BUFFERARCHIVED = 15;
    public static final int EVENT_BUFFERUNARCHIVED = 16;
    public static final int EVENT_RENAMECONVERSATION = 17;
    public static final int EVENT_STATUSCHANGED = 18;
    public static final int EVENT_CONNECTIONDELETED = 19;
    public static final int EVENT_AWAY = 20;
    public static final int EVENT_SELFBACK = 21;
    public static final int EVENT_KICK = 22;
    public static final int EVENT_CHANNELMODE = 23;
    public static final int EVENT_CHANNELTIMESTAMP = 24;
    public static final int EVENT_SELFDETAILS = 25;
    public static final int EVENT_USERMODE = 26;
    public static final int EVENT_SETIGNORES = 27;
    public static final int EVENT_BADCHANNELKEY = 28;
    public static final int EVENT_OPENBUFFER = 29;
    public static final int EVENT_INVALIDNICK = 30;
    public static final int EVENT_BANLIST = 31;
    public static final int EVENT_WHOLIST = 32;
    public static final int EVENT_WHOIS = 33;
    public static final int EVENT_LINKCHANNEL = 34;
    public static final int EVENT_LISTRESPONSEFETCHING = 35;
    public static final int EVENT_LISTRESPONSE = 36;
    public static final int EVENT_LISTRESPONSETOOMANY = 37;
    public static final int EVENT_CONNECTIONLAG = 38;
    public static final int EVENT_GLOBALMSG = 39;
    public static final int EVENT_ACCEPTLIST = 40;
    public static final int EVENT_NAMESLIST = 41;
    public static final int EVENT_REORDERCONNECTIONS = 42;
    public static final int EVENT_CHANNELTOPICIS = 43;
    public static final int EVENT_SERVERMAPLIST = 44;
    public static final int EVENT_QUIETLIST = 45;
    public static final int EVENT_BANEXCEPTIONLIST = 46;
    public static final int EVENT_INVITELIST = 47;
    public static final int EVENT_BACKLOG_START = 100;
    public static final int EVENT_BACKLOG_END = 101;
    public static final int EVENT_BACKLOG_FAILED = 102;
    public static final int EVENT_FAILURE_MSG = 103;
    public static final int EVENT_SUCCESS = 104;
    public static final int EVENT_PROGRESS = 105;
    public static final int EVENT_ALERT = 106;
    public static final int EVENT_DEBUG = 999;
    public static String IRCCLOUD_HOST = "api.irccloud.com";
    public static String IRCCLOUD_PATH = "/";
    private final Object parserLock = new Object();
    private WifiManager.WifiLock wifiLock = null;
    public long clockOffset = 0L;
    private float numbuffers = 0.0f;
    private float totalbuffers = 0.0f;
    private int currentcount = 0;
    public boolean ready = false;
    public String globalMsg = null;
    private HashMap<Integer, OOBIncludeTask> oobTasks = new HashMap();
    private PrivateKey SSLAuthKey;
    private String SSLAuthAlias;
    private X509Certificate[] SSLAuthCertificateChain;
    TrustManager[] tms;
    X509ExtendedKeyManager[] kms;
    private SSLSocketFactory IRCCloudSocketFactory = new SSLSocketFactory(){
        final String[] CIPHERS = new String[]{"TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA", "TLS_DHE_DSS_WITH_AES_128_CBC_SHA", "TLS_ECDHE_RSA_WITH_RC4_128_SHA", "TLS_ECDHE_ECDSA_WITH_RC4_128_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_256_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_WITH_RC4_128_SHA", "SSL_RSA_WITH_RC4_128_MD5"};
        final String[] PROTOCOLS = new String[]{"TLSv1.2", "TLSv1.1", "TLSv1"};
        SSLSocketFactory internalSocketFactory;

        private void init() {
            try {
                SSLContext c = SSLContext.getInstance("TLS");
                c.init(NetworkConnection.this.kms, NetworkConnection.this.tms, null);
                this.internalSocketFactory = c.getSocketFactory();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return this.CIPHERS;
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.CIPHERS;
        }

        @Override
        public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
            if (this.internalSocketFactory == null) {
                this.init();
            }
            SSLSocket socket = (SSLSocket)this.internalSocketFactory.createSocket(s, host, port, autoClose);
            try {
                socket.setEnabledProtocols(this.PROTOCOLS);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                socket.setEnabledCipherSuites(this.CIPHERS);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return socket;
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException {
            if (this.internalSocketFactory == null) {
                this.init();
            }
            SSLSocket socket = (SSLSocket)this.internalSocketFactory.createSocket(host, port);
            try {
                socket.setEnabledProtocols(this.PROTOCOLS);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                socket.setEnabledCipherSuites(this.CIPHERS);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return socket;
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
            if (this.internalSocketFactory == null) {
                this.init();
            }
            SSLSocket socket = (SSLSocket)this.internalSocketFactory.createSocket(host, port, localHost, localPort);
            try {
                socket.setEnabledProtocols(this.PROTOCOLS);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                socket.setEnabledCipherSuites(this.CIPHERS);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return socket;
        }

        @Override
        public Socket createSocket(InetAddress host, int port) throws IOException {
            if (this.internalSocketFactory == null) {
                this.init();
            }
            SSLSocket socket = (SSLSocket)this.internalSocketFactory.createSocket(host, port);
            try {
                socket.setEnabledProtocols(this.PROTOCOLS);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                socket.setEnabledCipherSuites(this.CIPHERS);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return socket;
        }

        @Override
        public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            if (this.internalSocketFactory == null) {
                this.init();
            }
            SSLSocket socket = (SSLSocket)this.internalSocketFactory.createSocket(address, port, localAddress, localPort);
            try {
                socket.setEnabledProtocols(this.PROTOCOLS);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                socket.setEnabledCipherSuites(this.CIPHERS);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return socket;
        }
    };
    BroadcastReceiver connectivityListener = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo ni = cm.getActiveNetworkInfo();
            if (ni != null && ni.isConnected() && (NetworkConnection.this.state == 0 || NetworkConnection.this.state == 3) && NetworkConnection.this.session != null && NetworkConnection.this.handlers.size() > 0) {
                if (NetworkConnection.this.idleTimerTask != null) {
                    NetworkConnection.this.idleTimerTask.cancel();
                }
                NetworkConnection.this.connect(NetworkConnection.this.session);
            } else if (ni == null || !ni.isConnected()) {
                NetworkConnection.this.cancel_idle_timer();
                NetworkConnection.this.reconnect_timestamp = 0L;
                try {
                    NetworkConnection.this.state = 3;
                    NetworkConnection.this.client.disconnect();
                    NetworkConnection.this.state = 0;
                    NetworkConnection.this.notifyHandlers(0, null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    };
    private TimerTask idleTimerTask = null;
    HashMap<String, Parser> parserMap = new HashMap<String, Parser>(){
        {
            String[] msgs;
            String[] alerts;
            this.put("idle", null);
            this.put("end_of_backlog", null);
            this.put("oob_skipped", null);
            this.put("user_account", null);
            this.put("header", new Parser(){

                @Override
                public void parse(IRCCloudJSONObject object) throws JSONException {
                    NetworkConnection.this.idle_interval = object.getLong("idle_interval") + 15000L;
                    NetworkConnection.this.clockOffset = object.getLong("time") - System.currentTimeMillis() / 1000L;
                    NetworkConnection.this.currentcount = 0;
                    NetworkConnection.this.currentBid = -1;
                    NetworkConnection.this.firstEid = -1L;
                    NetworkConnection.this.streamId = object.getString("streamid");
                    if (object.has("accrued")) {
                        NetworkConnection.this.accrued = object.getInt("accrued");
                    }
                    if (!object.has("resumed") || !object.getBoolean("resumed")) {
                        Log.d((String)NetworkConnection.TAG, (String)"Socket was not resumed");
                        Notifications.getInstance().clearNetworks();
                        Notifications.getInstance().clearLastSeenEIDs();
                    }
                }
            });
            this.put("global_system_message", new Parser(){

                @Override
                public void parse(IRCCloudJSONObject object) throws JSONException {
                    String msgType = object.getString("system_message_type");
                    if (msgType == null || !msgType.equalsIgnoreCase("eval") && !msgType.equalsIgnoreCase("refresh")) {
                        NetworkConnection.this.globalMsg = object.getString("msg");
                        NetworkConnection.this.notifyHandlers(39, object);
                    }
                }
            });
            this.put("num_invites", new Parser(){

                @Override
                public void parse(IRCCloudJSONObject object) throws JSONException {
                    if (NetworkConnection.this.userInfo != null) {
                        ((NetworkConnection)NetworkConnection.this).userInfo.num_invites = object.getInt("num_invites");
                    }
                }
            });
            this.put("stat_user", new Parser(){

                @Override
                public void parse(IRCCloudJSONObject object) throws JSONException {
                    NetworkConnection.this.userInfo = new UserInfo(object);
                    Crashlytics.setUserIdentifier("uid" + ((NetworkConnection)NetworkConnection.this).userInfo.id);
                    SharedPreferences.Editor prefs = PreferenceManager.getDefaultSharedPreferences((Context)IRCCloudApplication.getInstance().getApplicationContext()).edit();
                    prefs.putString("name", ((NetworkConnection)NetworkConnection.this).userInfo.name);
                    prefs.putString("email", ((NetworkConnection)NetworkConnection.this).userInfo.email);
                    prefs.putString("highlights", ((NetworkConnection)NetworkConnection.this).userInfo.highlights);
                    prefs.putBoolean("autoaway", ((NetworkConnection)NetworkConnection.this).userInfo.auto_away);
                    if (((NetworkConnection)NetworkConnection.this).userInfo.prefs != null) {
                        prefs.putBoolean("time-24hr", ((NetworkConnection)NetworkConnection.this).userInfo.prefs.has("time-24hr") && ((NetworkConnection)NetworkConnection.this).userInfo.prefs.get("time-24hr").getClass().equals(Boolean.class) && ((NetworkConnection)NetworkConnection.this).userInfo.prefs.getBoolean("time-24hr"));
                        prefs.putBoolean("time-seconds", ((NetworkConnection)NetworkConnection.this).userInfo.prefs.has("time-seconds") && ((NetworkConnection)NetworkConnection.this).userInfo.prefs.get("time-seconds").getClass().equals(Boolean.class) && ((NetworkConnection)NetworkConnection.this).userInfo.prefs.getBoolean("time-seconds"));
                        prefs.putBoolean("mode-showsymbol", ((NetworkConnection)NetworkConnection.this).userInfo.prefs.has("mode-showsymbol") && ((NetworkConnection)NetworkConnection.this).userInfo.prefs.get("mode-showsymbol").getClass().equals(Boolean.class) && ((NetworkConnection)NetworkConnection.this).userInfo.prefs.getBoolean("mode-showsymbol"));
                        prefs.putBoolean("nick-colors", ((NetworkConnection)NetworkConnection.this).userInfo.prefs.has("nick-colors") && ((NetworkConnection)NetworkConnection.this).userInfo.prefs.get("nick-colors").getClass().equals(Boolean.class) && ((NetworkConnection)NetworkConnection.this).userInfo.prefs.getBoolean("nick-colors"));
                        prefs.putBoolean("emoji-disableconvert", !((NetworkConnection)NetworkConnection.this).userInfo.prefs.has("emoji-disableconvert") || !((NetworkConnection)NetworkConnection.this).userInfo.prefs.get("emoji-disableconvert").getClass().equals(Boolean.class) || !((NetworkConnection)NetworkConnection.this).userInfo.prefs.getBoolean("emoji-disableconvert"));
                        prefs.putBoolean("pastebin-disableprompt", !((NetworkConnection)NetworkConnection.this).userInfo.prefs.has("pastebin-disableprompt") || !((NetworkConnection)NetworkConnection.this).userInfo.prefs.get("pastebin-disableprompt").getClass().equals(Boolean.class) || !((NetworkConnection)NetworkConnection.this).userInfo.prefs.getBoolean("pastebin-disableprompt"));
                    } else {
                        prefs.putBoolean("time-24hr", false);
                        prefs.putBoolean("time-seconds", false);
                        prefs.putBoolean("mode-showsymbol", false);
                        prefs.putBoolean("nick-colors", false);
                        prefs.putBoolean("emoji-disableconvert", true);
                        prefs.putBoolean("pastebin-disableprompt", true);
                    }
                    prefs.commit();
                    EventsDataSource.getInstance().clearCaches();
                    NetworkConnection.this.notifyHandlers(1, NetworkConnection.this.userInfo);
                }
            });
            this.put("set_ignores", new Parser(){

                @Override
                public void parse(IRCCloudJSONObject object) throws JSONException {
                    ServersDataSource s = ServersDataSource.getInstance();
                    s.updateIgnores(object.cid(), object.getJsonNode("masks"));
                    if (!NetworkConnection.this.backlog) {
                        NetworkConnection.this.notifyHandlers(27, object);
                    }
                }
            });
            this.put("ignore_list", this.get("set_ignores"));
            this.put("heartbeat_echo", new Parser(){

                @Override
                public void parse(IRCCloudJSONObject object) throws JSONException {
                    Iterator<Map.Entry<String, JsonNode>> iterator = object.getJsonNode("seenEids").fields();
                    while (iterator.hasNext()) {
                        Map.Entry<String, JsonNode> entry = iterator.next();
                        JsonNode eids = entry.getValue();
                        Iterator<Map.Entry<String, JsonNode>> j = eids.fields();
                        while (j.hasNext()) {
                            BuffersDataSource.Buffer b;
                            Map.Entry<String, JsonNode> eidentry = j.next();
                            int bid = Integer.valueOf(eidentry.getKey());
                            long eid = eidentry.getValue().asLong();
                            BuffersDataSource.getInstance().updateLastSeenEid(bid, eid);
                            Notifications.getInstance().deleteOldNotifications(bid, eid);
                            Notifications.getInstance().updateLastSeenEid(bid, eid);
                            if (EventsDataSource.getInstance().lastEidForBuffer(bid) > eid || (b = BuffersDataSource.getInstance().getBuffer(bid)) == null) continue;
                            b.unread = 0;
                            b.highlights = 0;
                        }
                    }
                    if (!NetworkConnection.this.backlog) {
                        NetworkConnection.this.notifyHandlers(6, object);
                        Notifications.getInstance().showNotifications(null);
                    }
                }
            });
            this.put("oob_include", new Parser(){

                @Override
                public void parse(IRCCloudJSONObject object) throws JSONException {
                    try {
                        if (Looper.myLooper() == null) {
                            Looper.prepare();
                        }
                        String url = "https://" + IRCCLOUD_HOST + object.getString("url");
                        OOBIncludeTask t = new OOBIncludeTask(-1);
                        NetworkConnection.this.oobTasks.put(-1, t);
                        t.execute(new URL[]{new URL(url)});
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                    }
                }
            });
            this.put("backlog_starts", new Parser(){

                @Override
                public void parse(IRCCloudJSONObject object) throws JSONException {
                    NetworkConnection.this.numbuffers = object.getInt("numbuffers");
                    NetworkConnection.this.totalbuffers = 0.0f;
                    NetworkConnection.this.currentBid = -1;
                    NetworkConnection.this.notifyHandlers(100, null);
                    NetworkConnection.this.backlog = true;
                }
            });
            this.put("backlog_complete", new Parser(){

                @Override
                public void parse(IRCCloudJSONObject object) throws JSONException {
                    NetworkConnection.this.accrued = 0;
                    NetworkConnection.this.backlog = false;
                    Log.d((String)NetworkConnection.TAG, (String)"Cleaning up invalid BIDs");
                    BuffersDataSource.getInstance().purgeInvalidBIDs();
                    ChannelsDataSource.getInstance().purgeInvalidChannels();
                    for (BuffersDataSource.Buffer b : BuffersDataSource.getInstance().getBuffers()) {
                        Notifications.getInstance().deleteOldNotifications(b.bid, b.last_seen_eid);
                    }
                    if (((NetworkConnection)NetworkConnection.this).userInfo.connections > 0L && (ServersDataSource.getInstance().count() == 0 || BuffersDataSource.getInstance().count() == 0)) {
                        Log.e((String)NetworkConnection.TAG, (String)"Failed to load buffers list, reconnecting");
                        NetworkConnection.this.notifyHandlers(102, null);
                        NetworkConnection.this.streamId = null;
                        if (NetworkConnection.this.client != null) {
                            NetworkConnection.this.client.disconnect();
                        }
                    } else {
                        NetworkConnection.this.failCount = 0;
                        NetworkConnection.this.ready = true;
                        NetworkConnection.this.notifyHandlers(101, null);
                    }
                }
            });
            this.put("bad_channel_key", new BroadcastParser(28));
            this.put("invalid_nick", new BroadcastParser(30));
            BroadcastParser alert = new BroadcastParser(106);
            for (String event : alerts = new String[]{"too_many_channels", "no_such_channel", "no_such_nick", "invalid_nick_change", "chan_privs_needed", "accept_exists", "banned_from_channel", "oper_only", "no_nick_change", "no_messages_from_non_registered", "not_registered", "already_registered", "too_many_targets", "no_such_server", "unknown_command", "help_not_found", "accept_full", "accept_not", "nick_collision", "nick_too_fast", "save_nick", "unknown_mode", "user_not_in_channel", "need_more_params", "users_dont_match", "users_disabled", "invalid_operator_password", "flood_warning", "privs_needed", "operator_fail", "not_on_channel", "ban_on_chan", "cannot_send_to_chan", "user_on_channel", "no_nick_given", "no_text_to_send", "no_origin", "only_servers_can_change_mode", "silence", "no_channel_topic", "invite_only_chan", "channel_full"}) {
                this.put(event, alert);
            }
            this.put("makeserver", new Parser(){

                @Override
                public void parse(IRCCloudJSONObject object) throws JSONException {
                    ServersDataSource s = ServersDataSource.getInstance();
                    String away = object.getString("away");
                    if (NetworkConnection.this.getUserInfo() != null && NetworkConnection.this.getUserInfo().auto_away && away.equals("Auto-away")) {
                        away = "";
                    }
                    ServersDataSource.Server server = s.createServer(object.cid(), object.getString("name"), object.getString("hostname"), object.getInt("port"), object.getString("nick"), object.getString("status"), object.getString("lag").equalsIgnoreCase("undefined") ? 0L : object.getLong("lag"), object.getBoolean("ssl") ? 1 : 0, object.getString("realname"), object.getString("server_pass"), object.getString("nickserv_pass"), object.getString("join_commands"), object.getJsonObject("fail_info"), away, object.getJsonNode("ignores"), object.has("order") && !object.getString("order").equals("undefined") ? object.getInt("order") : 0);
                    Notifications.getInstance().deleteNetwork(object.cid());
                    if (object.getString("name") != null && object.getString("name").length() > 0) {
                        Notifications.getInstance().addNetwork(object.cid(), object.getString("name"));
                    } else {
                        Notifications.getInstance().addNetwork(object.cid(), object.getString("hostname"));
                    }
                    if (!NetworkConnection.this.backlog) {
                        NetworkConnection.this.notifyHandlers(2, server);
                    }
                }
            });
            this.put("server_details_changed", this.get("makeserver"));
            this.put("connection_deleted", new Parser(){

                @Override
                public void parse(IRCCloudJSONObject object) throws JSONException {
                    ServersDataSource s = ServersDataSource.getInstance();
                    s.deleteAllDataForServer(object.cid());
                    Notifications.getInstance().deleteNetwork(object.cid());
                    Notifications.getInstance().showNotifications(null);
                    if (!NetworkConnection.this.backlog) {
                        NetworkConnection.this.notifyHandlers(19, object.cid());
                    }
                }
            });
            this.put("status_changed", new Parser(){

                @Override
                public void parse(IRCCloudJSONObject object) throws JSONException {
                    ServersDataSource s = ServersDataSource.getInstance();
                    s.updateStatus(object.cid(), object.getString("new_status"), object.getJsonObject("fail_info"));
                    if (!NetworkConnection.this.backlog) {
                        if (object.getString("new_status").equals("disconnected")) {
                            ArrayList<BuffersDataSource.Buffer> buffers = BuffersDataSource.getInstance().getBuffersForServer(object.cid());
                            for (BuffersDataSource.Buffer b : buffers) {
                                ChannelsDataSource.getInstance().deleteChannel(b.bid);
                            }
                        }
                        NetworkConnection.this.notifyHandlers(18, object);
                    }
                }
            });
            this.put("connection_lag", new Parser(){

                @Override
                public void parse(IRCCloudJSONObject object) throws JSONException {
                    ServersDataSource s = ServersDataSource.getInstance();
                    s.updateLag(object.cid(), object.getLong("lag"));
                    if (!NetworkConnection.this.backlog) {
                        NetworkConnection.this.notifyHandlers(38, object);
                    }
                }
            });
            this.put("isupport_params", new Parser(){

                @Override
                public void parse(IRCCloudJSONObject object) throws JSONException {
                    ServersDataSource s = ServersDataSource.getInstance();
                    s.updateUserModes(object.cid(), object.getString("usermodes"));
                    s.updateIsupport(object.cid(), object.getJsonObject("params"));
                }
            });
            this.put("reorder_connections", new Parser(){

                @Override
                public void parse(IRCCloudJSONObject object) throws JSONException {
                    ServersDataSource s = ServersDataSource.getInstance();
                    JsonNode order = object.getJsonNode("order");
                    for (int i = 0; i < order.size(); ++i) {
                        ServersDataSource.Server server = s.getServer(order.get(i).asInt());
                        server.order = i + 1;
                    }
                    NetworkConnection.this.notifyHandlers(42, object);
                }
            });
            this.put("open_buffer", new BroadcastParser(29));
            this.put("makebuffer", new Parser(){

                @Override
                public void parse(IRCCloudJSONObject object) throws JSONException {
                    BuffersDataSource b = BuffersDataSource.getInstance();
                    BuffersDataSource.Buffer buffer = b.createBuffer(object.bid(), object.cid(), object.has("min_eid") && !object.getString("min_eid").equalsIgnoreCase("undefined") ? object.getLong("min_eid") : 0L, object.has("last_seen_eid") && !object.getString("last_seen_eid").equalsIgnoreCase("undefined") ? object.getLong("last_seen_eid") : -1L, object.getString("name"), object.getString("buffer_type"), object.has("archived") && object.getBoolean("archived") ? 1 : 0, object.has("deferred") && object.getBoolean("deferred") ? 1 : 0, object.has("timeout") && object.getBoolean("timeout") ? 1 : 0);
                    Notifications.getInstance().deleteOldNotifications(buffer.bid, buffer.last_seen_eid);
                    Notifications.getInstance().updateLastSeenEid(buffer.bid, buffer.last_seen_eid);
                    if (EventsDataSource.getInstance().lastEidForBuffer(buffer.bid) <= buffer.last_seen_eid) {
                        buffer.unread = 0;
                        buffer.highlights = 0;
                    }
                    if (!NetworkConnection.this.backlog) {
                        NetworkConnection.this.notifyHandlers(3, buffer);
                    }
                    NetworkConnection.access$1908(NetworkConnection.this);
                }
            });
            this.put("delete_buffer", new Parser(){

                @Override
                public void parse(IRCCloudJSONObject object) throws JSONException {
                    BuffersDataSource b = BuffersDataSource.getInstance();
                    b.deleteAllDataForBuffer(object.bid());
                    Notifications.getInstance().deleteNotificationsForBid(object.bid());
                    Notifications.getInstance().showNotifications(null);
                    if (!NetworkConnection.this.backlog) {
                        NetworkConnection.this.notifyHandlers(4, object.bid());
                    }
                }
            });
            this.put("buffer_archived", new Parser(){

                @Override
                public void parse(IRCCloudJSONObject object) throws JSONException {
                    BuffersDataSource b = BuffersDataSource.getInstance();
                    b.updateArchived(object.bid(), 1);
                    if (!NetworkConnection.this.backlog) {
                        NetworkConnection.this.notifyHandlers(15, object.bid());
                    }
                }
            });
            this.put("buffer_unarchived", new Parser(){

                @Override
                public void parse(IRCCloudJSONObject object) throws JSONException {
                    BuffersDataSource b = BuffersDataSource.getInstance();
                    b.updateArchived(object.bid(), 0);
                    if (!NetworkConnection.this.backlog) {
                        NetworkConnection.this.notifyHandlers(16, object.bid());
                    }
                }
            });
            this.put("rename_conversation", new Parser(){

                @Override
                public void parse(IRCCloudJSONObject object) throws JSONException {
                    BuffersDataSource b = BuffersDataSource.getInstance();
                    b.updateName(object.bid(), object.getString("new_name"));
                    if (!NetworkConnection.this.backlog) {
                        NetworkConnection.this.notifyHandlers(17, object.bid());
                    }
                }
            });
            Parser msg = new Parser(){

                @Override
                public void parse(IRCCloudJSONObject object) throws JSONException {
                    EventsDataSource e = EventsDataSource.getInstance();
                    boolean newEvent = e.getEvent(object.eid(), object.bid()) == null;
                    EventsDataSource.Event event = e.addEvent(object);
                    BuffersDataSource.Buffer b = BuffersDataSource.getInstance().getBuffer(object.bid());
                    if (b != null && event.eid > b.last_seen_eid && event.isImportant(b.type)) {
                        if (event.highlight || b.type.equals("conversation")) {
                            if (newEvent) {
                                ++b.highlights;
                                b.unread = 1;
                            }
                            JSONObject bufferDisabledMap = null;
                            boolean show = true;
                            if (NetworkConnection.this.userInfo != null && ((NetworkConnection)NetworkConnection.this).userInfo.prefs != null && ((NetworkConnection)NetworkConnection.this).userInfo.prefs.has("buffer-disableTrackUnread") && (bufferDisabledMap = ((NetworkConnection)NetworkConnection.this).userInfo.prefs.getJSONObject("buffer-disableTrackUnread")) != null && bufferDisabledMap.has(String.valueOf(b.bid)) && bufferDisabledMap.getBoolean(String.valueOf(b.bid))) {
                                show = false;
                            }
                            if (show && Notifications.getInstance().getNotification(event.eid) == null) {
                                String message = ColorFormatter.irc_to_html(event.msg);
                                message = ColorFormatter.html_to_spanned(message).toString();
                                Notifications.getInstance().addNotification(event.cid, event.bid, event.eid, event.nick != null ? event.nick : event.from, message, b.name, b.type, event.type);
                                if (!NetworkConnection.this.backlog) {
                                    switch (b.type) {
                                        case "conversation": {
                                            if (event.type.equals("buffer_me_msg")) {
                                                Notifications.getInstance().showNotifications("\u2014 " + b.name + " " + message);
                                                break;
                                            }
                                            Notifications.getInstance().showNotifications(b.name + ": " + message);
                                            break;
                                        }
                                        case "console": {
                                            if (event.from == null || event.from.length() == 0) {
                                                ServersDataSource.Server s = ServersDataSource.getInstance().getServer(event.cid);
                                                if (s.name != null && s.name.length() > 0) {
                                                    Notifications.getInstance().showNotifications(s.name + ": " + message);
                                                    break;
                                                }
                                                Notifications.getInstance().showNotifications(s.hostname + ": " + message);
                                                break;
                                            }
                                            Notifications.getInstance().showNotifications(event.from + ": " + message);
                                            break;
                                        }
                                        default: {
                                            if (event.type.equals("buffer_me_msg")) {
                                                Notifications.getInstance().showNotifications(b.name + ": \u2014 " + event.nick + " " + message);
                                                break;
                                            }
                                            Notifications.getInstance().showNotifications(b.name + ": <" + event.from + "> " + message);
                                        }
                                    }
                                }
                            }
                        } else {
                            b.unread = 1;
                        }
                    } else if (b == null && !NetworkConnection.this.oobTasks.containsKey(-1)) {
                        Log.e((String)NetworkConnection.TAG, (String)"Got a message for a buffer that doesn't exist, reconnecting!");
                        NetworkConnection.this.notifyHandlers(102, null);
                        NetworkConnection.this.streamId = null;
                        if (NetworkConnection.this.client != null) {
                            NetworkConnection.this.client.disconnect();
                        }
                    }
                    if (NetworkConnection.this.handlers.size() == 0 && b != null && !b.scrolledUp && EventsDataSource.getInstance().getSizeOfBuffer(b.bid) > 200) {
                        EventsDataSource.getInstance().pruneEvents(b.bid);
                    }
                    if (event.reqid >= 0) {
                        EventsDataSource.Event pending = EventsDataSource.getInstance().findPendingEventForReqid(event.bid, event.reqid);
                        if (pending != null) {
                            try {
                                if (pending.expiration_timer != null) {
                                    pending.expiration_timer.cancel();
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (pending.eid != event.eid) {
                                EventsDataSource.getInstance().deleteEvent(pending.eid, pending.bid);
                            }
                        }
                    } else if (event.self && b != null && b.type.equals("conversation")) {
                        EventsDataSource.getInstance().clearPendingEvents(event.bid);
                    }
                    if (!NetworkConnection.this.backlog) {
                        NetworkConnection.this.notifyHandlers(5, event);
                    }
                }
            };
            for (String event : msgs = new String[]{"buffer_msg", "buffer_me_msg", "wait", "banned", "kill", "connecting_cancelled", "target_callerid", "notice", "server_motdstart", "server_welcome", "server_motd", "server_endofmotd", "server_nomotd", "server_luserclient", "server_luserop", "server_luserconns", "server_luserme", "server_n_local", "server_luserchannels", "server_n_global", "server_yourhost", "server_created", "server_luserunknown", "server_snomask", "services_down", "your_unique_id", "callerid", "target_notified", "myinfo", "hidden_host_set", "unhandled_line", "unparsed_line", "connecting_failed", "nickname_in_use", "channel_invite", "motd_response", "socket_closed", "channel_mode_list_change", "msg_services", "stats", "statslinkinfo", "statscommands", "statscline", "statsnline", "statsiline", "statskline", "statsqline", "statsyline", "statsbline", "statsgline", "statstline", "statseline", "statsvline", "statslline", "statsuptime", "statsoline", "statshline", "statssline", "statsuline", "statsdebug", "endofstats", "inviting_to_channel", "error", "too_fast", "no_bots", "wallops", "logged_in_as", "sasl_fail", "sasl_too_long", "sasl_aborted", "sasl_already", "you_are_operator", "btn_metadata_set", "sasl_success", "cap_ls", "cap_req", "cap_ack", "cap_raw", "help_topics_start", "help_topics", "help_topics_end", "helphdr", "helpop", "helptlr", "helphlp", "helpfwd", "helpign", "version", "newsflash", "invited", "codepage", "logged_out", "nick_locked", "info_response", "generic_server_info", "unknown_umode", "bad_ping", "rehashed_config", "knock", "bad_channel_mask", "kill_deny", "chan_own_priv_needed", "not_for_halfops", "chan_forbidden", "starircd_welcome", "zurna_motd", "ambiguous_error_message", "list_usage", "list_syntax", "who_syntax", "text", "admin_info", "watch_status", "sqline_nick"}) {
                this.put(event, msg);
            }
            this.put("link_channel", new Parser(){

                @Override
                public void parse(IRCCloudJSONObject object) throws JSONException {
                    EventsDataSource e = EventsDataSource.getInstance();
                    e.addEvent(object);
                    if (!NetworkConnection.this.backlog) {
                        NetworkConnection.this.notifyHandlers(34, object);
                    }
                }
            });
            this.put("channel_init", new Parser(){

                @Override
                public void parse(IRCCloudJSONObject object) throws JSONException {
                    ChannelsDataSource c = ChannelsDataSource.getInstance();
                    ChannelsDataSource.Channel channel = c.createChannel(object.cid(), object.bid(), object.getString("chan"), object.getJsonObject("topic").get("text").isNull() ? "" : object.getJsonObject("topic").get("text").asText(), object.getJsonObject("topic").get("time").asLong(), object.getJsonObject("topic").has("nick") ? object.getJsonObject("topic").get("nick").asText() : object.getJsonObject("topic").get("server").asText(), object.getString("channel_type"), object.getLong("timestamp"));
                    c.updateMode(object.bid(), object.getString("mode"), object.getJsonObject("ops"), true);
                    UsersDataSource u = UsersDataSource.getInstance();
                    u.deleteUsersForBuffer(object.bid());
                    JsonNode users = object.getJsonNode("members");
                    for (int i = 0; i < users.size(); ++i) {
                        JsonNode user = users.get(i);
                        u.createUser(object.cid(), object.bid(), user.get("nick").asText(), user.get("usermask").asText(), user.get("mode").asText(), user.get("away").asBoolean() ? 1 : 0, false);
                    }
                    BuffersDataSource.getInstance().dirty = true;
                    if (!NetworkConnection.this.backlog) {
                        NetworkConnection.this.notifyHandlers(7, channel);
                    }
                }
            });
            this.put("channel_topic", new Parser(){

                @Override
                public void parse(IRCCloudJSONObject object) throws JSONException {
                    EventsDataSource e = EventsDataSource.getInstance();
                    e.addEvent(object);
                    if (!NetworkConnection.this.backlog) {
                        ChannelsDataSource c = ChannelsDataSource.getInstance();
                        c.updateTopic(object.bid(), object.getString("topic"), object.getLong("eid") / 1000000L, object.has("author") ? object.getString("author") : object.getString("server"));
                        NetworkConnection.this.notifyHandlers(8, object);
                    }
                }
            });
            this.put("channel_url", new Parser(){

                @Override
                public void parse(IRCCloudJSONObject object) throws JSONException {
                    ChannelsDataSource c = ChannelsDataSource.getInstance();
                    c.updateURL(object.bid(), object.getString("url"));
                }
            });
            this.put("channel_mode", new Parser(){

                @Override
                public void parse(IRCCloudJSONObject object) throws JSONException {
                    EventsDataSource e = EventsDataSource.getInstance();
                    e.addEvent(object);
                    if (!NetworkConnection.this.backlog) {
                        ChannelsDataSource c = ChannelsDataSource.getInstance();
                        c.updateMode(object.bid(), object.getString("newmode"), object.getJsonObject("ops"), false);
                        NetworkConnection.this.notifyHandlers(23, object);
                    }
                }
            });
            this.put("channel_mode_is", this.get("channel_mode"));
            this.put("channel_timestamp", new Parser(){

                @Override
                public void parse(IRCCloudJSONObject object) throws JSONException {
                    if (!NetworkConnection.this.backlog) {
                        ChannelsDataSource c = ChannelsDataSource.getInstance();
                        c.updateTimestamp(object.bid(), object.getLong("timestamp"));
                        NetworkConnection.this.notifyHandlers(24, object);
                    }
                }
            });
            this.put("joined_channel", new Parser(){

                @Override
                public void parse(IRCCloudJSONObject object) throws JSONException {
                    EventsDataSource e = EventsDataSource.getInstance();
                    e.addEvent(object);
                    if (!NetworkConnection.this.backlog) {
                        UsersDataSource u = UsersDataSource.getInstance();
                        u.createUser(object.cid(), object.bid(), object.getString("nick"), object.getString("hostmask"), "", 0);
                        NetworkConnection.this.notifyHandlers(9, object);
                    }
                }
            });
            this.put("you_joined_channel", this.get("joined_channel"));
            this.put("parted_channel", new Parser(){

                @Override
                public void parse(IRCCloudJSONObject object) throws JSONException {
                    EventsDataSource e = EventsDataSource.getInstance();
                    e.addEvent(object);
                    if (!NetworkConnection.this.backlog) {
                        UsersDataSource u = UsersDataSource.getInstance();
                        u.deleteUser(object.bid(), object.getString("nick"));
                        if (object.type().equals("you_parted_channel")) {
                            ChannelsDataSource c = ChannelsDataSource.getInstance();
                            c.deleteChannel(object.bid());
                            u.deleteUsersForBuffer(object.bid());
                            BuffersDataSource.getInstance().dirty = true;
                        }
                        NetworkConnection.this.notifyHandlers(10, object);
                    }
                }
            });
            this.put("you_parted_channel", this.get("parted_channel"));
            this.put("quit", new Parser(){

                @Override
                public void parse(IRCCloudJSONObject object) throws JSONException {
                    EventsDataSource e = EventsDataSource.getInstance();
                    e.addEvent(object);
                    if (!NetworkConnection.this.backlog) {
                        UsersDataSource u = UsersDataSource.getInstance();
                        u.deleteUser(object.bid(), object.getString("nick"));
                        NetworkConnection.this.notifyHandlers(12, object);
                    }
                }
            });
            this.put("quit_server", new Parser(){

                @Override
                public void parse(IRCCloudJSONObject object) throws JSONException {
                    EventsDataSource e = EventsDataSource.getInstance();
                    e.addEvent(object);
                    if (!NetworkConnection.this.backlog) {
                        NetworkConnection.this.notifyHandlers(12, object);
                    }
                }
            });
            this.put("kicked_channel", new Parser(){

                @Override
                public void parse(IRCCloudJSONObject object) throws JSONException {
                    EventsDataSource e = EventsDataSource.getInstance();
                    e.addEvent(object);
                    if (!NetworkConnection.this.backlog) {
                        UsersDataSource u = UsersDataSource.getInstance();
                        u.deleteUser(object.bid(), object.getString("nick"));
                        if (object.type().equals("you_kicked_channel")) {
                            ChannelsDataSource c = ChannelsDataSource.getInstance();
                            c.deleteChannel(object.bid());
                            u.deleteUsersForBuffer(object.bid());
                            BuffersDataSource.getInstance().dirty = true;
                        }
                        NetworkConnection.this.notifyHandlers(22, object);
                    }
                }
            });
            this.put("you_kicked_channel", this.get("kicked_channel"));
            this.put("nickchange", new Parser(){

                @Override
                public void parse(IRCCloudJSONObject object) throws JSONException {
                    EventsDataSource e = EventsDataSource.getInstance();
                    e.addEvent(object);
                    if (!NetworkConnection.this.backlog) {
                        UsersDataSource u = UsersDataSource.getInstance();
                        u.updateNick(object.bid(), object.getString("oldnick"), object.getString("newnick"));
                        if (object.type().equals("you_nickchange")) {
                            ServersDataSource.getInstance().updateNick(object.cid(), object.getString("newnick"));
                        }
                        NetworkConnection.this.notifyHandlers(11, object);
                    }
                }
            });
            this.put("you_nickchange", this.get("nickchange"));
            this.put("user_channel_mode", new Parser(){

                @Override
                public void parse(IRCCloudJSONObject object) throws JSONException {
                    EventsDataSource e = EventsDataSource.getInstance();
                    e.addEvent(object);
                    if (!NetworkConnection.this.backlog) {
                        UsersDataSource u = UsersDataSource.getInstance();
                        u.updateMode(object.bid(), object.getString("nick"), object.getString("newmode"));
                        NetworkConnection.this.notifyHandlers(14, object);
                    }
                }
            });
            this.put("member_updates", new Parser(){

                @Override
                public void parse(IRCCloudJSONObject object) throws JSONException {
                    ObjectNode updates = object.getJsonObject("updates");
                    Iterator<Map.Entry<String, JsonNode>> i = ((JsonNode)updates).fields();
                    while (i.hasNext()) {
                        Map.Entry<String, JsonNode> e = i.next();
                        JsonNode user = e.getValue();
                        UsersDataSource u = UsersDataSource.getInstance();
                        u.updateAway(object.bid(), user.get("nick").asText(), user.get("away").asBoolean() ? 1 : 0);
                        u.updateHostmask(object.bid(), user.get("nick").asText(), user.get("usermask").asText());
                    }
                    if (!NetworkConnection.this.backlog) {
                        NetworkConnection.this.notifyHandlers(13, null);
                    }
                }
            });
            this.put("user_away", new Parser(){

                @Override
                public void parse(IRCCloudJSONObject object) throws JSONException {
                    BuffersDataSource b = BuffersDataSource.getInstance();
                    UsersDataSource u = UsersDataSource.getInstance();
                    u.updateAwayMsg(object.bid(), object.getString("nick"), 1, object.getString("msg"));
                    b.updateAway(object.cid(), object.getString("nick"), object.getString("msg"));
                    if (!NetworkConnection.this.backlog) {
                        NetworkConnection.this.notifyHandlers(20, object);
                    }
                }
            });
            this.put("away", this.get("user_away"));
            this.put("user_back", new Parser(){

                @Override
                public void parse(IRCCloudJSONObject object) throws JSONException {
                    BuffersDataSource b = BuffersDataSource.getInstance();
                    UsersDataSource u = UsersDataSource.getInstance();
                    u.updateAwayMsg(object.bid(), object.getString("nick"), 0, "");
                    b.updateAway(object.cid(), object.getString("nick"), "");
                    if (!NetworkConnection.this.backlog) {
                        NetworkConnection.this.notifyHandlers(20, object);
                    }
                }
            });
            this.put("self_away", new Parser(){

                @Override
                public void parse(IRCCloudJSONObject object) throws JSONException {
                    if (!NetworkConnection.this.backlog) {
                        ServersDataSource s = ServersDataSource.getInstance();
                        UsersDataSource u = UsersDataSource.getInstance();
                        u.updateAwayMsg(object.bid(), object.getString("nick"), 1, object.getString("away_msg"));
                        s.updateAway(object.cid(), object.getString("away_msg"));
                        NetworkConnection.this.notifyHandlers(20, object);
                    }
                }
            });
            this.put("self_back", new Parser(){

                @Override
                public void parse(IRCCloudJSONObject object) throws JSONException {
                    ServersDataSource s = ServersDataSource.getInstance();
                    UsersDataSource u = UsersDataSource.getInstance();
                    u.updateAwayMsg(object.bid(), object.getString("nick"), 0, "");
                    s.updateAway(object.cid(), "");
                    if (!NetworkConnection.this.backlog) {
                        NetworkConnection.this.notifyHandlers(21, object);
                    }
                }
            });
            this.put("self_details", new Parser(){

                @Override
                public void parse(IRCCloudJSONObject object) throws JSONException {
                    ServersDataSource s = ServersDataSource.getInstance();
                    s.updateUsermask(object.cid(), object.getString("usermask"));
                    EventsDataSource e = EventsDataSource.getInstance();
                    e.addEvent(object);
                    if (!NetworkConnection.this.backlog) {
                        NetworkConnection.this.notifyHandlers(25, object);
                    }
                }
            });
            this.put("user_mode", new Parser(){

                @Override
                public void parse(IRCCloudJSONObject object) throws JSONException {
                    EventsDataSource e = EventsDataSource.getInstance();
                    e.addEvent(object);
                    if (!NetworkConnection.this.backlog) {
                        ServersDataSource s = ServersDataSource.getInstance();
                        s.updateMode(object.cid(), object.getString("newmode"));
                        NetworkConnection.this.notifyHandlers(26, object);
                    }
                }
            });
            this.put("ban_list", new BroadcastParser(31));
            this.put("accept_list", new BroadcastParser(40));
            this.put("names_reply", new BroadcastParser(41));
            this.put("whois_response", new BroadcastParser(33));
            this.put("list_response_fetching", new BroadcastParser(35));
            this.put("list_response_toomany", new BroadcastParser(37));
            this.put("list_response", new BroadcastParser(36));
            this.put("map_list", new BroadcastParser(44));
            this.put("quiet_list", new BroadcastParser(45));
            this.put("ban_exception_list", new BroadcastParser(46));
            this.put("invite_list", new BroadcastParser(47));
            this.put("who_response", new Parser(){

                @Override
                public void parse(IRCCloudJSONObject object) throws JSONException {
                    if (!NetworkConnection.this.backlog) {
                        BuffersDataSource.Buffer b = BuffersDataSource.getInstance().getBufferByName(object.cid(), object.getString("subject"));
                        if (b != null) {
                            UsersDataSource u = UsersDataSource.getInstance();
                            JsonNode users = object.getJsonNode("users");
                            for (int i = 0; i < users.size(); ++i) {
                                JsonNode user = users.get(i);
                                u.updateHostmask(b.bid, user.get("nick").asText(), user.get("usermask").asText());
                                u.updateAway(b.bid, user.get("nick").asText(), user.get("away").asBoolean() ? 1 : 0);
                            }
                        }
                        NetworkConnection.this.notifyHandlers(32, object);
                    }
                }
            });
            this.put("time", new Parser(){

                @Override
                public void parse(IRCCloudJSONObject object) throws JSONException {
                    EventsDataSource.Event e = EventsDataSource.getInstance().addEvent(object);
                    if (!NetworkConnection.this.backlog) {
                        NetworkConnection.this.notifyHandlers(106, object);
                        NetworkConnection.this.notifyHandlers(5, e);
                    }
                }
            });
            this.put("channel_topic_is", new Parser(){

                @Override
                public void parse(IRCCloudJSONObject object) throws JSONException {
                    ChannelsDataSource.Channel c;
                    BuffersDataSource.Buffer b = BuffersDataSource.getInstance().getBufferByName(object.cid(), object.getString("chan"));
                    if (b != null && (c = ChannelsDataSource.getInstance().getChannelForBuffer(b.bid)) != null) {
                        c.topic_author = object.has("author") ? object.getString("author") : object.getString("server");
                        c.topic_time = object.getLong("time");
                        c.topic_text = object.getString("text");
                    }
                    if (!NetworkConnection.this.backlog) {
                        NetworkConnection.this.notifyHandlers(43, object);
                    }
                }
            });
        }
    };
    private TimerTask shutdownTimerTask = null;

    public void setSSLAuth(String alias, PrivateKey key, X509Certificate[] certificateChain) {
        this.SSLAuthAlias = alias;
        this.SSLAuthKey = key;
        this.SSLAuthCertificateChain = certificateChain;
    }

    public static NetworkConnection getInstance() {
        if (instance == null) {
            instance = new NetworkConnection();
        }
        return instance;
    }

    public NetworkConnection() {
        String version;
        String network_type = null;
        try {
            version = "/" + IRCCloudApplication.getInstance().getPackageManager().getPackageInfo((String)IRCCloudApplication.getInstance().getApplicationContext().getPackageName(), (int)0).versionName;
        }
        catch (Exception e) {
            version = "";
        }
        try {
            ConnectivityManager cm = (ConnectivityManager)IRCCloudApplication.getInstance().getSystemService("connectivity");
            NetworkInfo ni = cm.getActiveNetworkInfo();
            if (ni != null) {
                network_type = ni.getTypeName();
            }
        }
        catch (Exception cm) {
            // empty catch block
        }
        try {
            this.config = new JSONObject(PreferenceManager.getDefaultSharedPreferences((Context)IRCCloudApplication.getInstance().getApplicationContext()).getString("config", "{}"));
        }
        catch (JSONException e) {
            e.printStackTrace();
            this.config = new JSONObject();
        }
        this.useragent = TAG + version + " (" + Build.MODEL + "; " + Locale.getDefault().getCountry().toLowerCase() + "; Android " + Build.VERSION.RELEASE;
        WindowManager wm = (WindowManager)IRCCloudApplication.getInstance().getSystemService("window");
        this.useragent = this.useragent + "; " + wm.getDefaultDisplay().getWidth() + "x" + wm.getDefaultDisplay().getHeight();
        if (network_type != null) {
            this.useragent = this.useragent + "; " + network_type;
        }
        this.useragent = this.useragent + ")";
        WifiManager wfm = (WifiManager)IRCCloudApplication.getInstance().getApplicationContext().getSystemService("wifi");
        this.wifiLock = wfm.createWifiLock(TAG);
        this.kms = new X509ExtendedKeyManager[1];
        this.kms[0] = new X509ExtendedKeyManager(){

            @Override
            public String chooseClientAlias(String[] keyTypes, Principal[] issuers, Socket socket) {
                return NetworkConnection.this.SSLAuthAlias;
            }

            @Override
            public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
                throw new UnsupportedOperationException();
            }

            @Override
            public X509Certificate[] getCertificateChain(String alias) {
                return NetworkConnection.this.SSLAuthCertificateChain;
            }

            @Override
            public String[] getClientAliases(String keyType, Principal[] issuers) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String[] getServerAliases(String keyType, Principal[] issuers) {
                throw new UnsupportedOperationException();
            }

            @Override
            public PrivateKey getPrivateKey(String alias) {
                return NetworkConnection.this.SSLAuthKey;
            }
        };
        this.tms = new TrustManager[1];
        this.tms[0] = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                throw new CertificateException("Not implemented");
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                try {
                    TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("X509");
                    trustManagerFactory.init((KeyStore)null);
                    for (TrustManager trustManager : trustManagerFactory.getTrustManagers()) {
                        if (!(trustManager instanceof X509TrustManager)) continue;
                        X509TrustManager x509TrustManager = (X509TrustManager)trustManager;
                        x509TrustManager.checkServerTrusted(chain, authType);
                    }
                }
                catch (KeyStoreException e) {
                    throw new CertificateException(e);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new CertificateException(e);
                }
                if (BuildConfig.SSL_FPS != null && BuildConfig.SSL_FPS.length > 0) {
                    try {
                        MessageDigest md = MessageDigest.getInstance("SHA-1");
                        byte[] sha1 = md.digest(chain[0].getEncoded());
                        char[] hexArray = "0123456789ABCDEF".toCharArray();
                        char[] hexChars = new char[sha1.length * 2];
                        for (int j = 0; j < sha1.length; ++j) {
                            int v = sha1[j] & 0xFF;
                            hexChars[j * 2] = hexArray[v >>> 4];
                            hexChars[j * 2 + 1] = hexArray[v & 0xF];
                        }
                        String hexCharsStr = new String(hexChars);
                        boolean matched = false;
                        for (String fp : BuildConfig.SSL_FPS) {
                            if (!fp.equals(hexCharsStr)) continue;
                            matched = true;
                            break;
                        }
                        if (!matched) {
                            throw new CertificateException("Incorrect CN in cert chain");
                        }
                    }
                    catch (NoSuchAlgorithmException e) {
                        e.printStackTrace();
                    }
                }
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        WebSocketClient.setTrustManagers(this.tms);
    }

    public int getState() {
        return this.state;
    }

    public void disconnect() {
        if (this.client != null) {
            this.state = 3;
            this.client.disconnect();
        } else {
            this.state = 0;
        }
        if (this.idleTimerTask != null) {
            this.idleTimerTask.cancel();
        }
        if (this.wifiLock.isHeld()) {
            this.wifiLock.release();
        }
        this.reconnect_timestamp = 0L;
        for (Integer bid : this.oobTasks.keySet()) {
            try {
                this.oobTasks.get(bid).cancel(true);
            }
            catch (Exception exception) {}
        }
        this.oobTasks.clear();
        this.session = null;
        for (BuffersDataSource.Buffer b : BuffersDataSource.getInstance().getBuffers()) {
            if (b.scrolledUp) continue;
            EventsDataSource.getInstance().pruneEvents(b.bid);
        }
    }

    public JSONObject login(String email, String password) {
        try {
            String tokenResponse = this.fetch(new URL("https://" + IRCCLOUD_HOST + "/chat/auth-formtoken"), "", null, null);
            JSONObject token = new JSONObject(tokenResponse);
            if (token.has("token")) {
                String postdata = "email=" + URLEncoder.encode(email, "UTF-8") + "&password=" + URLEncoder.encode(password, "UTF-8") + "&token=" + token.getString("token");
                String response = this.fetch(new URL("https://" + IRCCLOUD_HOST + "/chat/login"), postdata, null, token.getString("token"));
                if (response.length() < 1) {
                    JSONObject o = new JSONObject();
                    o.put("message", (Object)"empty_response");
                    return o;
                }
                if (response.charAt(0) != '{') {
                    JSONObject o = new JSONObject();
                    o.put("message", (Object)"invalid_response");
                    return o;
                }
                return new JSONObject(response);
            }
            return null;
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (JSONException e) {
            e.printStackTrace();
            JSONObject o = new JSONObject();
            try {
                o.put("message", (Object)"json_error");
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return o;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public JSONObject signup(String realname, String email, String password, String impression) {
        try {
            String tokenResponse = this.fetch(new URL("https://" + IRCCLOUD_HOST + "/chat/auth-formtoken"), "", null, null);
            JSONObject token = new JSONObject(tokenResponse);
            if (token.has("token")) {
                String postdata = "realname=" + URLEncoder.encode(realname, "UTF-8") + "&email=" + URLEncoder.encode(email, "UTF-8") + "&password=" + URLEncoder.encode(password, "UTF-8") + "&token=" + token.getString("token") + "&android_impression=" + URLEncoder.encode(impression, "UTF-8");
                String response = this.fetch(new URL("https://" + IRCCLOUD_HOST + "/chat/signup"), postdata, null, token.getString("token"));
                if (response.length() < 1) {
                    JSONObject o = new JSONObject();
                    o.put("message", (Object)"empty_response");
                    return o;
                }
                if (response.charAt(0) != '{') {
                    JSONObject o = new JSONObject();
                    o.put("message", (Object)"invalid_response");
                    return o;
                }
                return new JSONObject(response);
            }
            return null;
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (JSONException e) {
            e.printStackTrace();
            JSONObject o = new JSONObject();
            try {
                o.put("message", (Object)"json_error");
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return o;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public JSONObject request_password(String email) {
        try {
            String tokenResponse = this.fetch(new URL("https://" + IRCCLOUD_HOST + "/chat/auth-formtoken"), "", null, null);
            JSONObject token = new JSONObject(tokenResponse);
            if (token.has("token")) {
                String postdata = "email=" + URLEncoder.encode(email, "UTF-8") + "&token=" + token.getString("token") + "&mobile=1";
                String response = this.fetch(new URL("https://" + IRCCLOUD_HOST + "/chat/request-access-link"), postdata, null, token.getString("token"));
                if (response.length() < 1) {
                    JSONObject o = new JSONObject();
                    o.put("message", (Object)"empty_response");
                    return o;
                }
                if (response.charAt(0) != '{') {
                    JSONObject o = new JSONObject();
                    o.put("message", (Object)"invalid_response");
                    return o;
                }
                return new JSONObject(response);
            }
            return null;
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (JSONException e) {
            e.printStackTrace();
            JSONObject o = new JSONObject();
            try {
                o.put("message", (Object)"json_error");
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return o;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public JSONObject impression(String adid, String referrer, String sk) {
        try {
            String postdata = "adid=" + URLEncoder.encode(adid, "UTF-8") + "&referrer=" + URLEncoder.encode(referrer, "UTF-8") + "&session=" + sk;
            String response = this.fetch(new URL("https://" + IRCCLOUD_HOST + "/chat/android-impressions"), postdata, sk, null);
            if (response.length() < 1) {
                JSONObject o = new JSONObject();
                o.put("message", (Object)"empty_response");
                return o;
            }
            if (response.charAt(0) != '{') {
                JSONObject o = new JSONObject();
                o.put("message", (Object)"invalid_response");
                return o;
            }
            return new JSONObject(response);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (JSONException e) {
            e.printStackTrace();
            JSONObject o = new JSONObject();
            try {
                o.put("message", (Object)"json_error");
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return o;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public JSONObject fetchJSON(String url) throws IOException {
        try {
            String response = this.fetch(new URL(url), null, null, null);
            return new JSONObject(response);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public JSONObject fetchJSON(String url, String postdata) throws IOException {
        try {
            String response = this.fetch(new URL(url), postdata, null, null);
            return new JSONObject(response);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public JSONObject fetchConfig() {
        try {
            JSONObject o = this.fetchJSON("https://" + IRCCLOUD_HOST + "/config");
            if (o != null) {
                this.config = o;
                SharedPreferences.Editor prefs = PreferenceManager.getDefaultSharedPreferences((Context)IRCCloudApplication.getInstance().getApplicationContext()).edit();
                prefs.putString("config", this.config.toString());
                prefs.commit();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.config;
    }

    public JSONObject registerGCM(String regId, String sk) throws IOException {
        String postdata = "device_id=" + regId + "&session=" + sk;
        try {
            String response = this.fetch(new URL("https://" + IRCCLOUD_HOST + "/gcm-register"), postdata, sk, null);
            return new JSONObject(response);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public JSONObject unregisterGCM(String regId, String sk) throws IOException {
        String postdata = "device_id=" + regId + "&session=" + sk;
        try {
            String response = this.fetch(new URL("https://" + IRCCLOUD_HOST + "/gcm-unregister"), postdata, sk, null);
            return new JSONObject(response);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public JSONObject files(int page) throws IOException {
        try {
            String response = this.fetch(new URL("https://" + IRCCLOUD_HOST + "/chat/files?page=" + page), null, this.session, null);
            return new JSONObject(response);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public JSONObject pastebins(int page) throws IOException {
        try {
            String response = this.fetch(new URL("https://" + IRCCLOUD_HOST + "/chat/pastebins?page=" + page), null, this.session, null);
            return new JSONObject(response);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void logout(final String sk) {
        idleTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    Log.i((String)NetworkConnection.TAG, (String)"Invalidating session");
                    NetworkConnection.this.fetch(new URL("https://" + IRCCLOUD_HOST + "/chat/logout"), "session=" + sk, sk, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, 50L);
    }

    public JSONArray networkPresets() throws IOException {
        try {
            String response = this.fetch(new URL("https://" + IRCCLOUD_HOST + "/static/networks.json"), null, null, null);
            JSONObject o = new JSONObject(response);
            return o.getJSONArray("networks");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void registerForConnectivity() {
        try {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
            IRCCloudApplication.getInstance().getApplicationContext().registerReceiver(this.connectivityListener, intentFilter);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void unregisterForConnectivity() {
        try {
            IRCCloudApplication.getInstance().getApplicationContext().unregisterReceiver(this.connectivityListener);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public synchronized void connect(String sk) {
        Object cm;
        NetworkInfo ni;
        Context ctx = IRCCloudApplication.getInstance().getApplicationContext();
        this.session = sk;
        String host = null;
        int port = -1;
        if (sk == null || sk.length() == 0) {
            return;
        }
        if (!(ctx == null || (ni = (cm = (ConnectivityManager)ctx.getSystemService("connectivity")).getActiveNetworkInfo()) != null && ni.isConnected())) {
            this.cancel_idle_timer();
            this.state = 0;
            this.reconnect_timestamp = 0L;
            this.notifyHandlers(0, null);
            return;
        }
        if (this.state == 1 || this.state == 2) {
            Log.w((String)TAG, (String)"Ignoring duplicate connect request");
            return;
        }
        this.state = 1;
        if (this.oobTasks.size() > 0) {
            Log.d((String)TAG, (String)"Clearing OOB tasks before connecting");
        }
        for (Integer bid : this.oobTasks.keySet()) {
            try {
                this.oobTasks.get(bid).cancel(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.oobTasks.clear();
        if (Build.VERSION.SDK_INT < 11) {
            if (ctx != null) {
                host = Proxy.getHost((Context)ctx);
                port = Proxy.getPort((Context)ctx);
            }
        } else {
            host = System.getProperty("http.proxyHost", null);
            try {
                port = Integer.parseInt(System.getProperty("http.proxyPort", "8080"));
            }
            catch (NumberFormatException e) {
                port = -1;
            }
        }
        if (!this.wifiLock.isHeld()) {
            this.wifiLock.acquire();
        }
        List<BasicNameValuePair> extraHeaders = Arrays.asList(new BasicNameValuePair("Cookie", "session=" + this.session), new BasicNameValuePair("User-Agent", this.useragent));
        String url = "wss://" + IRCCLOUD_HOST + IRCCLOUD_PATH;
        if (EventsDataSource.getInstance().highest_eid > 0L) {
            url = url + "?since_id=" + EventsDataSource.getInstance().highest_eid;
            if (this.streamId != null && this.streamId.length() > 0) {
                url = url + "&stream_id=" + this.streamId;
            }
        }
        if (host != null && host.length() > 0 && !host.equalsIgnoreCase("localhost") && !host.equalsIgnoreCase("127.0.0.1") && port > 0) {
            Crashlytics.log(3, TAG, "Connecting: " + url + " via proxy: " + host);
        } else {
            Crashlytics.log(3, TAG, "Connecting: " + url);
        }
        Crashlytics.log(3, TAG, "Attempt: " + this.failCount);
        this.client = new WebSocketClient(URI.create(url), new WebSocketClient.Listener(){

            @Override
            public void onConnect() {
                Crashlytics.log(3, NetworkConnection.TAG, "WebSocket connected");
                NetworkConnection.this.state = 2;
                NetworkConnection.this.notifyHandlers(0, null);
                NetworkConnection.this.fetchConfig();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onMessage(String message) {
                if (NetworkConnection.this.client != null && NetworkConnection.this.client.getListener() == this && message.length() > 0) {
                    try {
                        Object object = NetworkConnection.this.parserLock;
                        synchronized (object) {
                            NetworkConnection.this.parse_object(new IRCCloudJSONObject(NetworkConnection.this.mapper.readValue(message, JsonNode.class)));
                        }
                    }
                    catch (Exception e) {
                        Log.e((String)NetworkConnection.TAG, (String)("Unable to parse: " + message));
                        Crashlytics.logException(e);
                        e.printStackTrace();
                    }
                }
            }

            @Override
            public void onMessage(byte[] data) {
            }

            @Override
            public void onDisconnect(int code, String reason) {
                Crashlytics.log(3, NetworkConnection.TAG, "WebSocket disconnected");
                ConnectivityManager cm = (ConnectivityManager)IRCCloudApplication.getInstance().getApplicationContext().getSystemService("connectivity");
                NetworkInfo ni = cm.getActiveNetworkInfo();
                if (NetworkConnection.this.state == 3 || ni == null || !ni.isConnected()) {
                    NetworkConnection.this.cancel_idle_timer();
                } else {
                    NetworkConnection.this.failCount++;
                    NetworkConnection.this.idle_interval = NetworkConnection.this.failCount < 4 ? (long)(NetworkConnection.this.failCount * 1000) : (NetworkConnection.this.failCount < 10 ? 10000L : 30000L);
                    NetworkConnection.this.schedule_idle_timer();
                    Crashlytics.log(3, NetworkConnection.TAG, "Reconnecting in " + NetworkConnection.this.idle_interval / 1000L + " seconds");
                }
                NetworkConnection.this.state = 0;
                NetworkConnection.this.notifyHandlers(0, null);
                if (reason != null && reason.equals("SSL")) {
                    Crashlytics.log(6, NetworkConnection.TAG, "The socket was disconnected due to an SSL error");
                    try {
                        JSONObject o = new JSONObject();
                        o.put("message", (Object)"Unable to establish a secure connection to the IRCCloud servers.");
                        NetworkConnection.this.notifyHandlers(103, new IRCCloudJSONObject(o));
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
                NetworkConnection.this.client = null;
            }

            @Override
            public void onError(Exception error) {
                Crashlytics.log(6, NetworkConnection.TAG, "The WebSocket encountered an error: " + error.toString());
                if (NetworkConnection.this.state == 3) {
                    NetworkConnection.this.cancel_idle_timer();
                } else {
                    NetworkConnection.this.failCount++;
                    NetworkConnection.this.idle_interval = NetworkConnection.this.failCount < 4 ? (long)(NetworkConnection.this.failCount * 1000) : (NetworkConnection.this.failCount < 10 ? 10000L : 30000L);
                    NetworkConnection.this.schedule_idle_timer();
                    Crashlytics.log(3, NetworkConnection.TAG, "Reconnecting in " + NetworkConnection.this.idle_interval / 1000L + " seconds");
                }
                NetworkConnection.this.state = 0;
                NetworkConnection.this.notifyHandlers(0, null);
                NetworkConnection.this.client = null;
            }
        }, extraHeaders);
        Log.d((String)TAG, (String)"Creating websocket");
        this.reconnect_timestamp = 0L;
        this.idle_interval = 0L;
        this.accrued = 0;
        this.notifyHandlers(0, null);
        if (this.client != null) {
            this.client.setSocketTag(330807);
            if (host != null && host.length() > 0 && !host.equalsIgnoreCase("localhost") && !host.equalsIgnoreCase("127.0.0.1") && port > 0) {
                this.client.setProxy(host, port);
            } else {
                this.client.setProxy(null, -1);
            }
            this.client.connect();
        }
    }

    public void logout() {
        String sk = this.session;
        this.disconnect();
        this.ready = false;
        this.streamId = null;
        this.accrued = 0;
        SharedPreferences.Editor editor = IRCCloudApplication.getInstance().getApplicationContext().getSharedPreferences("prefs", 0).edit();
        try {
            String regId = GCMIntentService.getRegistrationId(IRCCloudApplication.getInstance().getApplicationContext());
            editor.clear();
            editor.commit();
            if (regId.length() > 0) {
                editor.putString(regId, sk);
                editor.commit();
                GCMIntentService.scheduleUnregisterTimer(100, regId, false);
            } else {
                this.logout(sk);
            }
        }
        catch (Exception e) {
            editor.clear();
            editor.commit();
            this.logout(sk);
        }
        SharedPreferences.Editor prefs = PreferenceManager.getDefaultSharedPreferences((Context)IRCCloudApplication.getInstance().getApplicationContext()).edit();
        prefs.clear();
        prefs.commit();
        ServersDataSource.getInstance().clear();
        BuffersDataSource.getInstance().clear();
        ChannelsDataSource.getInstance().clear();
        UsersDataSource.getInstance().clear();
        EventsDataSource.getInstance().clear();
        Notifications.getInstance().clearNetworks();
        Notifications.getInstance().clear();
        this.userInfo = null;
    }

    private synchronized int send(String method, JSONObject params) {
        if (this.client == null || this.state != 2) {
            return -1;
        }
        try {
            params.put("_reqid", ++this.last_reqid);
            params.put("_method", (Object)method);
            this.client.send(params.toString());
            return this.last_reqid;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int heartbeat(int cid, int bid, long last_seen_eid) {
        return this.heartbeat(bid, new Integer[]{cid}, new Integer[]{bid}, new Long[]{last_seen_eid});
    }

    public int heartbeat(int selectedBuffer, Integer[] cids, Integer[] bids, Long[] last_seen_eids) {
        try {
            JSONObject heartbeat = new JSONObject();
            for (int i = 0; i < cids.length; ++i) {
                JSONObject o;
                if (heartbeat.has(String.valueOf(cids[i]))) {
                    o = heartbeat.getJSONObject(String.valueOf(cids[i]));
                } else {
                    o = new JSONObject();
                    heartbeat.put(String.valueOf(cids[i]), (Object)o);
                }
                o.put(String.valueOf(bids[i]), (Object)last_seen_eids[i]);
            }
            JSONObject o = new JSONObject();
            o.put("selectedBuffer", selectedBuffer);
            o.put("seenEids", (Object)heartbeat.toString());
            return this.send("heartbeat", o);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int disconnect(int cid, String message) {
        try {
            JSONObject o = new JSONObject();
            o.put("cid", cid);
            o.put("msg", (Object)message);
            return this.send("disconnect", o);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int reconnect(int cid) {
        try {
            JSONObject o = new JSONObject();
            o.put("cid", cid);
            return this.send("reconnect", o);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int say(int cid, String to, String message) {
        try {
            JSONObject o = new JSONObject();
            o.put("cid", cid);
            if (to != null) {
                o.put("to", (Object)to);
            }
            o.put("msg", (Object)message);
            return this.send("say", o);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public JSONObject say(int cid, String to, String message, String sk) throws IOException {
        String postdata = "cid=" + cid + "&to=" + URLEncoder.encode(to, "UTF-8") + "&msg=" + URLEncoder.encode(message, "UTF-8") + "&session=" + sk;
        try {
            String response = this.fetch(new URL("https://" + IRCCLOUD_HOST + "/chat/say"), postdata, sk, null);
            return new JSONObject(response);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public int join(int cid, String channel, String key) {
        try {
            JSONObject o = new JSONObject();
            o.put("cid", cid);
            o.put("channel", (Object)channel);
            o.put("key", (Object)key);
            return this.send("join", o);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int part(int cid, String channel, String message) {
        try {
            JSONObject o = new JSONObject();
            o.put("cid", cid);
            o.put("channel", (Object)channel);
            o.put("msg", (Object)message);
            return this.send("part", o);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int kick(int cid, String channel, String nick, String message) {
        return this.say(cid, channel, "/kick " + nick + " " + message);
    }

    public int mode(int cid, String channel, String mode) {
        return this.say(cid, channel, "/mode " + channel + " " + mode);
    }

    public int invite(int cid, String channel, String nick) {
        return this.say(cid, channel, "/invite " + nick + " " + channel);
    }

    public int archiveBuffer(int cid, long bid) {
        try {
            JSONObject o = new JSONObject();
            o.put("cid", cid);
            o.put("id", bid);
            return this.send("archive-buffer", o);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int unarchiveBuffer(int cid, long bid) {
        try {
            JSONObject o = new JSONObject();
            o.put("cid", cid);
            o.put("id", bid);
            return this.send("unarchive-buffer", o);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int deleteBuffer(int cid, long bid) {
        try {
            JSONObject o = new JSONObject();
            o.put("cid", cid);
            o.put("id", bid);
            return this.send("delete-buffer", o);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int deleteServer(int cid) {
        try {
            JSONObject o = new JSONObject();
            o.put("cid", cid);
            return this.send("delete-connection", o);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int deleteFile(String id2) {
        try {
            JSONObject o = new JSONObject();
            o.put("file", (Object)id2);
            return this.send("delete-file", o);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int addServer(String hostname, int port, int ssl, String netname, String nickname, String realname, String server_pass, String nickserv_pass, String joincommands, String channels) {
        try {
            JSONObject o = new JSONObject();
            o.put("hostname", (Object)hostname);
            o.put("port", port);
            o.put("ssl", (Object)String.valueOf(ssl));
            if (netname != null) {
                o.put("netname", (Object)netname);
            }
            o.put("nickname", (Object)nickname);
            o.put("realname", (Object)realname);
            o.put("server_pass", (Object)server_pass);
            o.put("nspass", (Object)nickserv_pass);
            o.put("joincommands", (Object)joincommands);
            o.put("channels", (Object)channels);
            return this.send("add-server", o);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int editServer(int cid, String hostname, int port, int ssl, String netname, String nickname, String realname, String server_pass, String nickserv_pass, String joincommands) {
        try {
            JSONObject o = new JSONObject();
            o.put("hostname", (Object)hostname);
            o.put("port", port);
            o.put("ssl", (Object)String.valueOf(ssl));
            if (netname != null) {
                o.put("netname", (Object)netname);
            }
            o.put("nickname", (Object)nickname);
            o.put("realname", (Object)realname);
            o.put("server_pass", (Object)server_pass);
            o.put("nspass", (Object)nickserv_pass);
            o.put("joincommands", (Object)joincommands);
            o.put("cid", cid);
            return this.send("edit-server", o);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int ignore(int cid, String mask) {
        try {
            JSONObject o = new JSONObject();
            o.put("cid", cid);
            o.put("mask", (Object)mask);
            return this.send("ignore", o);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int unignore(int cid, String mask) {
        try {
            JSONObject o = new JSONObject();
            o.put("cid", cid);
            o.put("mask", (Object)mask);
            return this.send("unignore", o);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int set_prefs(String prefs) {
        try {
            Log.i((String)TAG, (String)("Setting prefs: " + prefs));
            JSONObject o = new JSONObject();
            o.put("prefs", (Object)prefs);
            return this.send("set-prefs", o);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int set_user_settings(String email, String realname, String hwords, boolean autoaway) {
        try {
            JSONObject o = new JSONObject();
            o.put("email", (Object)email);
            o.put("realname", (Object)realname);
            o.put("hwords", (Object)hwords);
            o.put("autoaway", (Object)(autoaway ? "1" : "0"));
            return this.send("user-settings", o);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int ns_help_register(int cid) {
        try {
            JSONObject o = new JSONObject();
            o.put("cid", cid);
            return this.send("ns-help-register", o);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int set_nspass(int cid, String nspass) {
        try {
            JSONObject o = new JSONObject();
            o.put("cid", cid);
            o.put("nspass", (Object)nspass);
            return this.send("set-nspass", o);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int whois(int cid, String nick, String server) {
        try {
            JSONObject o = new JSONObject();
            o.put("cid", cid);
            o.put("nick", (Object)nick);
            if (server != null) {
                o.put("server", (Object)server);
            }
            return this.send("whois", o);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int topic(int cid, String channel, String topic) {
        try {
            JSONObject o = new JSONObject();
            o.put("cid", cid);
            o.put("channel", (Object)channel);
            o.put("topic", (Object)topic);
            return this.send("topic", o);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int back(int cid) {
        try {
            JSONObject o = new JSONObject();
            o.put("cid", cid);
            return this.send("back", o);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int reorder_connections(String cids) {
        try {
            JSONObject o = new JSONObject();
            o.put("cids", (Object)cids);
            return this.send("reorder-connections", o);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int resend_verify_email() {
        JSONObject o = new JSONObject();
        return this.send("resend-verify-email", o);
    }

    public int finalize_upload(String id2, String filename, String original_filename) {
        try {
            JSONObject o = new JSONObject();
            o.put("id", (Object)id2);
            o.put("filename", (Object)filename);
            o.put("original_filename", (Object)original_filename);
            return this.send("upload-finalise", o);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int paste(String name, String extension, String contents) {
        try {
            JSONObject o = new JSONObject();
            if (name != null && name.length() > 0) {
                o.put("name", (Object)name);
            }
            o.put("contents", (Object)contents);
            o.put("extension", (Object)extension);
            return this.send("paste", o);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int edit_paste(String id2, String name, String extension, String contents) {
        try {
            JSONObject o = new JSONObject();
            o.put("id", (Object)id2);
            if (name != null && name.length() > 0) {
                o.put("name", (Object)name);
            }
            o.put("body", (Object)contents);
            o.put("extension", (Object)extension);
            return this.send("edit-pastebin", o);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int delete_paste(String id2) {
        try {
            JSONObject o = new JSONObject();
            o.put("id", (Object)id2);
            return this.send("delete-pastebin", o);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public void request_backlog(int cid, int bid, long beforeId) {
        try {
            if (this.oobTasks.containsKey(bid)) {
                Crashlytics.log(5, TAG, "Ignoring duplicate backlog request for BID: " + bid);
                return;
            }
            if (this.session == null || this.session.length() == 0) {
                Crashlytics.log(5, TAG, "Not fetching backlog before session is set");
                return;
            }
            if (Looper.myLooper() == null) {
                Looper.prepare();
            }
            OOBIncludeTask task = new OOBIncludeTask(bid);
            this.oobTasks.put(bid, task);
            if (beforeId > 0L) {
                task.execute(new URL[]{new URL("https://" + IRCCLOUD_HOST + "/chat/backlog?cid=" + cid + "&bid=" + bid + "&beforeid=" + beforeId)});
            } else {
                task.execute(new URL[]{new URL("https://" + IRCCLOUD_HOST + "/chat/backlog?cid=" + cid + "&bid=" + bid)});
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public void cancel_idle_timer() {
        if (this.idleTimerTask != null) {
            this.idleTimerTask.cancel();
        }
        this.reconnect_timestamp = 0L;
    }

    public void schedule_idle_timer() {
        if (this.idleTimerTask != null) {
            this.idleTimerTask.cancel();
        }
        if (this.idle_interval <= 0L) {
            return;
        }
        try {
            this.idleTimerTask = new TimerTask(){

                @Override
                public void run() {
                    if (NetworkConnection.this.handlers.size() > 0) {
                        Crashlytics.log(4, NetworkConnection.TAG, "Websocket idle time exceeded, reconnecting...");
                        NetworkConnection.this.state = 3;
                        NetworkConnection.this.notifyHandlers(0, null);
                        if (NetworkConnection.this.client != null) {
                            NetworkConnection.this.client.disconnect();
                        }
                        NetworkConnection.this.connect(NetworkConnection.this.session);
                    }
                    NetworkConnection.this.reconnect_timestamp = 0L;
                }
            };
            idleTimer.schedule(this.idleTimerTask, this.idle_interval);
            this.reconnect_timestamp = System.currentTimeMillis() + this.idle_interval;
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public long getReconnectTimestamp() {
        return this.reconnect_timestamp;
    }

    private synchronized void parse_object(IRCCloudJSONObject object) throws JSONException {
        this.cancel_idle_timer();
        if (!object.has("type")) {
            if (object.has("success") && !object.getBoolean("success") && object.has("message")) {
                Crashlytics.log(6, TAG, "Error: " + object);
                this.notifyHandlers(103, object);
            } else if (object.has("success")) {
                this.notifyHandlers(104, object);
            }
            return;
        }
        String type = object.type();
        if (type != null && type.length() > 0) {
            Parser p = this.parserMap.get(type);
            if (p != null) {
                p.parse(object);
            } else if (!this.parserMap.containsKey(type)) {
                Crashlytics.log(5, TAG, "Unhandled type: " + object.type());
            }
            if (this.backlog || type.equals("backlog_complete")) {
                if (!(object.bid() <= -1 && !type.equals("backlog_complete") || type.equals("makebuffer") || type.equals("channel_init"))) {
                    ++this.currentcount;
                    if (object.bid() != this.currentBid) {
                        this.currentBid = object.bid();
                        this.firstEid = object.eid();
                        this.currentcount = 0;
                    }
                }
                if (this.numbuffers > 0.0f && this.currentcount < 100) {
                    this.notifyHandlers(105, Float.valueOf((this.totalbuffers + (float)this.currentcount / 100.0f) / this.numbuffers * 1000.0f));
                }
            } else if (this.accrued > 0) {
                this.notifyHandlers(105, Float.valueOf((float)this.currentcount++ / (float)this.accrued * 1000.0f));
            }
        }
        if (!this.backlog && this.idle_interval > 0L && this.accrued < 1) {
            this.schedule_idle_timer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String fetch(URL url, String postdata, String sk, String token) throws Exception {
        String response;
        BufferedReader reader;
        HttpURLConnection conn;
        block29: {
            conn = null;
            java.net.Proxy proxy = null;
            String host = null;
            int port = -1;
            if (Build.VERSION.SDK_INT < 11) {
                Context ctx = IRCCloudApplication.getInstance().getApplicationContext();
                if (ctx != null) {
                    host = Proxy.getHost((Context)ctx);
                    port = Proxy.getPort((Context)ctx);
                }
            } else {
                host = System.getProperty("http.proxyHost", null);
                try {
                    port = Integer.parseInt(System.getProperty("http.proxyPort", "8080"));
                }
                catch (NumberFormatException e) {
                    port = -1;
                }
            }
            if (host != null && host.length() > 0 && !host.equalsIgnoreCase("localhost") && !host.equalsIgnoreCase("127.0.0.1") && port > 0) {
                InetSocketAddress proxyAddr = new InetSocketAddress(host, port);
                proxy = new java.net.Proxy(Proxy.Type.HTTP, proxyAddr);
            }
            if (host != null && host.length() > 0 && !host.equalsIgnoreCase("localhost") && !host.equalsIgnoreCase("127.0.0.1") && port > 0) {
                Crashlytics.log(3, TAG, "Requesting: " + url + " via proxy: " + host);
            } else {
                Crashlytics.log(3, TAG, "Requesting: " + url);
            }
            if (url.getProtocol().toLowerCase().equals("https")) {
                HttpsURLConnection https = (HttpsURLConnection)(proxy != null ? url.openConnection(proxy) : url.openConnection(java.net.Proxy.NO_PROXY));
                if (url.getHost().equals(IRCCLOUD_HOST)) {
                    https.setSSLSocketFactory(this.IRCCloudSocketFactory);
                }
                conn = https;
            } else {
                conn = (HttpURLConnection)(proxy != null ? url.openConnection(proxy) : url.openConnection(java.net.Proxy.NO_PROXY));
            }
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(5000);
            conn.setUseCaches(false);
            conn.setRequestProperty("User-Agent", this.useragent);
            if (sk != null) {
                conn.setRequestProperty("Cookie", "session=" + sk);
            }
            if (token != null) {
                conn.setRequestProperty("x-auth-formtoken", token);
            }
            if (postdata != null) {
                conn.setRequestMethod("POST");
                conn.setDoOutput(true);
                conn.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
                try (OutputStream ostr = null;){
                    ostr = conn.getOutputStream();
                    ostr.write(postdata.getBytes());
                }
            }
            reader = null;
            response = "";
            try {
                ConnectivityManager cm = (ConnectivityManager)IRCCloudApplication.getInstance().getSystemService("connectivity");
                NetworkInfo ni = cm.getActiveNetworkInfo();
                if (ni != null && ni.getType() == 1) {
                    Crashlytics.log(3, TAG, "Loading via WiFi");
                } else {
                    Crashlytics.log(3, TAG, "Loading via mobile");
                }
            }
            catch (Exception cm) {
                // empty catch block
            }
            try {
                if (conn.getInputStream() != null) {
                    reader = new BufferedReader(new InputStreamReader(conn.getInputStream()), 512);
                }
            }
            catch (IOException e) {
                if (conn.getErrorStream() == null) break block29;
                reader = new BufferedReader(new InputStreamReader(conn.getErrorStream()), 512);
            }
        }
        if (reader != null) {
            response = NetworkConnection.toString(reader);
            reader.close();
        }
        conn.disconnect();
        return response;
    }

    private static String toString(BufferedReader reader) throws IOException {
        String line;
        StringBuilder sb = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            sb.append(line).append('\n');
        }
        return sb.toString();
    }

    public Bitmap fetchImage(URL url, boolean cacheOnly) throws Exception {
        HttpURLConnection conn = null;
        java.net.Proxy proxy = null;
        String host = null;
        int port = -1;
        if (Build.VERSION.SDK_INT < 11) {
            Context ctx = IRCCloudApplication.getInstance().getApplicationContext();
            if (ctx != null) {
                host = Proxy.getHost((Context)ctx);
                port = Proxy.getPort((Context)ctx);
            }
        } else {
            host = System.getProperty("http.proxyHost", null);
            try {
                port = Integer.parseInt(System.getProperty("http.proxyPort", "8080"));
            }
            catch (NumberFormatException e) {
                port = -1;
            }
        }
        if (host != null && host.length() > 0 && !host.equalsIgnoreCase("localhost") && !host.equalsIgnoreCase("127.0.0.1") && port > 0) {
            InetSocketAddress proxyAddr = new InetSocketAddress(host, port);
            proxy = new java.net.Proxy(Proxy.Type.HTTP, proxyAddr);
        }
        if (host != null && host.length() > 0 && !host.equalsIgnoreCase("localhost") && !host.equalsIgnoreCase("127.0.0.1") && port > 0) {
            Crashlytics.log(3, TAG, "Requesting: " + url + " via proxy: " + host);
        } else {
            Crashlytics.log(3, TAG, "Requesting: " + url);
        }
        if (url.getProtocol().toLowerCase().equals("https")) {
            HttpsURLConnection https = (HttpsURLConnection)(proxy != null ? url.openConnection(proxy) : url.openConnection(java.net.Proxy.NO_PROXY));
            if (url.getHost().equals(IRCCLOUD_HOST)) {
                https.setSSLSocketFactory(this.IRCCloudSocketFactory);
            }
            conn = https;
        } else {
            conn = (HttpURLConnection)(proxy != null ? url.openConnection(proxy) : url.openConnection(java.net.Proxy.NO_PROXY));
        }
        conn.setConnectTimeout(30000);
        conn.setReadTimeout(30000);
        conn.setUseCaches(true);
        conn.setRequestProperty("User-Agent", this.useragent);
        if (cacheOnly) {
            conn.addRequestProperty("Cache-Control", "only-if-cached");
        }
        Bitmap bitmap = null;
        try {
            ConnectivityManager cm = (ConnectivityManager)IRCCloudApplication.getInstance().getSystemService("connectivity");
            NetworkInfo ni = cm.getActiveNetworkInfo();
            if (ni != null && ni.getType() == 1) {
                Crashlytics.log(3, TAG, "Loading via WiFi");
            } else {
                Crashlytics.log(3, TAG, "Loading via mobile");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (conn.getInputStream() != null) {
                bitmap = BitmapFactory.decodeStream((InputStream)conn.getInputStream());
            }
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        conn.disconnect();
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addHandler(IRCEventHandler handler) {
        ArrayList<IRCEventHandler> arrayList = this.handlers;
        synchronized (arrayList) {
            if (!this.handlers.contains(handler)) {
                this.handlers.add(handler);
            }
            if (this.shutdownTimerTask != null) {
                this.shutdownTimerTask.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeHandler(IRCEventHandler handler) {
        ArrayList<IRCEventHandler> arrayList = this.handlers;
        synchronized (arrayList) {
            this.handlers.remove(handler);
            if (this.handlers.isEmpty()) {
                SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)IRCCloudApplication.getInstance().getApplicationContext());
                long timeout = 300000L;
                try {
                    timeout = Long.valueOf(prefs.getString("timeout", "300000"));
                }
                catch (NumberFormatException e) {
                    SharedPreferences.Editor editor = prefs.edit();
                    editor.putString("timeout", "300000");
                    editor.commit();
                }
                if (this.shutdownTimerTask != null) {
                    this.shutdownTimerTask.cancel();
                }
                this.shutdownTimerTask = new TimerTask(){

                    @Override
                    public void run() {
                        if (NetworkConnection.this.handlers.isEmpty()) {
                            NetworkConnection.this.disconnect();
                        }
                    }
                };
                shutdownTimer.schedule(this.shutdownTimerTask, timeout);
                if (this.state != 2) {
                    if (this.idleTimerTask != null) {
                        this.idleTimerTask.cancel();
                    }
                    this.failCount = 0;
                    if (this.wifiLock.isHeld()) {
                        this.wifiLock.release();
                    }
                    this.reconnect_timestamp = 0L;
                    this.state = 0;
                }
            }
        }
    }

    public boolean uploadsAvailable() {
        return this.userInfo != null && !this.userInfo.uploads_disabled;
    }

    public boolean isVisible() {
        return this.handlers != null && this.handlers.size() > 0;
    }

    public void notifyHandlers(int message, Object object) {
        this.notifyHandlers(message, object, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void notifyHandlers(int message, Object object, IRCEventHandler exclude) {
        ArrayList<IRCEventHandler> arrayList = this.handlers;
        synchronized (arrayList) {
            if (this.handlers != null && (message == 105 || this.accrued == 0)) {
                for (int i = 0; i < this.handlers.size(); ++i) {
                    IRCEventHandler handler = this.handlers.get(i);
                    if (handler == exclude) continue;
                    handler.onIRCEvent(message, object);
                }
            }
        }
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    static /* synthetic */ float access$1908(NetworkConnection x0) {
        float f = x0.totalbuffers;
        x0.totalbuffers = f + 1.0f;
        return f;
    }

    private class OOBIncludeTask
    extends AsyncTask<URL, Void, Boolean> {
        private int bid = -1;
        private URL mUrl;
        private long retryDelay = 1000L;

        public OOBIncludeTask(int bid) {
            this.bid = bid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SuppressLint(value={"NewApi"})
        protected Boolean doInBackground(URL ... url) {
            try {
                Thread.currentThread().setPriority(1);
                long totalTime = System.currentTimeMillis();
                long totalParseTime = 0L;
                long totalJSONTime = 0L;
                long longestEventTime = 0L;
                String longestEventType = "";
                if (Build.VERSION.SDK_INT >= 14) {
                    TrafficStats.setThreadStatsTag((int)11845894);
                }
                Crashlytics.log(3, NetworkConnection.TAG, "Requesting: " + url[0]);
                this.mUrl = url[0];
                HttpURLConnection conn = null;
                java.net.Proxy proxy = null;
                String host = null;
                int port = -1;
                if (Build.VERSION.SDK_INT < 11) {
                    host = Proxy.getHost((Context)IRCCloudApplication.getInstance().getApplicationContext());
                    port = Proxy.getPort((Context)IRCCloudApplication.getInstance().getApplicationContext());
                } else {
                    host = System.getProperty("http.proxyHost", null);
                    port = Integer.parseInt(System.getProperty("http.proxyPort", "8080"));
                }
                if (host != null && host.length() > 0 && !host.equalsIgnoreCase("localhost") && !host.equalsIgnoreCase("127.0.0.1")) {
                    Crashlytics.log(3, NetworkConnection.TAG, "Connecting via proxy: " + host);
                    InetSocketAddress proxyAddr = new InetSocketAddress(host, port);
                    proxy = new java.net.Proxy(Proxy.Type.HTTP, proxyAddr);
                }
                if (url[0].getProtocol().toLowerCase().equals("https")) {
                    HttpsURLConnection https = proxy != null ? (HttpsURLConnection)url[0].openConnection(proxy) : (HttpsURLConnection)url[0].openConnection(java.net.Proxy.NO_PROXY);
                    https.setSSLSocketFactory(NetworkConnection.this.IRCCloudSocketFactory);
                    conn = https;
                } else {
                    conn = (HttpURLConnection)(proxy != null ? url[0].openConnection(proxy) : url[0].openConnection(java.net.Proxy.NO_PROXY));
                }
                conn.setRequestMethod("GET");
                conn.setRequestProperty("Connection", "close");
                conn.setRequestProperty("Cookie", "session=" + NetworkConnection.this.session);
                conn.setRequestProperty("Accept", "application/json");
                conn.setRequestProperty("Content-type", "application/json");
                conn.setRequestProperty("Accept-Encoding", "gzip");
                conn.setRequestProperty("User-Agent", NetworkConnection.this.useragent);
                try {
                    ConnectivityManager cm = (ConnectivityManager)IRCCloudApplication.getInstance().getSystemService("connectivity");
                    NetworkInfo ni = cm.getActiveNetworkInfo();
                    if (ni != null && ni.getType() == 1) {
                        Crashlytics.log(3, NetworkConnection.TAG, "Loading via WiFi");
                        conn.setConnectTimeout(2500);
                        conn.setReadTimeout(5000);
                    } else {
                        Crashlytics.log(3, NetworkConnection.TAG, "Loading via mobile");
                        conn.setConnectTimeout(5000);
                        conn.setReadTimeout(30000);
                    }
                }
                catch (Exception cm) {
                    // empty catch block
                }
                conn.connect();
                if (conn.getResponseCode() == 200) {
                    InputStreamReader reader;
                    block41: {
                        reader = null;
                        try {
                            if (conn.getInputStream() != null) {
                                if (conn.getContentEncoding() != null && conn.getContentEncoding().equalsIgnoreCase("gzip")) {
                                    reader = new InputStreamReader(new GZIPInputStream(conn.getInputStream()));
                                } else if (conn.getInputStream() != null) {
                                    reader = new InputStreamReader(conn.getInputStream());
                                }
                            }
                        }
                        catch (IOException e) {
                            if (conn.getErrorStream() == null) break block41;
                            if (conn.getContentEncoding() != null && conn.getContentEncoding().equalsIgnoreCase("gzip")) {
                                reader = new InputStreamReader(new GZIPInputStream(conn.getErrorStream()));
                            }
                            if (conn.getErrorStream() == null) break block41;
                            reader = new InputStreamReader(conn.getErrorStream());
                        }
                    }
                    JsonParser parser = NetworkConnection.this.mapper.getFactory().createParser(reader);
                    if (reader != null && parser.nextToken() == JsonToken.START_ARRAY) {
                        Object object = NetworkConnection.this.parserLock;
                        synchronized (object) {
                            NetworkConnection.this.cancel_idle_timer();
                            Crashlytics.log(3, NetworkConnection.TAG, "Connection time: " + (System.currentTimeMillis() - totalTime) + "ms");
                            Crashlytics.log(3, NetworkConnection.TAG, "Beginning backlog...");
                            if (this.bid > 0) {
                                NetworkConnection.this.notifyHandlers(100, null);
                            }
                            NetworkConnection.this.numbuffers = 0.0f;
                            NetworkConnection.this.totalbuffers = 0.0f;
                            NetworkConnection.this.currentBid = -1;
                            NetworkConnection.this.firstEid = -1L;
                            NetworkConnection.this.backlog = true;
                            if (this.bid == -1) {
                                BuffersDataSource.getInstance().invalidate();
                                ChannelsDataSource.getInstance().invalidate();
                                EventsDataSource.getInstance().clear();
                            }
                            int count = 0;
                            while (parser.nextToken() == JsonToken.START_OBJECT) {
                                if (this.isCancelled()) {
                                    Crashlytics.log(3, NetworkConnection.TAG, "Backlog parsing cancelled");
                                    return false;
                                }
                                long time = System.currentTimeMillis();
                                JsonNode e = (JsonNode)parser.readValueAsTree();
                                totalJSONTime += System.currentTimeMillis() - time;
                                time = System.currentTimeMillis();
                                IRCCloudJSONObject o = new IRCCloudJSONObject(e);
                                try {
                                    NetworkConnection.this.parse_object(o);
                                }
                                catch (Exception ex) {
                                    Crashlytics.log(6, NetworkConnection.TAG, "Unable to parse message type: " + o.type());
                                    ex.printStackTrace();
                                    Crashlytics.logException(ex);
                                }
                                long t = System.currentTimeMillis() - time;
                                if (t > longestEventTime) {
                                    longestEventTime = t;
                                    longestEventType = o.type();
                                }
                                totalParseTime += t;
                                ++count;
                                if (Build.VERSION.SDK_INT < 14) continue;
                                TrafficStats.incrementOperationCount((int)1);
                            }
                            NetworkConnection.this.backlog = false;
                            totalTime = System.currentTimeMillis() - totalTime;
                            Crashlytics.log(3, NetworkConnection.TAG, "Backlog complete: " + count + " events");
                            Crashlytics.log(3, NetworkConnection.TAG, "JSON parsing took: " + totalJSONTime + "ms (" + (float)totalJSONTime / (float)count + "ms / object)");
                            Crashlytics.log(3, NetworkConnection.TAG, "Backlog processing took: " + totalParseTime + "ms (" + (float)totalParseTime / (float)count + "ms / object)");
                            Crashlytics.log(3, NetworkConnection.TAG, "Total OOB load time: " + totalTime + "ms (" + (float)totalTime / (float)count + "ms / object)");
                            Crashlytics.log(3, NetworkConnection.TAG, "Longest event: " + longestEventType + " (" + longestEventTime + "ms)");
                            totalTime -= totalJSONTime;
                            Crashlytics.log(3, NetworkConnection.TAG, "Total non-processing time: " + (totalTime -= totalParseTime) + "ms (" + (float)totalTime / (float)count + "ms / object)");
                            ArrayList<BuffersDataSource.Buffer> buffers = BuffersDataSource.getInstance().getBuffers();
                            for (BuffersDataSource.Buffer b : buffers) {
                                Notifications.getInstance().deleteOldNotifications(b.bid, b.last_seen_eid);
                                if (b.timeout <= 0 || this.bid != -1) continue;
                                Crashlytics.log(3, NetworkConnection.TAG, "Requesting backlog for timed-out buffer: " + b.name);
                                NetworkConnection.this.request_backlog(b.cid, b.bid, 0L);
                            }
                            Notifications.getInstance().showNotifications(null);
                            NetworkConnection.this.schedule_idle_timer();
                            if (this.bid > 0) {
                                NetworkConnection.this.notifyHandlers(101, this.bid);
                            }
                        }
                    }
                    throw new Exception("Unexpected JSON response");
                    parser.close();
                    if (this.bid != -1) {
                        BuffersDataSource.getInstance().updateTimeout(this.bid, 0);
                    }
                    NetworkConnection.this.oobTasks.remove(this.bid);
                    Crashlytics.log(3, NetworkConnection.TAG, "OOB fetch complete!");
                    if (Build.VERSION.SDK_INT >= 14) {
                        TrafficStats.clearThreadStatsTag();
                    }
                    NetworkConnection.this.numbuffers = 0.0f;
                    return true;
                }
                Log.e((String)NetworkConnection.TAG, (String)("Invalid response code: " + conn.getResponseCode()));
                throw new Exception("Invalid response code: " + conn.getResponseCode());
            }
            catch (Exception e) {
                e.printStackTrace();
                if (this.bid != -1 && !this.isCancelled()) {
                    BuffersDataSource.Buffer b = BuffersDataSource.getInstance().getBuffer(this.bid);
                    if (b != null && b.timeout == 1) {
                        Crashlytics.log(5, NetworkConnection.TAG, "Failed to fetch backlog for timed-out buffer, retrying in " + this.retryDelay + "ms");
                        idleTimer.schedule(new TimerTask(){

                            @Override
                            public void run() {
                                OOBIncludeTask.this.doInBackground(OOBIncludeTask.this.mUrl);
                            }
                        }, this.retryDelay);
                        this.retryDelay *= 2L;
                    } else {
                        Crashlytics.log(6, NetworkConnection.TAG, "Failed to fetch backlog");
                        NetworkConnection.this.oobTasks.remove(this.bid);
                    }
                }
                if (Build.VERSION.SDK_INT >= 14) {
                    TrafficStats.clearThreadStatsTag();
                }
                NetworkConnection.this.notifyHandlers(102, null);
                if (this.bid == -1) {
                    Crashlytics.log(6, NetworkConnection.TAG, "Failed to fetch the initial backlog, reconnecting!");
                    NetworkConnection.this.streamId = null;
                    if (NetworkConnection.this.client != null) {
                        NetworkConnection.this.client.disconnect();
                    }
                }
                return false;
            }
        }
    }

    public class UserInfo {
        public int id;
        public String name;
        public String email;
        public boolean verified;
        public int last_selected_bid;
        public long connections;
        public long active_connections;
        public long join_date;
        public boolean auto_away;
        public String limits_name;
        public ObjectNode limits;
        public int num_invites;
        public JSONObject prefs;
        public String highlights;
        public boolean uploads_disabled;

        public UserInfo(IRCCloudJSONObject object) {
            this.id = object.getInt("id");
            Crashlytics.log(4, NetworkConnection.TAG, "Setting UserInfo for uid" + this.id);
            this.name = object.getString("name");
            this.email = object.getString("email");
            this.verified = object.getBoolean("verified");
            this.last_selected_bid = object.getInt("last_selected_bid");
            this.connections = object.getLong("num_connections");
            this.active_connections = object.getLong("num_active_connections");
            this.join_date = object.getLong("join_date");
            this.auto_away = object.getBoolean("autoaway");
            boolean bl = this.uploads_disabled = object.has("uploads_disabled") && object.getBoolean("uploads_disabled");
            if (object.has("prefs") && !object.getString("prefs").equals("null")) {
                try {
                    Crashlytics.log(4, NetworkConnection.TAG, "Prefs: " + object.getString("prefs"));
                    this.prefs = new JSONObject(object.getString("prefs"));
                }
                catch (JSONException e) {
                    Crashlytics.log(6, NetworkConnection.TAG, "Unable to parse prefs: " + object.getString("prefs"));
                    Crashlytics.logException(e);
                    this.prefs = null;
                }
            } else {
                Crashlytics.log(4, NetworkConnection.TAG, "User prefs not set");
                this.prefs = null;
            }
            this.limits_name = object.getString("limits_name");
            this.limits = object.getJsonObject("limits");
            if (object.has("highlights")) {
                JsonNode h = object.getJsonNode("highlights");
                this.highlights = "";
                for (int i = 0; i < h.size(); ++i) {
                    if (this.highlights.length() > 0) {
                        this.highlights = this.highlights + ", ";
                    }
                    this.highlights = this.highlights + h.get(i).asText();
                }
            }
        }
    }

    private class BroadcastParser
    implements Parser {
        int type;

        BroadcastParser(int t) {
            this.type = t;
        }

        @Override
        public void parse(IRCCloudJSONObject object) {
            if (!NetworkConnection.this.backlog) {
                NetworkConnection.this.notifyHandlers(this.type, object);
            }
        }
    }

    public static interface Parser {
        public void parse(IRCCloudJSONObject var1) throws JSONException;
    }

    public static interface IRCEventHandler {
        public void onIRCEvent(int var1, Object var2);
    }
}

