/*
 * Decompiled with CFR 0.152.
 */
package com.irccloud.android;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.database.SQLException;
import android.net.Uri;
import android.os.Build;
import android.preference.PreferenceManager;
import android.support.v4.app.NotificationCompat;
import android.support.v4.app.NotificationManagerCompat;
import android.support.v4.app.RemoteInput;
import android.text.Html;
import android.text.Spanned;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseArray;
import android.widget.RemoteViews;
import com.crashlytics.android.Crashlytics;
import com.irccloud.android.ColorFormatter;
import com.irccloud.android.IRCCloudApplication;
import com.irccloud.android.NetworkConnection;
import com.irccloud.android.RemoteInputService;
import com.irccloud.android.activity.QuickReplyActivity;
import com.sonyericsson.extras.liveware.aef.notification.Notification;
import com.sonyericsson.extras.liveware.extension.util.notification.NotificationUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Notifications {
    private ArrayList<Notification> mNotifications = null;
    private SparseArray<String> mNetworks = null;
    private SparseArray<Long> mLastSeenEIDs = null;
    private SparseArray<HashSet<Long>> mDismissedEIDs = null;
    private static Notifications instance = null;
    private int excludeBid = -1;
    private static final Timer mNotificationTimer = new Timer("notification-timer");
    private TimerTask mNotificationTimerTask = null;
    private static final Timer mSaveTimer = new Timer("notifications-save-timer");
    private TimerTask mSaveTimerTask = null;
    private String mTicker = null;

    public static Notifications getInstance() {
        if (instance == null) {
            instance = new Notifications();
        }
        return instance;
    }

    public Notifications() {
        try {
            this.load();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        this.mNotifications = new ArrayList();
        this.mNetworks = new SparseArray();
        this.mLastSeenEIDs = new SparseArray();
        this.mDismissedEIDs = new SparseArray();
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)IRCCloudApplication.getInstance().getApplicationContext());
        if (prefs.contains("notifications_json")) {
            try {
                JSONObject o;
                int i;
                JSONArray array2 = new JSONArray(prefs.getString("networks_json", "[]"));
                for (i = 0; i < array2.length(); ++i) {
                    o = array2.getJSONObject(i);
                    this.mNetworks.put(o.getInt("cid"), (Object)o.getString("network"));
                }
                array2 = new JSONArray(prefs.getString("lastseeneids_json", "[]"));
                for (i = 0; i < array2.length(); ++i) {
                    o = array2.getJSONObject(i);
                    this.mLastSeenEIDs.put(o.getInt("bid"), (Object)o.getLong("eid"));
                }
                array2 = new JSONArray(prefs.getString("dismissedeids_json", "[]"));
                for (i = 0; i < array2.length(); ++i) {
                    o = array2.getJSONObject(i);
                    int bid = o.getInt("bid");
                    this.mDismissedEIDs.put(bid, new HashSet());
                    JSONArray eids = o.getJSONArray("eids");
                    for (int j = 0; j < eids.length(); ++j) {
                        ((HashSet)this.mDismissedEIDs.get(bid)).add(eids.getLong(j));
                    }
                }
                ArrayList<Notification> arrayList = this.mNotifications;
                synchronized (arrayList) {
                    array2 = new JSONArray(prefs.getString("notifications_json", "[]"));
                    for (int i2 = 0; i2 < array2.length(); ++i2) {
                        JSONObject o2 = array2.getJSONObject(i2);
                        Notification n = new Notification();
                        n.bid = o2.getInt("bid");
                        n.cid = o2.getInt("cid");
                        n.eid = o2.getLong("eid");
                        n.nick = o2.getString("nick");
                        n.message = o2.getString("message");
                        n.chan = o2.getString("chan");
                        n.buffer_type = o2.getString("buffer_type");
                        n.message_type = o2.getString("message_type");
                        n.network = (String)this.mNetworks.get(n.cid);
                        if (o2.has("shown")) {
                            n.shown = o2.getBoolean("shown");
                        }
                        this.mNotifications.add(n);
                    }
                    Collections.sort(this.mNotifications, new comparator());
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    @TargetApi(value=9)
    private void save() {
        if (this.mSaveTimerTask != null) {
            this.mSaveTimerTask.cancel();
        }
        this.mSaveTimerTask = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SharedPreferences.Editor editor = PreferenceManager.getDefaultSharedPreferences((Context)IRCCloudApplication.getInstance().getApplicationContext()).edit();
                try {
                    Object o;
                    int i;
                    JSONObject o2;
                    JSONArray array2 = new JSONArray();
                    ArrayList arrayList = Notifications.this.mNotifications;
                    synchronized (arrayList) {
                        for (Notification n : Notifications.this.mNotifications) {
                            if (n == null) continue;
                            o2 = new JSONObject();
                            o2.put("cid", n.cid);
                            o2.put("bid", n.bid);
                            o2.put("eid", n.eid);
                            o2.put("nick", (Object)n.nick);
                            o2.put("message", (Object)n.message);
                            o2.put("chan", (Object)n.chan);
                            o2.put("buffer_type", (Object)n.buffer_type);
                            o2.put("message_type", (Object)n.message_type);
                            o2.put("shown", n.shown);
                            array2.put((Object)o2);
                        }
                        editor.putString("notifications_json", array2.toString());
                    }
                    array2 = new JSONArray();
                    for (i = 0; i < Notifications.this.mNetworks.size(); ++i) {
                        int cid = Notifications.this.mNetworks.keyAt(i);
                        String network = (String)Notifications.this.mNetworks.get(cid);
                        o2 = new JSONObject();
                        o2.put("cid", cid);
                        o2.put("network", (Object)network);
                        array2.put((Object)o2);
                    }
                    editor.putString("networks_json", array2.toString());
                    array2 = new JSONArray();
                    for (i = 0; i < Notifications.this.mLastSeenEIDs.size(); ++i) {
                        int bid = Notifications.this.mLastSeenEIDs.keyAt(i);
                        long eid = (Long)Notifications.this.mLastSeenEIDs.get(bid);
                        o = new JSONObject();
                        o.put("bid", bid);
                        o.put("eid", eid);
                        array2.put(o);
                    }
                    editor.putString("lastseeneids_json", array2.toString());
                    array2 = new JSONArray();
                    for (i = 0; i < Notifications.this.mDismissedEIDs.size(); ++i) {
                        JSONArray a = new JSONArray();
                        int bid = Notifications.this.mDismissedEIDs.keyAt(i);
                        HashSet eids = (HashSet)Notifications.this.mDismissedEIDs.get(bid);
                        if (eids.size() <= 0) continue;
                        o = eids.iterator();
                        while (o.hasNext()) {
                            long eid = (Long)o.next();
                            a.put(eid);
                        }
                        o = new JSONObject();
                        o.put("bid", bid);
                        o.put("eids", (Object)a);
                        array2.put(o);
                    }
                    editor.putString("dismissedeids_json", array2.toString());
                    if (Build.VERSION.SDK_INT >= 9) {
                        editor.apply();
                    } else {
                        editor.commit();
                    }
                }
                catch (ConcurrentModificationException e) {
                    Notifications.this.save();
                }
                catch (Exception | OutOfMemoryError e) {
                    editor.remove("notifications_json");
                    editor.remove("networks_json");
                    editor.remove("lastseeneids_json");
                    editor.remove("dismissedeids_json");
                    editor.commit();
                }
            }
        };
        try {
            mSaveTimer.schedule(this.mSaveTimerTask, 100L);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void clearDismissed() {
        this.mDismissedEIDs.clear();
        this.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        try {
            ArrayList<Notification> arrayList = this.mNotifications;
            synchronized (arrayList) {
                if (this.mNotifications.size() > 0) {
                    for (Notification n : this.mNotifications) {
                        NotificationManagerCompat.from(IRCCloudApplication.getInstance().getApplicationContext()).cancel((int)(n.eid / 1000L));
                        NotificationManagerCompat.from(IRCCloudApplication.getInstance().getApplicationContext()).cancel(n.bid);
                    }
                }
            }
            IRCCloudApplication.getInstance().getApplicationContext().sendBroadcast(new Intent("com.irccloud.android.dashclock.REFRESH"));
            try {
                if (PreferenceManager.getDefaultSharedPreferences((Context)IRCCloudApplication.getInstance().getApplicationContext()).getBoolean("notify_sony", false)) {
                    NotificationUtil.deleteAllEvents(IRCCloudApplication.getInstance().getApplicationContext());
                }
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.mSaveTimerTask != null) {
            this.mSaveTimerTask.cancel();
        }
        this.mNotifications.clear();
        this.mLastSeenEIDs.clear();
        this.mDismissedEIDs.clear();
        SharedPreferences.Editor editor = PreferenceManager.getDefaultSharedPreferences((Context)IRCCloudApplication.getInstance().getApplicationContext()).edit();
        editor.remove("notifications_json");
        editor.remove("lastseeneids_json");
        editor.remove("dismissedeids_json");
        editor.commit();
        this.updateTeslaUnreadCount();
    }

    public void clearNetworks() {
        this.mNetworks.clear();
        SharedPreferences.Editor editor = PreferenceManager.getDefaultSharedPreferences((Context)IRCCloudApplication.getInstance().getApplicationContext()).edit();
        editor.remove("networks_json");
        editor.commit();
    }

    public void clearLastSeenEIDs() {
        this.mLastSeenEIDs.clear();
        SharedPreferences.Editor editor = PreferenceManager.getDefaultSharedPreferences((Context)IRCCloudApplication.getInstance().getApplicationContext()).edit();
        editor.remove("lastseeneids_json");
        editor.commit();
    }

    public long getLastSeenEid(int bid) {
        if (this.mLastSeenEIDs.get(bid) != null) {
            return (Long)this.mLastSeenEIDs.get(bid);
        }
        return -1L;
    }

    public synchronized void updateLastSeenEid(int bid, long eid) {
        this.mLastSeenEIDs.put(bid, (Object)eid);
        this.save();
    }

    public synchronized boolean isDismissed(int bid, long eid) {
        if (this.mDismissedEIDs.get(bid) != null) {
            for (Long e : (HashSet)this.mDismissedEIDs.get(bid)) {
                if (e != eid) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dismiss(int bid, long eid) {
        if (this.mDismissedEIDs.get(bid) == null) {
            this.mDismissedEIDs.put(bid, new HashSet());
        }
        ((HashSet)this.mDismissedEIDs.get(bid)).add(eid);
        Notification n = this.getNotification(eid);
        ArrayList<Notification> arrayList = this.mNotifications;
        synchronized (arrayList) {
            if (n != null) {
                this.mNotifications.remove(n);
            }
        }
        this.save();
        if (IRCCloudApplication.getInstance() != null) {
            IRCCloudApplication.getInstance().getApplicationContext().sendBroadcast(new Intent("com.irccloud.android.dashclock.REFRESH"));
        }
        this.updateTeslaUnreadCount();
    }

    public synchronized void addNetwork(int cid, String network) {
        this.mNetworks.put(cid, (Object)network);
        this.save();
    }

    public synchronized void deleteNetwork(int cid) {
        this.mNetworks.remove(cid);
        this.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addNotification(int cid, int bid, long eid, String from, String message, String chan, String buffer_type, String message_type) {
        if (this.isDismissed(bid, eid)) {
            Crashlytics.log("Refusing to add notification for dismissed eid: " + eid);
            return;
        }
        long last_eid = this.getLastSeenEid(bid);
        if (eid <= last_eid) {
            Crashlytics.log("Refusing to add notification for seen eid: " + eid);
            return;
        }
        String network = this.getNetwork(cid);
        if (network == null) {
            this.addNetwork(cid, "Unknown Network");
        }
        Notification n = new Notification();
        n.bid = bid;
        n.cid = cid;
        n.eid = eid;
        n.nick = from;
        n.message = TextUtils.htmlEncode((String)ColorFormatter.emojify(message));
        n.chan = chan;
        n.buffer_type = buffer_type;
        n.message_type = message_type;
        n.network = network;
        ArrayList<Notification> arrayList = this.mNotifications;
        synchronized (arrayList) {
            this.mNotifications.add(n);
            Collections.sort(this.mNotifications, new comparator());
        }
        this.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNotification(int cid, int bid, long eid) {
        ArrayList<Notification> arrayList = this.mNotifications;
        synchronized (arrayList) {
            for (Notification n : this.mNotifications) {
                if (n.cid != cid || n.bid != bid || n.eid != eid) continue;
                this.mNotifications.remove(n);
                this.save();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteOldNotifications(int bid, long last_seen_eid) {
        ArrayList<Notification> notifications;
        boolean changed = false;
        if (this.mNotificationTimerTask != null) {
            this.mNotificationTimerTask.cancel();
        }
        if ((notifications = this.getOtherNotifications()).size() > 0) {
            for (Notification n : notifications) {
                if (n.bid != bid || n.eid > last_seen_eid) continue;
                NotificationManagerCompat.from(IRCCloudApplication.getInstance().getApplicationContext()).cancel((int)(n.eid / 1000L));
                changed = true;
            }
        }
        ArrayList<Notification> arrayList = this.mNotifications;
        synchronized (arrayList) {
            for (int i = 0; i < this.mNotifications.size(); ++i) {
                Notification n = this.mNotifications.get(i);
                if (n.bid != bid || n.eid > last_seen_eid) continue;
                this.mNotifications.remove(n);
                --i;
                NotificationManagerCompat.from(IRCCloudApplication.getInstance().getApplicationContext()).cancel(bid);
                NotificationManagerCompat.from(IRCCloudApplication.getInstance().getApplicationContext()).cancel((int)(n.eid / 1000L));
                changed = true;
            }
        }
        if (this.mDismissedEIDs.get(bid) != null) {
            HashSet eids = (HashSet)this.mDismissedEIDs.get(bid);
            Long[] eidsArray = eids.toArray(new Long[eids.size()]);
            for (int i = 0; i < eidsArray.length; ++i) {
                if (eidsArray[i] > last_seen_eid) continue;
                eids.remove(eidsArray[i]);
            }
        }
        this.save();
        if (changed) {
            IRCCloudApplication.getInstance().getApplicationContext().sendBroadcast(new Intent("com.irccloud.android.dashclock.REFRESH"));
            try {
                if (PreferenceManager.getDefaultSharedPreferences((Context)IRCCloudApplication.getInstance().getApplicationContext()).getBoolean("notify_sony", false)) {
                    NotificationUtil.deleteEvents(IRCCloudApplication.getInstance().getApplicationContext(), "friend_key = ?", new String[]{String.valueOf(bid)});
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.updateTeslaUnreadCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNotificationsForBid(int bid) {
        ArrayList<Notification> notifications = this.getOtherNotifications();
        if (notifications.size() > 0) {
            for (Notification n : notifications) {
                NotificationManagerCompat.from(IRCCloudApplication.getInstance().getApplicationContext()).cancel((int)(n.eid / 1000L));
            }
        }
        NotificationManagerCompat.from(IRCCloudApplication.getInstance().getApplicationContext()).cancel(bid);
        ArrayList<Notification> arrayList = this.mNotifications;
        synchronized (arrayList) {
            for (int i = 0; i < this.mNotifications.size(); ++i) {
                Notification n = this.mNotifications.get(i);
                if (n.bid != bid) continue;
                this.mNotifications.remove(n);
                --i;
            }
        }
        this.mDismissedEIDs.remove(bid);
        this.mLastSeenEIDs.remove(bid);
        IRCCloudApplication.getInstance().getApplicationContext().sendBroadcast(new Intent("com.irccloud.android.dashclock.REFRESH"));
        try {
            if (PreferenceManager.getDefaultSharedPreferences((Context)IRCCloudApplication.getInstance().getApplicationContext()).getBoolean("notify_sony", false)) {
                NotificationUtil.deleteEvents(IRCCloudApplication.getInstance().getApplicationContext(), "friend_key = ?", new String[]{String.valueOf(bid)});
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateTeslaUnreadCount();
    }

    private boolean isMessage(String type) {
        return !type.equalsIgnoreCase("channel_invite") && !type.equalsIgnoreCase("callerid");
    }

    public int count() {
        return this.mNotifications.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Notification> getMessageNotifications() {
        ArrayList<Notification> notifications = new ArrayList<Notification>();
        ArrayList<Notification> arrayList = this.mNotifications;
        synchronized (arrayList) {
            for (int i = 0; i < this.mNotifications.size(); ++i) {
                Notification n = this.mNotifications.get(i);
                if (n == null || n.bid == this.excludeBid || !this.isMessage(n.message_type)) continue;
                if (n.network == null) {
                    n.network = this.getNetwork(n.cid);
                }
                notifications.add(n);
            }
        }
        return notifications;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Notification> getOtherNotifications() {
        ArrayList<Notification> notifications = new ArrayList<Notification>();
        ArrayList<Notification> arrayList = this.mNotifications;
        synchronized (arrayList) {
            for (int i = 0; i < this.mNotifications.size(); ++i) {
                Notification n = this.mNotifications.get(i);
                if (n == null || n.bid == this.excludeBid || this.isMessage(n.message_type)) continue;
                if (n.network == null) {
                    n.network = this.getNetwork(n.cid);
                }
                notifications.add(n);
            }
        }
        return notifications;
    }

    public String getNetwork(int cid) {
        return (String)this.mNetworks.get(cid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Notification getNotification(long eid) {
        ArrayList<Notification> arrayList = this.mNotifications;
        synchronized (arrayList) {
            for (int i = 0; i < this.mNotifications.size(); ++i) {
                Notification n = this.mNotifications.get(i);
                if (n.bid == this.excludeBid || n.eid != eid || !this.isMessage(n.message_type)) continue;
                if (n.network == null) {
                    n.network = this.getNetwork(n.cid);
                }
                return n;
            }
        }
        return null;
    }

    public synchronized void excludeBid(int bid) {
        this.excludeBid = -1;
        ArrayList<Notification> notifications = this.getOtherNotifications();
        if (notifications.size() > 0) {
            for (Notification n : notifications) {
                NotificationManagerCompat.from(IRCCloudApplication.getInstance().getApplicationContext()).cancel((int)(n.eid / 1000L));
            }
        }
        NotificationManagerCompat.from(IRCCloudApplication.getInstance().getApplicationContext()).cancel(bid);
        this.excludeBid = bid;
    }

    public synchronized void showNotifications(String ticker) {
        if (ticker != null) {
            this.mTicker = ColorFormatter.emojify(ticker);
        }
        ArrayList<Notification> notifications = this.getMessageNotifications();
        for (Notification n : notifications) {
            if (!this.isDismissed(n.bid, n.eid)) continue;
            this.deleteNotification(n.cid, n.bid, n.eid);
        }
        if (this.mNotificationTimerTask != null) {
            this.mNotificationTimerTask.cancel();
        }
        try {
            this.mNotificationTimerTask = new TimerTask(){

                @Override
                public void run() {
                    Notifications.this.showMessageNotifications(Notifications.this.mTicker);
                    Notifications.this.showOtherNotifications();
                    Notifications.this.mTicker = null;
                    IRCCloudApplication.getInstance().getApplicationContext().sendBroadcast(new Intent("com.irccloud.android.dashclock.REFRESH"));
                    Notifications.this.updateTeslaUnreadCount();
                }
            };
            mNotificationTimer.schedule(this.mNotificationTimerTask, 5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void showOtherNotifications() {
        String title = "";
        String text = "";
        String ticker = null;
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)IRCCloudApplication.getInstance().getApplicationContext());
        ArrayList<Notification> notifications = this.getOtherNotifications();
        int notify_type = Integer.parseInt(prefs.getString("notify_type", "1"));
        boolean notify = false;
        if (notify_type == 1 || notify_type == 2 && NetworkConnection.getInstance().isVisible()) {
            notify = true;
        }
        if (notifications.size() > 0 && notify) {
            for (Notification n : notifications) {
                if (n.shown) continue;
                if (n.message_type.equals("callerid")) {
                    title = "Callerid: " + n.nick + " (" + n.network + ")";
                    text = n.nick + " " + n.message;
                    ticker = n.nick + " " + n.message;
                } else {
                    title = n.nick + " (" + n.network + ")";
                    text = n.message;
                    ticker = n.message;
                }
                NotificationManagerCompat.from(IRCCloudApplication.getInstance().getApplicationContext()).notify((int)(n.eid / 1000L), this.buildNotification(ticker, n.bid, new long[]{n.eid}, title, text, Html.fromHtml((String)text), 1, null, null, title, null));
                n.shown = true;
            }
        }
    }

    @SuppressLint(value={"NewApi"})
    private android.app.Notification buildNotification(String ticker, int bid, long[] eids, String title, String text, Spanned big_text, int count, Intent replyIntent, Spanned wear_text, String network, String[] auto_messages) {
        int led_color;
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)IRCCloudApplication.getInstance().getApplicationContext());
        NotificationCompat.Builder builder = new NotificationCompat.Builder(IRCCloudApplication.getInstance().getApplicationContext()).setContentTitle(title + (network != null ? " (" + network + ")" : "")).setContentText((CharSequence)Html.fromHtml((String)text)).setAutoCancel(true).setTicker(ticker).setWhen(eids[0] / 1000L).setSmallIcon(2130837630).setColor(IRCCloudApplication.getInstance().getApplicationContext().getResources().getColor(2131492899)).setVisibility(0).setCategory("msg").setPriority(1).setOnlyAlertOnce(false);
        if (ticker != null && System.currentTimeMillis() - prefs.getLong("lastNotificationTime", 0L) > 10000L) {
            String ringtone;
            if (prefs.getBoolean("notify_vibrate", true)) {
                builder.setDefaults(2);
            }
            if ((ringtone = prefs.getString("notify_ringtone", "content://settings/system/notification_sound")) != null && ringtone.length() > 0) {
                builder.setSound(Uri.parse((String)ringtone));
            }
        }
        if ((led_color = Integer.parseInt(prefs.getString("notify_led_color", "1"))) == 1) {
            if (prefs.getBoolean("notify_vibrate", true)) {
                builder.setDefaults(6);
            } else {
                builder.setDefaults(4);
            }
        } else if (led_color == 2) {
            builder.setLights(-16776961, 500, 500);
        }
        SharedPreferences.Editor editor = prefs.edit();
        editor.putLong("lastNotificationTime", System.currentTimeMillis());
        editor.commit();
        Intent i = new Intent();
        i.setComponent(new ComponentName(IRCCloudApplication.getInstance().getApplicationContext().getPackageName(), "com.irccloud.android.MainActivity"));
        i.putExtra("bid", bid);
        i.setData(Uri.parse((String)("bid://" + bid)));
        Intent dismiss = new Intent(IRCCloudApplication.getInstance().getApplicationContext().getResources().getString(2131165230));
        dismiss.setData(Uri.parse((String)("irccloud-dismiss://" + bid)));
        dismiss.putExtra("bid", bid);
        dismiss.putExtra("eids", eids);
        PendingIntent dismissPendingIntent = PendingIntent.getBroadcast((Context)IRCCloudApplication.getInstance().getApplicationContext(), (int)0, (Intent)dismiss, (int)0x8000000);
        builder.setContentIntent(PendingIntent.getActivity((Context)IRCCloudApplication.getInstance().getApplicationContext(), (int)0, (Intent)i, (int)0x8000000));
        builder.setDeleteIntent(dismissPendingIntent);
        if (replyIntent != null) {
            NotificationCompat.WearableExtender extender = new NotificationCompat.WearableExtender();
            PendingIntent replyPendingIntent = PendingIntent.getService((Context)IRCCloudApplication.getInstance().getApplicationContext(), (int)(bid + 1), (Intent)replyIntent, (int)0x50000000);
            extender.addAction(new NotificationCompat.Action.Builder(2130837625, "Reply", replyPendingIntent).addRemoteInput(new RemoteInput.Builder("extra_reply").setLabel("Reply to " + title).build()).build());
            if (count > 1 && wear_text != null) {
                extender.addPage(new NotificationCompat.Builder(IRCCloudApplication.getInstance().getApplicationContext()).setContentText((CharSequence)wear_text).extend(new NotificationCompat.WearableExtender().setStartScrollBottom(true)).build());
            }
            NotificationCompat.CarExtender.UnreadConversation.Builder unreadConvBuilder = new NotificationCompat.CarExtender.UnreadConversation.Builder(title + (network != null ? " (" + network + ")" : "")).setReadPendingIntent(dismissPendingIntent).setReplyAction(replyPendingIntent, new RemoteInput.Builder("extra_reply").setLabel("Reply to " + title).build());
            if (auto_messages != null) {
                for (String m : auto_messages) {
                    if (m == null || m.length() <= 0) continue;
                    unreadConvBuilder.addMessage(m);
                }
            } else {
                unreadConvBuilder.addMessage(text);
            }
            unreadConvBuilder.setLatestTimestamp(eids[count - 1] / 1000L);
            builder.extend(extender).extend(new NotificationCompat.CarExtender().setUnreadConversation(unreadConvBuilder.build()));
        }
        if (replyIntent != null && prefs.getBoolean("notify_quickreply", true)) {
            i = new Intent(IRCCloudApplication.getInstance().getApplicationContext(), QuickReplyActivity.class);
            i.setData(Uri.parse((String)("irccloud-bid://" + bid)));
            i.putExtras(replyIntent);
            i.addFlags(0x10000000);
            PendingIntent quickReplyIntent = PendingIntent.getActivity((Context)IRCCloudApplication.getInstance().getApplicationContext(), (int)0, (Intent)i, (int)0x8000000);
            builder.addAction(2130837613, "Quick Reply", quickReplyIntent);
        }
        android.app.Notification notification = builder.build();
        RemoteViews contentView = new RemoteViews(IRCCloudApplication.getInstance().getApplicationContext().getPackageName(), 2130903100);
        contentView.setTextViewText(2131623994, (CharSequence)(title + " (" + network + ")"));
        contentView.setTextViewText(2131624157, (CharSequence)(count == 1 ? Html.fromHtml((String)text) : count + " unread highlights."));
        contentView.setLong(2131624139, "setTime", eids[0] / 1000L);
        notification.contentView = contentView;
        if (Build.VERSION.SDK_INT >= 16 && big_text != null) {
            RemoteViews bigContentView = new RemoteViews(IRCCloudApplication.getInstance().getApplicationContext().getPackageName(), 2130903101);
            bigContentView.setTextViewText(2131623994, (CharSequence)(title + (!title.equals(network) ? " (" + network + ")" : "")));
            bigContentView.setTextViewText(2131624157, (CharSequence)big_text);
            bigContentView.setLong(2131624139, "setTime", eids[0] / 1000L);
            if (count > 3) {
                bigContentView.setViewVisibility(2131624170, 0);
                bigContentView.setTextViewText(2131624170, (CharSequence)("+" + (count - 3) + " more"));
            } else {
                bigContentView.setViewVisibility(2131624170, 8);
            }
            if (replyIntent != null && prefs.getBoolean("notify_quickreply", true)) {
                bigContentView.setViewVisibility(2131624172, 0);
                bigContentView.setViewVisibility(2131624171, 0);
                i = new Intent(IRCCloudApplication.getInstance().getApplicationContext(), QuickReplyActivity.class);
                i.setData(Uri.parse((String)("irccloud-bid://" + bid)));
                i.putExtras(replyIntent);
                i.addFlags(0x10000000);
                PendingIntent quickReplyIntent = PendingIntent.getActivity((Context)IRCCloudApplication.getInstance().getApplicationContext(), (int)0, (Intent)i, (int)0x8000000);
                bigContentView.setOnClickPendingIntent(2131624173, quickReplyIntent);
            }
            notification.bigContentView = bigContentView;
        }
        return notification;
    }

    private void notifyPebble(String title, String body) {
        JSONObject jsonData = new JSONObject();
        try {
            Intent i = new Intent("com.getpebble.action.SEND_NOTIFICATION");
            jsonData.put("title", (Object)title);
            jsonData.put("body", (Object)body);
            String notificationData = new JSONArray().put((Object)jsonData).toString();
            i.putExtra("messageType", "PEBBLE_ALERT");
            i.putExtra("sender", "IRCCloud");
            i.putExtra("notificationData", notificationData);
            IRCCloudApplication.getInstance().getApplicationContext().sendBroadcast(i);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showMessageNotifications(String ticker) {
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)IRCCloudApplication.getInstance().getApplicationContext());
        String text = "";
        String weartext = "";
        ArrayList<Notification> notifications = this.getMessageNotifications();
        int notify_type = Integer.parseInt(prefs.getString("notify_type", "1"));
        boolean notify = false;
        if (notify_type == 1 || notify_type == 2 && NetworkConnection.getInstance().isVisible()) {
            notify = true;
        }
        if (notifications.size() > 0 && notify) {
            int lastbid = notifications.get((int)0).bid;
            int count = 0;
            long[] eids = new long[notifications.size()];
            String[] auto_messages = new String[notifications.size()];
            Notification last = null;
            count = 0;
            boolean show = false;
            for (Notification n : notifications) {
                if (n.bid != lastbid) {
                    if (show) {
                        String title = last.chan;
                        if (title == null || title.length() == 0) {
                            title = last.nick;
                        }
                        if (title == null || title.length() == 0) {
                            title = last.network;
                        }
                        Intent replyIntent = new Intent(RemoteInputService.ACTION_REPLY);
                        replyIntent.putExtra("bid", last.bid);
                        replyIntent.putExtra("cid", last.cid);
                        replyIntent.putExtra("eids", eids);
                        replyIntent.putExtra("network", last.network);
                        if (last.buffer_type.equals("channel")) {
                            replyIntent.putExtra("to", last.chan);
                        } else {
                            replyIntent.putExtra("to", last.nick);
                        }
                        String body = "";
                        body = last.buffer_type.equals("channel") ? (last.message_type.equals("buffer_me_msg") ? "<b>\u2014 " + last.nick + "</b> " + last.message : "<b>&lt;" + last.nick + "&gt;</b> " + last.message) : (last.message_type.equals("buffer_me_msg") ? "\u2014 " + last.nick + " " + last.message : last.message);
                        NotificationManagerCompat.from(IRCCloudApplication.getInstance().getApplicationContext()).notify(lastbid, this.buildNotification(ticker, lastbid, eids, title, body, Html.fromHtml((String)text), count, replyIntent, Html.fromHtml((String)weartext), last.network, auto_messages));
                    }
                    lastbid = n.bid;
                    text = "";
                    weartext = "";
                    count = 0;
                    eids = new long[notifications.size()];
                    show = false;
                    auto_messages = new String[notifications.size()];
                }
                if (count < 3) {
                    if (text.length() > 0) {
                        text = text + "<br/>";
                    }
                    text = n.buffer_type.equals("conversation") && n.message_type.equals("buffer_me_msg") ? text + "\u2014 " + n.message : (n.buffer_type.equals("conversation") ? text + n.message : (n.message_type.equals("buffer_me_msg") ? text + "<b>\u2014 " + n.nick + "</b> " + n.message : text + "<b>" + n.nick + "</b> " + n.message));
                }
                if (weartext.length() > 0) {
                    weartext = weartext + "<br/><br/>";
                }
                weartext = n.message_type.equals("buffer_me_msg") ? weartext + "<b>\u2014 " + n.nick + "</b> " + n.message : weartext + "<b>&lt;" + n.nick + "&gt;</b> " + n.message;
                auto_messages[count] = n.buffer_type.equals("conversation") ? (n.message_type.equals("buffer_me_msg") ? "\u2014 " + n.nick + " " + Html.fromHtml((String)n.message).toString() : Html.fromHtml((String)n.message).toString()) : (n.message_type.equals("buffer_me_msg") ? "\u2014 " + n.nick + " " + Html.fromHtml((String)n.message).toString() : n.nick + " said: " + Html.fromHtml((String)n.message).toString());
                if (!n.shown) {
                    n.shown = true;
                    show = true;
                    if (prefs.getBoolean("notify_sony", false)) {
                        long time = System.currentTimeMillis();
                        long sourceId = NotificationUtil.getSourceId(IRCCloudApplication.getInstance().getApplicationContext(), "com.irccloud.android");
                        if (sourceId == -1L) {
                            Crashlytics.log(6, "IRCCloud", "Sony LiveWare Manager not configured, disabling Sony notifications");
                            SharedPreferences.Editor editor = prefs.edit();
                            editor.putBoolean("notify_sony", false);
                            editor.commit();
                        } else {
                            ContentValues eventValues = new ContentValues();
                            eventValues.put("readStatus", Boolean.valueOf(false));
                            eventValues.put("display_name", n.nick);
                            if (n.buffer_type.equals("channel") && n.chan != null && n.chan.length() > 0) {
                                eventValues.put("title", n.chan);
                            } else {
                                eventValues.put("title", n.network);
                            }
                            if (n.message_type.equals("buffer_me_msg")) {
                                eventValues.put("message", "\u2014 " + Html.fromHtml((String)n.message).toString());
                            } else {
                                eventValues.put("message", Html.fromHtml((String)n.message).toString());
                            }
                            eventValues.put("personal", Integer.valueOf(1));
                            eventValues.put("publishedTime", Long.valueOf(time));
                            eventValues.put("sourceId", Long.valueOf(sourceId));
                            eventValues.put("friend_key", String.valueOf(n.bid));
                            try {
                                IRCCloudApplication.getInstance().getApplicationContext().getContentResolver().insert(Notification.Event.URI, eventValues);
                            }
                            catch (IllegalArgumentException e) {
                                Log.e((String)"IRCCloud", (String)"Failed to insert event", (Throwable)e);
                            }
                            catch (SecurityException e) {
                                Log.e((String)"IRCCloud", (String)"Failed to insert event, is Live Ware Manager installed?", (Throwable)e);
                            }
                            catch (SQLException e) {
                                Log.e((String)"IRCCloud", (String)"Failed to insert event", (Throwable)e);
                            }
                        }
                    }
                    if (prefs.getBoolean("notify_pebble", false)) {
                        String pebbleTitle = n.network + ":\n";
                        String pebbleBody = "";
                        if (n.buffer_type.equals("channel") && n.chan != null && n.chan.length() > 0) {
                            pebbleTitle = n.chan + ":\n";
                        }
                        pebbleBody = n.message_type.equals("buffer_me_msg") ? "\u2014 " + n.message : n.message;
                        if (n.nick != null && n.nick.length() > 0) {
                            this.notifyPebble(n.nick, pebbleTitle + Html.fromHtml((String)pebbleBody).toString());
                        } else {
                            this.notifyPebble(n.network, pebbleTitle + Html.fromHtml((String)pebbleBody).toString());
                        }
                    }
                }
                eids[count++] = n.eid;
                last = n;
            }
            if (show) {
                String title = last.chan;
                if (title == null || title.length() == 0) {
                    title = last.nick;
                }
                if (title == null || title.length() == 0) {
                    title = last.network;
                }
                Intent replyIntent = new Intent(RemoteInputService.ACTION_REPLY);
                replyIntent.putExtra("bid", last.bid);
                replyIntent.putExtra("cid", last.cid);
                replyIntent.putExtra("network", last.network);
                replyIntent.putExtra("eids", eids);
                if (last.buffer_type.equals("channel")) {
                    replyIntent.putExtra("to", last.chan);
                } else {
                    replyIntent.putExtra("to", last.nick);
                }
                String body = "";
                body = last.buffer_type.equals("channel") ? (last.message_type.equals("buffer_me_msg") ? "<b>\u2014 " + last.nick + "</b> " + last.message : "<b>&lt;" + last.nick + "&gt;</b> " + last.message) : (last.message_type.equals("buffer_me_msg") ? "\u2014 " + last.nick + " " + last.message : last.message);
                NotificationManagerCompat.from(IRCCloudApplication.getInstance().getApplicationContext()).notify(lastbid, this.buildNotification(ticker, lastbid, eids, title, body, Html.fromHtml((String)text), count, replyIntent, Html.fromHtml((String)weartext), last.network, auto_messages));
            }
        }
    }

    public NotificationCompat.Builder alert(int bid, String title, String body) {
        NotificationCompat.Builder builder = new NotificationCompat.Builder(IRCCloudApplication.getInstance().getApplicationContext()).setContentTitle(title).setContentText(body).setTicker(body).setAutoCancel(true).setColor(IRCCloudApplication.getInstance().getApplicationContext().getResources().getColor(2131492899)).setSmallIcon(2130837630);
        Intent i = new Intent();
        i.setComponent(new ComponentName(IRCCloudApplication.getInstance().getApplicationContext().getPackageName(), "com.irccloud.android.MainActivity"));
        i.putExtra("bid", bid);
        i.setData(Uri.parse((String)("bid://" + bid)));
        builder.setContentIntent(PendingIntent.getActivity((Context)IRCCloudApplication.getInstance().getApplicationContext(), (int)0, (Intent)i, (int)0x8000000));
        NotificationManagerCompat.from(IRCCloudApplication.getInstance().getApplicationContext()).notify(bid, builder.build());
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTeslaUnreadCount() {
        try {
            IRCCloudApplication.getInstance().getApplicationContext().getPackageManager().getPackageInfo("com.teslacoilsw.notifier", 128);
        }
        catch (PackageManager.NameNotFoundException e) {
            return;
        }
        int count = 0;
        ArrayList<Notification> arrayList = this.mNotifications;
        synchronized (arrayList) {
            for (int i = 0; i < this.mNotifications.size(); ++i) {
                Notification n = this.mNotifications.get(i);
                if (n.bid == this.excludeBid) continue;
                ++count;
            }
        }
        try {
            ContentValues cv = new ContentValues();
            cv.put("tag", IRCCloudApplication.getInstance().getApplicationContext().getPackageManager().getLaunchIntentForPackage(IRCCloudApplication.getInstance().getApplicationContext().getPackageName()).getComponent().flattenToString());
            cv.put("count", Integer.valueOf(count));
            IRCCloudApplication.getInstance().getApplicationContext().getContentResolver().insert(Uri.parse((String)"content://com.teslacoilsw.notifier/unread_count"), cv);
        }
        catch (IllegalArgumentException cv) {
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public class comparator
    implements Comparator<Notification> {
        @Override
        public int compare(Notification n1, Notification n2) {
            if (n1.cid != n2.cid) {
                return Integer.valueOf(n1.cid).compareTo(n2.cid);
            }
            if (n1.bid != n2.bid) {
                return Integer.valueOf(n1.bid).compareTo(n2.bid);
            }
            return Long.valueOf(n1.eid).compareTo(n2.eid);
        }
    }

    public class Notification {
        public int cid;
        public int bid;
        public long eid;
        public String nick;
        public String message;
        public String network;
        public String chan;
        public String buffer_type;
        public String message_type;
        public boolean shown = false;

        public String toString() {
            return "{cid: " + this.cid + ", bid: " + this.bid + ", eid: " + this.eid + ", nick: " + this.nick + ", message: " + this.message + ", network: " + this.network + " shown: " + this.shown + "}";
        }
    }
}

