/*
 * Decompiled with CFR 0.152.
 */
package com.irccloud.android;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.NotificationManagerCompat;
import android.support.v4.app.RemoteInput;
import com.crashlytics.android.Crashlytics;
import com.irccloud.android.IRCCloudApplication;
import com.irccloud.android.NetworkConnection;
import com.irccloud.android.Notifications;
import com.squareup.leakcanary.RefWatcher;
import org.json.JSONObject;

public class RemoteInputService
extends IntentService {
    public static final String ACTION_REPLY = IRCCloudApplication.getInstance().getApplicationContext().getString(2131165229);

    public RemoteInputService() {
        super("RemoteInputService");
    }

    protected void onHandleIntent(Intent intent) {
        String action;
        boolean success = false;
        String sk = this.getSharedPreferences("prefs", 0).getString("session_key", "");
        if (intent != null && sk.length() > 0 && ACTION_REPLY.equals(action = intent.getAction())) {
            Bundle remoteInput = RemoteInput.getResultsFromIntent(intent);
            if (remoteInput != null || intent.hasExtra("reply")) {
                String reply;
                Crashlytics.log(4, "IRCCloud", "Got reply from RemoteInput");
                String string2 = reply = remoteInput != null ? remoteInput.getCharSequence("extra_reply").toString() : intent.getStringExtra("reply");
                if (!(reply.length() <= 0 || reply.contains("\n/") || reply.startsWith("/") && !reply.toLowerCase().startsWith("/me "))) {
                    try {
                        JSONObject o = NetworkConnection.getInstance().say(intent.getIntExtra("cid", -1), intent.getStringExtra("to"), reply, sk);
                        success = o.getBoolean("success");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                NotificationManagerCompat.from(IRCCloudApplication.getInstance().getApplicationContext()).cancel(intent.getIntExtra("bid", 0));
                if (intent.hasExtra("eids")) {
                    int bid = intent.getIntExtra("bid", -1);
                    long[] eids = intent.getLongArrayExtra("eids");
                    for (int j = 0; j < eids.length; ++j) {
                        if (eids[j] <= 0L) continue;
                        Notifications.getInstance().dismiss(bid, eids[j]);
                    }
                }
                Notifications.getInstance().showNotifications(null);
                if (!success) {
                    Notifications.getInstance().alert(intent.getIntExtra("bid", -1), "Sending Failed", reply.startsWith("/") ? "Please launch the IRCCloud app to send this command" : "Your message was not sent. Please try again shortly.");
                }
            } else {
                Crashlytics.log(6, "IRCCloud", "RemoteInputService received no remoteinput");
            }
        }
    }

    public void onDestroy() {
        super.onDestroy();
        RefWatcher refWatcher = IRCCloudApplication.getRefWatcher((Context)this);
        refWatcher.watch((Object)this);
    }
}

