/*
 * Decompiled with CFR 0.152.
 */
package com.irccloud.android;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.net.Uri;
import android.preference.PreferenceManager;
import android.util.Log;
import com.irccloud.android.IRCCloudApplication;
import com.irccloud.android.SonyRegistrationInformation;
import com.irccloud.android.activity.MainActivity;
import com.sonyericsson.extras.liveware.aef.notification.Notification;
import com.sonyericsson.extras.liveware.extension.util.ExtensionService;
import com.sonyericsson.extras.liveware.extension.util.registration.RegistrationInformation;

public class SonyExtensionService
extends ExtensionService {
    public static final String EXTENSION_SPECIFIC_ID = "com.irccloud.android";
    public static final String EXTENSION_KEY = "com.irccloud.android.key";
    public static final String LOG_TAG = "IRCCloud";

    public SonyExtensionService() {
        super(EXTENSION_KEY);
    }

    @Override
    public void onCreate() {
        super.onCreate();
        Log.d((String)LOG_TAG, (String)"onCreate");
    }

    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {
        return super.onStartCommand(intent, flags, startId);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        Log.d((String)LOG_TAG, (String)"onDestroy");
    }

    @Override
    protected void onViewEvent(Intent intent) {
        String action = intent.getStringExtra("action");
        int eventId = intent.getIntExtra("event_id", -1);
        if ("action_1".equals(action)) {
            this.doAction1(eventId);
        }
    }

    @Override
    protected void onRefreshRequest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAction1(int eventId) {
        try (Cursor cursor = null;){
            cursor = this.getContentResolver().query(Notification.Event.URI, null, "_id = " + eventId, null, null);
            if (cursor != null && cursor.moveToFirst()) {
                int nameIndex = cursor.getColumnIndex("display_name");
                int messageIndex = cursor.getColumnIndex("message");
                String bid = cursor.getString(cursor.getColumnIndex("friend_key"));
                Intent i = new Intent(IRCCloudApplication.getInstance().getApplicationContext(), MainActivity.class);
                i.addFlags(0x10000000);
                i.putExtra("bid", Integer.parseInt(bid));
                i.setData(Uri.parse((String)("bid://" + bid)));
                this.startActivity(i);
            }
        }
    }

    @Override
    public void onRegisterResult(boolean result) {
        super.onRegisterResult(result);
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)IRCCloudApplication.getInstance().getApplicationContext());
        if (prefs.getBoolean("notify_sony", true)) {
            SharedPreferences.Editor editor = prefs.edit();
            editor.putBoolean("notify_sony", true);
            editor.commit();
        }
    }

    @Override
    protected RegistrationInformation getRegistrationInformation() {
        return new SonyRegistrationInformation((Context)this);
    }

    @Override
    protected boolean keepRunningWhenConnected() {
        return false;
    }
}

