/*
 * Decompiled with CFR 0.152.
 */
package com.irccloud.android.activity;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Build;
import android.os.Bundle;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.TextView;
import com.google.android.gms.auth.api.Auth;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.irccloud.android.GCMIntentService;
import com.irccloud.android.IRCCloudJSONObject;
import com.irccloud.android.NetworkConnection;
import com.irccloud.android.activity.LoginActivity;
import com.irccloud.android.activity.PreferencesActivity;
import com.irccloud.android.data.ServersDataSource;
import java.lang.reflect.Field;

public class BaseActivity
extends AppCompatActivity
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener,
NetworkConnection.IRCEventHandler {
    NetworkConnection conn;
    private View dialogTextPrompt;
    private GoogleApiClient mGoogleApiClient;
    private boolean mResolvingError;
    private static final int REQUEST_RESOLVE_ERROR = 1001;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        if (BaseActivity.isMenuWorkaroundRequired()) {
            this.forceOverflowMenu();
        }
        super.onCreate(savedInstanceState);
        this.mGoogleApiClient = new GoogleApiClient.Builder((Context)this).addApi(Auth.CREDENTIALS_API).addConnectionCallbacks(this).addOnConnectionFailedListener(this).build();
    }

    @Override
    protected void onStart() {
        super.onStart();
        if (!this.mResolvingError) {
            this.mGoogleApiClient.connect();
        }
    }

    @Override
    protected void onStop() {
        this.mGoogleApiClient.disconnect();
        super.onStop();
    }

    @Override
    public void onConnected(Bundle connectionHint) {
    }

    @Override
    public void onConnectionSuspended(int cause) {
    }

    @Override
    public void onConnectionFailed(ConnectionResult result) {
        if (this.mResolvingError) {
            return;
        }
        if (result.hasResolution()) {
            try {
                this.mResolvingError = true;
                result.startResolutionForResult(this, 1001);
            }
            catch (IntentSender.SendIntentException e) {
                this.mGoogleApiClient.connect();
            }
        } else if (GooglePlayServicesUtil.isUserRecoverableError(result.getErrorCode())) {
            GooglePlayServicesUtil.getErrorDialog(result.getErrorCode(), this, 1001).show();
            this.mResolvingError = true;
        }
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 1001) {
            this.mResolvingError = false;
            if (resultCode == -1 && !this.mGoogleApiClient.isConnecting() && !this.mGoogleApiClient.isConnected()) {
                this.mGoogleApiClient.connect();
            }
        }
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        return keyCode == 82 && BaseActivity.isMenuWorkaroundRequired() || super.onKeyDown(keyCode, event);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode == 82 && BaseActivity.isMenuWorkaroundRequired()) {
            this.openOptionsMenu();
            return true;
        }
        try {
            return super.onKeyUp(keyCode, event);
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public View getDialogTextPrompt() {
        if (this.dialogTextPrompt == null) {
            this.dialogTextPrompt = ((LayoutInflater)this.getSystemService("layout_inflater")).inflate(2130903091, null);
        }
        if (this.dialogTextPrompt.getParent() != null) {
            ((ViewGroup)this.dialogTextPrompt.getParent()).removeView(this.dialogTextPrompt);
        }
        return this.dialogTextPrompt;
    }

    @Override
    public void onResume() {
        super.onResume();
        String session = this.getSharedPreferences("prefs", 0).getString("session_key", "");
        if (session != null && session.length() > 0) {
            this.conn = NetworkConnection.getInstance();
            this.conn.addHandler(this);
            if (this.conn.getState() == 0 || this.conn.getState() == 3) {
                this.conn.connect(session);
            }
            NetworkConnection.getInstance().registerForConnectivity();
        } else {
            Intent i = new Intent((Context)this, LoginActivity.class);
            i.addFlags(0x14000000);
            this.startActivity(i);
            this.finish();
        }
    }

    @Override
    public void onPause() {
        super.onPause();
        if (this.conn != null) {
            this.conn.removeHandler(this);
        }
        NetworkConnection.getInstance().unregisterForConnectivity();
    }

    @Override
    public void onIRCEvent(int what, Object obj) {
        String message = "";
        switch (what) {
            case 1: {
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (BaseActivity.this.getSharedPreferences("prefs", 0).contains("session_key") && "".length() > 0 && GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable((Context)BaseActivity.this) == 0) {
                            GCMIntentService.scheduleRegisterTimer(100);
                        }
                    }
                });
                break;
            }
            case 28: {
                final IRCCloudJSONObject o = (IRCCloudJSONObject)obj;
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        ServersDataSource.Server server = ServersDataSource.getInstance().getServer(o.cid());
                        AlertDialog.Builder builder = new AlertDialog.Builder((Context)BaseActivity.this);
                        builder.setInverseBackgroundForced(Build.VERSION.SDK_INT < 11);
                        View view = BaseActivity.this.getDialogTextPrompt();
                        TextView prompt = (TextView)view.findViewById(2131624120);
                        final EditText keyinput = (EditText)view.findViewById(2131624121);
                        keyinput.setText((CharSequence)"");
                        keyinput.setOnEditorActionListener(new TextView.OnEditorActionListener(){

                            public boolean onEditorAction(TextView textView, int actionId, KeyEvent event) {
                                if (actionId == 0 && event.getAction() == 0) {
                                    try {
                                        if (keyinput.getText() != null) {
                                            BaseActivity.this.conn.join(o.cid(), o.getString("chan"), keyinput.getText().toString());
                                        }
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                    ((AlertDialog)keyinput.getTag()).dismiss();
                                }
                                return true;
                            }
                        });
                        try {
                            prompt.setText((CharSequence)("Password for " + o.getString("chan")));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        builder.setTitle(server.name + " (" + server.hostname + ":" + server.port + ")");
                        builder.setView(view);
                        builder.setPositiveButton("Join", new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialog, int which) {
                                try {
                                    BaseActivity.this.conn.join(o.cid(), o.getString("chan"), keyinput.getText().toString());
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                dialog.dismiss();
                            }
                        });
                        builder.setNegativeButton("Cancel", new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialog, int which) {
                                dialog.dismiss();
                            }
                        });
                        AlertDialog dialog = builder.create();
                        keyinput.setTag((Object)dialog);
                        dialog.setOwnerActivity(BaseActivity.this);
                        dialog.getWindow().setSoftInputMode(5);
                        dialog.show();
                    }
                });
                break;
            }
            case 30: {
                final IRCCloudJSONObject o = (IRCCloudJSONObject)obj;
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        ServersDataSource.Server server = ServersDataSource.getInstance().getServer(o.cid());
                        AlertDialog.Builder builder = new AlertDialog.Builder((Context)BaseActivity.this);
                        builder.setInverseBackgroundForced(Build.VERSION.SDK_INT < 11);
                        View view = BaseActivity.this.getDialogTextPrompt();
                        TextView prompt = (TextView)view.findViewById(2131624120);
                        final EditText nickinput = (EditText)view.findViewById(2131624121);
                        nickinput.setText((CharSequence)"");
                        nickinput.setOnEditorActionListener(new TextView.OnEditorActionListener(){

                            public boolean onEditorAction(TextView exampleView, int actionId, KeyEvent event) {
                                if (actionId == 0 && event.getAction() == 0) {
                                    try {
                                        BaseActivity.this.conn.say(o.cid(), null, "/nick " + nickinput.getText().toString());
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                    ((AlertDialog)nickinput.getTag()).dismiss();
                                }
                                return true;
                            }
                        });
                        try {
                            String message = o.getString("invalid_nick") + " is not a valid nickname, try again";
                            if (server.isupport != null && server.isupport.has("NICKLEN")) {
                                message = message + "\n(" + server.isupport.get("NICKLEN").asText() + " chars)";
                            }
                            message = message + ".";
                            prompt.setText((CharSequence)message);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        builder.setTitle(server.name + " (" + server.hostname + ":" + server.port + ")");
                        builder.setView(view);
                        builder.setPositiveButton("Change Nickname", new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialog, int which) {
                                try {
                                    BaseActivity.this.conn.say(o.cid(), null, "/nick " + nickinput.getText().toString());
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                dialog.dismiss();
                            }
                        });
                        builder.setNegativeButton("Cancel", new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialog, int which) {
                                dialog.dismiss();
                            }
                        });
                        AlertDialog dialog = builder.create();
                        nickinput.setTag((Object)dialog);
                        dialog.setOwnerActivity(BaseActivity.this);
                        dialog.getWindow().setSoftInputMode(5);
                        dialog.show();
                    }
                });
                break;
            }
            case 106: {
                try {
                    IRCCloudJSONObject o = (IRCCloudJSONObject)obj;
                    String type = o.type();
                    if (type.equalsIgnoreCase("invite_only_chan")) {
                        this.showAlert(o.cid(), "You need an invitation to join " + o.getString("chan"));
                        break;
                    }
                    if (type.equalsIgnoreCase("channel_full")) {
                        this.showAlert(o.cid(), o.getString("chan") + " isn't allowing any more members to join.");
                        break;
                    }
                    if (type.equalsIgnoreCase("banned_from_channel")) {
                        this.showAlert(o.cid(), "You've been banned from " + o.getString("chan"));
                        break;
                    }
                    if (type.equalsIgnoreCase("invalid_nickchange")) {
                        this.showAlert(o.cid(), o.getString("ban_channel") + ": " + o.getString("msg"));
                        break;
                    }
                    if (type.equalsIgnoreCase("no_messages_from_non_registered")) {
                        if (o.has("nick") && o.getString("nick").length() > 0) {
                            this.showAlert(o.cid(), o.getString("nick") + ": " + o.getString("msg"));
                            break;
                        }
                        this.showAlert(o.cid(), o.getString("msg"));
                        break;
                    }
                    if (type.equalsIgnoreCase("not_registered")) {
                        String first = o.getString("first");
                        if (o.has("rest")) {
                            first = first + " " + o.getString("rest");
                        }
                        this.showAlert(o.cid(), first + ": " + o.getString("msg"));
                        break;
                    }
                    if (type.equalsIgnoreCase("too_many_channels")) {
                        this.showAlert(o.cid(), "Couldn't join " + o.getString("chan") + ": " + o.getString("msg"));
                        break;
                    }
                    if (type.equalsIgnoreCase("too_many_targets")) {
                        this.showAlert(o.cid(), o.getString("description") + ": " + o.getString("msg"));
                        break;
                    }
                    if (type.equalsIgnoreCase("no_such_server")) {
                        this.showAlert(o.cid(), o.getString("server") + ": " + o.getString("msg"));
                        break;
                    }
                    if (type.equalsIgnoreCase("unknown_command")) {
                        this.showAlert(o.cid(), "Unknown command: " + o.getString("command"));
                        break;
                    }
                    if (type.equalsIgnoreCase("help_not_found")) {
                        this.showAlert(o.cid(), o.getString("topic") + ": " + o.getString("msg"));
                        break;
                    }
                    if (type.equalsIgnoreCase("accept_exists")) {
                        this.showAlert(o.cid(), o.getString("nick") + " " + o.getString("msg"));
                        break;
                    }
                    if (type.equalsIgnoreCase("accept_not")) {
                        this.showAlert(o.cid(), o.getString("nick") + " " + o.getString("msg"));
                        break;
                    }
                    if (type.equalsIgnoreCase("nick_collision")) {
                        this.showAlert(o.cid(), o.getString("collision") + ": " + o.getString("msg"));
                        break;
                    }
                    if (type.equalsIgnoreCase("nick_too_fast")) {
                        this.showAlert(o.cid(), o.getString("nick") + ": " + o.getString("msg"));
                        break;
                    }
                    if (type.equalsIgnoreCase("save_nick")) {
                        this.showAlert(o.cid(), o.getString("nick") + ": " + o.getString("msg") + ": " + o.getString("new_nick"));
                        break;
                    }
                    if (type.equalsIgnoreCase("unknown_mode")) {
                        this.showAlert(o.cid(), "Missing mode: " + o.getString("params"));
                        break;
                    }
                    if (type.equalsIgnoreCase("user_not_in_channel")) {
                        this.showAlert(o.cid(), o.getString("nick") + " is not in " + o.getString("channel"));
                        break;
                    }
                    if (type.equalsIgnoreCase("need_more_params")) {
                        this.showAlert(o.cid(), "Missing parameters for command: " + o.getString("command"));
                        break;
                    }
                    if (type.equalsIgnoreCase("chan_privs_needed")) {
                        this.showAlert(o.cid(), o.getString("chan") + ": " + o.getString("msg"));
                        break;
                    }
                    if (type.equalsIgnoreCase("not_on_channel")) {
                        this.showAlert(o.cid(), o.getString("channel") + ": " + o.getString("msg"));
                        break;
                    }
                    if (type.equalsIgnoreCase("ban_on_chan")) {
                        this.showAlert(o.cid(), "You cannot change your nick to " + o.getString("proposed_nick") + " while banned on " + o.getString("channel"));
                        break;
                    }
                    if (type.equalsIgnoreCase("cannot_send_to_chan")) {
                        this.showAlert(o.cid(), o.getString("channel") + ": " + o.getString("msg"));
                        break;
                    }
                    if (type.equalsIgnoreCase("user_on_channel")) {
                        this.showAlert(o.cid(), o.getString("nick") + " is already a member of " + o.getString("channel"));
                        break;
                    }
                    if (type.equalsIgnoreCase("no_nick_given")) {
                        this.showAlert(o.cid(), "No nickname given");
                        break;
                    }
                    if (type.equalsIgnoreCase("silence")) {
                        String mask = o.getString("usermask");
                        message = mask.startsWith("-") ? mask.substring(1) + " removed from silence list" : (mask.startsWith("+") ? mask.substring(1) + " added to silence list" : "Silence list change: " + mask);
                        this.showAlert(o.cid(), message);
                        break;
                    }
                    if (type.equalsIgnoreCase("no_channel_topic")) {
                        this.showAlert(o.cid(), o.getString("channel") + ": " + o.getString("msg"));
                        break;
                    }
                    if (type.equalsIgnoreCase("time")) {
                        message = o.getString("time_string");
                        if (o.has("time_stamp") && o.getString("time_stamp").length() > 0) {
                            message = message + " (" + o.getString("time_stamp") + ")";
                        }
                        message = message + " \u2014 " + o.getString("time_server");
                        this.showAlert(o.cid(), message);
                        break;
                    }
                    this.showAlert(o.cid(), o.getString("msg"));
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                break;
            }
        }
    }

    protected void showAlert(int cid, final String msg) {
        final ServersDataSource.Server server = ServersDataSource.getInstance().getServer(cid);
        if (server != null) {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    AlertDialog.Builder builder = new AlertDialog.Builder((Context)BaseActivity.this);
                    builder.setInverseBackgroundForced(Build.VERSION.SDK_INT < 11);
                    builder.setTitle(server.name + " (" + server.hostname + ":" + server.port + ")");
                    builder.setMessage(msg);
                    builder.setNegativeButton("Ok", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            try {
                                dialog.dismiss();
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                // empty catch block
                            }
                        }
                    });
                    AlertDialog dialog = builder.create();
                    dialog.setOwnerActivity(BaseActivity.this);
                    dialog.show();
                }
            });
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(0x7F0F0000, menu2);
        return super.onCreateOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 2131624220: {
                AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
                builder.setInverseBackgroundForced(Build.VERSION.SDK_INT < 11);
                builder.setTitle("Logout");
                builder.setMessage("Would you like to logout of IRCCloud?");
                builder.setNegativeButton("Cancel", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                    }
                });
                builder.setPositiveButton("Logout", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                        BaseActivity.this.conn.logout();
                        if (BaseActivity.this.mGoogleApiClient.isConnected()) {
                            Auth.CredentialsApi.disableAutoSignIn(BaseActivity.this.mGoogleApiClient).setResultCallback(new ResultCallback<Status>(){

                                @Override
                                public void onResult(Status status) {
                                    Intent i = new Intent((Context)BaseActivity.this, LoginActivity.class);
                                    i.addFlags(0x14000000);
                                    BaseActivity.this.startActivity(i);
                                    BaseActivity.this.finish();
                                }
                            });
                        } else {
                            Intent i = new Intent((Context)BaseActivity.this, LoginActivity.class);
                            i.addFlags(0x14000000);
                            BaseActivity.this.startActivity(i);
                            BaseActivity.this.finish();
                        }
                    }
                });
                AlertDialog dialog = builder.create();
                dialog.setOwnerActivity(this);
                dialog.show();
                break;
            }
            case 2131624219: {
                Intent i = new Intent((Context)this, PreferencesActivity.class);
                this.startActivity(i);
            }
        }
        return super.onOptionsItemSelected(item);
    }

    public static boolean isMenuWorkaroundRequired() {
        return Build.VERSION.SDK_INT < 19 && Build.VERSION.SDK_INT > 10 && ("LGE".equalsIgnoreCase(Build.MANUFACTURER) || "E6710".equalsIgnoreCase(Build.DEVICE));
    }

    public void forceOverflowMenu() {
        try {
            ViewConfiguration config = ViewConfiguration.get((Context)this);
            Field menuKeyField = ViewConfiguration.class.getDeclaredField("sHasPermanentMenuKey");
            if (menuKeyField != null) {
                menuKeyField.setAccessible(true);
                menuKeyField.setBoolean(config, false);
            }
        }
        catch (Exception e) {
            Log.w((String)"IRCCloud", (String)"Failed to force overflow menu.");
        }
    }
}

