/*
 * Decompiled with CFR 0.152.
 */
package com.irccloud.android.activity;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.FragmentTransaction;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.widget.Toast;
import com.irccloud.android.IRCCloudJSONObject;
import com.irccloud.android.NetworkConnection;
import com.irccloud.android.activity.LoginActivity;
import com.irccloud.android.activity.MainActivity;
import com.irccloud.android.data.BuffersDataSource;
import com.irccloud.android.data.ServersDataSource;
import com.irccloud.android.fragment.EditConnectionFragment;

public class EditConnectionActivity
extends AppCompatActivity
implements NetworkConnection.IRCEventHandler {
    int reqid = -1;
    int cidToOpen = -1;
    int cid = -1;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (Build.VERSION.SDK_INT >= 21) {
            Bitmap cloud = BitmapFactory.decodeResource((Resources)this.getResources(), (int)2130837620);
            this.setTaskDescription(new ActivityManager.TaskDescription(this.getResources().getString(2131165254), cloud, -854020));
            cloud.recycle();
        }
        this.setContentView(2130903073);
        this.getSupportActionBar().setDisplayOptions(16);
        this.getSupportActionBar().setBackgroundDrawable(this.getResources().getDrawable(2130837566));
        this.getSupportActionBar().setCustomView(2130903070);
        this.getSupportActionBar().setElevation(0.0f);
        FragmentTransaction ft = this.getSupportFragmentManager().beginTransaction();
        final EditConnectionFragment newFragment = new EditConnectionFragment();
        if (this.getIntent() != null && this.getIntent().hasExtra("cid")) {
            newFragment.setCid(this.getIntent().getIntExtra("cid", -1));
            this.cid = this.getIntent().getIntExtra("cid", -1);
        }
        if (this.getIntent() != null && this.getIntent().hasExtra("hostname")) {
            newFragment.default_hostname = this.getIntent().getStringExtra("hostname");
        }
        if (this.getIntent() != null && this.getIntent().hasExtra("channels")) {
            newFragment.default_channels = this.getIntent().getStringExtra("channels");
        }
        newFragment.default_port = this.getIntent().getIntExtra("port", 6667);
        ft.replace(2131624035, newFragment);
        ft.commit();
        this.getSupportActionBar().getCustomView().findViewById(2131624029).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ServersDataSource.getInstance().count() < 1) {
                    NetworkConnection.getInstance().logout();
                    Intent i = new Intent((Context)EditConnectionActivity.this, LoginActivity.class);
                    i.addFlags(0x14000000);
                    EditConnectionActivity.this.startActivity(i);
                }
                EditConnectionActivity.this.finish();
            }
        });
        this.getSupportActionBar().getCustomView().findViewById(2131624030).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                EditConnectionActivity.this.reqid = newFragment.save();
            }
        });
        NetworkConnection.getInstance().addHandler(this);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        NetworkConnection.getInstance().removeHandler(this);
    }

    @Override
    public void onIRCEvent(int what, Object o) {
        switch (what) {
            case 3: {
                BuffersDataSource.Buffer buffer = (BuffersDataSource.Buffer)o;
                if (buffer.cid != this.cidToOpen) break;
                Intent i = new Intent((Context)this, MainActivity.class);
                i.putExtra("bid", buffer.bid);
                this.startActivity(i);
                this.finish();
                break;
            }
            case 104: {
                IRCCloudJSONObject obj = (IRCCloudJSONObject)o;
                if (obj.getInt("_reqid") != this.reqid) break;
                if (this.cid != -1) {
                    this.finish();
                    break;
                }
                this.cidToOpen = obj.cid();
                break;
            }
            case 103: {
                IRCCloudJSONObject obj = (IRCCloudJSONObject)o;
                if (obj.getInt("_reqid") != this.reqid) break;
                final String message = obj.getString("message");
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (message.equals("passworded_servers")) {
                            Toast.makeText((Context)EditConnectionActivity.this, (CharSequence)"You can\u2019t connect to passworded servers with free accounts.", (int)0).show();
                        } else if (message.equals("networks")) {
                            Toast.makeText((Context)EditConnectionActivity.this, (CharSequence)"You've exceeded the connection limit for free accounts.", (int)0).show();
                        } else if (message.equals("unverified")) {
                            Toast.makeText((Context)EditConnectionActivity.this, (CharSequence)"You can\u2019t connect to external servers until you confirm your email address.", (int)0).show();
                        } else {
                            Toast.makeText((Context)EditConnectionActivity.this, (CharSequence)("Unable to add connection: invalid " + message), (int)0).show();
                        }
                    }
                });
                break;
            }
            case 1: {
                this.finish();
                break;
            }
        }
    }
}

