/*
 * Decompiled with CFR 0.152.
 */
package com.irccloud.android.activity;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.nfc.NdefMessage;
import android.nfc.NdefRecord;
import android.nfc.NfcAdapter;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.view.MenuItemCompat;
import android.support.v7.widget.Toolbar;
import android.view.Menu;
import android.view.MenuItem;
import android.view.ViewGroup;
import android.webkit.JavascriptInterface;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;
import android.widget.Toast;
import com.irccloud.android.AsyncTaskEx;
import com.irccloud.android.GingerbreadImageProxy;
import com.irccloud.android.NetworkConnection;
import com.irccloud.android.ShareActionProviderHax;
import com.irccloud.android.activity.BaseActivity;
import java.net.URL;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONObject;

public class ImageViewerActivity
extends BaseActivity
implements ShareActionProviderHax.OnShareActionProviderSubVisibilityChangedListener {
    WebView mImage;
    ProgressBar mSpinner;
    ProgressBar mProgress;
    Toolbar toolbar;
    private static Timer mHideTimer = null;
    TimerTask mHideTimerTask = null;

    @Override
    @TargetApi(value=11)
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        mHideTimer = new Timer("actionbar-hide-timer");
        if (savedInstanceState == null) {
            this.overridePendingTransition(2130968588, 2130968587);
        }
        this.setContentView(2130903074);
        this.toolbar = (Toolbar)this.findViewById(2131624039);
        try {
            this.setSupportActionBar(this.toolbar);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (Build.VERSION.SDK_INT >= 14 && Build.VERSION.SDK_INT < 19) {
            this.getWindow().getDecorView().setSystemUiVisibility(1);
        } else if (Build.VERSION.SDK_INT >= 19 && Build.VERSION.SDK_INT < 21) {
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)this.toolbar.getLayoutParams();
            int resid = this.getResources().getIdentifier("status_bar_height", "dimen", "android");
            lp.topMargin = resid > 0 ? this.getResources().getDimensionPixelSize(resid) : this.getResources().getDimensionPixelSize(2131230820);
            this.toolbar.setLayoutParams((ViewGroup.LayoutParams)lp);
        }
        this.getSupportActionBar().setTitle("Image Viewer");
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.getSupportActionBar().setBackgroundDrawable(this.getResources().getDrawable(2130837709));
        this.mImage = (WebView)this.findViewById(2131623990);
        this.mImage.setBackgroundColor(0);
        this.mImage.addJavascriptInterface((Object)new JSInterface(), "Android");
        this.mImage.getSettings().setBuiltInZoomControls(true);
        if (Integer.parseInt(Build.VERSION.SDK) >= 19) {
            this.mImage.getSettings().setDisplayZoomControls(false);
        }
        this.mImage.getSettings().setJavaScriptEnabled(true);
        this.mImage.getSettings().setLoadWithOverviewMode(true);
        this.mImage.getSettings().setUseWideViewPort(true);
        this.mImage.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView view, int newProgress) {
                ImageViewerActivity.this.mProgress.setProgress(newProgress);
            }
        });
        this.mImage.setWebViewClient(new WebViewClient(){

            public void onPageFinished(WebView view, String url) {
                ImageViewerActivity.this.mSpinner.setVisibility(8);
                ImageViewerActivity.this.mProgress.setVisibility(8);
                ImageViewerActivity.this.mImage.setVisibility(0);
                ImageViewerActivity.this.hide_actionbar();
            }

            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                ImageViewerActivity.this.fail();
            }

            public void onLoadResource(WebView view, String url) {
                ImageViewerActivity.this.mSpinner.setVisibility(8);
                ImageViewerActivity.this.mProgress.setVisibility(0);
            }
        });
        this.mSpinner = (ProgressBar)this.findViewById(2131624037);
        this.mProgress = (ProgressBar)this.findViewById(2131624038);
        if (this.getIntent() != null && this.getIntent().getDataString() != null) {
            String url = this.getIntent().getDataString().replace(this.getResources().getString(2131165231), "http");
            String lower = url.toLowerCase().replace("https://", "").replace("http://", "");
            if (lower.startsWith("www.dropbox.com/")) {
                url = lower.startsWith("www.dropbox.com/s/") ? url.replace("://www.dropbox.com/s/", "://dl.dropboxusercontent.com/s/") : url + "?dl=1";
            } else if ((lower.startsWith("d.pr/i/") || lower.startsWith("droplr.com/i/")) && !lower.endsWith("+")) {
                url = url + "+";
            } else {
                if (lower.startsWith("imgur.com/") || lower.startsWith("www.imgur.com/")) {
                    new OEmbedTask().execute("https://api.imgur.com/oembed.json?url=" + url);
                    return;
                }
                if (lower.startsWith("flickr.com/") || lower.startsWith("www.flickr.com/")) {
                    new OEmbedTask().execute("https://www.flickr.com/services/oembed/?format=json&url=" + url);
                    return;
                }
                if (lower.startsWith("instagram.com/") || lower.startsWith("www.instagram.com/") || lower.startsWith("instagr.am/") || lower.startsWith("www.instagr.am/")) {
                    new OEmbedTask().execute("http://api.instagram.com/oembed?url=" + url);
                    return;
                }
                if (lower.startsWith("cl.ly")) {
                    new ClLyTask().execute(url);
                    return;
                }
                if (url.contains("/wiki/File:")) {
                    new WikiTask().execute(url.replace("/wiki/", "/w/api.php?action=query&format=json&prop=imageinfo&iiprop=url&titles="));
                } else if (lower.startsWith("leetfiles.com/") || lower.startsWith("www.leetfiles.com/")) {
                    url = url.replace("www.", "").replace("leetfiles.com/image/", "i.leetfiles.com/").replace("?id=", "");
                } else if (lower.startsWith("leetfil.es/") || lower.startsWith("www.leetfil.es/")) {
                    url = url.replace("www.", "").replace("leetfil.es/image/", "i.leetfiles.com/").replace("?id=", "");
                }
            }
            this.loadImage(url);
        } else {
            this.finish();
        }
    }

    private void loadImage(String urlStr) {
        try {
            if (Build.VERSION.SDK_INT < 11 && urlStr.startsWith("https://")) {
                GingerbreadImageProxy proxy = new GingerbreadImageProxy();
                proxy.init();
                proxy.start();
                urlStr = String.format("http://127.0.0.1:%d/%s", proxy.getPort(), urlStr);
            }
            URL url = new URL(urlStr);
            this.mImage.loadDataWithBaseURL(null, "<!DOCTYPE html>\n<html><head><style>html, body, table { height: 100%; width: 100%; background-color: #000;}</style></head>\n<body>\n<table><tr><td><img src='" + url.toString() + "' width='100%' onerror='Android.imageFailed()' onclick='Android.imageClicked()' style='background-color: #fff;'/>\n</td></tr></table></body>\n</html>", "text/html", "UTF-8", null);
            try {
                NfcAdapter nfc;
                if (Build.VERSION.SDK_INT >= 16 && (nfc = NfcAdapter.getDefaultAdapter((Context)this)) != null) {
                    nfc.setNdefPushMessage(new NdefMessage(NdefRecord.createUri((String)urlStr), new NdefRecord[0]), (Activity)this, new Activity[0]);
                }
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            this.fail();
        }
    }

    private void fail() {
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)this.getIntent().getDataString().replace(this.getResources().getString(2131165231), "http")));
        this.startActivity(intent);
        this.finish();
    }

    @Override
    public void onResume() {
        super.onResume();
        if (this.mSpinner != null && this.mSpinner.getVisibility() == 8) {
            this.hide_actionbar();
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (mHideTimer != null) {
            mHideTimer.cancel();
            mHideTimer = null;
        }
        if (this.mImage != null) {
            this.mImage.setWebViewClient(null);
            this.mImage.setWebChromeClient(null);
            if (Build.VERSION.SDK_INT >= 11) {
                this.mImage.removeJavascriptInterface("Android");
            }
        }
    }

    private void hide_actionbar() {
        if (mHideTimer != null) {
            if (this.mHideTimerTask != null) {
                this.mHideTimerTask.cancel();
            }
            this.mHideTimerTask = new TimerTask(){

                @Override
                public void run() {
                    ImageViewerActivity.this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            if (Build.VERSION.SDK_INT > 16) {
                                ImageViewerActivity.this.toolbar.animate().alpha(0.0f).translationY((float)(-ImageViewerActivity.this.toolbar.getHeight())).withEndAction(new Runnable(){

                                    @Override
                                    public void run() {
                                        ImageViewerActivity.this.toolbar.setVisibility(8);
                                    }
                                });
                            } else {
                                ImageViewerActivity.this.toolbar.setVisibility(8);
                            }
                        }
                    });
                }
            };
            mHideTimer.schedule(this.mHideTimerTask, 3000L);
        }
    }

    @Override
    public void onBackPressed() {
        super.onBackPressed();
        this.overridePendingTransition(2130968586, 2130968589);
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(2131689474, menu2);
        if (this.getIntent() != null && this.getIntent().getDataString() != null) {
            Intent intent = new Intent("android.intent.action.SEND", Uri.parse((String)this.getIntent().getDataString().replace(this.getResources().getString(2131165231), "http")));
            intent.setType("text/plain");
            intent.putExtra("android.intent.extra.TEXT", this.getIntent().getDataString().replace(this.getResources().getString(2131165231), "http"));
            intent.putExtra("android.support.v4.app.EXTRA_CALLING_PACKAGE", this.getPackageName());
            intent.putExtra("android.support.v4.app.EXTRA_CALLING_ACTIVITY", (Parcelable)this.getPackageManager().getLaunchIntentForPackage(this.getPackageName()).getComponent());
            intent.addFlags(0x10080000);
            MenuItem shareItem = menu2.findItem(2131624221);
            ShareActionProviderHax share = (ShareActionProviderHax)MenuItemCompat.getActionProvider(shareItem);
            share.onShareActionProviderSubVisibilityChangedListener = this;
            share.setShareIntent(intent);
        }
        return true;
    }

    public boolean onPrepareOptionsMenu(Menu menu2) {
        if (this.mHideTimerTask != null) {
            this.mHideTimerTask.cancel();
        }
        return super.onPrepareOptionsMenu(menu2);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.finish();
            this.overridePendingTransition(2130968586, 2130968589);
            return true;
        }
        if (item.getItemId() == 2131624222) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)this.getIntent().getDataString().replace(this.getResources().getString(2131165231), "http")));
            this.startActivity(intent);
            this.finish();
            return true;
        }
        if (item.getItemId() == 2131624223) {
            if (Build.VERSION.SDK_INT < 11) {
                android.text.ClipboardManager clipboard = (android.text.ClipboardManager)this.getSystemService("clipboard");
                clipboard.setText((CharSequence)this.getIntent().getDataString().replace(this.getResources().getString(2131165231), "http"));
            } else {
                ClipboardManager clipboard = (ClipboardManager)this.getSystemService("clipboard");
                ClipData clip = ClipData.newRawUri((CharSequence)"IRCCloud Image URL", (Uri)Uri.parse((String)this.getIntent().getDataString().replace(this.getResources().getString(2131165231), "http")));
                clipboard.setPrimaryClip(clip);
            }
            Toast.makeText((Context)this, (CharSequence)"Link copied to clipboard", (int)0).show();
        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    public void onShareActionProviderSubVisibilityChanged(boolean visible) {
        if (visible) {
            if (this.mHideTimerTask != null) {
                this.mHideTimerTask.cancel();
            }
        } else {
            this.hide_actionbar();
        }
    }

    public class JSInterface {
        @JavascriptInterface
        public void imageFailed() {
            ImageViewerActivity.this.fail();
        }

        @JavascriptInterface
        public void imageClicked() {
            ImageViewerActivity.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (ImageViewerActivity.this.toolbar.getVisibility() == 0) {
                        if (ImageViewerActivity.this.mHideTimerTask != null) {
                            ImageViewerActivity.this.mHideTimerTask.cancel();
                        }
                        if (Build.VERSION.SDK_INT > 16) {
                            ImageViewerActivity.this.toolbar.animate().alpha(0.0f).translationY((float)(-ImageViewerActivity.this.toolbar.getHeight())).withEndAction(new Runnable(){

                                @Override
                                public void run() {
                                    ImageViewerActivity.this.toolbar.setVisibility(8);
                                }
                            });
                        } else {
                            ImageViewerActivity.this.toolbar.setVisibility(8);
                        }
                    } else {
                        if (Build.VERSION.SDK_INT > 16) {
                            ImageViewerActivity.this.toolbar.setAlpha(0.0f);
                            ImageViewerActivity.this.toolbar.animate().alpha(1.0f).translationY(0.0f);
                        }
                        ImageViewerActivity.this.toolbar.setVisibility(0);
                        ImageViewerActivity.this.hide_actionbar();
                    }
                }
            });
        }
    }

    private class WikiTask
    extends AsyncTaskEx<String, Void, String> {
        private WikiTask() {
        }

        protected String doInBackground(String ... params) {
            try {
                JSONObject o = NetworkConnection.getInstance().fetchJSON(params[0]);
                JSONObject pages = o.getJSONObject("query").getJSONObject("pages");
                Iterator i = pages.keys();
                String pageid = (String)i.next();
                return pages.getJSONObject(pageid).getJSONArray("imageinfo").getJSONObject(0).getString("url");
            }
            catch (Exception exception) {
                return null;
            }
        }

        @Override
        protected void onPostExecute(String url) {
            if (url != null) {
                ImageViewerActivity.this.loadImage(url);
            } else {
                ImageViewerActivity.this.fail();
            }
        }
    }

    private class ClLyTask
    extends AsyncTaskEx<String, Void, String> {
        private ClLyTask() {
        }

        protected String doInBackground(String ... params) {
            try {
                JSONObject o = NetworkConnection.getInstance().fetchJSON(params[0]);
                if (o.getString("item_type").equalsIgnoreCase("image")) {
                    return o.getString("content_url");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        @Override
        protected void onPostExecute(String url) {
            if (url != null) {
                ImageViewerActivity.this.loadImage(url);
            } else {
                ImageViewerActivity.this.fail();
            }
        }
    }

    private class OEmbedTask
    extends AsyncTaskEx<String, Void, String> {
        private OEmbedTask() {
        }

        protected String doInBackground(String ... params) {
            try {
                JSONObject o = NetworkConnection.getInstance().fetchJSON(params[0]);
                if (o.getString("type").equalsIgnoreCase("photo")) {
                    return o.getString("url");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        @Override
        protected void onPostExecute(String url) {
            if (url != null) {
                ImageViewerActivity.this.loadImage(url);
            } else {
                ImageViewerActivity.this.fail();
            }
        }
    }
}

