/*
 * Decompiled with CFR 0.152.
 */
package com.irccloud.android.activity;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.app.ActivityManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentSender;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Typeface;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.support.v4.app.FragmentActivity;
import android.support.v7.app.AlertDialog;
import android.text.method.LinkMovementMethod;
import android.text.method.MovementMethod;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.WindowManager;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.crashlytics.android.answers.Answers;
import com.crashlytics.android.answers.EventAttributes;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.auth.api.Auth;
import com.google.android.gms.auth.api.credentials.Credential;
import com.google.android.gms.auth.api.credentials.CredentialRequest;
import com.google.android.gms.auth.api.credentials.CredentialRequestResult;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.irccloud.android.AsyncTaskEx;
import com.irccloud.android.NetworkConnection;
import com.irccloud.android.activity.MainActivity;
import java.io.IOException;
import java.util.ArrayList;
import org.json.JSONException;
import org.json.JSONObject;

public class LoginActivity
extends FragmentActivity
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener {
    private View login = null;
    private View loading = null;
    private AutoCompleteTextView email;
    private EditText password;
    private EditText host;
    private EditText name;
    private Button loginBtn;
    private Button signupBtn;
    private Button nextBtn;
    private Button sendAccessLinkBtn;
    private TextView connectingMsg = null;
    private TextView TOS = null;
    private TextView forgotPassword = null;
    private TextView enterpriseLearnMore = null;
    private TextView EnterYourEmail = null;
    private TextView hostHint = null;
    private LinearLayout notAProblem = null;
    private ProgressBar progressBar = null;
    private View connecting = null;
    private LinearLayout loginHint = null;
    private LinearLayout signupHint = null;
    private LinearLayout enterpriseHint = null;
    private LinearLayout loginSignupHint = null;
    private String impression_id = null;
    private GoogleApiClient mGoogleApiClient;
    private static final int REQUEST_RESOLVE_ERROR = 1001;
    private static final int REQUEST_RESOLVE_CREDENTIALS = 1002;
    private static final int REQUEST_RESOLVE_SAVE_CREDENTIALS = 1003;
    private boolean mResolvingError = false;
    private View.OnClickListener signupHintClickListener = new View.OnClickListener(){

        public void onClick(View view) {
            LoginActivity.this.name.setVisibility(0);
            LoginActivity.this.email.setVisibility(0);
            LoginActivity.this.password.setVisibility(0);
            LoginActivity.this.loginBtn.setVisibility(8);
            LoginActivity.this.signupBtn.setVisibility(0);
            LoginActivity.this.name.requestFocus();
            LoginActivity.this.TOS.setVisibility(0);
            LoginActivity.this.signupHint.setVisibility(8);
            LoginActivity.this.loginHint.setVisibility(0);
            LoginActivity.this.forgotPassword.setVisibility(8);
            LoginActivity.this.loginSignupHint.setVisibility(8);
            LoginActivity.this.EnterYourEmail.setVisibility(8);
            LoginActivity.this.sendAccessLinkBtn.setVisibility(8);
            LoginActivity.this.notAProblem.setVisibility(8);
            LoginActivity.this.email.setBackgroundResource(2130837635);
            LoginActivity.this.host.setVisibility(8);
            LoginActivity.this.nextBtn.setVisibility(8);
            LoginActivity.this.enterpriseLearnMore.setVisibility(8);
            LoginActivity.this.enterpriseHint.setVisibility(8);
            LoginActivity.this.hostHint.setVisibility(8);
        }
    };
    private View.OnClickListener loginHintClickListener = new View.OnClickListener(){

        public void onClick(View view) {
            LoginActivity.this.name.setVisibility(8);
            LoginActivity.this.email.setVisibility(0);
            LoginActivity.this.password.setVisibility(0);
            LoginActivity.this.loginBtn.setVisibility(0);
            LoginActivity.this.signupBtn.setVisibility(8);
            LoginActivity.this.email.requestFocus();
            LoginActivity.this.TOS.setVisibility(8);
            LoginActivity.this.loginHint.setVisibility(8);
            LoginActivity.this.forgotPassword.setVisibility(0);
            LoginActivity.this.loginSignupHint.setVisibility(8);
            LoginActivity.this.EnterYourEmail.setVisibility(8);
            LoginActivity.this.sendAccessLinkBtn.setVisibility(8);
            LoginActivity.this.notAProblem.setVisibility(8);
            LoginActivity.this.email.setBackgroundResource(2130837650);
            LoginActivity.this.host.setVisibility(8);
            LoginActivity.this.nextBtn.setVisibility(8);
            LoginActivity.this.enterpriseLearnMore.setVisibility(8);
            LoginActivity.this.enterpriseHint.setVisibility(8);
            LoginActivity.this.hostHint.setVisibility(8);
            if (LoginActivity.this.loginSignupHint.getChildAt(1).getVisibility() == 0) {
                LoginActivity.this.signupHint.setVisibility(0);
            } else {
                LoginActivity.this.enterpriseHint.setVisibility(0);
            }
        }
    };
    private View.OnClickListener forgotPasswordClickListener = new View.OnClickListener(){

        public void onClick(View view) {
            LoginActivity.this.loginHint.setVisibility(8);
            LoginActivity.this.signupHint.setVisibility(8);
            LoginActivity.this.loginSignupHint.setVisibility(0);
            LoginActivity.this.notAProblem.setVisibility(0);
            LoginActivity.this.password.setVisibility(8);
            LoginActivity.this.loginBtn.setVisibility(8);
            LoginActivity.this.signupBtn.setVisibility(8);
            LoginActivity.this.TOS.setVisibility(8);
            LoginActivity.this.sendAccessLinkBtn.setVisibility(0);
            LoginActivity.this.EnterYourEmail.setVisibility(0);
            LoginActivity.this.forgotPassword.setVisibility(8);
            LoginActivity.this.name.setVisibility(8);
            LoginActivity.this.email.setBackgroundResource(2130837636);
            LoginActivity.this.host.setVisibility(8);
            LoginActivity.this.nextBtn.setVisibility(8);
            LoginActivity.this.enterpriseLearnMore.setVisibility(8);
            LoginActivity.this.enterpriseHint.setVisibility(8);
            LoginActivity.this.hostHint.setVisibility(8);
        }
    };

    @Override
    public void onCreate(Bundle savedInstanceState) {
        View v;
        int i;
        View v2;
        int i2;
        super.onCreate(savedInstanceState);
        if (Build.VERSION.SDK_INT >= 21) {
            Bitmap cloud = BitmapFactory.decodeResource((Resources)this.getResources(), (int)2130837620);
            this.setTaskDescription(new ActivityManager.TaskDescription(this.getResources().getString(2131165254), cloud, -16044448));
            cloud.recycle();
        }
        this.requestWindowFeature(1);
        this.getWindow().setSoftInputMode(3);
        this.setContentView(2130903075);
        this.loading = this.findViewById(2131624067);
        this.connecting = this.findViewById(2131624063);
        this.connectingMsg = (TextView)this.findViewById(2131624064);
        this.progressBar = (ProgressBar)this.findViewById(2131624065);
        this.loginHint = (LinearLayout)this.findViewById(2131624044);
        this.signupHint = (LinearLayout)this.findViewById(2131624043);
        this.hostHint = (TextView)this.findViewById(2131624054);
        this.login = this.findViewById(2131624048);
        this.name = (EditText)this.findViewById(2131624050);
        if (savedInstanceState != null && savedInstanceState.containsKey("name")) {
            this.name.setText((CharSequence)savedInstanceState.getString("name"));
        }
        this.email = (AutoCompleteTextView)this.findViewById(2131624051);
        ArrayList<String> accounts = new ArrayList<String>();
        AccountManager am = (AccountManager)this.getSystemService("account");
        for (Account a : am.getAccounts()) {
            if (!a.name.contains("@") || accounts.contains(a.name)) continue;
            accounts.add(a.name);
        }
        if (accounts.size() > 0) {
            this.email.setAdapter((ListAdapter)new ArrayAdapter((Context)this, 17367043, (Object[])accounts.toArray(new String[accounts.size()])));
        }
        if (savedInstanceState != null && savedInstanceState.containsKey("email")) {
            this.email.setText((CharSequence)savedInstanceState.getString("email"));
        }
        this.password = (EditText)this.findViewById(2131624052);
        this.password.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView exampleView, int actionId, KeyEvent event) {
                if (actionId == 6) {
                    new LoginTask().execute(new Void[]{null});
                    return true;
                }
                return false;
            }
        });
        if (savedInstanceState != null && savedInstanceState.containsKey("password")) {
            this.password.setText((CharSequence)savedInstanceState.getString("password"));
        }
        this.host = (EditText)this.findViewById(2131624053);
        this.host.setVisibility(8);
        this.host.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView exampleView, int actionId, KeyEvent event) {
                if (actionId == 6) {
                    new LoginTask().execute(new Void[]{null});
                    return true;
                }
                return false;
            }
        });
        if (savedInstanceState != null && savedInstanceState.containsKey("host")) {
            this.host.setText((CharSequence)savedInstanceState.getString("host"));
        } else {
            this.host.setText((CharSequence)this.getSharedPreferences("prefs", 0).getString("host", "api.irccloud.com"));
        }
        if (this.host.getText().toString().equals("api.irccloud.com") || this.host.getText().toString().equals("www.irccloud.com")) {
            this.host.setText((CharSequence)"");
        }
        this.loginBtn = (Button)this.findViewById(2131624055);
        this.loginBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                new LoginTask().execute(new Void[]{null});
            }
        });
        this.loginBtn.setFocusable(true);
        this.loginBtn.requestFocus();
        this.sendAccessLinkBtn = (Button)this.findViewById(2131624058);
        this.sendAccessLinkBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                new ResetPasswordTask().execute(new Void[]{null});
            }
        });
        this.nextBtn = (Button)this.findViewById(2131624057);
        this.nextBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (LoginActivity.this.host.getText().length() > 0) {
                    NetworkConnection.IRCCLOUD_HOST = LoginActivity.this.host.getText().toString();
                    LoginActivity.this.trimHost();
                    new EnterpriseConfigTask().execute(new Void[]{null});
                }
            }
        });
        this.TOS = (TextView)this.findViewById(2131624059);
        this.TOS.setMovementMethod((MovementMethod)new LinkMovementMethod());
        this.forgotPassword = (TextView)this.findViewById(2131624060);
        this.forgotPassword.setOnClickListener(this.forgotPasswordClickListener);
        this.enterpriseLearnMore = (TextView)this.findViewById(2131624061);
        this.enterpriseLearnMore.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (this.isPackageInstalled("com.irccloud.android", (Context)LoginActivity.this)) {
                    LoginActivity.this.startActivity(LoginActivity.this.getPackageManager().getLaunchIntentForPackage("com.irccloud.android"));
                } else {
                    try {
                        LoginActivity.this.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)"market://details?id=com.irccloud.android")));
                    }
                    catch (Exception e) {
                        LoginActivity.this.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)"http://play.google.com/store/apps/details?id=com.irccloud.android")));
                    }
                }
            }

            private boolean isPackageInstalled(String packagename, Context context) {
                PackageManager pm = context.getPackageManager();
                try {
                    pm.getPackageInfo(packagename, 1);
                    return true;
                }
                catch (PackageManager.NameNotFoundException e) {
                    return false;
                }
            }
        });
        this.enterpriseHint = (LinearLayout)this.findViewById(2131624045);
        this.EnterYourEmail = (TextView)this.findViewById(2131624062);
        this.signupHint.setOnClickListener(this.signupHintClickListener);
        this.loginHint.setOnClickListener(this.loginHintClickListener);
        this.signupBtn = (Button)this.findViewById(2131624056);
        this.signupBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                new LoginTask().execute(new Void[]{null});
            }
        });
        TextView version = (TextView)this.findViewById(2131624068);
        try {
            version.setText((CharSequence)("Version " + this.getPackageManager().getPackageInfo((String)this.getPackageName(), (int)0).versionName));
        }
        catch (PackageManager.NameNotFoundException e) {
            version.setVisibility(8);
        }
        Typeface LatoRegular = Typeface.createFromAsset((AssetManager)this.getAssets(), (String)"Lato-Regular.ttf");
        Typeface LatoLightItalic = Typeface.createFromAsset((AssetManager)this.getAssets(), (String)"Lato-LightItalic.ttf");
        for (i2 = 0; i2 < this.signupHint.getChildCount(); ++i2) {
            v2 = this.signupHint.getChildAt(i2);
            if (!(v2 instanceof TextView)) continue;
            ((TextView)v2).setTypeface(LatoRegular);
        }
        for (i2 = 0; i2 < this.loginHint.getChildCount(); ++i2) {
            v2 = this.loginHint.getChildAt(i2);
            if (!(v2 instanceof TextView)) continue;
            ((TextView)v2).setTypeface(LatoRegular);
        }
        LinearLayout IRCCloud = (LinearLayout)this.findViewById(2131624042);
        for (i = 0; i < IRCCloud.getChildCount(); ++i) {
            v = IRCCloud.getChildAt(i);
            if (!(v instanceof TextView)) continue;
            ((TextView)v).setTypeface(LatoRegular);
        }
        this.notAProblem = (LinearLayout)this.findViewById(2131624049);
        for (i = 0; i < this.notAProblem.getChildCount(); ++i) {
            v = this.notAProblem.getChildAt(i);
            if (!(v instanceof TextView)) continue;
            ((TextView)v).setTypeface(i == 0 ? LatoRegular : LatoLightItalic);
        }
        this.loginSignupHint = (LinearLayout)this.findViewById(2131624047);
        for (i = 0; i < this.loginSignupHint.getChildCount(); ++i) {
            v = this.loginSignupHint.getChildAt(i);
            if (!(v instanceof TextView)) continue;
            ((TextView)v).setTypeface(LatoRegular);
            ((TextView)v).setOnClickListener(i == 0 ? this.loginHintClickListener : this.signupHintClickListener);
        }
        this.name.setTypeface(LatoRegular);
        this.email.setTypeface(LatoRegular);
        this.password.setTypeface(LatoRegular);
        this.host.setTypeface(LatoRegular);
        this.loginBtn.setTypeface(LatoRegular);
        this.signupBtn.setTypeface(LatoRegular);
        this.TOS.setTypeface(LatoRegular);
        this.EnterYourEmail.setTypeface(LatoRegular);
        this.hostHint.setTypeface(LatoLightItalic);
        if (savedInstanceState != null && savedInstanceState.containsKey("signup") && savedInstanceState.getBoolean("signup")) {
            this.signupHintClickListener.onClick(null);
        }
        if (savedInstanceState != null && savedInstanceState.containsKey("login") && savedInstanceState.getBoolean("login")) {
            this.loginHintClickListener.onClick(null);
        }
        if (savedInstanceState != null && savedInstanceState.containsKey("forgotPassword") && savedInstanceState.getBoolean("forgotPassword")) {
            this.forgotPasswordClickListener.onClick(null);
        }
        this.mResolvingError = savedInstanceState != null && savedInstanceState.getBoolean("resolving_error", false);
        this.mGoogleApiClient = new GoogleApiClient.Builder((Context)this).addApi(Auth.CREDENTIALS_API).addConnectionCallbacks(this).addOnConnectionFailedListener(this).build();
    }

    @Override
    public void onSaveInstanceState(Bundle state) {
        super.onSaveInstanceState(state);
        if (this.login != null && this.login.getVisibility() == 0) {
            if (this.email != null) {
                state.putString("email", this.email.getText().toString());
            }
            if (this.password != null) {
                state.putString("password", this.password.getText().toString());
            }
            if (this.host != null) {
                state.putString("host", this.host.getText().toString());
            }
            if (this.name != null) {
                state.putString("name", this.name.getText().toString());
            }
            if (this.signupBtn != null) {
                state.putBoolean("signup", this.signupBtn.getVisibility() == 0);
            }
            if (this.loginBtn != null) {
                state.putBoolean("login", this.loginBtn.getVisibility() == 0);
            }
            if (this.sendAccessLinkBtn != null) {
                state.putBoolean("forgotPassword", this.sendAccessLinkBtn.getVisibility() == 0);
            }
        }
        state.putBoolean("resolving_error", this.mResolvingError);
    }

    @Override
    public void onResume() {
        super.onResume();
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)this);
        if (prefs.getBoolean("screenlock", false)) {
            this.getWindow().addFlags(128);
        } else {
            this.getWindow().clearFlags(128);
        }
    }

    private void login_or_connect() {
        if (NetworkConnection.IRCCLOUD_HOST != null && NetworkConnection.IRCCLOUD_HOST.length() > 0 && this.getIntent() != null && this.getIntent().getData() != null && this.getIntent().getData().getPath().endsWith("/access-link")) {
            NetworkConnection.getInstance().logout();
            new AccessLinkTask().execute("https://" + NetworkConnection.IRCCLOUD_HOST + "/chat/access-link?" + this.getIntent().getData().getEncodedQuery().replace("&mobile=1", "") + "&format=json");
            this.setIntent(new Intent((Context)this, LoginActivity.class));
        } else if (this.getIntent() != null && this.getIntent().getData() != null && this.getIntent().getData().getHost().equals("referral")) {
            new ImpressionTask().execute(this.getIntent().getDataString().substring(this.getIntent().getData().getScheme().length() + this.getIntent().getData().getHost().length() + 4));
            if (this.getSharedPreferences("prefs", 0).contains("session_key")) {
                Intent i = new Intent((Context)this, MainActivity.class);
                this.startActivity(i);
                this.finish();
            }
        } else if (this.getSharedPreferences("prefs", 0).contains("session_key")) {
            Intent i = new Intent((Context)this, MainActivity.class);
            if (this.getIntent() != null) {
                if (this.getIntent().getData() != null) {
                    i.setData(this.getIntent().getData());
                }
                if (this.getIntent().getExtras() != null) {
                    i.putExtras(this.getIntent().getExtras());
                }
            }
            this.startActivity(i);
            this.finish();
        } else if (this.mGoogleApiClient.isConnected()) {
            Log.e((String)"IRCCloud", (String)"Play Services connected");
            CredentialRequest request = new CredentialRequest.Builder().setAccountTypes("https://" + NetworkConnection.IRCCLOUD_HOST).setSupportsPasswordLogin(true).build();
            Auth.CredentialsApi.request(this.mGoogleApiClient, request).setResultCallback(new ResultCallback<CredentialRequestResult>(){

                @Override
                public void onResult(CredentialRequestResult result) {
                    if (result.getStatus().isSuccess()) {
                        Log.e((String)"IRCCloud", (String)"Credentials request succeeded");
                        LoginActivity.this.email.setText((CharSequence)result.getCredential().getId());
                        LoginActivity.this.password.setText((CharSequence)result.getCredential().getPassword());
                        LoginActivity.this.loginHintClickListener.onClick(null);
                        new LoginTask().execute(new Void[]{null});
                    } else if (result.getStatus().getStatusCode() == 4) {
                        Log.e((String)"IRCCloud", (String)"Credentials request sign in");
                        LoginActivity.this.loading.setVisibility(8);
                        LoginActivity.this.connecting.setVisibility(8);
                        LoginActivity.this.login.setVisibility(0);
                    } else if (result.getStatus().hasResolution()) {
                        Log.e((String)"IRCCloud", (String)"Credentials request requires resolution");
                        try {
                            LoginActivity.this.startIntentSenderForResult(result.getStatus().getResolution().getIntentSender(), 1002, null, 0, 0, 0);
                        }
                        catch (IntentSender.SendIntentException e) {
                            e.printStackTrace();
                            LoginActivity.this.loading.setVisibility(8);
                            LoginActivity.this.connecting.setVisibility(8);
                            LoginActivity.this.login.setVisibility(0);
                        }
                    } else {
                        Log.e((String)"IRCCloud", (String)"Credentials request failed");
                        LoginActivity.this.loading.setVisibility(8);
                        LoginActivity.this.connecting.setVisibility(8);
                        LoginActivity.this.login.setVisibility(0);
                    }
                }
            });
        } else {
            this.loading.setVisibility(8);
            this.connecting.setVisibility(8);
            this.login.setVisibility(0);
        }
    }

    @Override
    protected void onStart() {
        super.onStart();
        if (!this.mResolvingError) {
            this.mGoogleApiClient.connect();
        }
    }

    @Override
    protected void onStop() {
        this.mGoogleApiClient.disconnect();
        super.onStop();
    }

    @Override
    public void onConnected(Bundle connectionHint) {
        this.login_or_connect();
    }

    @Override
    public void onConnectionSuspended(int cause) {
    }

    @Override
    public void onConnectionFailed(ConnectionResult result) {
        if (this.mResolvingError) {
            return;
        }
        if (result.hasResolution()) {
            try {
                this.mResolvingError = true;
                result.startResolutionForResult(this, 1001);
            }
            catch (IntentSender.SendIntentException e) {
                this.mGoogleApiClient.connect();
            }
        } else {
            if (GooglePlayServicesUtil.isUserRecoverableError(result.getErrorCode())) {
                GooglePlayServicesUtil.getErrorDialog(result.getErrorCode(), this, 1001).show();
                this.mResolvingError = true;
            }
            this.login_or_connect();
        }
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 1001) {
            this.mResolvingError = false;
            if (resultCode == -1 && !this.mGoogleApiClient.isConnecting() && !this.mGoogleApiClient.isConnected()) {
                this.mGoogleApiClient.connect();
            }
        } else if (requestCode == 1002) {
            if (resultCode == -1 && data.hasExtra("com.google.android.gms.credentials.Credential")) {
                Credential c = (Credential)data.getParcelableExtra("com.google.android.gms.credentials.Credential");
                this.name.setText((CharSequence)c.getName());
                this.email.setText((CharSequence)c.getId());
                this.password.setText((CharSequence)c.getPassword());
                this.loading.setVisibility(8);
                this.login.setVisibility(0);
                this.loginHintClickListener.onClick(null);
                new LoginTask().execute(new Void[]{null});
            } else {
                this.loading.setVisibility(8);
                this.login.setVisibility(0);
            }
        } else if (requestCode == 1003) {
            if (resultCode == -1) {
                Log.e((String)"IRCCloud", (String)"Credentials result: OK");
            }
            Intent i = new Intent((Context)this, MainActivity.class);
            i.setFlags(0x10000000);
            if (Build.VERSION.SDK_INT < 14) {
                i.addFlags(0x800000);
            }
            if (this.getIntent() != null) {
                if (this.getIntent().getData() != null) {
                    i.setData(this.getIntent().getData());
                }
                if (this.getIntent().getExtras() != null) {
                    i.putExtras(this.getIntent().getExtras());
                }
            }
            this.startActivity(i);
            this.finish();
        }
    }

    private void trimHost() {
        if (NetworkConnection.IRCCLOUD_HOST.startsWith("http://")) {
            NetworkConnection.IRCCLOUD_HOST = NetworkConnection.IRCCLOUD_HOST.substring(7);
        }
        if (NetworkConnection.IRCCLOUD_HOST.startsWith("https://")) {
            NetworkConnection.IRCCLOUD_HOST = NetworkConnection.IRCCLOUD_HOST.substring(8);
        }
        if (NetworkConnection.IRCCLOUD_HOST.endsWith("/")) {
            NetworkConnection.IRCCLOUD_HOST = NetworkConnection.IRCCLOUD_HOST.substring(0, NetworkConnection.IRCCLOUD_HOST.length() - 1);
        }
    }

    private class EnterpriseConfigTask
    extends AsyncTaskEx<Void, Void, JSONObject> {
        private EnterpriseConfigTask() {
        }

        @Override
        public void onPreExecute() {
            LoginActivity.this.host.setEnabled(false);
            LoginActivity.this.connectingMsg.setText((CharSequence)"Connecting");
            LoginActivity.this.progressBar.setIndeterminate(true);
            LoginActivity.this.connecting.setVisibility(0);
            LoginActivity.this.login.setVisibility(8);
            LoginActivity.this.loading.setVisibility(8);
        }

        protected JSONObject doInBackground(Void ... arg0) {
            try {
                return NetworkConnection.getInstance().fetchJSON("https://" + NetworkConnection.IRCCLOUD_HOST + "/config");
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }

        @Override
        public void onPostExecute(JSONObject result) {
            LoginActivity.this.host.setEnabled(true);
            LoginActivity.this.progressBar.setIndeterminate(false);
            LoginActivity.this.connecting.setVisibility(8);
            LoginActivity.this.login.setVisibility(0);
            try {
                if (result != null && result.get("enterprise") instanceof JSONObject) {
                    NetworkConnection.IRCCLOUD_HOST = result.getString("api_host");
                    LoginActivity.this.trimHost();
                    SharedPreferences.Editor editor = LoginActivity.this.getSharedPreferences("prefs", 0).edit();
                    editor.putString("host", NetworkConnection.IRCCLOUD_HOST);
                    editor.commit();
                    if (result.getString("auth_mechanism").equals("internal")) {
                        LoginActivity.this.loginSignupHint.getChildAt(1).setVisibility(0);
                    } else {
                        LoginActivity.this.loginSignupHint.getChildAt(1).setVisibility(8);
                    }
                    if (((JSONObject)result.get("enterprise")).has("fullname")) {
                        ((TextView)LoginActivity.this.findViewById(2131624046)).setText((CharSequence)((JSONObject)result.get("enterprise")).getString("fullname"));
                    }
                    if (NetworkConnection.IRCCLOUD_HOST != null && NetworkConnection.IRCCLOUD_HOST.length() > 0 && LoginActivity.this.getIntent() != null && LoginActivity.this.getIntent().getData() != null && LoginActivity.this.getIntent().getData().getPath().endsWith("/access-link")) {
                        NetworkConnection.getInstance().logout();
                        new AccessLinkTask().execute("https://" + NetworkConnection.IRCCLOUD_HOST + "/chat/access-link?" + LoginActivity.this.getIntent().getData().getEncodedQuery().replace("&mobile=1", "") + "&format=json");
                        LoginActivity.this.setIntent(new Intent((Context)LoginActivity.this, LoginActivity.class));
                    } else {
                        LoginActivity.this.loginHintClickListener.onClick(null);
                    }
                    return;
                }
            }
            catch (JSONException editor) {
                // empty catch block
            }
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)LoginActivity.this);
            builder.setInverseBackgroundForced(Build.VERSION.SDK_INT < 11);
            builder.setTitle("Connection Failed");
            builder.setMessage("Please check your host and try again shortly, or contact your system administrator for assistance.");
            builder.setNegativeButton("Ok", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                }
            });
            AlertDialog dialog = builder.create();
            dialog.setOwnerActivity(LoginActivity.this);
            try {
                dialog.show();
            }
            catch (WindowManager.BadTokenException badTokenException) {
                // empty catch block
            }
        }
    }

    private class ResetPasswordTask
    extends AsyncTaskEx<Void, Void, JSONObject> {
        private ResetPasswordTask() {
        }

        @Override
        public void onPreExecute() {
            LoginActivity.this.email.setEnabled(false);
            LoginActivity.this.sendAccessLinkBtn.setEnabled(false);
            LoginActivity.this.connectingMsg.setText((CharSequence)"Requesting Access Link");
            LoginActivity.this.progressBar.setIndeterminate(true);
            LoginActivity.this.connecting.setVisibility(0);
            LoginActivity.this.login.setVisibility(8);
            LoginActivity.this.loading.setVisibility(8);
        }

        protected JSONObject doInBackground(Void ... arg0) {
            return NetworkConnection.getInstance().request_password(LoginActivity.this.email.getText().toString());
        }

        @Override
        public void onPostExecute(JSONObject result) {
            block6: {
                LoginActivity.this.email.setEnabled(true);
                LoginActivity.this.sendAccessLinkBtn.setEnabled(true);
                LoginActivity.this.progressBar.setIndeterminate(false);
                LoginActivity.this.connecting.setVisibility(8);
                LoginActivity.this.login.setVisibility(0);
                try {
                    if (result == null || !result.has("success") || !result.getBoolean("success")) break block6;
                    AlertDialog.Builder builder = new AlertDialog.Builder((Context)LoginActivity.this);
                    builder.setInverseBackgroundForced(Build.VERSION.SDK_INT < 11);
                    builder.setTitle("Access Link");
                    builder.setMessage("We've sent you an access link.  Check your email and follow the instructions to sign in.");
                    builder.setNegativeButton("Ok", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            LoginActivity.this.loginHintClickListener.onClick(null);
                            dialog.dismiss();
                        }
                    });
                    AlertDialog dialog = builder.create();
                    dialog.setOwnerActivity(LoginActivity.this);
                    try {
                        dialog.show();
                    }
                    catch (WindowManager.BadTokenException badTokenException) {
                        // empty catch block
                    }
                    return;
                }
                catch (JSONException builder) {
                    // empty catch block
                }
            }
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)LoginActivity.this);
            builder.setInverseBackgroundForced(Build.VERSION.SDK_INT < 11);
            builder.setTitle("Password Reset Failed");
            builder.setMessage("Unable to request a password reset.  Please try again later.");
            builder.setNegativeButton("Ok", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                }
            });
            AlertDialog dialog = builder.create();
            dialog.setOwnerActivity(LoginActivity.this);
            try {
                dialog.show();
            }
            catch (WindowManager.BadTokenException badTokenException) {
                // empty catch block
            }
        }
    }

    private class AccessLinkTask
    extends AsyncTaskEx<String, Void, JSONObject> {
        private AccessLinkTask() {
        }

        @Override
        public void onPreExecute() {
            LoginActivity.this.name.setEnabled(false);
            LoginActivity.this.email.setEnabled(false);
            LoginActivity.this.password.setEnabled(false);
            LoginActivity.this.host.setEnabled(false);
            LoginActivity.this.loginHint.setEnabled(false);
            LoginActivity.this.signupHint.setEnabled(false);
            LoginActivity.this.loginBtn.setEnabled(false);
            LoginActivity.this.signupBtn.setEnabled(false);
            LoginActivity.this.connectingMsg.setText((CharSequence)"Signing in");
            LoginActivity.this.progressBar.setIndeterminate(true);
            LoginActivity.this.connecting.setVisibility(0);
            LoginActivity.this.login.setVisibility(8);
            LoginActivity.this.loading.setVisibility(8);
        }

        protected JSONObject doInBackground(String ... arg0) {
            try {
                return NetworkConnection.getInstance().fetchJSON(arg0[0]);
            }
            catch (IOException e) {
                return null;
            }
        }

        @Override
        public void onPostExecute(JSONObject result) {
            if (result != null && result.has("session")) {
                try {
                    SharedPreferences.Editor editor = LoginActivity.this.getSharedPreferences("prefs", 0).edit();
                    editor.putString("session_key", result.getString("session"));
                    if (result.has("websocket_host")) {
                        NetworkConnection.IRCCLOUD_HOST = result.getString("websocket_host");
                        NetworkConnection.IRCCLOUD_PATH = result.getString("websocket_path");
                    }
                    editor.putString("host", NetworkConnection.IRCCLOUD_HOST);
                    editor.putString("path", NetworkConnection.IRCCLOUD_PATH);
                    editor.commit();
                    Intent i = new Intent((Context)LoginActivity.this, MainActivity.class);
                    if (LoginActivity.this.getIntent() != null) {
                        if (LoginActivity.this.getIntent().getData() != null) {
                            i.setData(LoginActivity.this.getIntent().getData());
                        }
                        if (LoginActivity.this.getIntent().getExtras() != null) {
                            i.putExtras(LoginActivity.this.getIntent().getExtras());
                        }
                    }
                    LoginActivity.this.startActivity(i);
                    LoginActivity.this.finish();
                    Answers.getInstance().logEvent("login", new EventAttributes().put("method", "access-link"));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            } else {
                LoginActivity.this.name.setEnabled(true);
                LoginActivity.this.email.setEnabled(true);
                LoginActivity.this.password.setEnabled(true);
                LoginActivity.this.host.setEnabled(true);
                LoginActivity.this.loginBtn.setEnabled(true);
                LoginActivity.this.signupBtn.setEnabled(true);
                LoginActivity.this.loginHint.setEnabled(true);
                LoginActivity.this.signupHint.setEnabled(true);
                LoginActivity.this.connecting.setVisibility(8);
                LoginActivity.this.login.setVisibility(0);
                AlertDialog.Builder builder = new AlertDialog.Builder((Context)LoginActivity.this);
                builder.setInverseBackgroundForced(Build.VERSION.SDK_INT < 11);
                builder.setTitle("Login Failed");
                builder.setMessage("Invalid access link");
                builder.setNegativeButton("Ok", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                    }
                });
                AlertDialog dialog = builder.create();
                dialog.setOwnerActivity(LoginActivity.this);
                try {
                    dialog.show();
                }
                catch (WindowManager.BadTokenException badTokenException) {
                    // empty catch block
                }
            }
        }
    }

    private class ImpressionTask
    extends AsyncTaskEx<String, Void, JSONObject> {
        private ImpressionTask() {
        }

        protected JSONObject doInBackground(String ... arg0) {
            try {
                return NetworkConnection.getInstance().impression(AdvertisingIdClient.getAdvertisingIdInfo((Context)LoginActivity.this).getId(), arg0[0], LoginActivity.this.getSharedPreferences("prefs", 0).getString("session_key", ""));
            }
            catch (IOException iOException) {
            }
            catch (GooglePlayServicesNotAvailableException e) {
                e.printStackTrace();
            }
            catch (GooglePlayServicesRepairableException e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        public void onPostExecute(JSONObject result) {
            if (result != null && result.has("success")) {
                try {
                    if (result.getBoolean("success")) {
                        LoginActivity.this.impression_id = result.getString("id");
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private class LoginTask
    extends AsyncTaskEx<Void, Void, JSONObject> {
        private LoginTask() {
        }

        @Override
        public void onPreExecute() {
            LoginActivity.this.name.setEnabled(false);
            LoginActivity.this.email.setEnabled(false);
            LoginActivity.this.password.setEnabled(false);
            LoginActivity.this.host.setEnabled(false);
            LoginActivity.this.loginHint.setEnabled(false);
            LoginActivity.this.signupHint.setEnabled(false);
            SharedPreferences.Editor editor = LoginActivity.this.getSharedPreferences("prefs", 0).edit();
            editor.putString("host", NetworkConnection.IRCCLOUD_HOST);
            editor.commit();
            LoginActivity.this.loginBtn.setEnabled(false);
            LoginActivity.this.signupBtn.setEnabled(false);
            if (LoginActivity.this.name.getVisibility() == 0) {
                LoginActivity.this.connectingMsg.setText((CharSequence)"Creating Account");
            } else {
                LoginActivity.this.connectingMsg.setText((CharSequence)"Signing in");
            }
            LoginActivity.this.progressBar.setIndeterminate(true);
            LoginActivity.this.connecting.setVisibility(0);
            LoginActivity.this.login.setVisibility(8);
            LoginActivity.this.loading.setVisibility(8);
        }

        protected JSONObject doInBackground(Void ... arg0) {
            try {
                NetworkConnection.IRCCLOUD_HOST = "api.irccloud.com";
                JSONObject config = NetworkConnection.getInstance().fetchConfig();
                NetworkConnection.IRCCLOUD_HOST = config.getString("api_host");
                LoginActivity.this.trimHost();
            }
            catch (Exception e) {
                return null;
            }
            if (LoginActivity.this.name.getVisibility() == 0) {
                if (LoginActivity.this.name.getText() != null && LoginActivity.this.name.getText().length() > 0 && LoginActivity.this.email.getText() != null && LoginActivity.this.email.getText().length() > 0 && LoginActivity.this.password.getText() != null && LoginActivity.this.password.getText().length() > 0) {
                    return NetworkConnection.getInstance().signup(LoginActivity.this.name.getText().toString(), LoginActivity.this.email.getText().toString(), LoginActivity.this.password.getText().toString(), LoginActivity.this.impression_id != null ? LoginActivity.this.impression_id : "");
                }
                return null;
            }
            if (LoginActivity.this.email.getText() != null && LoginActivity.this.email.getText().length() > 0 && LoginActivity.this.password.getText() != null && LoginActivity.this.password.getText().length() > 0) {
                return NetworkConnection.getInstance().login(LoginActivity.this.email.getText().toString(), LoginActivity.this.password.getText().toString());
            }
            return null;
        }

        @Override
        public void onPostExecute(JSONObject result) {
            block24: {
                if (result != null && result.has("session")) {
                    try {
                        SharedPreferences.Editor editor = LoginActivity.this.getSharedPreferences("prefs", 0).edit();
                        editor.putString("session_key", result.getString("session"));
                        if (result.has("websocket_host")) {
                            NetworkConnection.IRCCLOUD_HOST = result.getString("websocket_host");
                            NetworkConnection.IRCCLOUD_PATH = result.getString("websocket_path");
                        }
                        editor.putString("host", NetworkConnection.IRCCLOUD_HOST);
                        editor.putString("path", NetworkConnection.IRCCLOUD_PATH);
                        editor.commit();
                        final Intent i = new Intent((Context)LoginActivity.this, MainActivity.class);
                        i.setFlags(0x10000000);
                        if (Build.VERSION.SDK_INT < 14) {
                            i.addFlags(0x800000);
                        }
                        if (LoginActivity.this.getIntent() != null) {
                            if (LoginActivity.this.getIntent().getData() != null) {
                                i.setData(LoginActivity.this.getIntent().getData());
                            }
                            if (LoginActivity.this.getIntent().getExtras() != null) {
                                i.putExtras(LoginActivity.this.getIntent().getExtras());
                            }
                        }
                        if (LoginActivity.this.mGoogleApiClient.isConnected()) {
                            Credential.Builder builder = new Credential.Builder(LoginActivity.this.email.getText().toString()).setPassword(LoginActivity.this.password.getText().toString());
                            if (LoginActivity.this.name.getText() != null && LoginActivity.this.name.getText().length() > 0) {
                                builder.setName(LoginActivity.this.name.getText().toString());
                            }
                            Auth.CredentialsApi.save(LoginActivity.this.mGoogleApiClient, builder.build()).setResultCallback(new ResultCallback<Status>(){

                                @Override
                                public void onResult(Status status) {
                                    if (status.isSuccess()) {
                                        Log.e((String)"IRCCloud", (String)"Credentials saved");
                                        LoginActivity.this.startActivity(i);
                                        LoginActivity.this.finish();
                                    } else if (status.hasResolution()) {
                                        Log.e((String)"IRCCloud", (String)"Credentials require resolution");
                                        try {
                                            LoginActivity.this.startIntentSenderForResult(status.getResolution().getIntentSender(), 1003, null, 0, 0, 0);
                                        }
                                        catch (IntentSender.SendIntentException e) {
                                            e.printStackTrace();
                                            LoginActivity.this.startActivity(i);
                                            LoginActivity.this.finish();
                                        }
                                    }
                                }
                            });
                        } else {
                            LoginActivity.this.startActivity(i);
                            LoginActivity.this.finish();
                        }
                        if (LoginActivity.this.name.getVisibility() == 0) {
                            Answers.getInstance().logEvent("signup", new EventAttributes().put("method", "email"));
                            break block24;
                        }
                        Answers.getInstance().logEvent("login", new EventAttributes().put("method", "email"));
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                } else {
                    LoginActivity.this.name.setEnabled(true);
                    LoginActivity.this.email.setEnabled(true);
                    LoginActivity.this.password.setEnabled(true);
                    LoginActivity.this.host.setEnabled(true);
                    LoginActivity.this.loginBtn.setEnabled(true);
                    LoginActivity.this.signupBtn.setEnabled(true);
                    LoginActivity.this.loginHint.setEnabled(true);
                    LoginActivity.this.signupHint.setEnabled(true);
                    LoginActivity.this.connecting.setVisibility(8);
                    LoginActivity.this.login.setVisibility(0);
                    AlertDialog.Builder builder = new AlertDialog.Builder((Context)LoginActivity.this);
                    builder.setInverseBackgroundForced(Build.VERSION.SDK_INT < 11);
                    if (LoginActivity.this.name.getVisibility() == 0) {
                        builder.setTitle("Sign Up Failed");
                    } else {
                        builder.setTitle("Login Failed");
                    }
                    String message = "Unable to connect to IRCCloud.  Please try again later.";
                    if (result != null) {
                        try {
                            if (result.has("message")) {
                                message = result.getString("message");
                                message = message.equalsIgnoreCase("auth") || message.equalsIgnoreCase("email") || message.equalsIgnoreCase("password") || message.equalsIgnoreCase("legacy_account") ? (LoginActivity.this.name.getVisibility() == 0 ? "Invalid email address or password.  Please try again." : "Incorrect username or password.  Please try again.") : (message.equals("json_error") ? "Invalid response received from the server.  Please try again shortly." : (message.equals("invalid_response") ? "Unexpected response received from the server.  Check your network settings and try again shortly." : (message.equals("empty_response") ? "The server did not respond.  Check your network settings and try again shortly." : (message.equals("realname") ? "Please enter a valid name and try again." : (message.equals("email_exists") ? "This email address is already in use, please sign in or try another." : (message.equals("rate_limited") ? "Rate limited, please try again in a few minutes." : (message.equals("password_error") ? "Invalid password, try again." : (message.equals("banned") || message.equals("ip_banned") ? "Signup server unavailable, please try again later." : (message.equals("bad_email") ? "No signups allowed from that domain." : (message.equals("tor_blocked") ? "No signups allowed from TOR exit nodes" : (message.equals("signup_ip_blocked") ? "Your IP address has been blacklisted" : "Error: " + message)))))))))));
                            }
                            if (LoginActivity.this.mGoogleApiClient.isConnected()) {
                                Auth.CredentialsApi.delete(LoginActivity.this.mGoogleApiClient, new Credential.Builder(LoginActivity.this.email.getText().toString()).setPassword(LoginActivity.this.password.getText().toString()).build()).setResultCallback(new ResultCallback<Status>(){

                                    @Override
                                    public void onResult(Status status) {
                                    }
                                });
                            }
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                        }
                    } else if (LoginActivity.this.name.getVisibility() == 0 && (LoginActivity.this.name.getText() == null || LoginActivity.this.name.getText().length() == 0) || LoginActivity.this.email.getText() == null || LoginActivity.this.email.getText().length() == 0 || LoginActivity.this.password.getText() == null || LoginActivity.this.password.getText().length() == 0) {
                        message = LoginActivity.this.name.getVisibility() == 0 ? "Please enter your name, email address, and password." : "Please enter your username and password.";
                    }
                    builder.setMessage(message);
                    builder.setNegativeButton("Ok", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            dialog.dismiss();
                        }
                    });
                    AlertDialog dialog = builder.create();
                    dialog.setOwnerActivity(LoginActivity.this);
                    try {
                        dialog.show();
                    }
                    catch (WindowManager.BadTokenException badTokenException) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

