/*
 * Decompiled with CFR 0.152.
 */
package com.irccloud.android.activity;

import android.animation.TimeInterpolator;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.ComponentName;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.net.Uri;
import android.nfc.NdefMessage;
import android.nfc.NdefRecord;
import android.nfc.NfcAdapter;
import android.os.Build;
import android.os.Bundle;
import android.os.Debug;
import android.os.Environment;
import android.os.Looper;
import android.os.Parcelable;
import android.os.PowerManager;
import android.preference.PreferenceManager;
import android.provider.MediaStore;
import android.support.v4.app.NotificationCompat;
import android.support.v4.app.NotificationManagerCompat;
import android.support.v4.widget.DrawerLayout;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.Toolbar;
import android.text.Editable;
import android.text.Spannable;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.method.LinkMovementMethod;
import android.text.method.MovementMethod;
import android.text.style.BackgroundColorSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.StyleSpan;
import android.text.style.URLSpan;
import android.text.style.UnderlineSpan;
import android.util.Log;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.EditText;
import android.widget.GridView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import com.crashlytics.android.Crashlytics;
import com.fasterxml.jackson.databind.JsonNode;
import com.irccloud.android.ActionEditText;
import com.irccloud.android.AsyncTaskEx;
import com.irccloud.android.BuildConfig;
import com.irccloud.android.ColorFormatter;
import com.irccloud.android.DrawerArrowDrawable;
import com.irccloud.android.IRCCloudApplication;
import com.irccloud.android.IRCCloudJSONObject;
import com.irccloud.android.NetworkConnection;
import com.irccloud.android.Notifications;
import com.irccloud.android.activity.BaseActivity;
import com.irccloud.android.activity.EditConnectionActivity;
import com.irccloud.android.activity.ImgurAuthActivity;
import com.irccloud.android.activity.LoginActivity;
import com.irccloud.android.activity.PastebinsActivity;
import com.irccloud.android.activity.ServerReorderActivity;
import com.irccloud.android.activity.UploadsActivity;
import com.irccloud.android.data.BuffersDataSource;
import com.irccloud.android.data.ChannelsDataSource;
import com.irccloud.android.data.EventsDataSource;
import com.irccloud.android.data.ServersDataSource;
import com.irccloud.android.data.UsersDataSource;
import com.irccloud.android.fragment.AcceptListFragment;
import com.irccloud.android.fragment.BufferOptionsFragment;
import com.irccloud.android.fragment.BuffersListFragment;
import com.irccloud.android.fragment.ChannelListFragment;
import com.irccloud.android.fragment.ChannelModeListFragment;
import com.irccloud.android.fragment.ChannelOptionsFragment;
import com.irccloud.android.fragment.EditConnectionFragment;
import com.irccloud.android.fragment.IgnoreListFragment;
import com.irccloud.android.fragment.MessageViewFragment;
import com.irccloud.android.fragment.NamesListFragment;
import com.irccloud.android.fragment.NickservFragment;
import com.irccloud.android.fragment.PastebinEditorFragment;
import com.irccloud.android.fragment.ServerMapListFragment;
import com.irccloud.android.fragment.ServerReorderFragment;
import com.irccloud.android.fragment.UsersListFragment;
import com.irccloud.android.fragment.WhoListFragment;
import com.irccloud.android.fragment.WhoisFragment;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Scanner;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public class MainActivity
extends BaseActivity
implements NetworkConnection.IRCEventHandler,
BuffersListFragment.OnBufferSelectedListener,
MessageViewFragment.MessageViewListener,
PastebinEditorFragment.PastebinEditorListener,
UsersListFragment.OnUserSelectedListener {
    BuffersDataSource.Buffer buffer;
    ServersDataSource.Server server;
    ActionEditText messageTxt;
    View sendBtn;
    UsersDataSource.User selected_user;
    View userListView;
    View buffersListView;
    TextView title;
    TextView subtitle;
    ImageView key;
    LinearLayout messageContainer;
    DrawerLayout drawerLayout;
    NetworkConnection conn;
    private boolean shouldFadeIn = false;
    private RefreshUpIndicatorTask refreshUpIndicatorTask = null;
    private ShowNotificationsTask showNotificationsTask = null;
    private ArrayList<Integer> backStack = new ArrayList();
    PowerManager.WakeLock screenLock = null;
    private int launchBid = -1;
    private Uri launchURI = null;
    private AlertDialog channelsListDialog;
    String bufferToOpen = null;
    int cidToOpen = -1;
    private Uri imageCaptureURI = null;
    private ProgressBar progressBar;
    private TextView errorMsg = null;
    private static Timer countdownTimer = null;
    private TimerTask countdownTimerTask = null;
    private String error = null;
    private TextWatcher textWatcher = null;
    private SuggestionsAdapter suggestionsAdapter;
    private View suggestionsContainer;
    private GridView suggestions;
    private static Timer suggestionsTimer = null;
    private TimerTask suggestionsTimerTask = null;
    private ArrayList<UsersDataSource.User> sortedUsers = null;
    private ArrayList<ChannelsDataSource.Channel> sortedChannels = null;
    private ImgurUploadTask imgurTask = null;
    private FileUploadTask fileUploadTask = null;
    private DrawerArrowDrawable upDrawable;
    private int redColor;
    private int blueColor;
    private int greyColor = 0;
    private HashMap<Integer, EventsDataSource.Event> pendingEvents = new HashMap();
    private ToggleListener mDrawerListener = new ToggleListener();
    private ScreenReceiver screenReceiver = new ScreenReceiver();

    @Override
    @SuppressLint(value={"NewApi"})
    public void onCreate(Bundle savedInstanceState) {
        Bitmap cloud22;
        super.onCreate(savedInstanceState);
        suggestionsTimer = new Timer("suggestions-timer");
        countdownTimer = new Timer("messsage-countdown-timer");
        IntentFilter filter = new IntentFilter("android.intent.action.SCREEN_ON");
        filter.addAction("android.intent.action.SCREEN_OFF");
        this.registerReceiver(this.screenReceiver, filter);
        if (Build.VERSION.SDK_INT >= 21 && (cloud22 = BitmapFactory.decodeResource((Resources)this.getResources(), (int)2130837620)) != null) {
            this.setTaskDescription(new ActivityManager.TaskDescription(this.getResources().getString(2131165254), cloud22, -854020));
            cloud22.recycle();
        }
        this.setContentView(2130903076);
        try {
            this.setSupportActionBar((Toolbar)this.findViewById(2131624039));
        }
        catch (Throwable cloud22) {
            // empty catch block
        }
        this.suggestionsAdapter = new SuggestionsAdapter();
        this.progressBar = (ProgressBar)this.findViewById(2131624038);
        this.errorMsg = (TextView)this.findViewById(2131624066);
        this.buffersListView = this.findViewById(2131624075);
        this.messageContainer = (LinearLayout)this.findViewById(2131624070);
        this.drawerLayout = (DrawerLayout)this.findViewById(2131624069);
        this.redColor = this.getResources().getColor(2131492913);
        this.blueColor = this.getResources().getColor(2131492899);
        this.messageTxt = (ActionEditText)this.findViewById(2131624073);
        this.messageTxt.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (MainActivity.this.sendBtn.isEnabled() && NetworkConnection.getInstance().getState() == 2 && event.getAction() == 0 && keyCode == 66 && MainActivity.this.messageTxt.getText() != null && MainActivity.this.messageTxt.getText().length() > 0) {
                    MainActivity.this.sendBtn.setEnabled(false);
                    new SendTask().execute(new Void[]{null});
                } else if (keyCode == 61) {
                    if (event.getAction() == 0) {
                        MainActivity.this.nextSuggestion();
                    }
                    return true;
                }
                return false;
            }
        });
        this.messageTxt.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (MainActivity.this.drawerLayout != null && v == MainActivity.this.messageTxt && hasFocus) {
                    MainActivity.this.drawerLayout.closeDrawers();
                    MainActivity.this.update_suggestions(false);
                } else if (!hasFocus) {
                    MainActivity.this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            MainActivity.this.suggestionsContainer.setVisibility(4);
                        }
                    });
                }
            }
        });
        this.messageTxt.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (MainActivity.this.drawerLayout != null) {
                    MainActivity.this.drawerLayout.closeDrawers();
                }
            }
        });
        this.messageTxt.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView view, int actionId, KeyEvent event) {
                if (MainActivity.this.sendBtn.isEnabled() && NetworkConnection.getInstance().getState() == 2 && actionId == 4 && MainActivity.this.messageTxt.getText() != null && MainActivity.this.messageTxt.getText().length() > 0) {
                    MainActivity.this.sendBtn.setEnabled(false);
                    new SendTask().execute(new Void[]{null});
                }
                return true;
            }
        });
        this.textWatcher = new TextWatcher(){

            public void afterTextChanged(Editable s) {
                String text;
                Object[] spans;
                for (Object o : spans = s.getSpans(0, s.length(), Object.class)) {
                    if ((s.getSpanFlags(o) & 0x100) == 256 || o.getClass() != StyleSpan.class && o.getClass() != ForegroundColorSpan.class && o.getClass() != BackgroundColorSpan.class && o.getClass() != UnderlineSpan.class && o.getClass() != URLSpan.class) continue;
                    s.removeSpan(o);
                }
                if (s.length() > 0 && NetworkConnection.getInstance().getState() == 2) {
                    MainActivity.this.sendBtn.setEnabled(true);
                    if (Build.VERSION.SDK_INT >= 11) {
                        MainActivity.this.sendBtn.setAlpha(1.0f);
                    }
                } else {
                    MainActivity.this.sendBtn.setEnabled(false);
                    if (Build.VERSION.SDK_INT >= 11) {
                        MainActivity.this.sendBtn.setAlpha(0.5f);
                    }
                }
                if ((text = s.toString()).endsWith("\t")) {
                    text = text.substring(0, text.length() - 1);
                    MainActivity.this.messageTxt.setText(text);
                    MainActivity.this.nextSuggestion();
                } else if (MainActivity.this.suggestionsContainer != null && MainActivity.this.suggestionsContainer.getVisibility() == 0) {
                    MainActivity.this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            MainActivity.this.update_suggestions(false);
                        }
                    });
                } else if (suggestionsTimer != null) {
                    if (MainActivity.this.suggestionsTimerTask != null) {
                        MainActivity.this.suggestionsTimerTask.cancel();
                    }
                    MainActivity.this.suggestionsTimerTask = new TimerTask(){

                        @Override
                        public void run() {
                            Thread.currentThread().setPriority(1);
                            MainActivity.this.update_suggestions(false);
                        }
                    };
                    suggestionsTimer.schedule(MainActivity.this.suggestionsTimerTask, 250L);
                }
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }
        };
        this.messageTxt.addTextChangedListener(this.textWatcher);
        this.sendBtn = this.findViewById(2131624074);
        this.sendBtn.setFocusable(false);
        this.sendBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (NetworkConnection.getInstance().getState() == 2) {
                    new SendTask().execute(new Void[]{null});
                }
            }
        });
        View photoBtn = this.findViewById(2131624072);
        if (photoBtn != null) {
            photoBtn.setFocusable(false);
            photoBtn.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    MainActivity.this.insertPhoto();
                }
            });
        }
        this.userListView = this.findViewById(2131624076);
        View v = this.getLayoutInflater().inflate(2130903071, null);
        v.findViewById(2131624031).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MainActivity.this.show_topic_popup();
            }
        });
        if (this.drawerLayout != null && this.findViewById(2131624077) == null) {
            this.upDrawable = new DrawerArrowDrawable(this);
            this.greyColor = this.upDrawable.getColor();
            ((Toolbar)this.findViewById(2131624039)).setNavigationIcon(this.upDrawable);
            ((Toolbar)this.findViewById(2131624039)).setNavigationContentDescription("Show navigation drawer");
            this.drawerLayout.setDrawerListener(this.mDrawerListener);
            if (this.refreshUpIndicatorTask != null) {
                this.refreshUpIndicatorTask.cancel(true);
            }
            this.refreshUpIndicatorTask = new RefreshUpIndicatorTask();
            this.refreshUpIndicatorTask.execute(new Void[]{null});
        }
        this.messageTxt.setDrawerLayout(this.drawerLayout);
        this.title = (TextView)v.findViewById(2131623994);
        this.subtitle = (TextView)v.findViewById(2131624033);
        this.key = (ImageView)v.findViewById(2131624032);
        this.getSupportActionBar().setCustomView(v);
        this.getSupportActionBar().setDisplayShowCustomEnabled(true);
        this.getSupportActionBar().setDisplayShowTitleEnabled(false);
        if (savedInstanceState != null && savedInstanceState.containsKey("cid")) {
            this.server = ServersDataSource.getInstance().getServer(savedInstanceState.getInt("cid"));
            this.buffer = BuffersDataSource.getInstance().getBuffer(savedInstanceState.getInt("bid"));
            this.backStack = (ArrayList)savedInstanceState.getSerializable("backStack");
        }
        this.imageCaptureURI = savedInstanceState != null && savedInstanceState.containsKey("imagecaptureuri") ? Uri.parse((String)savedInstanceState.getString("imagecaptureuri")) : null;
        ConfigInstance config = (ConfigInstance)this.getLastCustomNonConfigurationInstance();
        if (config != null) {
            this.imgurTask = config.imgurUploadTask;
            this.fileUploadTask = config.fileUploadTask;
        }
        this.drawerLayout.setScrimColor(0);
        this.drawerLayout.closeDrawers();
        this.getSupportActionBar().setElevation(0.0f);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        this.unregisterReceiver(this.screenReceiver);
        if (countdownTimer != null) {
            countdownTimer.cancel();
            countdownTimer = null;
        }
        if (suggestionsTimer != null) {
            suggestionsTimer.cancel();
            suggestionsTimer = null;
        }
        if (this.messageTxt != null) {
            this.messageTxt.setDrawerLayout(null);
            if (this.textWatcher != null) {
                this.messageTxt.removeTextChangedListener(this.textWatcher);
            }
            this.messageTxt.setText(null);
        }
        this.textWatcher = null;
        this.fileUploadTask = null;
        this.imgurTask = null;
        for (EventsDataSource.Event e : this.pendingEvents.values()) {
            try {
                if (e.expiration_timer != null) {
                    e.expiration_timer.cancel();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            e.expiration_timer = null;
            e.failed = true;
            e.bg_color = 2131492904;
        }
        this.pendingEvents.clear();
    }

    private void updateReconnecting() {
        if (this.conn == null) {
            return;
        }
        if (this.conn.getState() == 2) {
            this.getSupportActionBar().setTitle("Loading");
        } else if (this.conn.getState() == 1 || this.conn.getReconnectTimestamp() > 0L) {
            this.getSupportActionBar().setDisplayShowCustomEnabled(false);
            this.getSupportActionBar().setDisplayShowTitleEnabled(true);
            this.progressBar.setProgress(0);
            this.progressBar.setIndeterminate(true);
            if (this.progressBar.getVisibility() != 0) {
                if (Build.VERSION.SDK_INT >= 16) {
                    this.progressBar.setAlpha(0.0f);
                    this.progressBar.animate().alpha(1.0f).setDuration(200L);
                }
                this.progressBar.setVisibility(0);
            }
            if (this.conn.getState() == 0 && this.conn.getReconnectTimestamp() > 0L) {
                int seconds = (int)((this.conn.getReconnectTimestamp() - System.currentTimeMillis()) / 1000L);
                if (seconds < 1) {
                    this.getSupportActionBar().setTitle("Connecting");
                    this.errorMsg.setVisibility(8);
                } else if (seconds >= 10) {
                    this.getSupportActionBar().setTitle("Reconnecting in 0:" + seconds);
                    if (this.error != null && this.error.length() > 0) {
                        this.errorMsg.setText((CharSequence)this.error);
                        this.errorMsg.setVisibility(0);
                    } else {
                        this.errorMsg.setVisibility(8);
                        this.error = null;
                    }
                } else {
                    this.getSupportActionBar().setTitle("Reconnecting in 0:0" + seconds);
                    this.errorMsg.setVisibility(8);
                    this.error = null;
                }
                try {
                    if (countdownTimer != null) {
                        if (this.countdownTimerTask != null) {
                            this.countdownTimerTask.cancel();
                        }
                        this.countdownTimerTask = new TimerTask(){

                            @Override
                            public void run() {
                                if (MainActivity.this.conn != null) {
                                    MainActivity.this.runOnUiThread(new Runnable(){

                                        @Override
                                        public void run() {
                                            MainActivity.this.updateReconnecting();
                                        }
                                    });
                                }
                            }
                        };
                        countdownTimer.schedule(this.countdownTimerTask, 1000L);
                    }
                }
                catch (Exception exception) {}
            } else {
                this.getSupportActionBar().setTitle("Connecting");
                this.error = null;
                this.errorMsg.setVisibility(8);
            }
        } else {
            this.getSupportActionBar().setTitle("Offline");
            this.progressBar.setIndeterminate(false);
            this.progressBar.setProgress(0);
            this.getSupportActionBar().setDisplayShowCustomEnabled(false);
            this.getSupportActionBar().setDisplayShowTitleEnabled(true);
        }
    }

    private void show_pastebin_prompt() {
        PastebinEditorFragment f = (PastebinEditorFragment)this.getSupportFragmentManager().findFragmentByTag("pastebin");
        if (f == null) {
            f = new PastebinEditorFragment();
            f.pastecontents = this.messageTxt.getText().toString();
            f.listener = this;
            try {
                f.show(this.getSupportFragmentManager(), "pastebin");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    @Override
    public void onPastebinFailed(final String pastecontents) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                MainActivity.this.sendBtn.setEnabled(true);
                if (Build.VERSION.SDK_INT >= 11) {
                    MainActivity.this.sendBtn.setAlpha(1.0f);
                }
                MainActivity.this.messageTxt.setText(pastecontents);
            }
        });
    }

    @Override
    public void onPastebinSendAsText(final String text) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                MainActivity.this.messageTxt.setText(text);
                SendTask t = new SendTask();
                t.forceText = true;
                t.execute(new Void[]{null});
            }
        });
    }

    @Override
    public void onPastebinSaved() {
    }

    @Override
    public void onPastebinCancelled() {
    }

    private void show_topic_popup() {
        ChannelsDataSource.Channel c = ChannelsDataSource.getInstance().getChannelForBuffer(this.buffer.bid);
        if (c != null) {
            UsersDataSource.User self_user;
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
            builder.setInverseBackgroundForced(Build.VERSION.SDK_INT < 11);
            View v = this.getLayoutInflater().inflate(2130903092, null);
            if (c.topic_text.length() > 0) {
                Object author = "";
                if (c.topic_author != null && c.topic_author.length() > 0) {
                    author = "\u2014 Set by " + c.topic_author;
                    if (c.topic_time > 0L) {
                        author = (String)author + " on " + DateFormat.getDateTimeInstance().format(new Date(c.topic_time * 1000L));
                    }
                    v.findViewById(2131624123).setVisibility(0);
                    ((TextView)v.findViewById(2131624123)).setText((CharSequence)author);
                }
                ((TextView)v.findViewById(2131624122)).setText((CharSequence)ColorFormatter.html_to_spanned(ColorFormatter.emojify(ColorFormatter.irc_to_html(TextUtils.htmlEncode((String)c.topic_text))), true, this.server));
            } else {
                ((TextView)v.findViewById(2131624122)).setText((CharSequence)"No topic set.");
            }
            if (c.mode.length() > 0) {
                v.findViewById(2131624124).setVisibility(0);
                ((TextView)v.findViewById(2131624124)).setText((CharSequence)("Mode: +" + c.mode));
                for (ChannelsDataSource.Mode m : c.modes) {
                    switch (m.mode) {
                        case "i": {
                            v.findViewById(2131624125).setVisibility(0);
                            break;
                        }
                        case "k": {
                            v.findViewById(2131624126).setVisibility(0);
                            ((TextView)v.findViewById(2131624032)).setText((CharSequence)m.param);
                            break;
                        }
                        case "m": {
                            v.findViewById(2131624127).setVisibility(0);
                            break;
                        }
                        case "n": {
                            v.findViewById(2131624128).setVisibility(0);
                            break;
                        }
                        case "p": {
                            v.findViewById(2131624129).setVisibility(0);
                            break;
                        }
                        case "s": {
                            v.findViewById(2131624130).setVisibility(0);
                            break;
                        }
                        case "t": {
                            v.findViewById(2131624131).setVisibility(0);
                        }
                    }
                }
            }
            builder.setView(v);
            builder.setNegativeButton("Close", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                }
            });
            boolean canEditTopic = c.hasMode("t") ? (self_user = UsersDataSource.getInstance().getUser(this.buffer.bid, this.server.nick)) != null && (self_user.mode.contains(this.server != null ? this.server.MODE_OWNER : "q") || self_user.mode.contains(this.server != null ? this.server.MODE_ADMIN : "a") || self_user.mode.contains(this.server != null ? this.server.MODE_OP : "o") || self_user.mode.contains(this.server != null ? this.server.MODE_HALFOP : "h")) : true;
            if (canEditTopic) {
                builder.setPositiveButton("Edit Topic", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                        MainActivity.this.editTopic();
                    }
                });
            }
            final AlertDialog dialog = builder.create();
            dialog.setOwnerActivity(this);
            dialog.show();
            ((TextView)v.findViewById(2131624122)).setMovementMethod((MovementMethod)new LinkMovementMethod(){

                public boolean onTouchEvent(TextView widget, Spannable buffer, MotionEvent event) {
                    if (super.onTouchEvent(widget, buffer, event) && event.getAction() == 1) {
                        dialog.dismiss();
                        return true;
                    }
                    return false;
                }
            });
        }
    }

    private void update_suggestions(boolean force) {
        if (this.buffer != null && this.suggestionsContainer != null && this.messageTxt != null && this.messageTxt.getText() != null) {
            String text;
            try {
                text = this.messageTxt.getText().toString();
            }
            catch (Exception e) {
                text = "";
            }
            if (text.lastIndexOf(32) > 0 && text.lastIndexOf(32) < text.length() - 1) {
                text = text.substring(text.lastIndexOf(32) + 1);
            }
            if (text.endsWith(":")) {
                text = text.substring(0, text.length() - 1);
            }
            text = text.toLowerCase();
            final ArrayList<String> sugs = new ArrayList<String>();
            HashSet<String> sugs_set = new HashSet<String>();
            if (text.length() > 2 || force || text.length() > 0 && this.suggestionsAdapter.activePos != -1) {
                boolean disabled;
                if (this.sortedChannels == null) {
                    this.sortedChannels = ChannelsDataSource.getInstance().getChannels();
                    if (this.sortedChannels == null) {
                        return;
                    }
                    Collections.sort(this.sortedChannels, new Comparator<ChannelsDataSource.Channel>(){

                        @Override
                        public int compare(ChannelsDataSource.Channel lhs, ChannelsDataSource.Channel rhs) {
                            return lhs.name.compareTo(rhs.name);
                        }
                    });
                }
                if (this.buffer != null && this.messageTxt.getText().length() > 0 && this.buffer.type.equals("channel") && this.buffer.name.toLowerCase().startsWith(text) && !sugs_set.contains(this.buffer.name)) {
                    sugs_set.add(this.buffer.name);
                    sugs.add(this.buffer.name);
                }
                for (ChannelsDataSource.Channel channel : this.sortedChannels) {
                    if (text.length() <= 0 || text.charAt(0) != channel.name.charAt(0) || !channel.name.toLowerCase().startsWith(text) || sugs_set.contains(channel.name)) continue;
                    sugs_set.add(channel.name);
                    sugs.add(channel.name);
                }
                JSONObject disableAutoSuggest = null;
                if (NetworkConnection.getInstance().getUserInfo() != null && NetworkConnection.getInstance().getUserInfo().prefs != null) {
                    try {
                        if (NetworkConnection.getInstance().getUserInfo().prefs.has("channel-disableAutoSuggest")) {
                            disableAutoSuggest = NetworkConnection.getInstance().getUserInfo().prefs.getJSONObject("channel-disableAutoSuggest");
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                try {
                    disabled = disableAutoSuggest != null && disableAutoSuggest.has(String.valueOf(this.buffer.bid)) && disableAutoSuggest.getBoolean(String.valueOf(this.buffer.bid));
                }
                catch (JSONException e) {
                    disabled = false;
                }
                if (this.sortedUsers == null && this.buffer != null && (force || !disabled)) {
                    this.sortedUsers = UsersDataSource.getInstance().getUsersForBuffer(this.buffer.bid);
                    if (this.sortedUsers != null) {
                        Collections.sort(this.sortedUsers, new Comparator<UsersDataSource.User>(){

                            @Override
                            public int compare(UsersDataSource.User lhs, UsersDataSource.User rhs) {
                                if (lhs.last_mention > rhs.last_mention) {
                                    return -1;
                                }
                                if (lhs.last_mention < rhs.last_mention) {
                                    return 1;
                                }
                                return lhs.nick.compareToIgnoreCase(rhs.nick);
                            }
                        });
                    }
                }
                if (this.sortedUsers != null) {
                    for (UsersDataSource.User user : this.sortedUsers) {
                        String nick = user.nick_lowercase;
                        if (text.matches("^[a-zA-Z0-9]+.*")) {
                            nick = nick.replaceFirst("^[^a-zA-Z0-9]+", "");
                        }
                        if (!nick.startsWith(text) || sugs_set.contains(user.nick)) continue;
                        sugs_set.add(user.nick);
                        sugs.add(user.nick);
                    }
                }
            }
            if (Build.VERSION.SDK_INT >= 14 && text.startsWith(":") && text.length() > 1) {
                String q = text.toLowerCase().substring(1);
                for (String emocode : ColorFormatter.emojiMap.keySet()) {
                    String emoji;
                    if (!emocode.startsWith(q) || sugs_set.contains(emoji = ColorFormatter.emojiMap.get(emocode))) continue;
                    sugs_set.add(emoji);
                    sugs.add(emoji);
                }
            }
            if (sugs.size() == 0 && this.suggestionsContainer.getVisibility() == 4) {
                return;
            }
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (sugs.size() > 0) {
                        if (((MainActivity)MainActivity.this).suggestionsAdapter.activePos == -1) {
                            MainActivity.this.suggestionsAdapter.clear();
                            for (String s : sugs) {
                                MainActivity.this.suggestionsAdapter.add(s);
                            }
                            MainActivity.this.suggestionsAdapter.notifyDataSetChanged();
                            MainActivity.this.suggestions.smoothScrollToPosition(0);
                        }
                        if (MainActivity.this.suggestionsContainer.getVisibility() == 4) {
                            if (Build.VERSION.SDK_INT < 16) {
                                AlphaAnimation anim2 = new AlphaAnimation(0.0f, 1.0f);
                                anim2.setDuration(250L);
                                anim2.setFillAfter(true);
                                MainActivity.this.suggestionsContainer.startAnimation((Animation)anim2);
                            } else {
                                MainActivity.this.suggestionsContainer.setAlpha(0.0f);
                                MainActivity.this.suggestionsContainer.setTranslationY(1000.0f);
                                MainActivity.this.suggestionsContainer.animate().alpha(1.0f).translationY(0.0f).setInterpolator((TimeInterpolator)new DecelerateInterpolator());
                            }
                            MainActivity.this.suggestionsContainer.setVisibility(0);
                            MainActivity.this.runOnUiThread(new Runnable(){

                                @Override
                                public void run() {
                                    if (MainActivity.this.suggestionsContainer.getHeight() < 48) {
                                        MainActivity.this.getSupportActionBar().hide();
                                    }
                                }
                            });
                        }
                    } else if (MainActivity.this.suggestionsContainer.getVisibility() == 0) {
                        if (Build.VERSION.SDK_INT < 16) {
                            AlphaAnimation anim3 = new AlphaAnimation(1.0f, 0.0f);
                            anim3.setDuration(250L);
                            anim3.setFillAfter(true);
                            anim3.setAnimationListener(new Animation.AnimationListener(){

                                public void onAnimationStart(Animation animation) {
                                }

                                public void onAnimationEnd(Animation animation) {
                                    MainActivity.this.suggestionsContainer.setVisibility(4);
                                    MainActivity.this.suggestionsAdapter.clear();
                                    MainActivity.this.suggestionsAdapter.notifyDataSetChanged();
                                }

                                public void onAnimationRepeat(Animation animation) {
                                }
                            });
                            MainActivity.this.suggestionsContainer.startAnimation((Animation)anim3);
                        } else {
                            MainActivity.this.suggestionsContainer.animate().alpha(1.0f).translationY(1000.0f).setInterpolator((TimeInterpolator)new AccelerateInterpolator()).withEndAction(new Runnable(){

                                @Override
                                public void run() {
                                    MainActivity.this.suggestionsContainer.setVisibility(4);
                                    MainActivity.this.suggestionsAdapter.clear();
                                    MainActivity.this.suggestionsAdapter.notifyDataSetChanged();
                                }
                            });
                        }
                        MainActivity.this.sortedUsers = null;
                        MainActivity.this.sortedChannels = null;
                        if (!MainActivity.this.getSupportActionBar().isShowing()) {
                            MainActivity.this.getSupportActionBar().show();
                        }
                    }
                }
            });
        }
    }

    private void nextSuggestion() {
        if (this.suggestionsAdapter.getCount() == 0) {
            this.update_suggestions(true);
        }
        if (this.suggestionsAdapter.getCount() > 0) {
            this.suggestionsAdapter.activePos = this.suggestionsAdapter.activePos < 0 || this.suggestionsAdapter.activePos >= this.suggestionsAdapter.getCount() - 1 ? 0 : ++this.suggestionsAdapter.activePos;
            this.suggestionsAdapter.notifyDataSetChanged();
            this.suggestions.smoothScrollToPosition(this.suggestionsAdapter.activePos);
            String nick = (String)this.suggestionsAdapter.getItem(this.suggestionsAdapter.activePos);
            String text = this.messageTxt.getText().toString();
            if (text.lastIndexOf(32) > 0) {
                this.messageTxt.setText(text.substring(0, text.lastIndexOf(32) + 1) + nick);
            } else if (nick.startsWith("#") || text.startsWith(":")) {
                this.messageTxt.setText(nick);
            } else {
                this.messageTxt.setText(nick + ":");
            }
            this.messageTxt.setSelection(this.messageTxt.getText().length());
        }
    }

    @Override
    public void onSaveInstanceState(Bundle state) {
        super.onSaveInstanceState(state);
        if (this.server != null) {
            state.putInt("cid", this.server.cid);
        }
        if (this.buffer != null) {
            state.putInt("bid", this.buffer.bid);
            this.buffer.draft = this.messageTxt != null && this.messageTxt.getText() != null ? this.messageTxt.getText().toString() : null;
        }
        state.putSerializable("backStack", this.backStack);
        if (this.imageCaptureURI != null) {
            state.putString("imagecaptureuri", this.imageCaptureURI.toString());
        }
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            if (this.drawerLayout != null && (this.drawerLayout.isDrawerOpen(3) || this.drawerLayout.isDrawerOpen(5))) {
                this.drawerLayout.closeDrawers();
                return true;
            }
            while (this.backStack != null && this.backStack.size() > 0) {
                BuffersDataSource.Buffer b;
                Integer bid = this.backStack.get(0);
                this.backStack.remove(0);
                if (this.buffer != null && bid == this.buffer.bid || (b = BuffersDataSource.getInstance().getBuffer(bid)) == null) continue;
                this.onBufferSelected(bid);
                if (this.backStack.size() > 0) {
                    this.backStack.remove(0);
                }
                return true;
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    private void setFromIntent(Intent intent) {
        this.launchBid = -1;
        this.launchURI = null;
        if (NetworkConnection.getInstance().ready) {
            this.setIntent(new Intent((Context)this, MainActivity.class));
        }
        if (intent.hasExtra("bid")) {
            int new_bid = intent.getIntExtra("bid", 0);
            if (NetworkConnection.getInstance().ready && NetworkConnection.getInstance().getState() == 2 && BuffersDataSource.getInstance().getBuffer(new_bid) == null) {
                Crashlytics.log(5, "IRCCloud", "Invalid bid requested by launch intent: " + new_bid);
                Notifications.getInstance().deleteNotificationsForBid(new_bid);
                if (this.showNotificationsTask != null) {
                    this.showNotificationsTask.cancel(true);
                }
                this.showNotificationsTask = new ShowNotificationsTask();
                this.showNotificationsTask.execute(new_bid);
                return;
            }
            if (BuffersDataSource.getInstance().getBuffer(new_bid) != null) {
                Crashlytics.log(3, "IRCCloud", "Found BID, switching buffers");
                if (this.buffer != null && this.buffer.bid != new_bid) {
                    this.backStack.add(0, this.buffer.bid);
                }
                this.buffer = BuffersDataSource.getInstance().getBuffer(new_bid);
                this.server = ServersDataSource.getInstance().getServer(this.buffer.cid);
            } else {
                Crashlytics.log(3, "IRCCloud", "BID not found, will try after reconnecting");
                this.launchBid = new_bid;
            }
        }
        if (intent.getData() != null && intent.getData().getScheme() != null && intent.getData().getScheme().startsWith("irc")) {
            if (this.open_uri(intent.getData())) {
                return;
            }
            this.launchURI = intent.getData();
            this.buffer = null;
            this.server = null;
        } else if (intent.hasExtra("cid") && this.buffer == null) {
            this.buffer = BuffersDataSource.getInstance().getBufferByName(intent.getIntExtra("cid", 0), intent.getStringExtra("name"));
            if (this.buffer != null) {
                this.server = ServersDataSource.getInstance().getServer(intent.getIntExtra("cid", 0));
            }
        }
        if (this.buffer == null) {
            this.server = null;
        } else {
            if (intent.hasExtra("android.intent.extra.STREAM")) {
                String type = this.getContentResolver().getType((Uri)intent.getParcelableExtra("android.intent.extra.STREAM"));
                if (type != null && type.startsWith("image/") && (!NetworkConnection.getInstance().uploadsAvailable() || PreferenceManager.getDefaultSharedPreferences((Context)this).getString("image_service", "IRCCloud").equals("imgur"))) {
                    new ImgurRefreshTask((Uri)intent.getParcelableExtra("android.intent.extra.STREAM")).execute(new Void[]{null});
                } else {
                    this.fileUploadTask = new FileUploadTask((Uri)intent.getParcelableExtra("android.intent.extra.STREAM"), this);
                    this.fileUploadTask.execute(new Void[]{null});
                }
            }
            if (intent.hasExtra("android.intent.extra.TEXT")) {
                this.buffer.draft = intent.hasExtra("android.intent.extra.SUBJECT") ? intent.getStringExtra("android.intent.extra.SUBJECT") + " (" + intent.getStringExtra("android.intent.extra.TEXT") + ")" : intent.getStringExtra("android.intent.extra.TEXT");
            }
        }
        if (this.buffer == null) {
            this.launchBid = intent.getIntExtra("bid", -1);
        } else {
            this.onBufferSelected(this.buffer.bid);
        }
    }

    @Override
    protected void onNewIntent(Intent intent) {
        if (intent != null) {
            Crashlytics.log(3, "IRCCloud", "Got new launch intent");
            this.setFromIntent(intent);
        }
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public void onResume() {
        Crashlytics.log(3, "IRCCloud", "Resuming app");
        this.conn = NetworkConnection.getInstance();
        this.conn.addHandler(this);
        super.onResume();
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)this);
        if (prefs.getBoolean("screenlock", false)) {
            this.getWindow().addFlags(128);
        } else {
            this.getWindow().clearFlags(128);
        }
        if (this.conn.getState() != 2) {
            if (this.drawerLayout != null && !NetworkConnection.getInstance().ready) {
                this.drawerLayout.setDrawerLockMode(1);
                this.getSupportActionBar().setHomeButtonEnabled(false);
            }
            this.sendBtn.setEnabled(false);
            if (Build.VERSION.SDK_INT >= 11) {
                this.sendBtn.setAlpha(0.5f);
            }
            this.conn.connect(this.getSharedPreferences("prefs", 0).getString("session_key", ""));
        } else {
            if (this.drawerLayout != null) {
                this.drawerLayout.setDrawerLockMode(0);
                this.getSupportActionBar().setHomeButtonEnabled(true);
            }
            if (this.messageTxt.getText() != null && this.messageTxt.getText().length() > 0) {
                this.sendBtn.setEnabled(true);
                if (Build.VERSION.SDK_INT >= 11) {
                    this.sendBtn.setAlpha(1.0f);
                }
            }
        }
        if (this.server == null || this.launchURI != null || this.getIntent() != null && (this.getIntent().hasExtra("bid") || this.getIntent().getData() != null)) {
            if (this.getIntent() != null && (this.getIntent().hasExtra("bid") || this.getIntent().getData() != null)) {
                Crashlytics.log(3, "IRCCloud", "Launch intent contains a BID or URL");
                this.setFromIntent(this.getIntent());
            } else if (!(this.conn.getState() != 2 || this.conn.getUserInfo() == null || !this.conn.ready || this.launchURI != null && this.open_uri(this.launchURI) || this.open_bid(this.conn.getUserInfo().last_selected_bid) || this.open_bid(BuffersDataSource.getInstance().firstBid()) || this.drawerLayout == null || !NetworkConnection.getInstance().ready || this.findViewById(2131624077) != null)) {
                this.drawerLayout.openDrawer(3);
            }
        } else if (this.buffer != null) {
            int bid = this.buffer.bid;
            this.onBufferSelected(bid);
        }
        this.updateUsersListFragmentVisibility();
        this.update_subtitle();
        this.suggestions = ((MessageViewFragment)this.getSupportFragmentManager().findFragmentById((int)2131624071)).suggestions;
        this.suggestions.setAdapter((ListAdapter)this.suggestionsAdapter);
        this.suggestions.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                String nick = (String)MainActivity.this.suggestionsAdapter.getItem(position);
                String text = MainActivity.this.messageTxt.getText().toString();
                if (text.lastIndexOf(32) > 0) {
                    MainActivity.this.messageTxt.setText(text.substring(0, text.lastIndexOf(32) + 1) + nick + " ");
                } else if (nick.startsWith("#") || text.startsWith(":")) {
                    MainActivity.this.messageTxt.setText(nick + " ");
                } else {
                    MainActivity.this.messageTxt.setText(nick + ": ");
                }
                MainActivity.this.messageTxt.setSelection(MainActivity.this.messageTxt.getText().length());
            }
        });
        this.suggestionsContainer = ((MessageViewFragment)this.getSupportFragmentManager().findFragmentById((int)2131624071)).suggestionsContainer;
        this.update_suggestions(false);
        if (this.refreshUpIndicatorTask != null) {
            this.refreshUpIndicatorTask.cancel(true);
        }
        this.refreshUpIndicatorTask = new RefreshUpIndicatorTask();
        this.refreshUpIndicatorTask.execute(new Void[]{null});
        this.supportInvalidateOptionsMenu();
        if (NetworkConnection.getInstance().ready && this.buffer != null) {
            try {
                if (this.showNotificationsTask != null) {
                    this.showNotificationsTask.cancel(true);
                }
                this.showNotificationsTask = new ShowNotificationsTask();
                this.showNotificationsTask.execute(this.buffer.bid);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.sendBtn.setEnabled(this.messageTxt.getText().length() > 0);
        if (Build.VERSION.SDK_INT >= 11 && this.messageTxt.getText().length() == 0) {
            this.sendBtn.setAlpha(0.5f);
        }
        if (this.drawerLayout != null) {
            this.drawerLayout.closeDrawers();
        }
        this.updateReconnecting();
        if (this.imgurTask != null) {
            this.imgurTask.setActivity(this);
        }
        if (this.fileUploadTask != null) {
            this.fileUploadTask.setActivity(this);
            if (this.fileUploadTask.metadataDialog == null && !this.fileUploadTask.filenameSet) {
                this.fileUploadTask.show_dialog();
            }
        }
        this.messageTxt.clearFocus();
        this.messageTxt.setEnabled(true);
    }

    @Override
    public void onPause() {
        super.onPause();
        if (this.imgurTask != null) {
            this.imgurTask.setActivity(null);
        }
        if (this.fileUploadTask != null) {
            this.fileUploadTask.setActivity(null);
        }
        try {
            if (this.showNotificationsTask != null) {
                this.showNotificationsTask.cancel(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.showNotificationsTask = new ShowNotificationsTask();
        this.showNotificationsTask.execute(-1);
        if (this.channelsListDialog != null) {
            this.channelsListDialog.dismiss();
        }
        if (this.conn != null) {
            this.conn.removeHandler(this);
        }
        this.suggestionsAdapter.clear();
        this.conn = null;
        this.progressBar.setVisibility(8);
        this.errorMsg.setVisibility(8);
        this.error = null;
        if (this.buffer != null) {
            this.backStack.add(0, this.buffer.bid);
        }
    }

    @Override
    public Object onRetainCustomNonConfigurationInstance() {
        ConfigInstance config = new ConfigInstance();
        config.imgurUploadTask = this.imgurTask;
        config.fileUploadTask = this.fileUploadTask;
        if (this.fileUploadTask != null) {
            if (this.fileUploadTask.metadataDialog != null) {
                this.fileUploadTask.metadataDialog.dismiss();
            }
            this.fileUploadTask.metadataDialog = null;
            this.fileUploadTask.fileSize = null;
        }
        return config;
    }

    private boolean open_uri(Uri uri) {
        if (uri != null && this.conn != null && this.conn.ready) {
            this.launchURI = null;
            ServersDataSource.Server s = null;
            try {
                if (uri.getHost().equals("cid")) {
                    s = ServersDataSource.getInstance().getServer(Integer.parseInt((String)uri.getPathSegments().get(0)));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (s == null) {
                s = uri.getPort() > 0 ? ServersDataSource.getInstance().getServer(uri.getHost(), uri.getPort()) : (uri.getScheme() != null && uri.getScheme().equalsIgnoreCase("ircs") ? ServersDataSource.getInstance().getServer(uri.getHost(), true) : ServersDataSource.getInstance().getServer(uri.getHost()));
            }
            if (s != null) {
                if (uri.getPath() != null && uri.getPath().length() > 1) {
                    BuffersDataSource.Buffer b;
                    String key = null;
                    String channel = uri.getLastPathSegment();
                    if (channel.contains(",")) {
                        key = channel.substring(channel.indexOf(",") + 1);
                        channel = channel.substring(0, channel.indexOf(","));
                    }
                    if ((b = BuffersDataSource.getInstance().getBufferByName(s.cid, channel)) != null) {
                        this.server = null;
                        return this.open_bid(b.bid);
                    }
                    this.onBufferSelected(-1);
                    this.title.setText((CharSequence)channel);
                    this.getSupportActionBar().setTitle(channel);
                    this.bufferToOpen = channel;
                    this.conn.join(s.cid, channel, key);
                    return true;
                }
                BuffersDataSource.Buffer b = BuffersDataSource.getInstance().getBufferByName(s.cid, "*");
                if (b != null) {
                    return this.open_bid(b.bid);
                }
            } else {
                if (!this.getResources().getBoolean(2131361795)) {
                    Intent i = new Intent((Context)this, EditConnectionActivity.class);
                    i.putExtra("hostname", uri.getHost());
                    if (uri.getPort() > 0) {
                        i.putExtra("port", uri.getPort());
                    } else if (uri.getScheme().equalsIgnoreCase("ircs")) {
                        i.putExtra("port", 6697);
                    }
                    if (uri.getPath() != null && uri.getPath().length() > 1) {
                        i.putExtra("channels", uri.getPath().substring(1).replace(",", " "));
                    }
                    this.startActivity(i);
                } else {
                    EditConnectionFragment connFragment = new EditConnectionFragment();
                    connFragment.default_hostname = uri.getHost();
                    if (uri.getPort() > 0) {
                        connFragment.default_port = uri.getPort();
                    } else if (uri.getScheme().equalsIgnoreCase("ircs")) {
                        connFragment.default_port = 6697;
                    }
                    if (uri.getPath() != null && uri.getPath().length() > 1) {
                        connFragment.default_channels = uri.getPath().substring(1).replace(",", " ");
                    }
                    connFragment.show(this.getSupportFragmentManager(), "addnetwork");
                }
                return true;
            }
        }
        return false;
    }

    private boolean open_bid(int bid) {
        if (BuffersDataSource.getInstance().getBuffer(bid) != null) {
            this.onBufferSelected(bid);
            if (bid == this.launchBid) {
                this.launchBid = -1;
            }
            return true;
        }
        Log.w((String)"IRCCloud", (String)"Requested BID not found");
        return false;
    }

    private void update_subtitle() {
        if (this.server == null || this.buffer == null) {
            this.title.setText((CharSequence)this.bufferToOpen);
            this.subtitle.setVisibility(8);
        } else {
            if (this.buffer.type.equals("console")) {
                if (this.server.name.length() > 0) {
                    this.title.setText((CharSequence)this.server.name);
                    if (this.progressBar.getVisibility() == 8) {
                        this.getSupportActionBar().setTitle(this.server.name);
                    }
                } else {
                    this.title.setText((CharSequence)this.server.hostname);
                    if (this.progressBar.getVisibility() == 8) {
                        this.getSupportActionBar().setTitle(this.server.hostname);
                    }
                }
            } else {
                this.title.setText((CharSequence)this.buffer.name);
                if (this.progressBar.getVisibility() == 8) {
                    this.getSupportActionBar().setTitle(this.buffer.name);
                }
            }
            if (this.buffer.archived > 0 && !this.buffer.type.equals("console")) {
                this.subtitle.setVisibility(0);
                this.subtitle.setText((CharSequence)"(archived)");
                if (this.buffer.type.equals("conversation")) {
                    this.title.setContentDescription((CharSequence)("Conversation with " + this.title.getText()));
                } else if (this.buffer.type.equals("channel")) {
                    this.title.setContentDescription((CharSequence)("Channel " + this.buffer.normalizedName()));
                }
            } else if (this.buffer.type.equals("conversation")) {
                this.title.setContentDescription((CharSequence)("Conversation with " + this.title.getText()));
                if (this.buffer.away_msg != null && this.buffer.away_msg.length() > 0) {
                    this.subtitle.setVisibility(0);
                    if (this.buffer.away_msg != null && this.buffer.away_msg.length() > 0) {
                        this.subtitle.setText((CharSequence)("Away: " + ColorFormatter.html_to_spanned(ColorFormatter.emojify(ColorFormatter.irc_to_html(TextUtils.htmlEncode((String)this.buffer.away_msg)))).toString()));
                    } else {
                        this.subtitle.setText((CharSequence)"Away");
                    }
                } else {
                    UsersDataSource.User u = UsersDataSource.getInstance().findUserOnConnection(this.buffer.cid, this.buffer.name);
                    if (u != null && u.away > 0) {
                        this.subtitle.setVisibility(0);
                        if (u.away_msg != null && u.away_msg.length() > 0) {
                            this.subtitle.setText((CharSequence)("Away: " + ColorFormatter.html_to_spanned(ColorFormatter.emojify(ColorFormatter.irc_to_html(TextUtils.htmlEncode((String)u.away_msg)))).toString()));
                        } else {
                            this.subtitle.setText((CharSequence)"Away");
                        }
                    } else {
                        this.subtitle.setVisibility(8);
                    }
                }
                this.key.setVisibility(8);
            } else if (this.buffer.type.equals("channel")) {
                this.title.setContentDescription((CharSequence)("Channel " + this.buffer.normalizedName() + ". Double-tap to view or edit the topic."));
                ChannelsDataSource.Channel c = ChannelsDataSource.getInstance().getChannelForBuffer(this.buffer.bid);
                if (c != null && c.topic_text.length() > 0) {
                    this.subtitle.setVisibility(0);
                    this.subtitle.setText((CharSequence)ColorFormatter.html_to_spanned(ColorFormatter.emojify(ColorFormatter.irc_to_html(TextUtils.htmlEncode((String)c.topic_text)))).toString());
                    this.subtitle.setContentDescription((CharSequence)".");
                } else {
                    this.subtitle.setVisibility(8);
                }
                if (c != null && c.key) {
                    this.key.setImageResource(2130837631);
                    this.key.setVisibility(0);
                } else {
                    this.key.setVisibility(8);
                }
            } else if (this.buffer.type.equals("console")) {
                this.subtitle.setVisibility(0);
                this.subtitle.setText((CharSequence)(this.server.hostname + ":" + this.server.port));
                this.title.setContentDescription((CharSequence)("Network " + this.server.name));
                this.subtitle.setContentDescription((CharSequence)".");
                if (this.server.ssl > 0) {
                    this.key.setImageResource(2130837708);
                } else {
                    this.key.setImageResource(2130837706);
                }
                this.key.setVisibility(0);
            }
        }
        this.supportInvalidateOptionsMenu();
    }

    private void updateUsersListFragmentVisibility() {
        boolean hide = true;
        if (this.userListView != null) {
            ChannelsDataSource.Channel c = null;
            if (this.buffer != null && this.buffer.type.equals("channel") && (c = ChannelsDataSource.getInstance().getChannelForBuffer(this.buffer.bid)) != null) {
                hide = false;
            }
            try {
                JSONObject hiddenMap;
                if (this.conn != null && this.conn.getUserInfo() != null && this.conn.getUserInfo().prefs != null && this.findViewById(2131624077) != null && (hiddenMap = this.conn.getUserInfo().prefs.getJSONObject("channel-hiddenMembers")).has(String.valueOf(this.buffer.bid)) && hiddenMap.getBoolean(String.valueOf(this.buffer.bid))) {
                    hide = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (hide) {
                this.userListView.setVisibility(8);
                if (this.drawerLayout != null) {
                    if (this.findViewById(2131624077) != null && c != null) {
                        this.drawerLayout.setDrawerLockMode(0, 5);
                    } else {
                        this.drawerLayout.setDrawerLockMode(1, 5);
                    }
                }
            } else {
                this.userListView.setVisibility(0);
                if (this.drawerLayout != null) {
                    if (this.findViewById(2131624077) != null) {
                        this.drawerLayout.setDrawerLockMode(1, 5);
                    } else {
                        this.drawerLayout.setDrawerLockMode(0, 5);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onIRCEvent(int what, Object obj) {
        super.onIRCEvent(what, obj);
        Integer event_bid = 0;
        final Object o = obj;
        switch (what) {
            case 999: {
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        MainActivity.this.errorMsg.setVisibility(0);
                        MainActivity.this.errorMsg.setText((CharSequence)o.toString());
                    }
                });
                break;
            }
            case 105: {
                final float progress = ((Float)obj).floatValue();
                if (!((float)this.progressBar.getProgress() < progress)) break;
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        MainActivity.this.progressBar.setIndeterminate(false);
                        MainActivity.this.progressBar.setProgress((int)progress);
                    }
                });
                break;
            }
            case 100: {
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        MainActivity.this.progressBar.setProgress(0);
                    }
                });
                break;
            }
            case 17: {
                if (this.buffer == null || (Integer)obj != this.buffer.bid) break;
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        MainActivity.this.update_subtitle();
                    }
                });
                break;
            }
            case 43: {
                IRCCloudJSONObject event = (IRCCloudJSONObject)obj;
                if (this.buffer == null || this.buffer.cid != event.cid() || !this.buffer.name.equalsIgnoreCase(event.getString("chan"))) break;
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        MainActivity.this.update_subtitle();
                        MainActivity.this.show_topic_popup();
                    }
                });
                break;
            }
            case 34: {
                IRCCloudJSONObject event = (IRCCloudJSONObject)obj;
                if (event != null && this.cidToOpen == event.cid() && event.has("invalid_chan") && event.has("valid_chan") && event.getString("invalid_chan").equalsIgnoreCase(this.bufferToOpen)) {
                    this.bufferToOpen = event.getString("valid_chan");
                    obj = BuffersDataSource.getInstance().getBuffer(event.bid());
                } else {
                    this.bufferToOpen = null;
                    return;
                }
            }
            case 3: {
                BuffersDataSource.Buffer b = (BuffersDataSource.Buffer)obj;
                if (this.cidToOpen != b.cid || this.bufferToOpen != null && (!b.name.equalsIgnoreCase(this.bufferToOpen) || this.buffer != null && this.bufferToOpen.equalsIgnoreCase(this.buffer.name))) break;
                this.server = null;
                final int bid = b.bid;
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        MainActivity.this.onBufferSelected(bid);
                    }
                });
                this.bufferToOpen = null;
                this.cidToOpen = -1;
                break;
            }
            case 29: {
                IRCCloudJSONObject event = (IRCCloudJSONObject)obj;
                try {
                    this.bufferToOpen = event.getString("name");
                    this.cidToOpen = event.cid();
                    BuffersDataSource.Buffer b = BuffersDataSource.getInstance().getBufferByName(this.cidToOpen, this.bufferToOpen);
                    if (b == null || this.bufferToOpen.equalsIgnoreCase(this.buffer.name)) break;
                    this.server = null;
                    this.bufferToOpen = null;
                    this.cidToOpen = -1;
                    final int bid = b.bid;
                    this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            MainActivity.this.onBufferSelected(bid);
                        }
                    });
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                break;
            }
            case 0: {
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        MainActivity.this.updateReconnecting();
                    }
                });
                if (this.conn == null) break;
                if (this.conn.getState() == 2) {
                    for (EventsDataSource.Event e : this.pendingEvents.values()) {
                        try {
                            e.expiration_timer.cancel();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        e.expiration_timer = null;
                        e.failed = true;
                        e.bg_color = 2131492904;
                    }
                    if (this.drawerLayout != null && NetworkConnection.getInstance().ready) {
                        this.runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                MainActivity.this.drawerLayout.setDrawerLockMode(0);
                                MainActivity.this.getSupportActionBar().setHomeButtonEnabled(true);
                                MainActivity.this.updateUsersListFragmentVisibility();
                            }
                        });
                    }
                    if (this.server == null || this.messageTxt.getText() == null || this.messageTxt.getText().length() <= 0) break;
                    this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            MainActivity.this.sendBtn.setEnabled(true);
                            if (Build.VERSION.SDK_INT >= 11) {
                                MainActivity.this.sendBtn.setAlpha(1.0f);
                            }
                        }
                    });
                    break;
                }
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (MainActivity.this.drawerLayout != null && !NetworkConnection.getInstance().ready) {
                            MainActivity.this.drawerLayout.setDrawerLockMode(1);
                            MainActivity.this.getSupportActionBar().setHomeButtonEnabled(false);
                        }
                        MainActivity.this.sendBtn.setEnabled(false);
                        if (Build.VERSION.SDK_INT >= 11) {
                            MainActivity.this.sendBtn.setAlpha(0.5f);
                        }
                    }
                });
                break;
            }
            case 31: {
                final IRCCloudJSONObject event = (IRCCloudJSONObject)obj;
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (event != null && event.getString("channel").equalsIgnoreCase(MainActivity.this.buffer.name)) {
                            Bundle args = new Bundle();
                            args.putInt("cid", MainActivity.this.buffer.cid);
                            args.putInt("bid", MainActivity.this.buffer.bid);
                            args.putString("mode", "b");
                            args.putString("placeholder", "No bans in effect.\n\nYou can ban someone by tapping their nickname in the user list, long-pressing a message, or by using /ban.");
                            args.putString("mask", "mask");
                            args.putString("list", "bans");
                            args.putString("title", "Ban list for " + MainActivity.this.buffer.name);
                            args.putString("event", event.toString());
                            ChannelModeListFragment channelModeList = (ChannelModeListFragment)MainActivity.this.getSupportFragmentManager().findFragmentByTag("banlist");
                            if (channelModeList == null) {
                                channelModeList = new ChannelModeListFragment();
                                channelModeList.setArguments(args);
                                try {
                                    channelModeList.show(MainActivity.this.getSupportFragmentManager(), "banlist");
                                }
                                catch (IllegalStateException illegalStateException) {}
                            } else {
                                channelModeList.setArguments(args);
                            }
                        }
                    }
                });
                break;
            }
            case 45: {
                final IRCCloudJSONObject event = (IRCCloudJSONObject)obj;
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (event != null && event.getString("channel").equalsIgnoreCase(MainActivity.this.buffer.name)) {
                            Bundle args = new Bundle();
                            args.putInt("cid", MainActivity.this.buffer.cid);
                            args.putInt("bid", MainActivity.this.buffer.bid);
                            args.putString("mode", "q");
                            args.putString("placeholder", "Empty quiet list.");
                            args.putString("mask", "quiet_mask");
                            args.putString("list", "list");
                            args.putString("title", "Quiet list for " + MainActivity.this.buffer.name);
                            args.putString("event", event.toString());
                            ChannelModeListFragment channelModeList = (ChannelModeListFragment)MainActivity.this.getSupportFragmentManager().findFragmentByTag("quietlist");
                            if (channelModeList == null) {
                                channelModeList = new ChannelModeListFragment();
                                channelModeList.setArguments(args);
                                try {
                                    channelModeList.show(MainActivity.this.getSupportFragmentManager(), "quietlist");
                                }
                                catch (IllegalStateException illegalStateException) {}
                            } else {
                                channelModeList.setArguments(args);
                            }
                        }
                    }
                });
                break;
            }
            case 46: {
                final IRCCloudJSONObject event = (IRCCloudJSONObject)obj;
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (event != null && event.getString("channel").equalsIgnoreCase(MainActivity.this.buffer.name)) {
                            Bundle args = new Bundle();
                            args.putInt("cid", MainActivity.this.buffer.cid);
                            args.putInt("bid", MainActivity.this.buffer.bid);
                            args.putString("mode", "e");
                            args.putString("placeholder", "Empty exception list.");
                            args.putString("mask", "mask");
                            args.putString("list", "exceptions");
                            args.putString("title", "Exception list for " + MainActivity.this.buffer.name);
                            args.putString("event", event.toString());
                            ChannelModeListFragment channelModeList = (ChannelModeListFragment)MainActivity.this.getSupportFragmentManager().findFragmentByTag("exceptionlist");
                            if (channelModeList == null) {
                                channelModeList = new ChannelModeListFragment();
                                channelModeList.setArguments(args);
                                try {
                                    channelModeList.show(MainActivity.this.getSupportFragmentManager(), "exceptionlist");
                                }
                                catch (IllegalStateException illegalStateException) {}
                            } else {
                                channelModeList.setArguments(args);
                            }
                        }
                    }
                });
                break;
            }
            case 47: {
                final IRCCloudJSONObject event = (IRCCloudJSONObject)obj;
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (event != null && event.getString("channel").equalsIgnoreCase(MainActivity.this.buffer.name)) {
                            Bundle args = new Bundle();
                            args.putInt("cid", MainActivity.this.buffer.cid);
                            args.putInt("bid", MainActivity.this.buffer.bid);
                            args.putString("mode", "I");
                            args.putString("placeholder", "Empty invite list");
                            args.putString("mask", "mask");
                            args.putString("list", "list");
                            args.putString("title", "Invite list for " + MainActivity.this.buffer.name);
                            args.putString("event", event.toString());
                            ChannelModeListFragment channelModeList = (ChannelModeListFragment)MainActivity.this.getSupportFragmentManager().findFragmentByTag("invitelist");
                            if (channelModeList == null) {
                                channelModeList = new ChannelModeListFragment();
                                channelModeList.setArguments(args);
                                try {
                                    channelModeList.show(MainActivity.this.getSupportFragmentManager(), "invitelist");
                                }
                                catch (IllegalStateException illegalStateException) {}
                            } else {
                                channelModeList.setArguments(args);
                            }
                        }
                    }
                });
                break;
            }
            case 40: {
                final IRCCloudJSONObject event = (IRCCloudJSONObject)obj;
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (event != null && event.cid() == MainActivity.this.buffer.cid) {
                            Bundle args = new Bundle();
                            args.putInt("cid", MainActivity.this.buffer.cid);
                            args.putString("event", event.toString());
                            AcceptListFragment acceptList = (AcceptListFragment)MainActivity.this.getSupportFragmentManager().findFragmentByTag("acceptlist");
                            if (acceptList == null) {
                                acceptList = new AcceptListFragment();
                                acceptList.setArguments(args);
                                try {
                                    acceptList.show(MainActivity.this.getSupportFragmentManager(), "acceptlist");
                                }
                                catch (IllegalStateException illegalStateException) {}
                            } else {
                                acceptList.setArguments(args);
                            }
                        }
                    }
                });
                break;
            }
            case 32: {
                final IRCCloudJSONObject event = (IRCCloudJSONObject)obj;
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        Bundle args = new Bundle();
                        args.putString("event", event.toString());
                        WhoListFragment whoList = (WhoListFragment)MainActivity.this.getSupportFragmentManager().findFragmentByTag("wholist");
                        if (whoList == null) {
                            whoList = new WhoListFragment();
                            whoList.setArguments(args);
                            try {
                                whoList.show(MainActivity.this.getSupportFragmentManager(), "wholist");
                            }
                            catch (IllegalStateException illegalStateException) {}
                        } else {
                            whoList.setArguments(args);
                        }
                    }
                });
                break;
            }
            case 41: {
                final IRCCloudJSONObject event = (IRCCloudJSONObject)obj;
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        Bundle args = new Bundle();
                        args.putString("event", event.toString());
                        NamesListFragment namesList = (NamesListFragment)MainActivity.this.getSupportFragmentManager().findFragmentByTag("nameslist");
                        if (namesList == null) {
                            namesList = new NamesListFragment();
                            namesList.setArguments(args);
                            try {
                                namesList.show(MainActivity.this.getSupportFragmentManager(), "nameslist");
                            }
                            catch (IllegalStateException illegalStateException) {}
                        } else {
                            namesList.setArguments(args);
                        }
                    }
                });
                break;
            }
            case 44: {
                final IRCCloudJSONObject event = (IRCCloudJSONObject)obj;
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        Bundle args = new Bundle();
                        args.putString("event", event.toString());
                        ServerMapListFragment serversList = (ServerMapListFragment)MainActivity.this.getSupportFragmentManager().findFragmentByTag("serverslist");
                        if (serversList == null) {
                            serversList = new ServerMapListFragment();
                            serversList.setArguments(args);
                            try {
                                serversList.show(MainActivity.this.getSupportFragmentManager(), "serverslist");
                            }
                            catch (IllegalStateException illegalStateException) {}
                        } else {
                            serversList.setArguments(args);
                        }
                    }
                });
                break;
            }
            case 33: {
                final IRCCloudJSONObject event = (IRCCloudJSONObject)obj;
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        Bundle args = new Bundle();
                        args.putString("event", event.toString());
                        WhoisFragment whois = (WhoisFragment)MainActivity.this.getSupportFragmentManager().findFragmentByTag("whois");
                        if (whois == null) {
                            whois = new WhoisFragment();
                            whois.setArguments(args);
                            try {
                                whois.show(MainActivity.this.getSupportFragmentManager(), "whois");
                            }
                            catch (IllegalStateException illegalStateException) {}
                        } else {
                            whois.setArguments(args);
                        }
                    }
                });
                break;
            }
            case 35: {
                final IRCCloudJSONObject event = (IRCCloudJSONObject)obj;
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        String dialogtitle = "List of channels on " + ServersDataSource.getInstance().getServer((int)event.cid()).hostname;
                        if (MainActivity.this.channelsListDialog == null) {
                            MainActivity ctx = MainActivity.this;
                            AlertDialog.Builder builder = new AlertDialog.Builder((Context)ctx);
                            builder.setInverseBackgroundForced(Build.VERSION.SDK_INT < 11);
                            builder.setView(MainActivity.this.getLayoutInflater().inflate(2130903085, null));
                            builder.setTitle(dialogtitle);
                            builder.setNegativeButton("Close", new DialogInterface.OnClickListener(){

                                public void onClick(DialogInterface dialog, int which) {
                                    dialog.dismiss();
                                }
                            });
                            MainActivity.this.channelsListDialog = builder.create();
                            MainActivity.this.channelsListDialog.setOwnerActivity(MainActivity.this);
                        } else {
                            MainActivity.this.channelsListDialog.setTitle(dialogtitle);
                        }
                        try {
                            MainActivity.this.channelsListDialog.show();
                        }
                        catch (IllegalStateException ctx) {
                            // empty catch block
                        }
                        ChannelListFragment channels = (ChannelListFragment)MainActivity.this.getSupportFragmentManager().findFragmentById(2131624097);
                        Bundle args = new Bundle();
                        args.putInt("cid", event.cid());
                        channels.setArguments(args);
                    }
                });
                break;
            }
            case 1: {
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        MainActivity.this.updateUsersListFragmentVisibility();
                        MainActivity.this.supportInvalidateOptionsMenu();
                        if (MainActivity.this.refreshUpIndicatorTask != null) {
                            MainActivity.this.refreshUpIndicatorTask.cancel(true);
                        }
                        MainActivity.this.refreshUpIndicatorTask = new RefreshUpIndicatorTask();
                        MainActivity.this.refreshUpIndicatorTask.execute(new Void[]{null});
                    }
                });
                if (this.launchBid != -1 || this.server != null || this.conn == null || this.conn.getUserInfo() == null) break;
                this.launchBid = this.conn.getUserInfo().last_selected_bid;
                break;
            }
            case 18: {
                try {
                    IRCCloudJSONObject event = (IRCCloudJSONObject)obj;
                    if (event == null || this.server == null || event.cid() != this.server.cid) break;
                    this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            MainActivity.this.supportInvalidateOptionsMenu();
                        }
                    });
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                break;
            }
            case 2: {
                ServersDataSource.Server s = (ServersDataSource.Server)obj;
                if (this.server != null && s != null && s.cid == this.server.cid) {
                    this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            MainActivity.this.supportInvalidateOptionsMenu();
                            MainActivity.this.update_subtitle();
                        }
                    });
                    break;
                }
                this.cidToOpen = s.cid;
                this.bufferToOpen = "*";
                break;
            }
            case 15: 
            case 16: {
                event_bid = (Integer)obj;
                if (this.buffer != null && event_bid == this.buffer.bid) {
                    this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            MainActivity.this.update_subtitle();
                        }
                    });
                }
                if (this.refreshUpIndicatorTask != null) {
                    this.refreshUpIndicatorTask.cancel(true);
                }
                this.refreshUpIndicatorTask = new RefreshUpIndicatorTask();
                this.refreshUpIndicatorTask.execute(new Void[]{null});
                break;
            }
            case 9: {
                IRCCloudJSONObject event = (IRCCloudJSONObject)obj;
                if (event == null || this.buffer == null || event.bid() != this.buffer.bid || !event.type().equals("you_joined_channel")) break;
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        MainActivity.this.supportInvalidateOptionsMenu();
                        MainActivity.this.updateUsersListFragmentVisibility();
                    }
                });
                break;
            }
            case 10: 
            case 22: {
                IRCCloudJSONObject event = (IRCCloudJSONObject)obj;
                if (event == null || this.buffer == null || event.bid() != this.buffer.bid || !event.type().toLowerCase().startsWith("you_")) break;
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        MainActivity.this.supportInvalidateOptionsMenu();
                        MainActivity.this.updateUsersListFragmentVisibility();
                    }
                });
                break;
            }
            case 7: {
                ChannelsDataSource.Channel channel = (ChannelsDataSource.Channel)obj;
                if (channel == null || this.buffer == null || channel.bid != this.buffer.bid) break;
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        MainActivity.this.update_subtitle();
                        MainActivity.this.supportInvalidateOptionsMenu();
                        MainActivity.this.updateUsersListFragmentVisibility();
                    }
                });
                break;
            }
            case 101: {
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        MainActivity.this.errorMsg.setVisibility(8);
                        MainActivity.this.error = null;
                        if (MainActivity.this.progressBar.getVisibility() == 0) {
                            if (Build.VERSION.SDK_INT >= 16) {
                                MainActivity.this.progressBar.animate().alpha(0.0f).setDuration(200L).withEndAction(new Runnable(){

                                    @Override
                                    public void run() {
                                        MainActivity.this.progressBar.setVisibility(8);
                                    }
                                });
                            } else {
                                MainActivity.this.progressBar.setVisibility(8);
                            }
                        }
                        MainActivity.this.getSupportActionBar().setDisplayShowTitleEnabled(false);
                        MainActivity.this.getSupportActionBar().setDisplayShowCustomEnabled(true);
                        if (MainActivity.this.drawerLayout != null) {
                            MainActivity.this.drawerLayout.setDrawerLockMode(0);
                            MainActivity.this.getSupportActionBar().setHomeButtonEnabled(true);
                            MainActivity.this.updateUsersListFragmentVisibility();
                        }
                        if (ServersDataSource.getInstance().count() < 1) {
                            Crashlytics.log(3, "IRCCloud", "No servers configured, launching add dialog");
                            MainActivity.this.addNetwork();
                        } else {
                            if (MainActivity.this.server == null || MainActivity.this.launchURI != null || MainActivity.this.launchBid != -1) {
                                Crashlytics.log(3, "IRCCloud", "Backlog loaded and we're waiting for a buffer, switching now");
                                if (!(MainActivity.this.launchURI != null && MainActivity.this.open_uri(MainActivity.this.launchURI) || MainActivity.this.launchBid != -1 && MainActivity.this.open_bid(MainActivity.this.launchBid) || MainActivity.this.conn != null && MainActivity.this.conn.getUserInfo() != null && MainActivity.this.open_bid(MainActivity.this.conn.getUserInfo().last_selected_bid) || MainActivity.this.open_bid(BuffersDataSource.getInstance().firstBid()) || MainActivity.this.drawerLayout == null || !NetworkConnection.getInstance().ready || MainActivity.this.findViewById(2131624077) != null)) {
                                    MainActivity.this.drawerLayout.openDrawer(3);
                                }
                            }
                            MainActivity.this.update_subtitle();
                        }
                        if (MainActivity.this.refreshUpIndicatorTask != null) {
                            MainActivity.this.refreshUpIndicatorTask.cancel(true);
                        }
                        MainActivity.this.refreshUpIndicatorTask = new RefreshUpIndicatorTask();
                        MainActivity.this.refreshUpIndicatorTask.execute(new Void[]{null});
                    }
                });
                break;
            }
            case 4: 
            case 19: {
                ArrayList<Integer> arrayList;
                Integer id2 = (Integer)obj;
                if (what == 4) {
                    arrayList = this.backStack;
                    synchronized (arrayList) {
                        for (int i = 0; i < this.backStack.size(); ++i) {
                            if (!this.backStack.get(i).equals(id2)) continue;
                            this.backStack.remove(i);
                            --i;
                        }
                    }
                }
                if (this.buffer != null && id2 == (what == 19 ? this.buffer.cid : this.buffer.bid)) {
                    arrayList = this.backStack;
                    synchronized (arrayList) {
                        while (this.backStack != null && this.backStack.size() > 0) {
                            final Integer bid = this.backStack.get(0);
                            this.backStack.remove(0);
                            BuffersDataSource.Buffer b = BuffersDataSource.getInstance().getBuffer(bid);
                            if (b == null) continue;
                            this.runOnUiThread(new Runnable(){

                                @Override
                                public void run() {
                                    MainActivity.this.onBufferSelected(bid);
                                    if (MainActivity.this.backStack.size() > 0) {
                                        MainActivity.this.backStack.remove(0);
                                    }
                                }
                            });
                            return;
                        }
                    }
                    this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            if (BuffersDataSource.getInstance().count() == 0) {
                                MainActivity.this.startActivity(new Intent((Context)MainActivity.this, EditConnectionActivity.class));
                                MainActivity.this.finish();
                            } else if (!MainActivity.this.open_bid(NetworkConnection.getInstance().getUserInfo().last_selected_bid) && !MainActivity.this.open_bid(BuffersDataSource.getInstance().firstBid())) {
                                MainActivity.this.finish();
                            }
                        }
                    });
                }
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (MainActivity.this.refreshUpIndicatorTask != null) {
                            MainActivity.this.refreshUpIndicatorTask.cancel(true);
                        }
                        MainActivity.this.refreshUpIndicatorTask = new RefreshUpIndicatorTask();
                        MainActivity.this.refreshUpIndicatorTask.execute(new Void[]{null});
                    }
                });
                break;
            }
            case 8: 
            case 23: {
                IRCCloudJSONObject event = (IRCCloudJSONObject)obj;
                if (event == null || this.buffer == null || event.bid() != this.buffer.bid) break;
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        MainActivity.this.update_subtitle();
                    }
                });
                break;
            }
            case 20: 
            case 21: {
                try {
                    IRCCloudJSONObject event = (IRCCloudJSONObject)obj;
                    if (event == null || this.buffer == null || event.cid() != this.buffer.cid || !event.getString("nick").equalsIgnoreCase(this.buffer.name)) break;
                    this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            MainActivity.this.update_subtitle();
                        }
                    });
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                break;
            }
            case 6: {
                boolean shouldRefresh = false;
                IRCCloudJSONObject event = (IRCCloudJSONObject)obj;
                JsonNode seenEids = event.getJsonNode("seenEids");
                Iterator<Map.Entry<String, JsonNode>> iterator = seenEids.fields();
                while (iterator.hasNext()) {
                    Map.Entry<String, JsonNode> entry = iterator.next();
                    JsonNode eids = entry.getValue();
                    Iterator<Map.Entry<String, JsonNode>> j = eids.fields();
                    while (j.hasNext()) {
                        Map.Entry<String, JsonNode> eidentry = j.next();
                        Integer bid = Integer.valueOf(eidentry.getKey());
                        if (this.buffer == null || bid == this.buffer.bid) continue;
                        shouldRefresh = true;
                    }
                }
                if (!shouldRefresh) break;
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (MainActivity.this.refreshUpIndicatorTask != null) {
                            MainActivity.this.refreshUpIndicatorTask.cancel(true);
                        }
                        MainActivity.this.refreshUpIndicatorTask = new RefreshUpIndicatorTask();
                        MainActivity.this.refreshUpIndicatorTask.execute(new Void[]{null});
                    }
                });
                break;
            }
            case 103: {
                IRCCloudJSONObject event = (IRCCloudJSONObject)obj;
                if (event != null && event.has("_reqid")) {
                    int reqid = event.getInt("_reqid");
                    if (this.pendingEvents.containsKey(reqid)) {
                        EventsDataSource.Event e = this.pendingEvents.get(reqid);
                        EventsDataSource.getInstance().deleteEvent(e.eid, e.bid);
                        this.pendingEvents.remove(event.getInt("_reqid"));
                        e.failed = true;
                        e.bg_color = 2131492904;
                        if (e.expiration_timer != null) {
                            e.expiration_timer.cancel();
                        }
                        this.conn.notifyHandlers(5, e);
                    }
                } else {
                    if (event.getString("message").equalsIgnoreCase("auth")) {
                        this.conn.logout();
                        Intent i = new Intent((Context)this, LoginActivity.class);
                        i.addFlags(0x14000000);
                        this.startActivity(i);
                        this.finish();
                    }
                    if (event.getString("message").equalsIgnoreCase("set_shard")) {
                        NetworkConnection.getInstance().disconnect();
                        NetworkConnection.getInstance().ready = false;
                        SharedPreferences.Editor editor = this.getSharedPreferences("prefs", 0).edit();
                        editor.putString("session_key", event.getString("cookie"));
                        if (event.has("websocket_host")) {
                            NetworkConnection.IRCCLOUD_HOST = event.getString("websocket_host");
                            NetworkConnection.IRCCLOUD_PATH = event.getString("websocket_path");
                        }
                        editor.putString("host", NetworkConnection.IRCCLOUD_HOST);
                        editor.putString("path", NetworkConnection.IRCCLOUD_PATH);
                        editor.commit();
                        NetworkConnection.getInstance().connect(event.getString("cookie"));
                    }
                }
                try {
                    this.error = event.getString("message");
                    if (this.error.equals("temp_unavailable")) {
                        this.error = "Your account is temporarily unavailable";
                    }
                    this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            MainActivity.this.updateReconnecting();
                        }
                    });
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                break;
            }
            case 5: {
                try {
                    EventsDataSource.Event e = (EventsDataSource.Event)obj;
                    if (e == null || this.buffer == null) break;
                    if (e.bid != this.buffer.bid && this.upDrawable != null) {
                        BuffersDataSource.Buffer buf = BuffersDataSource.getInstance().getBuffer(e.bid);
                        if (e.isImportant(buf.type)) {
                            if (this.upDrawable.getColor() != this.redColor && (e.highlight || buf.type.equals("conversation"))) {
                                this.runOnUiThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        MainActivity.this.upDrawable.setColor(MainActivity.this.redColor);
                                    }
                                });
                            } else if (this.upDrawable.getColor() == this.greyColor) {
                                JSONObject channelDisabledMap = null;
                                JSONObject bufferDisabledMap = null;
                                if (NetworkConnection.getInstance().getUserInfo() != null && NetworkConnection.getInstance().getUserInfo().prefs != null) {
                                    try {
                                        if (NetworkConnection.getInstance().getUserInfo().prefs.has("channel-disableTrackUnread")) {
                                            channelDisabledMap = NetworkConnection.getInstance().getUserInfo().prefs.getJSONObject("channel-disableTrackUnread");
                                        }
                                        if (NetworkConnection.getInstance().getUserInfo().prefs.has("buffer-disableTrackUnread")) {
                                            bufferDisabledMap = NetworkConnection.getInstance().getUserInfo().prefs.getJSONObject("buffer-disableTrackUnread");
                                        }
                                    }
                                    catch (Exception e1) {
                                        e1.printStackTrace();
                                    }
                                }
                                if (buf.type.equalsIgnoreCase("channel") && channelDisabledMap != null && channelDisabledMap.has(String.valueOf(buf.bid)) && channelDisabledMap.getBoolean(String.valueOf(buf.bid)) || bufferDisabledMap != null && bufferDisabledMap.has(String.valueOf(buf.bid)) && bufferDisabledMap.getBoolean(String.valueOf(buf.bid))) break;
                                this.runOnUiThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        MainActivity.this.upDrawable.setColor(MainActivity.this.blueColor);
                                    }
                                });
                            }
                        }
                    }
                    if (e.from.equalsIgnoreCase(this.buffer.name)) {
                        this.pendingEvents.clear();
                        break;
                    }
                    if (!this.pendingEvents.containsKey(e.reqid)) break;
                    this.pendingEvents.remove(e.reqid);
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu2) {
        if (this.buffer != null && this.buffer.type != null && NetworkConnection.getInstance().ready) {
            if (this.buffer.type.equals("channel")) {
                this.getMenuInflater().inflate(2131689478, menu2);
                this.getMenuInflater().inflate(2131689477, menu2);
            } else if (this.buffer.type.equals("conversation")) {
                this.getMenuInflater().inflate(2131689480, menu2);
            } else if (this.buffer.type.equals("console")) {
                this.getMenuInflater().inflate(0x7F0F0007, menu2);
            }
            this.getMenuInflater().inflate(2131689476, menu2);
        }
        this.getMenuInflater().inflate(2131689475, menu2);
        return super.onCreateOptionsMenu(menu2);
    }

    public boolean onPrepareOptionsMenu(Menu menu2) {
        if (menu2 != null && this.buffer != null && this.buffer.type != null && NetworkConnection.getInstance().ready) {
            if (this.buffer.archived == 0) {
                if (menu2.findItem(2131624225) != null) {
                    menu2.findItem(2131624225).setTitle(2131165268);
                }
            } else if (menu2.findItem(2131624225) != null) {
                menu2.findItem(2131624225).setTitle(2131165282);
            }
            if (this.buffer.type.equals("channel")) {
                if (ChannelsDataSource.getInstance().getChannelForBuffer(this.buffer.bid) == null) {
                    if (menu2.findItem(2131624230) != null) {
                        menu2.findItem(2131624230).setTitle(2131165280);
                    }
                    if (menu2.findItem(2131624225) != null) {
                        menu2.findItem(2131624225).setVisible(true);
                        menu2.findItem(2131624225).setEnabled(true);
                    }
                    if (menu2.findItem(2131624226) != null) {
                        menu2.findItem(2131624226).setVisible(true);
                        menu2.findItem(2131624226).setEnabled(true);
                    }
                    if (menu2.findItem(2131624231) != null) {
                        menu2.findItem(2131624231).setEnabled(false);
                        menu2.findItem(2131624231).setVisible(false);
                    }
                    if (menu2.findItem(2131624229) != null) {
                        menu2.findItem(2131624229).setVisible(false);
                        menu2.findItem(2131624229).setEnabled(false);
                    }
                } else {
                    if (menu2.findItem(2131624230) != null) {
                        menu2.findItem(2131624230).setTitle(2131165276);
                    }
                    if (menu2.findItem(2131624225) != null) {
                        menu2.findItem(2131624225).setVisible(false);
                        menu2.findItem(2131624225).setEnabled(false);
                    }
                    if (menu2.findItem(2131624226) != null) {
                        menu2.findItem(2131624226).setVisible(false);
                        menu2.findItem(2131624226).setEnabled(false);
                    }
                    if (menu2.findItem(2131624229) != null) {
                        menu2.findItem(2131624229).setVisible(true);
                        menu2.findItem(2131624229).setEnabled(true);
                    }
                    if (menu2.findItem(2131624231) != null && this.findViewById(2131624077) != null) {
                        boolean hide = true;
                        try {
                            JSONObject hiddenMap;
                            if (this.conn != null && this.conn.getUserInfo() != null && this.conn.getUserInfo().prefs != null && (hiddenMap = this.conn.getUserInfo().prefs.getJSONObject("channel-hiddenMembers")).has(String.valueOf(this.buffer.bid)) && hiddenMap.getBoolean(String.valueOf(this.buffer.bid))) {
                                hide = false;
                            }
                        }
                        catch (JSONException jSONException) {
                            // empty catch block
                        }
                        if (hide) {
                            menu2.findItem(2131624231).setEnabled(false);
                            menu2.findItem(2131624231).setVisible(false);
                        } else {
                            menu2.findItem(2131624231).setEnabled(true);
                            menu2.findItem(2131624231).setVisible(true);
                        }
                    }
                }
            } else if (this.buffer.type.equals("console")) {
                if (menu2.findItem(2131624225) != null) {
                    menu2.findItem(2131624225).setVisible(false);
                    menu2.findItem(2131624225).setEnabled(false);
                }
                if (this.server != null && this.server.status != null && (this.server.status.equalsIgnoreCase("waiting_to_retry") || this.server.status.contains("connected") && !this.server.status.startsWith("dis"))) {
                    if (menu2.findItem(2131624235) != null) {
                        menu2.findItem(2131624235).setTitle(2131165271);
                    }
                    if (menu2.findItem(2131624226) != null) {
                        menu2.findItem(2131624226).setVisible(false);
                        menu2.findItem(2131624226).setEnabled(false);
                    }
                } else {
                    if (menu2.findItem(2131624235) != null) {
                        menu2.findItem(2131624235).setTitle(2131165279);
                    }
                    if (menu2.findItem(2131624226) != null) {
                        menu2.findItem(2131624226).setVisible(true);
                        menu2.findItem(2131624226).setEnabled(true);
                    }
                }
            }
        }
        return super.onPrepareOptionsMenu(menu2);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent imageReturnedIntent) {
        if (this.buffer != null) {
            if (requestCode == 1 && resultCode == -1) {
                if (this.imageCaptureURI != null) {
                    if (!NetworkConnection.getInstance().uploadsAvailable() || PreferenceManager.getDefaultSharedPreferences((Context)this).getString("image_service", "IRCCloud").equals("imgur")) {
                        new ImgurRefreshTask(this.imageCaptureURI).execute(new Void[]{null});
                    } else {
                        this.fileUploadTask = new FileUploadTask(this.imageCaptureURI, this);
                        this.fileUploadTask.execute(new Void[]{null});
                    }
                    if (PreferenceManager.getDefaultSharedPreferences((Context)this).getBoolean("keep_photos", false) && this.imageCaptureURI.toString().startsWith("file://")) {
                        ContentValues image = new ContentValues();
                        image.put("_data", this.imageCaptureURI.toString().substring(7));
                        this.getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, image);
                    }
                }
            } else if (requestCode == 2 && resultCode == -1) {
                Uri selectedImage = imageReturnedIntent.getData();
                if (selectedImage != null) {
                    if (!NetworkConnection.getInstance().uploadsAvailable() || PreferenceManager.getDefaultSharedPreferences((Context)this).getString("image_service", "IRCCloud").equals("imgur")) {
                        new ImgurRefreshTask(selectedImage).execute(new Void[]{null});
                    } else {
                        this.fileUploadTask = new FileUploadTask(selectedImage, this);
                        this.fileUploadTask.execute(new Void[]{null});
                    }
                }
            } else if (requestCode == 3 && resultCode == -1) {
                Uri selectedFile = imageReturnedIntent.getData();
                if (selectedFile != null) {
                    this.fileUploadTask = new FileUploadTask(selectedFile, this);
                    this.fileUploadTask.execute(new Void[]{null});
                }
            } else if (requestCode == 4 && resultCode == -1) {
                this.buffer.draft = "";
                this.messageTxt.setText("");
            }
        }
    }

    private void insertPhoto() {
        CharSequence[] charSequenceArray;
        if (this.buffer == null) {
            return;
        }
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setInverseBackgroundForced(Build.VERSION.SDK_INT < 11);
        if (Build.VERSION.SDK_INT < 19 || !NetworkConnection.getInstance().uploadsAvailable()) {
            CharSequence[] charSequenceArray2 = new String[4];
            charSequenceArray2[0] = "Take a Photo";
            charSequenceArray2[1] = "Choose Existing";
            charSequenceArray2[2] = "Start a Pastebin";
            charSequenceArray = charSequenceArray2;
            charSequenceArray2[3] = "Your Pastebins";
        } else {
            String[] stringArray = new String[5];
            stringArray[0] = "Take a Photo";
            stringArray[1] = "Choose Existing Photo";
            stringArray[2] = "Choose Existing Document";
            stringArray[3] = "Start a Pastebin";
            charSequenceArray = stringArray;
            stringArray[4] = "Your Pastebins";
        }
        CharSequence[] items = charSequenceArray;
        if (NetworkConnection.getInstance().uploadsAvailable()) {
            items = Arrays.copyOf(items, items.length + 1);
            items[items.length - 1] = "File Uploads";
        }
        CharSequence[] dialogItems = items;
        builder.setItems(dialogItems, new DialogInterface.OnClickListener((String[])dialogItems){
            final /* synthetic */ String[] val$dialogItems;
            {
                this.val$dialogItems = stringArray;
            }

            public void onClick(DialogInterface dialog, int which) {
                if (MainActivity.this.buffer != null) {
                    switch (this.val$dialogItems[which]) {
                        case "Take a Photo": {
                            try {
                                File imageDir = new File(Environment.getExternalStorageDirectory(), "IRCCloud");
                                imageDir.mkdirs();
                                new File(imageDir, ".nomedia").createNewFile();
                                MainActivity.this.imageCaptureURI = Uri.fromFile((File)File.createTempFile("irccloudcapture", ".jpg", imageDir));
                                Intent i = new Intent("android.media.action.IMAGE_CAPTURE");
                                i.putExtra("output", (Parcelable)MainActivity.this.imageCaptureURI);
                                MainActivity.this.startActivityForResult(i, 1);
                            }
                            catch (IOException iOException) {}
                            break;
                        }
                        case "Choose Existing": 
                        case "Choose Existing Photo": {
                            Intent i = new Intent("android.intent.action.GET_CONTENT", MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
                            i.addCategory("android.intent.category.OPENABLE");
                            i.setType("image/*");
                            MainActivity.this.startActivityForResult(Intent.createChooser((Intent)i, (CharSequence)"Select Picture"), 2);
                            break;
                        }
                        case "Choose Existing Document": {
                            Intent i = new Intent("android.intent.action.GET_CONTENT");
                            i.addCategory("android.intent.category.OPENABLE");
                            i.setType("*/*");
                            MainActivity.this.startActivityForResult(Intent.createChooser((Intent)i, (CharSequence)"Select A Document"), 3);
                            break;
                        }
                        case "Start a Pastebin": {
                            MainActivity.this.show_pastebin_prompt();
                            break;
                        }
                        case "Your Pastebins": {
                            Intent i = new Intent((Context)MainActivity.this, PastebinsActivity.class);
                            MainActivity.this.startActivity(i);
                            break;
                        }
                        case "File Uploads": {
                            Intent i = new Intent((Context)MainActivity.this, UploadsActivity.class);
                            i.putExtra("cid", MainActivity.this.buffer.cid);
                            i.putExtra("to", MainActivity.this.buffer.name);
                            i.putExtra("msg", MainActivity.this.messageTxt.getText().toString());
                            MainActivity.this.startActivityForResult(i, 4);
                        }
                    }
                }
                dialog.dismiss();
            }
        });
        AlertDialog dialog = builder.create();
        dialog.setOwnerActivity(this);
        dialog.show();
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                if (this.drawerLayout == null || this.findViewById(2131624077) != null) break;
                if (this.drawerLayout.isDrawerOpen(3)) {
                    this.drawerLayout.closeDrawer(3);
                } else if (this.drawerLayout.getDrawerLockMode(3) == 0) {
                    this.drawerLayout.openDrawer(3);
                }
                this.drawerLayout.closeDrawer(5);
                break;
            }
            case 2131624236: {
                NetworkConnection.getInstance().whois(this.buffer.cid, this.buffer.name, null);
                break;
            }
            case 2131624234: {
                NickservFragment nsFragment = new NickservFragment();
                nsFragment.setCid(this.buffer.cid);
                nsFragment.show(this.getSupportFragmentManager(), "nickserv");
                break;
            }
            case 2131624224: {
                this.addNetwork();
                break;
            }
            case 2131624227: {
                ChannelOptionsFragment newFragment = new ChannelOptionsFragment(this.buffer.cid, this.buffer.bid);
                newFragment.show(this.getSupportFragmentManager(), "channeloptions");
                break;
            }
            case 2131624232: {
                BufferOptionsFragment bufferFragment = new BufferOptionsFragment(this.buffer.cid, this.buffer.bid, this.buffer.type);
                bufferFragment.show(this.getSupportFragmentManager(), "bufferoptions");
                break;
            }
            case 2131624231: {
                if (this.drawerLayout != null) {
                    if (this.drawerLayout.isDrawerOpen(5)) {
                        this.drawerLayout.closeDrawers();
                    } else {
                        if (this.findViewById(2131624077) == null) {
                            this.drawerLayout.closeDrawer(3);
                        }
                        this.drawerLayout.setDrawerLockMode(0, 5);
                        this.drawerLayout.openDrawer(5);
                    }
                    if (!this.getSharedPreferences("prefs", 0).getBoolean("userSwipeTip", false)) {
                        Toast.makeText((Context)this, (CharSequence)"Drag from the edge of the screen to quickly open and close the user list", (int)1).show();
                        SharedPreferences.Editor editor = this.getSharedPreferences("prefs", 0).edit();
                        editor.putBoolean("userSwipeTip", true);
                        editor.commit();
                    }
                }
                return true;
            }
            case 2131624228: {
                Bundle args = new Bundle();
                args.putInt("cid", this.buffer.cid);
                IgnoreListFragment ignoreList = new IgnoreListFragment();
                ignoreList.setArguments(args);
                ignoreList.show(this.getSupportFragmentManager(), "ignorelist");
                return true;
            }
            case 2131624229: {
                NetworkConnection.getInstance().mode(this.buffer.cid, this.buffer.name, "b");
                return true;
            }
            case 2131624230: {
                if (ChannelsDataSource.getInstance().getChannelForBuffer(this.buffer.bid) == null) {
                    NetworkConnection.getInstance().join(this.buffer.cid, this.buffer.name, null);
                } else {
                    NetworkConnection.getInstance().part(this.buffer.cid, this.buffer.name, null);
                }
                return true;
            }
            case 2131624225: {
                if (this.buffer.archived == 0) {
                    NetworkConnection.getInstance().archiveBuffer(this.buffer.cid, this.buffer.bid);
                } else {
                    NetworkConnection.getInstance().unarchiveBuffer(this.buffer.cid, this.buffer.bid);
                }
                return true;
            }
            case 2131624226: {
                AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
                builder.setInverseBackgroundForced(Build.VERSION.SDK_INT < 11);
                if (this.buffer.type.equals("console")) {
                    builder.setTitle("Delete Connection");
                } else {
                    builder.setTitle("Delete History");
                }
                if (this.buffer.type.equalsIgnoreCase("console")) {
                    builder.setMessage("Are you sure you want to remove this connection?");
                } else if (this.buffer.type.equalsIgnoreCase("channel")) {
                    builder.setMessage("Are you sure you want to clear your history in " + this.buffer.name + "?");
                } else {
                    builder.setMessage("Are you sure you want to clear your history with " + this.buffer.name + "?");
                }
                builder.setPositiveButton("Cancel", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                    }
                });
                builder.setNeutralButton("Delete", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        if (MainActivity.this.buffer.type.equals("console")) {
                            NetworkConnection.getInstance().deleteServer(MainActivity.this.buffer.cid);
                        } else {
                            NetworkConnection.getInstance().deleteBuffer(MainActivity.this.buffer.cid, MainActivity.this.buffer.bid);
                        }
                        dialog.dismiss();
                    }
                });
                AlertDialog dialog = builder.create();
                dialog.setOwnerActivity(this);
                dialog.show();
                return true;
            }
            case 2131624233: {
                if (!this.getResources().getBoolean(2131361795)) {
                    Intent i = new Intent((Context)this, EditConnectionActivity.class);
                    i.putExtra("cid", this.buffer.cid);
                    this.startActivity(i);
                } else {
                    EditConnectionFragment editFragment = new EditConnectionFragment();
                    editFragment.setCid(this.buffer.cid);
                    editFragment.show(this.getSupportFragmentManager(), "editconnection");
                }
                return true;
            }
            case 2131624235: {
                if (this.server != null && this.server.status != null && this.server.status.equalsIgnoreCase("waiting_to_retry") || this.server.status.contains("connected") && !this.server.status.startsWith("dis")) {
                    NetworkConnection.getInstance().disconnect(this.buffer.cid, null);
                } else {
                    NetworkConnection.getInstance().reconnect(this.buffer.cid);
                }
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    void editTopic() {
        ChannelsDataSource.Channel c = ChannelsDataSource.getInstance().getChannelForBuffer(this.buffer.bid);
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setInverseBackgroundForced(Build.VERSION.SDK_INT < 11);
        View view = this.getDialogTextPrompt();
        TextView prompt = (TextView)view.findViewById(2131624120);
        final EditText input = (EditText)view.findViewById(2131624121);
        input.setText((CharSequence)c.topic_text);
        prompt.setVisibility(8);
        builder.setTitle("Channel Topic");
        builder.setView(view);
        builder.setPositiveButton("Set Topic", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                MainActivity.this.conn.topic(MainActivity.this.buffer.cid, MainActivity.this.buffer.name, input.getText().toString());
                dialog.dismiss();
            }
        });
        builder.setNegativeButton("Cancel", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        AlertDialog dialog = builder.create();
        dialog.setOwnerActivity(this);
        dialog.getWindow().setSoftInputMode(5);
        dialog.show();
    }

    @Override
    public void onMessageDoubleClicked(EventsDataSource.Event event) {
        if (event == null) {
            return;
        }
        String from = event.from;
        if (from == null || from.length() == 0) {
            from = event.nick;
        }
        this.onUserDoubleClicked(from);
    }

    @Override
    public void onUserDoubleClicked(String from) {
        if (this.messageTxt == null || from == null || from.length() == 0) {
            return;
        }
        if (!this.getSharedPreferences("prefs", 0).getBoolean("mentionTip", false)) {
            SharedPreferences.Editor editor = this.getSharedPreferences("prefs", 0).edit();
            editor.putBoolean("mentionTip", true);
            editor.commit();
        }
        if (this.drawerLayout != null) {
            this.drawerLayout.closeDrawers();
        }
        if (this.messageTxt.getText().length() == 0) {
            this.messageTxt.append(from + ": ");
        } else {
            char nextChar;
            int oldPosition = this.messageTxt.getSelectionStart();
            if (oldPosition < 0) {
                oldPosition = 0;
            }
            String text = this.messageTxt.getText().toString();
            int start = oldPosition - 1;
            if (start > 0 && text.charAt(start) == ' ') {
                --start;
            }
            while (start > 0 && text.charAt(start) != ' ') {
                --start;
            }
            int match = text.indexOf(from, start);
            int end = oldPosition + from.length();
            if (end > text.length() - 1) {
                end = text.length() - 1;
            }
            char c = nextChar = match + from.length() < text.length() ? text.charAt(match + from.length()) : (char)'\u0000';
            if (match >= 0 && match < end && (nextChar == '\u0000' || nextChar == ' ' || nextChar == ':')) {
                String newtext = "";
                newtext = match > 1 && text.charAt(match - 1) == ' ' ? text.substring(0, match - 1) : text.substring(0, match);
                if (match + from.length() < text.length() && text.charAt(match + from.length()) == ':' && match + from.length() + 1 < text.length() && text.charAt(match + from.length() + 1) == ' ') {
                    if (match + from.length() + 2 < text.length()) {
                        newtext = newtext + text.substring(match + from.length() + 2, text.length());
                    }
                } else if (match + from.length() < text.length()) {
                    newtext = newtext + text.substring(match + from.length(), text.length());
                }
                if (newtext.endsWith(" ")) {
                    newtext = newtext.substring(0, newtext.length() - 1);
                }
                if (newtext.equals(":")) {
                    newtext = "";
                }
                this.messageTxt.setText(newtext);
                if (match < newtext.length()) {
                    this.messageTxt.setSelection(match);
                } else {
                    this.messageTxt.setSelection(newtext.length());
                }
            } else {
                if (oldPosition == text.length() - 1) {
                    text = text + " " + from + " ";
                } else {
                    String newtext;
                    String string2 = newtext = oldPosition > 0 ? text.substring(0, oldPosition) : "";
                    if (!newtext.endsWith(" ")) {
                        from = " " + from;
                    }
                    if (!text.substring(oldPosition, text.length()).startsWith(" ")) {
                        from = from + " ";
                    }
                    newtext = newtext + from;
                    if ((newtext = newtext + text.substring(oldPosition, text.length())).endsWith(" ")) {
                        newtext = newtext.substring(0, newtext.length() - 1);
                    }
                    text = newtext + " ";
                }
                this.messageTxt.setText(text);
                if (text.length() > 0) {
                    if (oldPosition + from.length() + 2 < text.length()) {
                        this.messageTxt.setSelection(oldPosition + from.length());
                    } else {
                        this.messageTxt.setSelection(text.length());
                    }
                }
            }
        }
        this.messageTxt.requestFocus();
        InputMethodManager keyboard = (InputMethodManager)this.getSystemService("input_method");
        keyboard.showSoftInput((View)this.messageTxt, 0);
    }

    @Override
    public boolean onBufferLongClicked(final BuffersDataSource.Buffer b) {
        if (b == null) {
            return false;
        }
        ArrayList<String> itemList = new ArrayList<String>();
        ServersDataSource.Server s = ServersDataSource.getInstance().getServer(b.cid);
        if (this.buffer == null || b.bid != this.buffer.bid) {
            itemList.add("Open");
        }
        if (ChannelsDataSource.getInstance().getChannelForBuffer(b.bid) != null) {
            itemList.add("Leave");
            itemList.add("Display Options\u2026");
        } else {
            if (b.type.equalsIgnoreCase("channel")) {
                itemList.add("Join");
            } else if (b.type.equalsIgnoreCase("console")) {
                if (s.status.equalsIgnoreCase("waiting_to_retry") || s.status.contains("connected") && !s.status.startsWith("dis")) {
                    itemList.add("Disconnect");
                } else {
                    itemList.add("Connect");
                    itemList.add("Delete");
                }
                itemList.add("Edit Connection\u2026");
            }
            if (!b.type.equalsIgnoreCase("console")) {
                if (b.archived == 0) {
                    itemList.add("Archive");
                } else {
                    itemList.add("Unarchive");
                }
                itemList.add("Delete");
            }
            if (!b.type.equalsIgnoreCase("channel")) {
                itemList.add("Display Options\u2026");
            }
        }
        itemList.add("Mark All As Read");
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setInverseBackgroundForced(Build.VERSION.SDK_INT < 11);
        if (b.type.equalsIgnoreCase("console")) {
            builder.setTitle(s.name);
        } else {
            builder.setTitle(b.name);
        }
        CharSequence[] items = itemList.toArray(new String[itemList.size()]);
        builder.setItems(items, new DialogInterface.OnClickListener((String[])items){
            final /* synthetic */ String[] val$items;
            {
                this.val$items = stringArray;
            }

            public void onClick(DialogInterface dialogInterface, int item) {
                if (MainActivity.this.conn == null || b == null) {
                    return;
                }
                if (this.val$items[item].equals("Open")) {
                    MainActivity.this.onBufferSelected(b.bid);
                } else if (this.val$items[item].equals("Join")) {
                    MainActivity.this.conn.join(b.cid, b.name, null);
                } else if (this.val$items[item].equals("Leave")) {
                    MainActivity.this.conn.part(b.cid, b.name, null);
                } else if (this.val$items[item].equals("Archive")) {
                    MainActivity.this.conn.archiveBuffer(b.cid, b.bid);
                } else if (this.val$items[item].equals("Unarchive")) {
                    MainActivity.this.conn.unarchiveBuffer(b.cid, b.bid);
                } else if (this.val$items[item].equals("Connect")) {
                    MainActivity.this.conn.reconnect(b.cid);
                } else if (this.val$items[item].equals("Disconnect")) {
                    MainActivity.this.conn.disconnect(b.cid, null);
                } else if (this.val$items[item].equals("Display Options\u2026")) {
                    if (b.type.equals("channel")) {
                        ChannelOptionsFragment newFragment = new ChannelOptionsFragment(b.cid, b.bid);
                        newFragment.show(MainActivity.this.getSupportFragmentManager(), "channeloptions");
                    } else {
                        BufferOptionsFragment newFragment = new BufferOptionsFragment(b.cid, b.bid, b.type);
                        newFragment.show(MainActivity.this.getSupportFragmentManager(), "bufferoptions");
                    }
                } else if (this.val$items[item].equals("Edit Connection\u2026")) {
                    if (!MainActivity.this.getResources().getBoolean(2131361795)) {
                        Intent i = new Intent((Context)MainActivity.this, EditConnectionActivity.class);
                        i.putExtra("cid", b.cid);
                        MainActivity.this.startActivity(i);
                    } else {
                        EditConnectionFragment editFragment = new EditConnectionFragment();
                        editFragment.setCid(b.cid);
                        editFragment.show(MainActivity.this.getSupportFragmentManager(), "editconnection");
                    }
                } else if (this.val$items[item].equals("Mark All As Read")) {
                    ArrayList<Integer> cids = new ArrayList<Integer>();
                    ArrayList<Integer> bids = new ArrayList<Integer>();
                    ArrayList<Long> eids = new ArrayList<Long>();
                    for (BuffersDataSource.Buffer b2 : BuffersDataSource.getInstance().getBuffers()) {
                        if (b2.unread != 1 || EventsDataSource.getInstance().lastEidForBuffer(b2.bid) <= 0L) continue;
                        b2.unread = 0;
                        b2.highlights = 0;
                        b2.last_seen_eid = EventsDataSource.getInstance().lastEidForBuffer(b2.bid);
                        cids.add(b2.cid);
                        bids.add(b2.bid);
                        eids.add(b2.last_seen_eid);
                    }
                    BuffersListFragment blf = (BuffersListFragment)MainActivity.this.getSupportFragmentManager().findFragmentById(2131624075);
                    if (blf != null) {
                        blf.refresh();
                    }
                    MainActivity.this.conn.heartbeat(MainActivity.this.buffer.bid, cids.toArray(new Integer[cids.size()]), bids.toArray(new Integer[bids.size()]), eids.toArray(new Long[eids.size()]));
                } else if (this.val$items[item].equals("Delete")) {
                    AlertDialog.Builder builder = new AlertDialog.Builder((Context)MainActivity.this);
                    builder.setInverseBackgroundForced(Build.VERSION.SDK_INT < 11);
                    if (b.type.equalsIgnoreCase("console")) {
                        builder.setTitle("Delete Connection");
                    } else {
                        builder.setTitle("Delete History");
                    }
                    if (b.type.equalsIgnoreCase("console")) {
                        builder.setMessage("Are you sure you want to remove this connection?");
                    } else if (b.type.equalsIgnoreCase("channel")) {
                        builder.setMessage("Are you sure you want to clear your history in " + b.name + "?");
                    } else {
                        builder.setMessage("Are you sure you want to clear your history with " + b.name + "?");
                    }
                    builder.setPositiveButton("Cancel", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            dialog.dismiss();
                        }
                    });
                    builder.setNeutralButton("Delete", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            if (b.type.equalsIgnoreCase("console")) {
                                MainActivity.this.conn.deleteServer(b.cid);
                            } else {
                                MainActivity.this.conn.deleteBuffer(b.cid, b.bid);
                            }
                            dialog.dismiss();
                        }
                    });
                    AlertDialog dialog = builder.create();
                    dialog.setOwnerActivity(MainActivity.this);
                    dialog.show();
                }
            }
        });
        AlertDialog dialog = builder.create();
        dialog.setOwnerActivity(this);
        dialog.show();
        return true;
    }

    @Override
    public boolean onMessageLongClicked(EventsDataSource.Event event) {
        UsersDataSource.User user;
        String from = event.from;
        if (from == null || from.length() == 0) {
            from = event.nick;
        }
        if ((user = UsersDataSource.getInstance().getUser(this.buffer.bid, from)) == null && from != null && event.hostmask != null) {
            user = new UsersDataSource.User();
            user.nick = from;
            user.hostmask = event.hostmask;
            user.mode = "";
        }
        if (user == null && event.html == null) {
            return false;
        }
        if (event.hostmask != null && event.hostmask.length() > 0) {
            user.hostmask = event.hostmask;
        }
        if (event.html != null) {
            String html = event.html;
            if (event.type.equals("buffer_msg") && user != null && html.startsWith("<b>")) {
                String nick = event.html.substring(0, event.html.indexOf("</b>"));
                if (!nick.contains(user.nick) && event.html.indexOf("</b>", nick.length() + 4) > 0) {
                    nick = event.html.substring(0, event.html.indexOf("</b>", nick.length() + 4));
                }
                if (nick.contains(user.nick + "<")) {
                    html = html.substring(nick.length());
                    nick = "<b>&lt;" + nick.replace("</b> <font", "</b><font").substring(3);
                    html = nick + "&gt;" + html;
                } else if (nick.endsWith(user.nick)) {
                    html = html.substring(nick.length());
                    nick = "<b>&lt;" + nick.replace("</b> ", "</b>").substring(3);
                    html = nick + "&gt;" + html;
                }
            }
            this.showUserPopup(user, ColorFormatter.html_to_spanned(event.timestamp + " " + html, true, ServersDataSource.getInstance().getServer(event.cid)));
        } else {
            this.showUserPopup(user, null);
        }
        return true;
    }

    @Override
    public void onFailedMessageClicked(EventsDataSource.Event event) {
        final EventsDataSource.Event e = event;
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setInverseBackgroundForced(Build.VERSION.SDK_INT < 11);
        builder.setTitle(this.server.name + " (" + this.server.hostname + ":" + this.server.port + ")");
        builder.setMessage("This message could not be sent");
        builder.setNegativeButton("Cancel", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                try {
                    dialog.dismiss();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        });
        builder.setPositiveButton("Try Again", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                try {
                    MainActivity.this.pendingEvents.remove(e.reqid);
                    e.pending = true;
                    e.failed = false;
                    e.bg_color = 2131492946;
                    e.reqid = NetworkConnection.getInstance().say(e.cid, e.chan, e.command);
                    if (e.reqid >= 0) {
                        MainActivity.this.pendingEvents.put(e.reqid, e);
                        e.expiration_timer = new TimerTask(){

                            @Override
                            public void run() {
                                if (MainActivity.this.pendingEvents.containsKey(e.reqid)) {
                                    MainActivity.this.pendingEvents.remove(e.reqid);
                                    e.failed = true;
                                    e.bg_color = 2131492904;
                                    e.expiration_timer = null;
                                    NetworkConnection.getInstance().notifyHandlers(5, e, MainActivity.this);
                                }
                            }
                        };
                        if (countdownTimer != null) {
                            countdownTimer.schedule(e.expiration_timer, 30000L);
                        }
                    }
                    dialog.dismiss();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        });
        AlertDialog dialog = builder.create();
        dialog.setOwnerActivity(this);
        dialog.show();
    }

    @Override
    public void onUserSelected(int c, String chan, String nick) {
        UsersDataSource u = UsersDataSource.getInstance();
        this.showUserPopup(u.getUser(this.buffer.bid, nick), null);
    }

    @SuppressLint(value={"NewApi"})
    private void showUserPopup(UsersDataSource.User user, Spanned message) {
        ArrayList<String> itemList = new ArrayList<String>();
        Spanned text_to_copy = message;
        this.selected_user = user;
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setInverseBackgroundForced(Build.VERSION.SDK_INT < 11);
        if (message != null) {
            if (((URLSpan[])message.getSpans(0, message.length(), URLSpan.class)).length > 0) {
                itemList.add("Copy URL");
            }
            itemList.add("Copy Message");
        }
        if (this.selected_user != null) {
            UsersDataSource.User self_user;
            itemList.add("Whois\u2026");
            itemList.add("Send a message");
            itemList.add("Mention");
            itemList.add("Invite to a channel\u2026");
            itemList.add("Ignore");
            if (this.buffer.type.equalsIgnoreCase("channel") && (self_user = UsersDataSource.getInstance().getUser(this.buffer.bid, this.server.nick)) != null && self_user.mode != null) {
                if (self_user.mode.contains(this.server != null ? this.server.MODE_OWNER : "q") || self_user.mode.contains(this.server != null ? this.server.MODE_ADMIN : "a") || self_user.mode.contains(this.server != null ? this.server.MODE_OP : "o")) {
                    if (this.selected_user.mode.contains(this.server != null ? this.server.MODE_OP : "o")) {
                        itemList.add("Deop");
                    } else {
                        itemList.add("Op");
                    }
                }
                if (self_user.mode.contains(this.server != null ? this.server.MODE_OWNER : "q") || self_user.mode.contains(this.server != null ? this.server.MODE_ADMIN : "a") || self_user.mode.contains(this.server != null ? this.server.MODE_OP : "o") || self_user.mode.contains(this.server != null ? this.server.MODE_HALFOP : "h")) {
                    itemList.add("Kick\u2026");
                    itemList.add("Ban\u2026");
                }
            }
            itemList.add("Copy Hostmask");
        }
        CharSequence[] items = itemList.toArray(new String[itemList.size()]);
        if (this.selected_user != null) {
            if (this.selected_user.hostmask != null && this.selected_user.hostmask.length() > 0) {
                builder.setTitle(this.selected_user.nick + "\n(" + this.selected_user.hostmask + ")");
            } else {
                builder.setTitle(this.selected_user.nick);
            }
        } else {
            builder.setTitle("Message");
        }
        builder.setItems(items, new DialogInterface.OnClickListener((String[])items, text_to_copy){
            final /* synthetic */ String[] val$items;
            final /* synthetic */ Spanned val$text_to_copy;
            {
                this.val$items = stringArray;
                this.val$text_to_copy = spanned;
            }

            public void onClick(DialogInterface dialogInterface, int item) {
                if (MainActivity.this.conn == null || MainActivity.this.buffer == null) {
                    return;
                }
                AlertDialog.Builder builder = new AlertDialog.Builder((Context)MainActivity.this);
                builder.setInverseBackgroundForced(Build.VERSION.SDK_INT < 11);
                if (this.val$items[item].equals("Copy Message")) {
                    if (Build.VERSION.SDK_INT < 11) {
                        android.text.ClipboardManager clipboard = (android.text.ClipboardManager)MainActivity.this.getSystemService("clipboard");
                        clipboard.setText((CharSequence)this.val$text_to_copy);
                    } else {
                        ClipboardManager clipboard = (ClipboardManager)MainActivity.this.getSystemService("clipboard");
                        if (clipboard != null) {
                            ClipData clip = ClipData.newPlainText((CharSequence)"IRCCloud Message", (CharSequence)this.val$text_to_copy);
                            clipboard.setPrimaryClip(clip);
                        } else {
                            Toast.makeText((Context)MainActivity.this, (CharSequence)"Unable to copy message. Please try again.", (int)0).show();
                            return;
                        }
                    }
                    Toast.makeText((Context)MainActivity.this, (CharSequence)"Message copied to clipboard", (int)0).show();
                } else if (this.val$items[item].equals("Copy Hostmask")) {
                    if (Build.VERSION.SDK_INT < 11) {
                        android.text.ClipboardManager clipboard = (android.text.ClipboardManager)MainActivity.this.getSystemService("clipboard");
                        clipboard.setText((CharSequence)(MainActivity.this.selected_user.nick + "!" + MainActivity.this.selected_user.hostmask));
                    } else {
                        ClipboardManager clipboard = (ClipboardManager)MainActivity.this.getSystemService("clipboard");
                        ClipData clip = ClipData.newPlainText((CharSequence)"Hostmask", (CharSequence)(MainActivity.this.selected_user.nick + "!" + MainActivity.this.selected_user.hostmask));
                        clipboard.setPrimaryClip(clip);
                    }
                    Toast.makeText((Context)MainActivity.this, (CharSequence)"Hostmask copied to clipboard", (int)0).show();
                } else if (this.val$items[item].equals("Copy URL") && this.val$text_to_copy != null) {
                    final ArrayList<String> urlListItems = new ArrayList<String>();
                    for (URLSpan o : (URLSpan[])this.val$text_to_copy.getSpans(0, this.val$text_to_copy.length(), URLSpan.class)) {
                        String url = o.getURL();
                        url = url.replace(MainActivity.this.getResources().getString(2131165231) + "://", "http://");
                        url = url.replace(MainActivity.this.getResources().getString(2131165232) + "://", "https://");
                        if (MainActivity.this.server != null) {
                            url = url.replace(MainActivity.this.getResources().getString(2131165233) + "://cid/" + MainActivity.this.server.cid + "/", (MainActivity.this.server.ssl > 0 ? "ircs://" : "irc://") + MainActivity.this.server.hostname + ":" + MainActivity.this.server.port + "/");
                        }
                        urlListItems.add(url);
                    }
                    if (urlListItems.size() == 1) {
                        android.text.ClipboardManager clipboard;
                        if (Build.VERSION.SDK_INT < 11) {
                            clipboard = (android.text.ClipboardManager)MainActivity.this.getSystemService("clipboard");
                            clipboard.setText((CharSequence)urlListItems.get(0));
                        } else {
                            clipboard = (ClipboardManager)MainActivity.this.getSystemService("clipboard");
                            ClipData clip = ClipData.newRawUri((CharSequence)((CharSequence)urlListItems.get(0)), (Uri)Uri.parse((String)((String)urlListItems.get(0))));
                            clipboard.setPrimaryClip(clip);
                        }
                        Toast.makeText((Context)MainActivity.this, (CharSequence)"URL copied to clipboard", (int)0).show();
                    } else {
                        builder = new AlertDialog.Builder((Context)MainActivity.this);
                        builder.setInverseBackgroundForced(Build.VERSION.SDK_INT < 11);
                        builder.setTitle("Choose a URL");
                        builder.setItems(urlListItems.toArray(new String[urlListItems.size()]), new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialogInterface, int i) {
                                if (Build.VERSION.SDK_INT < 11) {
                                    android.text.ClipboardManager clipboard = (android.text.ClipboardManager)MainActivity.this.getSystemService("clipboard");
                                    clipboard.setText((CharSequence)urlListItems.get(i));
                                } else {
                                    ClipboardManager clipboard = (ClipboardManager)MainActivity.this.getSystemService("clipboard");
                                    ClipData clip = ClipData.newRawUri((CharSequence)((CharSequence)urlListItems.get(i)), (Uri)Uri.parse((String)((String)urlListItems.get(i))));
                                    clipboard.setPrimaryClip(clip);
                                }
                                Toast.makeText((Context)MainActivity.this, (CharSequence)"URL copied to clipboard", (int)0).show();
                            }
                        });
                        builder.setNegativeButton("Cancel", new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialog, int which) {
                                dialog.dismiss();
                            }
                        });
                        AlertDialog dialog = builder.create();
                        dialog.setOwnerActivity(MainActivity.this);
                        dialog.getWindow().setSoftInputMode(5);
                        dialog.show();
                    }
                } else if (this.val$items[item].equals("Whois\u2026")) {
                    MainActivity.this.conn.whois(MainActivity.this.buffer.cid, MainActivity.this.selected_user.nick, null);
                } else if (this.val$items[item].equals("Send a message")) {
                    MainActivity.this.conn.say(MainActivity.this.buffer.cid, null, "/query " + MainActivity.this.selected_user.nick);
                } else if (this.val$items[item].equals("Mention")) {
                    if (!MainActivity.this.getSharedPreferences("prefs", 0).getBoolean("mentionTip", false)) {
                        Toast.makeText((Context)MainActivity.this, (CharSequence)"Double-tap a message to quickly reply to the sender", (int)1).show();
                        SharedPreferences.Editor editor = MainActivity.this.getSharedPreferences("prefs", 0).edit();
                        editor.putBoolean("mentionTip", true);
                        editor.commit();
                    }
                    MainActivity.this.onUserDoubleClicked(MainActivity.this.selected_user.nick);
                } else if (this.val$items[item].equals("Invite to a channel\u2026")) {
                    View view = MainActivity.this.getDialogTextPrompt();
                    TextView prompt = (TextView)view.findViewById(2131624120);
                    final EditText input = (EditText)view.findViewById(2131624121);
                    input.setText((CharSequence)"");
                    prompt.setText((CharSequence)("Invite " + MainActivity.this.selected_user.nick + " to a channel"));
                    builder.setTitle(MainActivity.this.server.name + " (" + MainActivity.this.server.hostname + ":" + MainActivity.this.server.port + ")");
                    builder.setView(view);
                    builder.setPositiveButton("Invite", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            MainActivity.this.conn.invite(MainActivity.this.buffer.cid, input.getText().toString(), MainActivity.this.selected_user.nick);
                            dialog.dismiss();
                        }
                    });
                    builder.setNegativeButton("Cancel", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            dialog.dismiss();
                        }
                    });
                    AlertDialog dialog = builder.create();
                    dialog.setOwnerActivity(MainActivity.this);
                    dialog.getWindow().setSoftInputMode(5);
                    dialog.show();
                } else if (this.val$items[item].equals("Ignore")) {
                    View view = MainActivity.this.getDialogTextPrompt();
                    TextView prompt = (TextView)view.findViewById(2131624120);
                    final EditText input = (EditText)view.findViewById(2131624121);
                    input.setText((CharSequence)("*!" + MainActivity.this.selected_user.hostmask));
                    prompt.setText((CharSequence)("Ignore messages for " + MainActivity.this.selected_user.nick + " at this hostmask"));
                    builder.setTitle(MainActivity.this.server.name + " (" + MainActivity.this.server.hostname + ":" + MainActivity.this.server.port + ")");
                    builder.setView(view);
                    builder.setPositiveButton("Ignore", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            MainActivity.this.conn.ignore(MainActivity.this.buffer.cid, input.getText().toString());
                            dialog.dismiss();
                        }
                    });
                    builder.setNegativeButton("Cancel", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            dialog.dismiss();
                        }
                    });
                    AlertDialog dialog = builder.create();
                    dialog.setOwnerActivity(MainActivity.this);
                    dialog.getWindow().setSoftInputMode(5);
                    dialog.show();
                } else if (this.val$items[item].equals("Op")) {
                    MainActivity.this.conn.mode(MainActivity.this.buffer.cid, MainActivity.this.buffer.name, "+" + (MainActivity.this.server != null ? MainActivity.this.server.MODE_OP : "o") + " " + MainActivity.this.selected_user.nick);
                } else if (this.val$items[item].equals("Deop")) {
                    MainActivity.this.conn.mode(MainActivity.this.buffer.cid, MainActivity.this.buffer.name, "-" + (MainActivity.this.server != null ? MainActivity.this.server.MODE_OP : "o") + " " + MainActivity.this.selected_user.nick);
                } else if (this.val$items[item].equals("Kick\u2026")) {
                    View view = MainActivity.this.getDialogTextPrompt();
                    TextView prompt = (TextView)view.findViewById(2131624120);
                    final EditText input = (EditText)view.findViewById(2131624121);
                    input.setText((CharSequence)"");
                    prompt.setText((CharSequence)"Give a reason for kicking");
                    builder.setTitle(MainActivity.this.server.name + " (" + MainActivity.this.server.hostname + ":" + MainActivity.this.server.port + ")");
                    builder.setView(view);
                    builder.setPositiveButton("Kick", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            MainActivity.this.conn.kick(MainActivity.this.buffer.cid, MainActivity.this.buffer.name, MainActivity.this.selected_user.nick, input.getText().toString());
                            dialog.dismiss();
                        }
                    });
                    builder.setNegativeButton("Cancel", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            dialog.dismiss();
                        }
                    });
                    AlertDialog dialog = builder.create();
                    dialog.setOwnerActivity(MainActivity.this);
                    dialog.getWindow().setSoftInputMode(5);
                    dialog.show();
                } else if (this.val$items[item].equals("Ban\u2026")) {
                    View view = MainActivity.this.getDialogTextPrompt();
                    TextView prompt = (TextView)view.findViewById(2131624120);
                    final EditText input = (EditText)view.findViewById(2131624121);
                    input.setText((CharSequence)("*!" + MainActivity.this.selected_user.hostmask));
                    prompt.setText((CharSequence)("Add a banmask for " + MainActivity.this.selected_user.nick));
                    builder.setTitle(MainActivity.this.server.name + " (" + MainActivity.this.server.hostname + ":" + MainActivity.this.server.port + ")");
                    builder.setView(view);
                    builder.setPositiveButton("Ban", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            MainActivity.this.conn.mode(MainActivity.this.buffer.cid, MainActivity.this.buffer.name, "+b " + input.getText().toString());
                            dialog.dismiss();
                        }
                    });
                    builder.setNegativeButton("Cancel", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            dialog.dismiss();
                        }
                    });
                    AlertDialog dialog = builder.create();
                    dialog.setOwnerActivity(MainActivity.this);
                    dialog.getWindow().setSoftInputMode(5);
                    dialog.show();
                }
                dialogInterface.dismiss();
            }
        });
        AlertDialog dialog = builder.create();
        dialog.setOwnerActivity(this);
        dialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialogInterface) {
                MessageViewFragment mvf = (MessageViewFragment)MainActivity.this.getSupportFragmentManager().findFragmentById(2131624071);
                if (mvf != null) {
                    mvf.longPressOverride = false;
                }
            }
        });
        dialog.show();
    }

    @Override
    public void onBufferSelected(int bid) {
        this.launchBid = -1;
        this.launchURI = null;
        this.cidToOpen = -1;
        this.bufferToOpen = null;
        this.setIntent(new Intent((Context)this, MainActivity.class));
        if (this.suggestionsTimerTask != null) {
            this.suggestionsTimerTask.cancel();
        }
        this.sortedChannels = null;
        this.sortedUsers = null;
        if (this.drawerLayout != null) {
            this.drawerLayout.closeDrawers();
        }
        if (bid != -1 && this.conn != null && this.conn.getUserInfo() != null) {
            this.conn.getUserInfo().last_selected_bid = bid;
        }
        for (int i = 0; i < this.backStack.size(); ++i) {
            if (this.buffer == null || this.backStack.get(i) != this.buffer.bid) continue;
            this.backStack.remove(i);
        }
        if (this.buffer != null && this.buffer.bid >= 0 && bid != this.buffer.bid) {
            this.backStack.add(0, this.buffer.bid);
            this.buffer.draft = this.messageTxt.getText().toString();
        }
        this.shouldFadeIn = this.buffer != null && this.buffer.bid != -1 && this.buffer.cid != -1 && this.buffer.bid != bid;
        this.buffer = BuffersDataSource.getInstance().getBuffer(bid);
        if (this.buffer != null) {
            Crashlytics.log(3, "IRCCloud", "Buffer selected: cid" + this.buffer.cid + " bid" + bid + " shouldFadeIn: " + this.shouldFadeIn);
            this.server = ServersDataSource.getInstance().getServer(this.buffer.cid);
            try {
                TreeMap events = EventsDataSource.getInstance().getEventsForBuffer(this.buffer.bid);
                if (events != null) {
                    events = (TreeMap)events.clone();
                    for (EventsDataSource.Event e : events.values()) {
                        UsersDataSource.User u;
                        if (e == null || !e.highlight || e.from == null || (u = UsersDataSource.getInstance().getUser(this.buffer.bid, e.from)) == null || u.last_mention >= e.eid) continue;
                        u.last_mention = e.eid;
                    }
                }
            }
            catch (Exception e) {
                Crashlytics.logException(e);
            }
            try {
                NfcAdapter nfc;
                if (Build.VERSION.SDK_INT >= 16 && this.buffer != null && this.server != null && (nfc = NfcAdapter.getDefaultAdapter((Context)this)) != null) {
                    String uri = "irc";
                    if (this.server.ssl > 0) {
                        uri = uri + "s";
                    }
                    uri = uri + "://" + this.server.hostname + ":" + this.server.port;
                    if (this.buffer.type.equals("channel")) {
                        uri = uri + "/" + URLEncoder.encode(this.buffer.name, "UTF-8");
                        ChannelsDataSource.Channel c = ChannelsDataSource.getInstance().getChannelForBuffer(this.buffer.bid);
                        if (c != null && c.hasMode("k")) {
                            uri = uri + "," + c.paramForMode("k");
                        }
                    }
                    nfc.setNdefPushMessage(new NdefMessage(NdefRecord.createUri((String)uri), new NdefRecord[0]), (Activity)this, new Activity[0]);
                }
            }
            catch (Exception nfc) {}
        } else {
            Crashlytics.log(3, "IRCCloud", "Buffer selected but not found: bid" + bid + " shouldFadeIn: " + this.shouldFadeIn);
            this.server = null;
        }
        this.update_subtitle();
        final Bundle b = new Bundle();
        if (this.buffer != null) {
            b.putInt("cid", this.buffer.cid);
        }
        b.putInt("bid", bid);
        b.putBoolean("fade", this.shouldFadeIn);
        BuffersListFragment blf = (BuffersListFragment)this.getSupportFragmentManager().findFragmentById(2131624075);
        final MessageViewFragment mvf = (MessageViewFragment)this.getSupportFragmentManager().findFragmentById(2131624071);
        UsersListFragment ulf = (UsersListFragment)this.getSupportFragmentManager().findFragmentById(2131624076);
        UsersListFragment ulf2 = (UsersListFragment)this.getSupportFragmentManager().findFragmentById(2131624077);
        if (mvf != null) {
            mvf.ready = false;
        }
        if (blf != null) {
            blf.setSelectedBid(bid);
        }
        if (ulf != null) {
            ulf.setArguments(b);
        }
        if (ulf2 != null) {
            ulf2.setArguments(b);
        }
        if (this.shouldFadeIn) {
            Crashlytics.log(3, "IRCCloud", "Fade Out");
            if (Build.VERSION.SDK_INT < 16) {
                AlphaAnimation anim2 = new AlphaAnimation(1.0f, 0.0f);
                anim2.setDuration(150L);
                anim2.setFillAfter(true);
                anim2.setAnimationListener(new Animation.AnimationListener(){

                    public void onAnimationStart(Animation animation) {
                    }

                    public void onAnimationEnd(Animation animation) {
                        if (mvf != null) {
                            mvf.setArguments(b);
                        }
                        MainActivity.this.messageTxt.setText("");
                        if (MainActivity.this.buffer != null && MainActivity.this.buffer.draft != null) {
                            MainActivity.this.messageTxt.append(MainActivity.this.buffer.draft);
                        }
                    }

                    public void onAnimationRepeat(Animation animation) {
                    }
                });
                try {
                    mvf.getListView().startAnimation((Animation)anim2);
                    ulf.getListView().startAnimation((Animation)anim2);
                }
                catch (Exception exception) {}
            } else {
                mvf.getListView().animate().alpha(0.0f).withEndAction(new Runnable(){

                    @Override
                    public void run() {
                        if (mvf != null) {
                            mvf.setArguments(b);
                        }
                        MainActivity.this.messageTxt.setText("");
                        if (MainActivity.this.buffer != null && MainActivity.this.buffer.draft != null) {
                            MainActivity.this.messageTxt.append(MainActivity.this.buffer.draft);
                        }
                    }
                });
                ulf.getListView().animate().alpha(0.0f);
            }
            mvf.showSpinner(true);
        } else {
            if (mvf != null) {
                mvf.setArguments(b);
            }
            this.messageTxt.setText("");
            if (this.buffer != null && this.buffer.draft != null) {
                this.messageTxt.append(this.buffer.draft);
            }
        }
        this.updateUsersListFragmentVisibility();
        this.supportInvalidateOptionsMenu();
        if (this.showNotificationsTask != null) {
            this.showNotificationsTask.cancel(true);
        }
        this.showNotificationsTask = new ShowNotificationsTask();
        this.showNotificationsTask.execute(bid);
        if (this.drawerLayout != null) {
            new RefreshUpIndicatorTask().execute(new Void[]{null});
        }
        if (this.buffer != null && this.buffer.cid != -1 && this.drawerLayout != null) {
            this.drawerLayout.setDrawerLockMode(0, 3);
            this.getSupportActionBar().setHomeButtonEnabled(true);
        }
        this.update_suggestions(false);
    }

    @Override
    public void onMessageViewReady() {
        if (this.shouldFadeIn) {
            Crashlytics.log(3, "IRCCloud", "Fade In");
            MessageViewFragment mvf = (MessageViewFragment)this.getSupportFragmentManager().findFragmentById(2131624071);
            UsersListFragment ulf = (UsersListFragment)this.getSupportFragmentManager().findFragmentById(2131624076);
            if (Build.VERSION.SDK_INT < 16) {
                AlphaAnimation anim2 = new AlphaAnimation(0.0f, 1.0f);
                anim2.setDuration(150L);
                anim2.setFillAfter(true);
                if (mvf != null && mvf.getListView() != null) {
                    mvf.getListView().startAnimation((Animation)anim2);
                }
                if (ulf != null && ulf.getListView() != null) {
                    ulf.getListView().startAnimation((Animation)anim2);
                }
            } else {
                if (mvf != null && mvf.getListView() != null) {
                    mvf.getListView().animate().alpha(1.0f);
                }
                if (ulf != null && ulf.getListView() != null) {
                    ulf.getListView().animate().alpha(1.0f);
                }
            }
            if (mvf != null && mvf.getListView() != null) {
                if (mvf.buffer != this.buffer && this.buffer != null && BuffersDataSource.getInstance().getBuffer(this.buffer.bid) != null) {
                    Bundle b = new Bundle();
                    b.putInt("cid", this.buffer.cid);
                    b.putInt("bid", this.buffer.bid);
                    b.putBoolean("fade", false);
                    mvf.setArguments(b);
                }
                mvf.showSpinner(false);
            }
            this.shouldFadeIn = false;
        }
    }

    @Override
    public void addButtonPressed(int cid) {
        if (this.drawerLayout != null) {
            this.drawerLayout.closeDrawers();
        }
    }

    @Override
    public void addNetwork() {
        if (this.drawerLayout != null) {
            this.drawerLayout.closeDrawers();
        }
        if (this.getWindowManager().getDefaultDisplay().getWidth() < 800) {
            Intent i = new Intent((Context)this, EditConnectionActivity.class);
            this.startActivity(i);
        } else {
            EditConnectionFragment connFragment = new EditConnectionFragment();
            connFragment.show(this.getSupportFragmentManager(), "addnetwork");
        }
    }

    @Override
    public void reorder() {
        if (this.drawerLayout != null) {
            this.drawerLayout.closeDrawers();
        }
        if (!this.getResources().getBoolean(2131361795)) {
            Intent i = new Intent((Context)this, ServerReorderActivity.class);
            this.startActivity(i);
        } else {
            try {
                ServerReorderFragment fragment = new ServerReorderFragment();
                fragment.show(this.getSupportFragmentManager(), "reorder");
            }
            catch (IllegalStateException e) {
                Intent i = new Intent((Context)this, ServerReorderActivity.class);
                this.startActivity(i);
            }
        }
    }

    private int getOrientation(Context context, Uri photoUri) {
        int orientation = -1;
        Cursor cursor = context.getContentResolver().query(photoUri, new String[]{"orientation"}, null, null, null);
        if (cursor != null) {
            cursor.moveToFirst();
            orientation = cursor.getInt(0);
            cursor.close();
        }
        return orientation;
    }

    private Bitmap loadThumbnail(Context context, Uri photoUri) throws IOException {
        Bitmap srcBitmap;
        int rotatedHeight;
        int rotatedWidth;
        InputStream is = context.getContentResolver().openInputStream(photoUri);
        BitmapFactory.Options dbo = new BitmapFactory.Options();
        dbo.inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)dbo);
        is.close();
        int orientation = this.getOrientation(context, photoUri);
        if (orientation == 90 || orientation == 270) {
            rotatedWidth = dbo.outHeight;
            rotatedHeight = dbo.outWidth;
        } else {
            rotatedWidth = dbo.outWidth;
            rotatedHeight = dbo.outHeight;
        }
        is = context.getContentResolver().openInputStream(photoUri);
        if (rotatedWidth > 1024 || rotatedHeight > 1024) {
            float widthRatio = (float)rotatedWidth / 1024.0f;
            float heightRatio = (float)rotatedHeight / 1024.0f;
            float maxRatio = Math.max(widthRatio, heightRatio);
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inSampleSize = (int)maxRatio;
            srcBitmap = BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)options);
        } else {
            srcBitmap = BitmapFactory.decodeStream((InputStream)is);
        }
        is.close();
        if (orientation > 0) {
            Matrix matrix = new Matrix();
            matrix.postRotate((float)orientation);
            srcBitmap = Bitmap.createBitmap((Bitmap)srcBitmap, (int)0, (int)0, (int)srcBitmap.getWidth(), (int)srcBitmap.getHeight(), (Matrix)matrix, (boolean)true);
        }
        return srcBitmap;
    }

    private Uri resize(Uri in) {
        Uri out = null;
        try {
            int len;
            int MAX_IMAGE_SIZE = Integer.parseInt(PreferenceManager.getDefaultSharedPreferences((Context)this).getString("photo_size", "1024"));
            File imageDir = new File(Environment.getExternalStorageDirectory(), "IRCCloud");
            imageDir.mkdirs();
            new File(imageDir, ".nomedia").createNewFile();
            BitmapFactory.Options o = new BitmapFactory.Options();
            o.inJustDecodeBounds = true;
            BitmapFactory.decodeStream((InputStream)IRCCloudApplication.getInstance().getApplicationContext().getContentResolver().openInputStream(in), null, (BitmapFactory.Options)o);
            int scale = 1;
            if (o.outWidth < MAX_IMAGE_SIZE && o.outHeight < MAX_IMAGE_SIZE) {
                return in;
            }
            if (o.outWidth > o.outHeight) {
                if (o.outWidth > MAX_IMAGE_SIZE) {
                    scale = o.outWidth / MAX_IMAGE_SIZE;
                }
            } else if (o.outHeight > MAX_IMAGE_SIZE) {
                scale = o.outHeight / MAX_IMAGE_SIZE;
            }
            o = new BitmapFactory.Options();
            o.inSampleSize = scale;
            Bitmap bmp = BitmapFactory.decodeStream((InputStream)IRCCloudApplication.getInstance().getApplicationContext().getContentResolver().openInputStream(in), null, (BitmapFactory.Options)o);
            out = Uri.fromFile((File)File.createTempFile("irccloudcapture-original", ".jpg", imageDir));
            InputStream is = IRCCloudApplication.getInstance().getApplicationContext().getContentResolver().openInputStream(in);
            OutputStream os = IRCCloudApplication.getInstance().getApplicationContext().getContentResolver().openOutputStream(out);
            byte[] buffer = new byte[8192];
            while ((len = is.read(buffer)) != -1) {
                os.write(buffer, 0, len);
            }
            is.close();
            os.close();
            ExifInterface exif = new ExifInterface(out.getPath());
            int orientation = exif.getAttributeInt("Orientation", 1);
            new File(new URI(out.toString())).delete();
            out = Uri.fromFile((File)File.createTempFile("irccloudcapture-resized", ".jpg", imageDir));
            if (orientation > 1) {
                Matrix matrix = new Matrix();
                switch (orientation) {
                    case 6: {
                        matrix.postRotate(90.0f);
                        break;
                    }
                    case 3: {
                        matrix.postRotate(180.0f);
                        break;
                    }
                    case 8: {
                        matrix.postRotate(270.0f);
                    }
                }
                try {
                    Bitmap oldbmp = bmp;
                    bmp = Bitmap.createBitmap((Bitmap)oldbmp, (int)0, (int)0, (int)oldbmp.getWidth(), (int)oldbmp.getHeight(), (Matrix)matrix, (boolean)true);
                    oldbmp.recycle();
                }
                catch (OutOfMemoryError e) {
                    Log.e((String)"IRCCloud", (String)"Out of memory rotating the photo, it may look wrong on imgur");
                }
            }
            if (bmp == null || !bmp.compress(Bitmap.CompressFormat.JPEG, 90, IRCCloudApplication.getInstance().getApplicationContext().getContentResolver().openOutputStream(out))) {
                out = null;
            }
            if (bmp != null) {
                bmp.recycle();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            Crashlytics.logException(e);
        }
        catch (OutOfMemoryError e) {
            Log.e((String)"IRCCloud", (String)"Out of memory rotating the photo, it may look wrong on imgur");
        }
        if (!PreferenceManager.getDefaultSharedPreferences((Context)this).getBoolean("keep_photos", false) && in.toString().contains("irccloudcapture")) {
            try {
                new File(new URI(in.toString())).delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (out != null) {
            return out;
        }
        return in;
    }

    public class ScreenReceiver
    extends BroadcastReceiver {
        public boolean wasScreenOn = true;

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.intent.action.SCREEN_OFF")) {
                InputMethodManager imm = (InputMethodManager)MainActivity.this.getSystemService("input_method");
                imm.hideSoftInputFromWindow(MainActivity.this.messageTxt.getWindowToken(), 0);
                this.wasScreenOn = false;
            } else if (intent.getAction().equals("android.intent.action.SCREEN_ON")) {
                this.wasScreenOn = true;
            }
        }
    }

    public static class FileUploadTask
    extends AsyncTaskEx<Void, Float, String>
    implements NetworkConnection.IRCEventHandler {
        private HttpURLConnection http = null;
        private Uri mFileUri;
        private int total = 0;
        private TextView fileSize;
        private AlertDialog metadataDialog;
        public MainActivity activity;
        public BuffersDataSource.Buffer mBuffer;
        public int reqid = -1;
        private String error;
        public String filename;
        public String original_filename;
        public String type;
        public String file_id;
        public String message;
        public boolean uploadFinished = false;
        public boolean filenameSet = false;
        private NotificationCompat.Builder notification;

        public FileUploadTask(Uri fileUri, MainActivity activity) {
            this.mBuffer = activity.buffer;
            this.mFileUri = fileUri;
            this.type = activity.getContentResolver().getType(this.mFileUri);
            if (Build.VERSION.SDK_INT < 16) {
                this.original_filename = fileUri.getLastPathSegment();
            } else {
                Cursor cursor = null;
                try {
                    cursor = activity.getContentResolver().query(fileUri, null, null, null, null, null);
                    this.original_filename = cursor != null && cursor.moveToFirst() ? cursor.getString(cursor.getColumnIndex("_display_name")) : fileUri.getLastPathSegment();
                }
                catch (Exception e) {
                    this.original_filename = String.valueOf(System.currentTimeMillis());
                }
                if (cursor != null) {
                    cursor.close();
                }
            }
            if (this.original_filename == null || this.original_filename.length() == 0) {
                this.original_filename = "file";
            }
            if (this.type == null) {
                String lower = this.original_filename.toLowerCase();
                this.type = lower.endsWith(".jpg") || lower.endsWith(".jpeg") ? "image/jpeg" : (lower.endsWith(".png") ? "image/png" : (lower.endsWith(".bmp") ? "image/bmp" : "application/octet-stream"));
            }
            if (!this.original_filename.contains(".")) {
                this.original_filename = this.original_filename + "." + this.type.substring(this.type.indexOf("/") + 1);
            }
            this.setActivity(activity);
            this.notification = new NotificationCompat.Builder(IRCCloudApplication.getInstance().getApplicationContext()).setContentTitle("Uploading File").setContentText("Calculating size\u2026 \u2022 " + this.type).setProgress(0, 0, true).setLocalOnly(true).setOngoing(true).setColor(IRCCloudApplication.getInstance().getApplicationContext().getResources().getColor(2131492899)).setSmallIcon(0x1080088);
            Intent i = new Intent();
            i.setComponent(new ComponentName(IRCCloudApplication.getInstance().getApplicationContext().getPackageName(), "com.irccloud.android.MainActivity"));
            i.putExtra("bid", this.mBuffer.bid);
            i.setData(Uri.parse((String)("bid://" + this.mBuffer.bid)));
            this.notification.setContentIntent(PendingIntent.getActivity((Context)IRCCloudApplication.getInstance().getApplicationContext(), (int)0, (Intent)i, (int)0x8000000));
            this.show_dialog();
            Crashlytics.log(4, "IRCCloud", "Uploading file to IRCCloud: " + this.original_filename + " " + this.type);
        }

        public void show_dialog() {
            this.activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    String filesize;
                    AlertDialog.Builder builder = new AlertDialog.Builder((Context)FileUploadTask.this.activity);
                    builder.setInverseBackgroundForced(Build.VERSION.SDK_INT < 11);
                    final View view = FileUploadTask.this.activity.getLayoutInflater().inflate(2130903093, null);
                    final EditText fileinput = (EditText)view.findViewById(2131624115);
                    final EditText messageinput = (EditText)view.findViewById(2131624116);
                    ImageView thumbnail = (ImageView)view.findViewById(2131624132);
                    messageinput.setText((CharSequence)FileUploadTask.this.activity.buffer.draft);
                    FileUploadTask.this.activity.buffer.draft = "";
                    FileUploadTask.this.activity.messageTxt.setText("");
                    view.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                        public void onGlobalLayout() {
                            if (fileinput.hasFocus() || messageinput.hasFocus()) {
                                view.post(new Runnable(){

                                    @Override
                                    public void run() {
                                        view.scrollTo(0, view.getBottom());
                                    }
                                });
                            }
                        }
                    });
                    if (FileUploadTask.this.type.startsWith("image/")) {
                        try {
                            thumbnail.setImageBitmap(FileUploadTask.this.activity.loadThumbnail(IRCCloudApplication.getInstance().getApplicationContext(), FileUploadTask.this.mFileUri));
                            thumbnail.setVisibility(0);
                        }
                        catch (OutOfMemoryError e) {
                            thumbnail.setVisibility(8);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else {
                        thumbnail.setVisibility(8);
                    }
                    FileUploadTask.this.fileSize = (TextView)view.findViewById(2131624133);
                    if (FileUploadTask.this.total == 0) {
                        FileUploadTask.this.fileSize.setText((CharSequence)("Calculating size\u2026 \u2022 " + FileUploadTask.this.type));
                    } else if (FileUploadTask.this.total < 1024) {
                        filesize = FileUploadTask.this.total + " B";
                        FileUploadTask.this.fileSize.setText((CharSequence)(filesize + " \u2022 " + FileUploadTask.this.type));
                    } else {
                        int exp = (int)(Math.log(FileUploadTask.this.total) / Math.log(1024.0));
                        filesize = String.format("%.1f ", (double)FileUploadTask.this.total / Math.pow(1024.0, exp)) + "KMGTPE".charAt(exp - 1) + "B";
                        FileUploadTask.this.fileSize.setText((CharSequence)(filesize + " \u2022 " + FileUploadTask.this.type));
                    }
                    fileinput.setText((CharSequence)FileUploadTask.this.original_filename);
                    fileinput.setOnEditorActionListener(new TextView.OnEditorActionListener(){

                        public boolean onEditorAction(TextView exampleView, int actionId, KeyEvent event) {
                            if (actionId == 0 && event.getAction() == 0) {
                                try {
                                    FileUploadTask.this.filename = fileinput.getText().toString();
                                    FileUploadTask.this.filenameSet = true;
                                    FileUploadTask.this.finalize_upload();
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                ((AlertDialog)fileinput.getTag()).dismiss();
                            }
                            return true;
                        }
                    });
                    builder.setTitle("Upload A File To " + FileUploadTask.this.mBuffer.name);
                    builder.setView(view);
                    builder.setPositiveButton("Send", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            try {
                                FileUploadTask.this.filename = fileinput.getText().toString();
                                FileUploadTask.this.message = messageinput.getText().toString();
                                FileUploadTask.this.filenameSet = true;
                                FileUploadTask.this.finalize_upload();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            dialog.dismiss();
                            FileUploadTask.this.metadataDialog = null;
                        }
                    });
                    builder.setNegativeButton("Cancel", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            dialog.cancel();
                            FileUploadTask.this.metadataDialog = null;
                        }
                    });
                    builder.setOnCancelListener(new DialogInterface.OnCancelListener(){

                        public void onCancel(DialogInterface dialog) {
                            if (FileUploadTask.this.activity.fileUploadTask != null) {
                                FileUploadTask.this.activity.fileUploadTask.cancel(true);
                            }
                            FileUploadTask.this.activity.fileUploadTask = null;
                            dialog.dismiss();
                            FileUploadTask.this.hide_progress();
                            if (FileUploadTask.this.activity.buffer != null) {
                                FileUploadTask.this.activity.buffer.draft = messageinput.getText().toString();
                            }
                            if (FileUploadTask.this.activity.messageTxt != null) {
                                FileUploadTask.this.activity.messageTxt.setText((CharSequence)messageinput.getText());
                            }
                            FileUploadTask.this.metadataDialog = null;
                        }
                    });
                    FileUploadTask.this.metadataDialog = builder.create();
                    fileinput.setTag((Object)FileUploadTask.this.metadataDialog);
                    FileUploadTask.this.metadataDialog.setOwnerActivity(FileUploadTask.this.activity);
                    FileUploadTask.this.metadataDialog.getWindow().setSoftInputMode(16);
                    FileUploadTask.this.metadataDialog.show();
                }
            });
        }

        private void finalize_upload() {
            if (this.uploadFinished && this.filenameSet && !this.isCancelled()) {
                if (this.file_id != null && this.file_id.length() > 0) {
                    NetworkConnection.getInstance().addHandler(this);
                    this.reqid = NetworkConnection.getInstance().finalize_upload(this.file_id, this.filename, this.original_filename);
                } else if (this.activity != null) {
                    this.activity.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            FileUploadTask.this.show_alert("Upload Failed", "Unable to upload file to IRCCloud." + (FileUploadTask.this.error != null ? "\n\n" + FileUploadTask.this.error : ""));
                        }
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected String doInBackground(Void ... params) {
            InputStream fileIn;
            try {
                while (this.activity == null) {
                    Thread.sleep(100L);
                }
                if (this.type != null && this.type.startsWith("image/") && !this.type.equals("image/gif") && !this.type.equals("image/png") && Integer.parseInt(PreferenceManager.getDefaultSharedPreferences((Context)this.activity).getString("photo_size", "1024")) > 0) {
                    this.mFileUri = this.activity.resize(this.mFileUri);
                }
                fileIn = this.activity.getContentResolver().openInputStream(this.mFileUri);
                Cursor c = this.activity.getContentResolver().query(this.mFileUri, new String[]{"_size"}, null, null, null);
                if (c != null && c.moveToFirst()) {
                    this.total = c.getInt(0);
                    c.close();
                } else {
                    this.total = fileIn.available();
                }
            }
            catch (Exception e) {
                Crashlytics.log(6, "IRCCloud", "could not open InputStream: " + e);
                if (this.activity != null) {
                    this.activity.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            FileUploadTask.this.show_alert("Upload Failed", "Unable to open input file stream");
                        }
                    });
                } else {
                    NotificationManagerCompat.from(IRCCloudApplication.getInstance().getApplicationContext()).cancel(this.mBuffer.bid);
                    Notifications.getInstance().alert(this.mBuffer.bid, "Upload Failed", "Unable to upload file to IRCCloud.");
                }
                return null;
            }
            if (this.total > 15000000) {
                if (this.activity != null) {
                    this.activity.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            FileUploadTask.this.show_alert("Upload Failed", "Sorry, you can\u2019t upload files larger than 15 MB");
                        }
                    });
                } else {
                    NotificationManagerCompat.from(IRCCloudApplication.getInstance().getApplicationContext()).cancel(this.mBuffer.bid);
                    Notifications.getInstance().alert(this.mBuffer.bid, "Upload Failed", "Unable to upload file to IRCCloud.");
                }
                return null;
            }
            this.activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    String filesize;
                    if (FileUploadTask.this.total < 1024) {
                        filesize = FileUploadTask.this.total + " B";
                    } else {
                        int exp = (int)(Math.log(FileUploadTask.this.total) / Math.log(1024.0));
                        filesize = String.format("%.1f ", (double)FileUploadTask.this.total / Math.pow(1024.0, exp)) + "KMGTPE".charAt(exp - 1) + "B";
                    }
                    FileUploadTask.this.fileSize.setText((CharSequence)(filesize + " \u2022 " + FileUploadTask.this.type));
                    FileUploadTask.this.notification.setContentText(filesize + " \u2022 " + FileUploadTask.this.type);
                    NotificationManagerCompat.from(IRCCloudApplication.getInstance().getApplicationContext()).notify(FileUploadTask.this.mBuffer.bid, FileUploadTask.this.notification.build());
                }
            });
            InputStream responseIn = null;
            try {
                String boundary = UUID.randomUUID().toString();
                this.http = (HttpURLConnection)new URL("https://" + NetworkConnection.IRCCLOUD_HOST + "/chat/upload").openConnection();
                this.http.setReadTimeout(60000);
                this.http.setConnectTimeout(60000);
                this.http.setDoOutput(true);
                this.http.setFixedLengthStreamingMode(this.total + boundary.length() * 2 + this.original_filename.length() + this.type.length() + 88);
                this.http.setRequestProperty("User-Agent", NetworkConnection.getInstance().useragent);
                this.http.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
                this.http.setRequestProperty("Cookie", "session=" + NetworkConnection.getInstance().session);
                this.http.setRequestProperty("x-irccloud-session", NetworkConnection.getInstance().session);
                OutputStream out = this.http.getOutputStream();
                out.write(("--" + boundary + "\r\n").getBytes());
                out.write(("Content-Disposition: form-data; name=\"file\"; filename=\"" + this.original_filename + "\"\r\n").getBytes());
                out.write(("Content-Type: " + this.type + "\r\n\r\n").getBytes());
                this.copy(fileIn, out);
                if (!this.isCancelled()) {
                    out.write(("\r\n--" + boundary + "--\r\n").getBytes());
                    out.flush();
                    out.close();
                    if (this.http.getResponseCode() == 200) {
                        responseIn = this.http.getInputStream();
                        String string2 = this.onInput(responseIn);
                        return string2;
                    }
                    Crashlytics.log(4, "IRCCloud", "responseCode=" + this.http.getResponseCode());
                    responseIn = this.http.getErrorStream();
                    StringBuilder sb = new StringBuilder();
                    Scanner scanner = new Scanner(responseIn).useDelimiter("\\A");
                    while (scanner.hasNext()) {
                        sb.append(scanner.next());
                    }
                    Crashlytics.log(6, "IRCCloud", "error response: " + sb.toString());
                } else {
                    Log.e((String)"IRCCloud", (String)"Upload cancelled");
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Crashlytics.logException(ex);
                this.error = "An unexpected error occurred. Please try again later.";
            }
            finally {
                try {
                    if (responseIn != null) {
                        responseIn.close();
                    }
                }
                catch (Exception ex) {}
                try {
                    if (this.http != null) {
                        this.http.disconnect();
                    }
                }
                catch (Exception ex) {}
                try {
                    fileIn.close();
                }
                catch (Exception ex) {}
            }
            return null;
        }

        public void setActivity(MainActivity a) {
            this.activity = a;
            if (a != null && this.total > 0 && !this.uploadFinished) {
                this.activity.getSupportActionBar().setTitle("Uploading");
                this.activity.getSupportActionBar().setDisplayShowCustomEnabled(false);
                this.activity.getSupportActionBar().setDisplayShowTitleEnabled(true);
                this.activity.progressBar.setProgress(0);
                this.activity.progressBar.setIndeterminate(true);
                if (this.activity.progressBar.getVisibility() != 0) {
                    if (Build.VERSION.SDK_INT >= 16) {
                        this.activity.progressBar.setAlpha(0.0f);
                        this.activity.progressBar.animate().alpha(1.0f).setDuration(200L);
                    }
                    this.activity.progressBar.setVisibility(0);
                }
            }
        }

        protected void onProgressUpdate(Float ... values) {
            if (values[0].floatValue() < 1.0f) {
                this.notification.setProgress(1000, (int)(values[0].floatValue() * 1000.0f), false);
            } else {
                this.notification.setProgress(0, 0, true);
            }
            NotificationManagerCompat.from(IRCCloudApplication.getInstance().getApplicationContext()).notify(this.mBuffer.bid, this.notification.build());
            if (this.activity != null) {
                try {
                    if (this.activity.progressBar.getVisibility() != 0) {
                        this.activity.getSupportActionBar().setTitle("Uploading");
                        this.activity.getSupportActionBar().setDisplayShowCustomEnabled(false);
                        this.activity.getSupportActionBar().setDisplayShowTitleEnabled(true);
                        if (Build.VERSION.SDK_INT >= 16) {
                            this.activity.progressBar.setAlpha(0.0f);
                            this.activity.progressBar.animate().alpha(1.0f).setDuration(200L);
                        }
                        this.activity.progressBar.setVisibility(0);
                    }
                    if (values[0].floatValue() < 1.0f) {
                        this.activity.progressBar.setIndeterminate(false);
                        this.activity.progressBar.setProgress((int)(values[0].floatValue() * 1000.0f));
                    } else {
                        this.activity.progressBar.setIndeterminate(true);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        protected void onPostExecute(String s) {
            if (this.mFileUri != null && this.mFileUri.toString().contains("irccloudcapture") && s != null && s.length() > 0 && (!PreferenceManager.getDefaultSharedPreferences((Context)IRCCloudApplication.getInstance().getApplicationContext()).getBoolean("keep_photos", false) || this.mFileUri.toString().contains("irccloudcapture-resized"))) {
                try {
                    new File(new URI(this.mFileUri.toString())).delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.file_id = s;
            this.uploadFinished = true;
            this.finalize_upload();
        }

        private int copy(InputStream input, OutputStream output) throws IOException {
            byte[] buffer = new byte[8192];
            int count = 0;
            int n = 0;
            while (-1 != (n = input.read(buffer)) && !this.isCancelled()) {
                output.write(buffer, 0, n);
                this.publishProgress(Float.valueOf((float)(count += n) / (float)this.total));
            }
            return count;
        }

        protected String onInput(InputStream in) throws Exception {
            StringBuilder sb = new StringBuilder();
            Scanner scanner = new Scanner(in).useDelimiter("\\A");
            while (scanner.hasNext()) {
                sb.append(scanner.next());
            }
            JSONObject root = new JSONObject(sb.toString());
            if (root.has("success") && root.getBoolean("success")) {
                return root.getString("id");
            }
            return null;
        }

        @Override
        protected void onCancelled() {
            super.onCancelled();
            this.activity.fileUploadTask = null;
            NetworkConnection.getInstance().removeHandler(this);
            this.hide_progress();
        }

        private void hide_progress() {
            if (this.activity.progressBar != null && this.activity.progressBar.getVisibility() == 0) {
                if (Build.VERSION.SDK_INT >= 16) {
                    this.activity.progressBar.animate().alpha(0.0f).setDuration(200L).withEndAction(new Runnable(){

                        @Override
                        public void run() {
                            FileUploadTask.this.activity.progressBar.setVisibility(8);
                        }
                    });
                } else {
                    this.activity.progressBar.setVisibility(8);
                }
            }
            this.activity.getSupportActionBar().setDisplayShowCustomEnabled(true);
            this.activity.getSupportActionBar().setDisplayShowTitleEnabled(false);
            NotificationManagerCompat.from(IRCCloudApplication.getInstance().getApplicationContext()).cancel(this.mBuffer.bid);
        }

        @Override
        public void onIRCEvent(int what, Object obj) {
            Object o = obj;
            switch (what) {
                case 104: {
                    IRCCloudJSONObject event = (IRCCloudJSONObject)obj;
                    if (event.getInt("_reqid") != this.reqid) break;
                    this.message = this.message == null || this.message.length() == 0 ? "" : this.message + " ";
                    this.message = this.message + event.getJsonObject("file").get("url").asText();
                    NetworkConnection.getInstance().say(this.mBuffer.cid, this.mBuffer.name, this.message);
                    this.activity.fileUploadTask = null;
                    NetworkConnection.getInstance().removeHandler(this);
                    this.activity.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            NotificationManagerCompat.from(IRCCloudApplication.getInstance().getApplicationContext()).cancel(FileUploadTask.this.mBuffer.bid);
                            FileUploadTask.this.hide_progress();
                        }
                    });
                    break;
                }
                case 103: {
                    final IRCCloudJSONObject event = (IRCCloudJSONObject)obj;
                    if (event.getInt("_reqid") != this.reqid) break;
                    this.activity.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            FileUploadTask.this.hide_progress();
                            FileUploadTask.this.show_alert("Upload Failed", "Unable to upload file to IRCCloud: " + event.getString("message"));
                        }
                    });
                    this.activity.fileUploadTask = null;
                    NetworkConnection.getInstance().removeHandler(this);
                }
            }
        }

        private void show_alert(String title, String message) {
            NotificationManagerCompat.from(IRCCloudApplication.getInstance().getApplicationContext()).cancel(this.mBuffer.bid);
            try {
                if (this.activity == null) {
                    throw new IllegalStateException();
                }
                if (Looper.myLooper() == null) {
                    Looper.prepare();
                }
                this.hide_progress();
                AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.activity);
                builder.setInverseBackgroundForced(Build.VERSION.SDK_INT < 11);
                builder.setTitle(title);
                builder.setMessage(message);
                builder.setNegativeButton("Ok", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        try {
                            dialog.dismiss();
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                });
                AlertDialog dialog = builder.create();
                dialog.setOwnerActivity(this.activity);
                dialog.show();
                this.metadataDialog.dismiss();
            }
            catch (Exception e) {
                Notifications.getInstance().alert(this.mBuffer.bid, "Upload Failed", "Unable to upload file to IRCCloud.");
            }
        }
    }

    public class ImgurUploadTask
    extends AsyncTaskEx<Void, Float, String> {
        private final String UPLOAD_URL = "".length() > 0 ? "https://imgur-apiv3.p.mashape.com/3/image" : "https://api.imgur.com/3/image";
        private Uri mImageUri;
        private int total = 0;
        public Activity activity;
        private String error;
        private BuffersDataSource.Buffer mBuffer;

        public ImgurUploadTask(Uri imageUri) {
            Crashlytics.log(4, "IRCCloud", "Uploading image to " + this.UPLOAD_URL);
            this.mImageUri = imageUri;
            this.mBuffer = MainActivity.this.buffer;
            this.setActivity(MainActivity.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected String doInBackground(Void ... params) {
            String string2;
            InputStream imageIn;
            try {
                while (this.activity == null) {
                    Thread.sleep(100L);
                }
                String type = this.activity.getContentResolver().getType(this.mImageUri);
                if (type != null && !type.equals("image/gif") || Integer.parseInt(PreferenceManager.getDefaultSharedPreferences((Context)this.activity).getString("photo_size", "1024")) > 0) {
                    this.mImageUri = MainActivity.this.resize(this.mImageUri);
                }
                imageIn = this.activity.getContentResolver().openInputStream(this.mImageUri);
                this.total = imageIn.available();
            }
            catch (Exception e) {
                Crashlytics.log(6, "IRCCloud", "could not open InputStream: " + e);
                return null;
            }
            HttpURLConnection conn = null;
            InputStream responseIn = null;
            try {
                conn = (HttpURLConnection)new URL(this.UPLOAD_URL).openConnection();
                conn.setDoOutput(true);
                conn.setFixedLengthStreamingMode(this.total);
                if ("".length() > 0) {
                    conn.setRequestProperty("X-Mashape-Authorization", "");
                }
                if (MainActivity.this.getSharedPreferences("prefs", 0).contains("imgur_access_token")) {
                    conn.setRequestProperty("Authorization", "Bearer " + MainActivity.this.getSharedPreferences("prefs", 0).getString("imgur_access_token", ""));
                } else {
                    conn.setRequestProperty("Authorization", "Client-ID ");
                }
                OutputStream out = conn.getOutputStream();
                this.copy(imageIn, out);
                out.flush();
                out.close();
                if (conn.getResponseCode() == 200) {
                    responseIn = conn.getInputStream();
                    String string3 = this.onInput(responseIn);
                    return string3;
                }
                Crashlytics.log(4, "IRCCloud", "responseCode=" + conn.getResponseCode());
                responseIn = conn.getErrorStream();
                StringBuilder sb = new StringBuilder();
                Scanner scanner = new Scanner(responseIn).useDelimiter("\\A");
                while (scanner.hasNext()) {
                    sb.append(scanner.next());
                }
                JSONObject root = new JSONObject(sb.toString());
                this.error = root.has("data") && root.getJSONObject("data").has("error") ? root.getJSONObject("data").getString("error") : null;
                Crashlytics.log(6, "IRCCloud", "error response: " + sb.toString());
                string2 = null;
            }
            catch (Exception ex) {
                Crashlytics.log(6, "IRCCloud", "Error during POST: " + ex);
                String string4 = null;
                return string4;
            }
            finally {
                try {
                    responseIn.close();
                }
                catch (Exception exception) {}
                try {
                    conn.disconnect();
                }
                catch (Exception exception) {}
                try {
                    imageIn.close();
                }
                catch (Exception exception) {}
            }
            return string2;
        }

        public void setActivity(Activity a) {
            this.activity = a;
            if (a != null && this.total > 0) {
                MainActivity.this.getSupportActionBar().setTitle("Uploading");
                MainActivity.this.getSupportActionBar().setDisplayShowCustomEnabled(false);
                MainActivity.this.getSupportActionBar().setDisplayShowTitleEnabled(true);
                MainActivity.this.progressBar.setProgress(0);
                MainActivity.this.progressBar.setIndeterminate(true);
                if (MainActivity.this.progressBar.getVisibility() != 0) {
                    if (Build.VERSION.SDK_INT >= 16) {
                        MainActivity.this.progressBar.setAlpha(0.0f);
                        MainActivity.this.progressBar.animate().alpha(1.0f).setDuration(200L);
                    }
                    MainActivity.this.progressBar.setVisibility(0);
                }
            }
        }

        protected void onProgressUpdate(Float ... values) {
            if (this.activity != null) {
                try {
                    if (MainActivity.this.progressBar.getVisibility() != 0) {
                        MainActivity.this.getSupportActionBar().setTitle("Uploading");
                        MainActivity.this.getSupportActionBar().setDisplayShowCustomEnabled(false);
                        MainActivity.this.getSupportActionBar().setDisplayShowTitleEnabled(true);
                        if (Build.VERSION.SDK_INT >= 16) {
                            MainActivity.this.progressBar.setAlpha(0.0f);
                            MainActivity.this.progressBar.animate().alpha(1.0f).setDuration(200L);
                        }
                        MainActivity.this.progressBar.setVisibility(0);
                    }
                    if (values[0].floatValue() < 1.0f) {
                        MainActivity.this.progressBar.setIndeterminate(false);
                        MainActivity.this.progressBar.setProgress((int)(values[0].floatValue() * 1000.0f));
                    } else {
                        MainActivity.this.progressBar.setIndeterminate(true);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        protected void onPostExecute(String s) {
            if (this.mImageUri != null && this.mImageUri.toString().contains("irccloudcapture") && s != null && s.length() > 0 && (!PreferenceManager.getDefaultSharedPreferences((Context)IRCCloudApplication.getInstance().getApplicationContext()).getBoolean("keep_photos", false) || this.mImageUri.toString().contains("irccloudcapture-resized"))) {
                try {
                    new File(new URI(this.mImageUri.toString())).delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.activity != null) {
                if (MainActivity.this.progressBar.getVisibility() == 0) {
                    if (Build.VERSION.SDK_INT >= 16) {
                        MainActivity.this.progressBar.animate().alpha(0.0f).setDuration(200L).withEndAction(new Runnable(){

                            @Override
                            public void run() {
                                MainActivity.this.progressBar.setVisibility(8);
                            }
                        });
                    } else {
                        MainActivity.this.progressBar.setVisibility(8);
                    }
                }
                MainActivity.this.getSupportActionBar().setDisplayShowCustomEnabled(true);
                MainActivity.this.getSupportActionBar().setDisplayShowTitleEnabled(false);
            }
            this.setText(s);
        }

        private void setText(final String s) {
            if (s == null) {
                try {
                    JSONObject root;
                    if (this.error != null && (root = new JSONObject(this.error)).has("status") && root.getInt("status") == 403) {
                        new ImgurRefreshTask(this.mImageUri).execute(new Void[]{null});
                        return;
                    }
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
            if (this.activity != null) {
                Crashlytics.log(4, "IRCCloud", "Upload finished");
                if (s != null) {
                    if (this.mBuffer != null) {
                        if (this.mBuffer.draft == null) {
                            this.mBuffer.draft = "";
                        }
                        if (this.mBuffer.draft.length() > 0 && !this.mBuffer.draft.endsWith(" ")) {
                            this.mBuffer.draft = this.mBuffer.draft + " ";
                        }
                        this.mBuffer.draft = this.mBuffer.draft + s;
                    }
                    this.activity.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            ActionEditText messageTxt = (ActionEditText)ImgurUploadTask.this.activity.findViewById(2131624073);
                            String txt = messageTxt.getText().toString();
                            if (txt.length() > 0 && !txt.endsWith(" ")) {
                                txt = txt + " ";
                            }
                            txt = txt + s.replace("http://", "https://");
                            messageTxt.setText(txt);
                        }
                    });
                } else {
                    this.activity.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            if (ImgurUploadTask.this.activity != null) {
                                if (Looper.myLooper() == null) {
                                    Looper.prepare();
                                }
                                AlertDialog.Builder builder = new AlertDialog.Builder((Context)ImgurUploadTask.this.activity);
                                builder.setInverseBackgroundForced(Build.VERSION.SDK_INT < 11);
                                builder.setTitle("Upload Failed");
                                builder.setMessage("Unable to upload photo to imgur.  Please try again." + (ImgurUploadTask.this.error != null ? "\n\n" + ImgurUploadTask.this.error : ""));
                                builder.setNegativeButton("Ok", new DialogInterface.OnClickListener(){

                                    public void onClick(DialogInterface dialog, int which) {
                                        dialog.dismiss();
                                    }
                                });
                                AlertDialog dialog = builder.create();
                                dialog.setOwnerActivity(ImgurUploadTask.this.activity);
                                dialog.show();
                            }
                        }
                    });
                }
                MainActivity.this.imgurTask = null;
            } else if (this.mBuffer != null && s != null) {
                Crashlytics.log(4, "IRCCloud", "Upload finished, updating draft");
                if (this.mBuffer.draft == null) {
                    this.mBuffer.draft = "";
                }
                if (this.mBuffer.draft.length() > 0 && !this.mBuffer.draft.endsWith(" ")) {
                    this.mBuffer.draft = this.mBuffer.draft + " ";
                }
                this.mBuffer.draft = this.mBuffer.draft + s;
            } else if (suggestionsTimer != null) {
                suggestionsTimer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        ImgurUploadTask.this.setText(s);
                    }
                }, 500L);
            }
        }

        private int copy(InputStream input, OutputStream output) throws IOException {
            byte[] buffer = new byte[8192];
            int count = 0;
            int n = 0;
            while (-1 != (n = input.read(buffer))) {
                output.write(buffer, 0, n);
                this.publishProgress(Float.valueOf((float)(count += n) / (float)this.total));
            }
            return count;
        }

        protected String onInput(InputStream in) throws Exception {
            StringBuilder sb = new StringBuilder();
            Scanner scanner = new Scanner(in).useDelimiter("\\A");
            while (scanner.hasNext()) {
                sb.append(scanner.next());
            }
            JSONObject root = new JSONObject(sb.toString());
            this.error = root.has("data") && root.getJSONObject("data").has("error") ? root.getJSONObject("data").getString("error") : null;
            this.total = 0;
            return root.getJSONObject("data").getString("link");
        }
    }

    public class ImgurRefreshTask
    extends AsyncTaskEx<Void, Void, JSONObject> {
        private final String REFRESH_URL = "https://api.imgur.com/oauth2/token";
        private Uri mImageUri;

        public ImgurRefreshTask(Uri imageUri) {
            this.mImageUri = imageUri;
        }

        protected JSONObject doInBackground(Void ... params) {
            try {
                if (MainActivity.this.getSharedPreferences("prefs", 0).contains("imgur_refresh_token")) {
                    JSONObject o = NetworkConnection.getInstance().fetchJSON("https://api.imgur.com/oauth2/token", "client_id=&client_secret=&grant_type=refresh_token&refresh_token=" + MainActivity.this.getSharedPreferences("prefs", 0).getString("imgur_refresh_token", ""));
                    return o;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        protected void onPostExecute(JSONObject o) {
            try {
                if (MainActivity.this.getSharedPreferences("prefs", 0).contains("imgur_refresh_token")) {
                    if (o == null || o.has("success") && !o.getBoolean("success")) {
                        MainActivity.this.startActivity(new Intent((Context)MainActivity.this, ImgurAuthActivity.class));
                    } else {
                        SharedPreferences.Editor prefs = MainActivity.this.getSharedPreferences("prefs", 0).edit();
                        Iterator i = o.keys();
                        while (i.hasNext()) {
                            String k = (String)i.next();
                            prefs.putString("imgur_" + k, o.getString(k));
                        }
                        prefs.commit();
                        if (this.mImageUri != null) {
                            MainActivity.this.imgurTask = new ImgurUploadTask(this.mImageUri);
                            MainActivity.this.imgurTask.execute(new Void[]{null});
                        }
                    }
                } else if (this.mImageUri != null) {
                    MainActivity.this.imgurTask = new ImgurUploadTask(this.mImageUri);
                    MainActivity.this.imgurTask.execute(new Void[]{null});
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    private class ToggleListener
    implements DrawerLayout.DrawerListener {
        private ToggleListener() {
        }

        @Override
        public void onDrawerSlide(View view, float slideOffset) {
        }

        @Override
        public void onDrawerOpened(View view) {
            if (((DrawerLayout.LayoutParams)view.getLayoutParams()).gravity == 3) {
                MainActivity.this.drawerLayout.setDrawerLockMode(1, 5);
            } else {
                MainActivity.this.drawerLayout.setDrawerLockMode(1, 3);
            }
            try {
                if (MainActivity.this.getCurrentFocus() != null) {
                    InputMethodManager imm = (InputMethodManager)MainActivity.this.getSystemService("input_method");
                    imm.hideSoftInputFromWindow(MainActivity.this.getCurrentFocus().getWindowToken(), 0);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void onDrawerClosed(View view) {
            if (((DrawerLayout.LayoutParams)view.getLayoutParams()).gravity == 3) {
                MainActivity.this.drawerLayout.setDrawerLockMode(0);
                MainActivity.this.updateUsersListFragmentVisibility();
            } else {
                MainActivity.this.drawerLayout.setDrawerLockMode(0, 3);
            }
            MessageViewFragment mvf = (MessageViewFragment)MainActivity.this.getSupportFragmentManager().findFragmentById(2131624071);
            if (mvf != null) {
                mvf.drawerClosed();
            }
        }

        @Override
        public void onDrawerStateChanged(int i) {
            if (i != 2) {
                if (MainActivity.this.findViewById(2131624077) != null) {
                    MainActivity.this.drawerLayout.bringChildToFront(MainActivity.this.findViewById(2131624077));
                } else {
                    if (MainActivity.this.buffersListView != null) {
                        MainActivity.this.drawerLayout.bringChildToFront(MainActivity.this.buffersListView);
                    }
                    if (MainActivity.this.userListView != null) {
                        MainActivity.this.drawerLayout.bringChildToFront(MainActivity.this.userListView);
                    }
                }
                MainActivity.this.drawerLayout.setScrimColor(-1728053248);
            }
        }
    }

    public static class ConfigInstance {
        public ImgurUploadTask imgurUploadTask;
        public FileUploadTask fileUploadTask;
    }

    private class ShowNotificationsTask
    extends AsyncTaskEx<Integer, Void, Void> {
        private ShowNotificationsTask() {
        }

        protected Void doInBackground(Integer ... params) {
            Notifications.getInstance().excludeBid(params[0]);
            if (params[0] > 0) {
                Notifications.getInstance().showNotifications(null);
            }
            MainActivity.this.showNotificationsTask = null;
            return null;
        }
    }

    private class RefreshUpIndicatorTask
    extends AsyncTaskEx<Void, Void, Void> {
        int unread = 0;
        int highlights = 0;

        private RefreshUpIndicatorTask() {
        }

        protected Void doInBackground(Void ... arg0) {
            if (MainActivity.this.drawerLayout != null) {
                JSONObject channelDisabledMap = null;
                JSONObject bufferDisabledMap = null;
                if (NetworkConnection.getInstance().getUserInfo() != null && NetworkConnection.getInstance().getUserInfo().prefs != null) {
                    try {
                        if (NetworkConnection.getInstance().getUserInfo().prefs.has("channel-disableTrackUnread")) {
                            channelDisabledMap = NetworkConnection.getInstance().getUserInfo().prefs.getJSONObject("channel-disableTrackUnread");
                        }
                        if (NetworkConnection.getInstance().getUserInfo().prefs.has("buffer-disableTrackUnread")) {
                            bufferDisabledMap = NetworkConnection.getInstance().getUserInfo().prefs.getJSONObject("buffer-disableTrackUnread");
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ArrayList<BuffersDataSource.Buffer> buffers = BuffersDataSource.getInstance().getBuffers();
                for (int j = 0; j < buffers.size(); ++j) {
                    BuffersDataSource.Buffer b = buffers.get(j);
                    if (MainActivity.this.buffer != null && b.bid == MainActivity.this.buffer.bid) continue;
                    if (this.unread == 0) {
                        int u = 0;
                        try {
                            u = b.unread;
                            if (b.type.equalsIgnoreCase("channel") && channelDisabledMap != null && channelDisabledMap.has(String.valueOf(b.bid)) && channelDisabledMap.getBoolean(String.valueOf(b.bid))) {
                                u = 0;
                            } else if (bufferDisabledMap != null && bufferDisabledMap.has(String.valueOf(b.bid)) && bufferDisabledMap.getBoolean(String.valueOf(b.bid))) {
                                u = 0;
                            }
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                        }
                        this.unread += u;
                    }
                    if (this.highlights == 0) {
                        try {
                            if (!(b.type.equalsIgnoreCase("conversation") && bufferDisabledMap != null && bufferDisabledMap.has(String.valueOf(b.bid)) && bufferDisabledMap.getBoolean(String.valueOf(b.bid)))) {
                                this.highlights += b.highlights;
                            }
                        }
                        catch (JSONException jSONException) {
                            // empty catch block
                        }
                    }
                    if (this.highlights > 0) break;
                }
            }
            return null;
        }

        @Override
        protected void onPostExecute(Void result) {
            if (!this.isCancelled() && MainActivity.this.upDrawable != null) {
                if (this.highlights > 0) {
                    MainActivity.this.upDrawable.setColor(MainActivity.this.redColor);
                } else if (this.unread > 0) {
                    MainActivity.this.upDrawable.setColor(MainActivity.this.blueColor);
                } else {
                    MainActivity.this.upDrawable.setColor(MainActivity.this.greyColor);
                }
                MainActivity.this.refreshUpIndicatorTask = null;
            }
        }
    }

    private class SendTask
    extends AsyncTaskEx<Void, Void, Void> {
        boolean forceText = false;
        EventsDataSource.Event e = null;

        public SendTask() {
            SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)IRCCloudApplication.getInstance().getApplicationContext());
            this.forceText = !prefs.getBoolean("pastebin-disableprompt", true);
        }

        @Override
        protected void onPreExecute() {
            if (MainActivity.this.conn != null && MainActivity.this.conn.getState() == 2 && MainActivity.this.messageTxt.getText() != null && MainActivity.this.messageTxt.getText().length() > 0 && MainActivity.this.buffer != null && MainActivity.this.server != null) {
                String msg;
                MainActivity.this.sendBtn.setEnabled(false);
                if (Build.VERSION.SDK_INT >= 11) {
                    MainActivity.this.sendBtn.setAlpha(0.5f);
                }
                if ((msg = MainActivity.this.messageTxt.getText().toString()).startsWith("//")) {
                    msg = msg.substring(1);
                } else if (msg.startsWith("/") && !msg.startsWith("/me ")) {
                    msg = null;
                }
                if (MainActivity.this.messageTxt.getText().toString().equals("/paste") || !this.forceText && msg != null && (msg.length() > 1080 || msg.split("\n").length > 1)) {
                    if (MainActivity.this.messageTxt.getText().toString().equals("/paste")) {
                        MainActivity.this.messageTxt.setText("");
                    }
                    MainActivity.this.show_pastebin_prompt();
                    return;
                }
                UsersDataSource.User u = UsersDataSource.getInstance().getUser(MainActivity.this.buffer.bid, MainActivity.this.server.nick);
                this.e = new EventsDataSource.Event();
                this.e.command = MainActivity.this.messageTxt.getText().toString();
                this.e.cid = MainActivity.this.buffer.cid;
                this.e.bid = MainActivity.this.buffer.bid;
                this.e.eid = (System.currentTimeMillis() + MainActivity.this.conn.clockOffset + 5000L) * 1000L;
                if (this.e.eid < EventsDataSource.getInstance().lastEidForBuffer(MainActivity.this.buffer.bid)) {
                    this.e.eid = EventsDataSource.getInstance().lastEidForBuffer(MainActivity.this.buffer.bid) + 1000L;
                }
                this.e.self = true;
                this.e.from = MainActivity.this.server.nick;
                this.e.nick = MainActivity.this.server.nick;
                if (!MainActivity.this.buffer.type.equals("console")) {
                    this.e.chan = MainActivity.this.buffer.name;
                }
                if (u != null) {
                    this.e.from_mode = u.mode;
                }
                this.e.msg = msg;
                if (msg != null && msg.toLowerCase().startsWith("/me ")) {
                    this.e.type = "buffer_me_msg";
                    this.e.msg = msg.substring(4);
                } else {
                    this.e.type = "buffer_msg";
                }
                this.e.color = 2131492956;
                this.e.bg_color = MainActivity.this.title.getText() != null && MainActivity.this.title.getText().equals(MainActivity.this.server.nick) ? 2131492930 : 2131492946;
                this.e.row_type = 0;
                this.e.html = null;
                this.e.group_msg = null;
                this.e.linkify = true;
                this.e.target_mode = null;
                this.e.highlight = false;
                this.e.reqid = -1;
                this.e.pending = true;
                if (this.e.msg != null) {
                    this.e.msg = TextUtils.htmlEncode((String)this.e.msg);
                    EventsDataSource.getInstance().addEvent(this.e);
                    MainActivity.this.conn.notifyHandlers(5, this.e, MainActivity.this);
                }
            }
        }

        protected Void doInBackground(Void ... arg0) {
            if (BuildConfig.DEBUG && this.e != null && this.e.command != null && (this.e.command.equals("/starttrace") || this.e.command.equals("/stoptrace") || this.e.command.equals("/crash"))) {
                this.e.reqid = -2;
                return null;
            }
            if (this.e != null && this.e.command != null && this.e.command.equals("/ignore")) {
                this.e.reqid = -2;
                return null;
            }
            if (this.e != null && MainActivity.this.conn != null && MainActivity.this.conn.getState() == 2 && MainActivity.this.messageTxt.getText() != null && MainActivity.this.messageTxt.getText().length() > 0) {
                this.e.reqid = MainActivity.this.conn.say(this.e.cid, this.e.chan, this.e.command);
                if (this.e.msg != null) {
                    MainActivity.this.pendingEvents.put(this.e.reqid, this.e);
                }
            }
            return null;
        }

        @Override
        protected void onPostExecute(Void result) {
            if (BuildConfig.DEBUG) {
                if (MainActivity.this.messageTxt.getText().toString().equals("/starttrace")) {
                    Debug.startMethodTracing((String)"irccloud");
                    MainActivity.this.showAlert(this.e.cid, "Method tracing started");
                } else if (MainActivity.this.messageTxt.getText().toString().equals("/stoptrace")) {
                    Debug.stopMethodTracing();
                    MainActivity.this.showAlert(this.e.cid, "Method tracing finished");
                } else if (MainActivity.this.messageTxt.getText().toString().equals("/crash")) {
                    Crashlytics.getInstance().crash();
                }
            }
            if (this.e != null && this.e.command.equals("/ignore")) {
                Bundle args = new Bundle();
                args.putInt("cid", MainActivity.this.buffer.cid);
                IgnoreListFragment ignoreList = new IgnoreListFragment();
                ignoreList.setArguments(args);
                ignoreList.show(MainActivity.this.getSupportFragmentManager(), "ignorelist");
            }
            if (this.e != null && this.e.reqid != -1) {
                MainActivity.this.messageTxt.setText("");
                BuffersDataSource.getInstance().updateDraft(this.e.bid, null);
                this.e.expiration_timer = new TimerTask(){

                    @Override
                    public void run() {
                        if (MainActivity.this.pendingEvents.containsKey(SendTask.this.e.reqid)) {
                            MainActivity.this.pendingEvents.remove(SendTask.this.e.reqid);
                            SendTask.this.e.failed = true;
                            SendTask.this.e.bg_color = 2131492904;
                            SendTask.this.e.expiration_timer = null;
                            if (MainActivity.this.conn != null) {
                                MainActivity.this.conn.notifyHandlers(5, SendTask.this.e, MainActivity.this);
                            }
                        }
                    }
                };
                try {
                    if (countdownTimer != null) {
                        countdownTimer.schedule(this.e.expiration_timer, 30000L);
                    }
                }
                catch (IllegalStateException illegalStateException) {}
            } else {
                MainActivity.this.sendBtn.setEnabled(true);
                if (Build.VERSION.SDK_INT >= 11) {
                    MainActivity.this.sendBtn.setAlpha(1.0f);
                }
            }
        }
    }

    private class SuggestionsAdapter
    extends ArrayAdapter<String> {
        public int activePos;

        public SuggestionsAdapter() {
            super((Context)MainActivity.this, 2130903127);
            this.activePos = -1;
            this.setNotifyOnChange(false);
        }

        public void clear() {
            super.clear();
            this.activePos = -1;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            TextView v = (TextView)super.getView(position, convertView, parent);
            if (position == this.activePos) {
                v.setTextColor(-1);
                v.setBackgroundResource(2130837731);
            } else {
                v.setTextColor(MainActivity.this.getResources().getColor(2131492968));
                v.setBackgroundResource(2130837730);
            }
            v.setSelected(true);
            return v;
        }
    }
}

