/*
 * Decompiled with CFR 0.152.
 */
package com.irccloud.android.activity;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.nfc.NdefMessage;
import android.nfc.NdefRecord;
import android.nfc.NfcAdapter;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v7.widget.Toolbar;
import android.view.Menu;
import android.view.MenuItem;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;
import android.widget.Toast;
import com.irccloud.android.AsyncTaskEx;
import com.irccloud.android.NetworkConnection;
import com.irccloud.android.ShareActionProviderHax;
import com.irccloud.android.activity.BaseActivity;
import com.irccloud.android.fragment.PastebinEditorFragment;
import java.net.URL;

public class PastebinViewerActivity
extends BaseActivity
implements ShareActionProviderHax.OnShareActionProviderSubVisibilityChangedListener,
PastebinEditorFragment.PastebinEditorListener {
    WebView mWebView;
    ProgressBar mSpinner;
    Toolbar toolbar;
    String html;
    String url;

    @Override
    public void onPastebinFailed(String pastecontents) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                PastebinViewerActivity.this.mSpinner.setVisibility(8);
                PastebinViewerActivity.this.supportInvalidateOptionsMenu();
            }
        });
    }

    @Override
    public void onPastebinSaved() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                PastebinViewerActivity.this.mWebView.clearCache(true);
                PastebinViewerActivity.this.mWebView.reload();
                PastebinViewerActivity.this.getSupportActionBar().setTitle("Pastebin");
                PastebinViewerActivity.this.getSupportActionBar().setSubtitle(null);
                PastebinViewerActivity.this.mSpinner.setVisibility(0);
                PastebinViewerActivity.this.supportInvalidateOptionsMenu();
                new FetchPastebinTask().execute(new Void[0]);
            }
        });
    }

    @Override
    public void onPastebinSendAsText(String text) {
    }

    @Override
    public void onPastebinCancelled() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                PastebinViewerActivity.this.mSpinner.setVisibility(8);
                PastebinViewerActivity.this.supportInvalidateOptionsMenu();
            }
        });
    }

    @Override
    @TargetApi(value=11)
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (Build.VERSION.SDK_INT >= 21) {
            Bitmap cloud = BitmapFactory.decodeResource((Resources)this.getResources(), (int)2130837620);
            this.setTaskDescription(new ActivityManager.TaskDescription(this.getResources().getString(2131165254), cloud, -854020));
            cloud.recycle();
        }
        if (savedInstanceState == null) {
            this.overridePendingTransition(2130968588, 2130968587);
        }
        this.setContentView(2130903077);
        this.mSpinner = (ProgressBar)this.findViewById(2131624037);
        this.toolbar = (Toolbar)this.findViewById(2131624039);
        this.setSupportActionBar(this.toolbar);
        this.getSupportActionBar().setTitle("Pastebin");
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.getSupportActionBar().setBackgroundDrawable(this.getResources().getDrawable(2130837566));
        this.mWebView = (WebView)this.findViewById(2131623990);
        this.mWebView.getSettings().setBuiltInZoomControls(true);
        if (Integer.parseInt(Build.VERSION.SDK) >= 19) {
            this.mWebView.getSettings().setDisplayZoomControls(false);
        }
        this.mWebView.getSettings().setJavaScriptEnabled(true);
        this.mWebView.addJavascriptInterface((Object)new JSInterface(), "Android");
        this.mWebView.getSettings().setLoadWithOverviewMode(false);
        this.mWebView.getSettings().setUseWideViewPort(false);
        this.mWebView.getSettings().setAppCacheEnabled(false);
        this.mWebView.setWebViewClient(new WebViewClient(){

            public void onPageFinished(WebView view, String url) {
            }

            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                PastebinViewerActivity.this.fail();
            }

            public void onLoadResource(WebView view, String url) {
            }
        });
        if (savedInstanceState != null && savedInstanceState.containsKey("url")) {
            this.url = savedInstanceState.getString("url");
            this.html = savedInstanceState.getString("html");
            this.mWebView.loadDataWithBaseURL(this.url, this.html, "text/html", "UTF-8", null);
        } else if (this.getIntent() != null && this.getIntent().getDataString() != null) {
            this.url = this.getIntent().getDataString().replace(this.getResources().getString(2131165234), "https");
            new FetchPastebinTask().execute(new Void[0]);
        } else {
            this.finish();
        }
    }

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString("url", this.url);
        outState.putString("html", this.html);
    }

    private void fail() {
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)this.url));
        this.startActivity(intent);
        this.finish();
    }

    @Override
    public void onResume() {
        super.onResume();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (this.mWebView != null) {
            this.mWebView.setWebViewClient(null);
            this.mWebView.setWebChromeClient(null);
        }
    }

    @Override
    public void onBackPressed() {
        super.onBackPressed();
        this.overridePendingTransition(2130968586, 2130968589);
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(2131689481, menu2);
        return true;
    }

    public boolean onPrepareOptionsMenu(Menu menu2) {
        if (Uri.parse((String)this.url).getQueryParameter("own_paste") == null || !Uri.parse((String)this.url).getQueryParameter("own_paste").equals("1")) {
            menu2.findItem(2131624238).setVisible(false);
            menu2.findItem(2131624195).setVisible(false);
        }
        if (this.mSpinner == null || this.mSpinner.getVisibility() != 8) {
            menu2.findItem(2131624237).setEnabled(false);
        }
        return super.onPrepareOptionsMenu(menu2);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.finish();
            this.overridePendingTransition(2130968586, 2130968589);
            return true;
        }
        if (item.getItemId() == 2131624195) {
            if (Uri.parse((String)this.url).getQueryParameter("own_paste").equals("1")) {
                NetworkConnection.getInstance().delete_paste(Uri.parse((String)this.url).getQueryParameter("id"));
                this.finish();
                Toast.makeText((Context)this, (CharSequence)"Pastebin deleted", (int)0).show();
            }
        } else if (item.getItemId() == 2131624237) {
            item.setChecked(!item.isChecked());
            this.mWebView.loadUrl("javascript:$('a.lines').click()");
        } else {
            if (item.getItemId() == 2131624222) {
                Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)this.url));
                this.startActivity(intent);
                this.finish();
                return true;
            }
            if (item.getItemId() == 2131624223) {
                if (Build.VERSION.SDK_INT < 11) {
                    android.text.ClipboardManager clipboard = (android.text.ClipboardManager)this.getSystemService("clipboard");
                    if (this.url.contains("?id=")) {
                        clipboard.setText((CharSequence)this.url.substring(0, this.url.indexOf("?id=")));
                    } else {
                        clipboard.setText((CharSequence)this.url);
                    }
                } else {
                    ClipboardManager clipboard = (ClipboardManager)this.getSystemService("clipboard");
                    ClipData clip = this.url.contains("?id=") ? ClipData.newRawUri((CharSequence)"IRCCloud Pastebin URL", (Uri)Uri.parse((String)this.url.substring(0, this.url.indexOf("?id=")))) : ClipData.newRawUri((CharSequence)"IRCCloud Pastebin URL", (Uri)Uri.parse((String)this.url));
                    clipboard.setPrimaryClip(clip);
                }
                Toast.makeText((Context)this, (CharSequence)"Link copied to clipboard", (int)0).show();
            } else if (item.getItemId() == 2131624221) {
                if (this.getIntent() != null && this.getIntent().getDataString() != null) {
                    Intent intent = new Intent("android.intent.action.SEND", Uri.parse((String)this.url));
                    intent.setType("text/plain");
                    if (this.url.contains("?id=")) {
                        intent.putExtra("android.intent.extra.TEXT", this.url.substring(0, this.url.indexOf("?id=")));
                    } else {
                        intent.putExtra("android.intent.extra.TEXT", this.url);
                    }
                    intent.putExtra("android.support.v4.app.EXTRA_CALLING_PACKAGE", this.getPackageName());
                    intent.putExtra("android.support.v4.app.EXTRA_CALLING_ACTIVITY", (Parcelable)this.getPackageManager().getLaunchIntentForPackage(this.getPackageName()).getComponent());
                    intent.addFlags(0x10080000);
                    this.startActivity(Intent.createChooser((Intent)intent, (CharSequence)"Share Pastebin"));
                }
            } else if (item.getItemId() == 2131624238) {
                this.mSpinner.setVisibility(0);
                PastebinEditorFragment f = (PastebinEditorFragment)this.getSupportFragmentManager().findFragmentByTag("editor");
                if (f == null) {
                    f = new PastebinEditorFragment();
                    f.pasteID = Uri.parse((String)this.url).getQueryParameter("id");
                    f.listener = this;
                    try {
                        f.show(this.getSupportFragmentManager(), "editor");
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
            }
        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    public void onShareActionProviderSubVisibilityChanged(boolean visible) {
    }

    public class JSInterface {
        @JavascriptInterface
        public void ready() {
            PastebinViewerActivity.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    PastebinViewerActivity.this.mSpinner.setVisibility(8);
                    PastebinViewerActivity.this.supportInvalidateOptionsMenu();
                }
            });
        }

        @JavascriptInterface
        public void setTitle(final String title, final String subtitle) {
            PastebinViewerActivity.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (title != null && title.length() > 0 && PastebinViewerActivity.this.getSupportActionBar() != null) {
                        PastebinViewerActivity.this.getSupportActionBar().setTitle(title);
                    }
                    if (subtitle != null && subtitle.length() > 0 && PastebinViewerActivity.this.getSupportActionBar() != null) {
                        PastebinViewerActivity.this.getSupportActionBar().setSubtitle(subtitle);
                    }
                }
            });
        }
    }

    private class FetchPastebinTask
    extends AsyncTaskEx<Void, Void, String> {
        private FetchPastebinTask() {
        }

        protected String doInBackground(Void ... params) {
            try {
                String html = NetworkConnection.getInstance().fetch(new URL(PastebinViewerActivity.this.url), null, null, null);
                if (html != null && html.length() > 0) {
                    html = html.replace("</head>", "<style>html, body, .mainContainer, .pasteContainer { width: 100% }body, div.paste { background-color: #fafafa; }h1#title, div#pasteSidebar, div.paste h1 { display: none; }.mainContainerFull, .mainContent, .mainContentPaste, div.paste { margin: 0px; padding: 0px; border: none; width: 100%; }</style></head>");
                    html = html.replace("https://js.stripe.com/v2", "");
                    html = html.replace("https://checkout.stripe.com/v3/checkout.js", "");
                    html = html.replace("https://platform.twitter.com/widgets.js", "");
                    html = html.replace("https://platform.vine.co/static/scripts/embed.js", "");
                    html = html.replace("https://connect.facebook.net/en_US/all.js#xfbml=1&status=0&appId=1524400614444110", "");
                    html = html.replace("https://apis.google.com/js/plusone.js", "");
                    html = html.replace("//rum-static.pingdom.net/prum.min.js", "");
                    html = html.replace("window.IRCCloudAppMapSource =", "window.IRCCloudAppMapSourceDisabled =");
                    html = html.replace("</body>", "<script>window.PASTEVIEW.model.on('loaded', _.bind(function () {\nAndroid.setTitle(window.PASTEVIEW.model.get('name'), window.PASTEVIEW.syntax() + \" \u2022 \" + window.PASTEVIEW.lines());\n}, window.PASTEVIEW.model));\nwindow.PASTEVIEW.on('rendered', _.bind(function () {\nvar height = window.PASTEVIEW.ace.container.style.height;\nheight = height.substring(0, height.length - 2);\nif(height < window.innerHeight) { window.PASTEVIEW.ace.container.style.height = window.innerHeight + \"px\"; }\n$('div.pasteContainer').height(window.PASTEVIEW.ace.container.style.height);\nAndroid.ready();\n}, window.PASTEVIEW));\nwindow.PASTEVIEW.model.on('removed', _.bind(function () {\nAndroid.ready();\n}, window.PASTEVIEW.model));\nwindow.PASTEVIEW.model.on('fetchError', _.bind(function () {\nAndroid.ready();\n}, window.PASTEVIEW.model));\n</script></body>");
                }
                return html;
            }
            catch (Exception exception) {
                return null;
            }
        }

        @Override
        protected void onPostExecute(String html) {
            if (html != null) {
                PastebinViewerActivity.this.html = html;
                PastebinViewerActivity.this.mWebView.loadDataWithBaseURL(PastebinViewerActivity.this.url, html, "text/html", "UTF-8", null);
                try {
                    NfcAdapter nfc;
                    if (Build.VERSION.SDK_INT >= 16 && (nfc = NfcAdapter.getDefaultAdapter((Context)PastebinViewerActivity.this)) != null) {
                        nfc.setNdefPushMessage(new NdefMessage(NdefRecord.createUri((String)PastebinViewerActivity.this.url), new NdefRecord[0]), (Activity)PastebinViewerActivity.this, new Activity[0]);
                    }
                }
                catch (Exception exception) {}
            } else {
                PastebinViewerActivity.this.fail();
            }
        }
    }
}

