/*
 * Decompiled with CFR 0.152.
 */
package com.irccloud.android.activity;

import android.app.ActivityManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.v7.app.AlertDialog;
import android.text.format.DateUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ImageButton;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;
import com.crashlytics.android.Crashlytics;
import com.github.fge.uritemplate.URITemplate;
import com.github.fge.uritemplate.URITemplateException;
import com.github.fge.uritemplate.vars.VariableMap;
import com.irccloud.android.AsyncTaskEx;
import com.irccloud.android.IRCCloudJSONObject;
import com.irccloud.android.NetworkConnection;
import com.irccloud.android.activity.BaseActivity;
import com.irccloud.android.activity.PastebinViewerActivity;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PastebinsActivity
extends BaseActivity {
    private int page = 0;
    private int reqid = -1;
    private PastebinsAdapter adapter = new PastebinsAdapter();
    private boolean canLoadMore = true;
    private View footer;
    private Pastebin pasteToDelete;
    private URITemplate uri_template = null;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (Build.VERSION.SDK_INT >= 21) {
            Bitmap cloud = BitmapFactory.decodeResource((Resources)this.getResources(), (int)2130837620);
            this.setTaskDescription(new ActivityManager.TaskDescription(this.getResources().getString(2131165254), cloud, -854020));
            cloud.recycle();
        }
        this.setContentView(2130903096);
        if (this.getSupportActionBar() != null) {
            this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
            this.getSupportActionBar().setHomeAsUpIndicator(2130837526);
            this.getSupportActionBar().setBackgroundDrawable(this.getResources().getDrawable(2130837566));
            this.getSupportActionBar().setElevation(0.0f);
        }
        if (savedInstanceState != null && savedInstanceState.containsKey("adapter")) {
            Pastebin[] pastebins;
            this.page = savedInstanceState.getInt("page");
            for (Pastebin p : pastebins = (Pastebin[])savedInstanceState.getSerializable("adapter")) {
                this.adapter.addPastebin(p);
            }
            this.adapter.notifyDataSetChanged();
        }
        this.footer = this.getLayoutInflater().inflate(2130903099, null);
        ListView listView = (ListView)this.findViewById(16908298);
        listView.setAdapter((ListAdapter)this.adapter);
        listView.addFooterView(this.footer);
        listView.setOnScrollListener(new AbsListView.OnScrollListener(){

            public void onScrollStateChanged(AbsListView absListView, int i) {
            }

            public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
                if (PastebinsActivity.this.canLoadMore && firstVisibleItem + visibleItemCount > totalItemCount - 4) {
                    PastebinsActivity.this.canLoadMore = false;
                    new FetchPastebinsTask().execute(new Void[]{null});
                }
            }
        });
        listView.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> adapterView, View view, int i, long l) {
            }

            public void onNothingSelected(AdapterView<?> adapterView) {
            }
        });
        listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Pastebin p = (Pastebin)PastebinsActivity.this.adapter.getItem(i);
                Intent intent = new Intent((Context)PastebinsActivity.this, PastebinViewerActivity.class);
                intent.setData(Uri.parse((String)(p.url + "?id=" + p.id + "&own_paste=" + (p.own_paste ? "1" : "0"))));
                PastebinsActivity.this.startActivity(intent);
            }
        });
        Toast.makeText((Context)this, (CharSequence)"Tap a pastebin to view full text with syntax highlighting", (int)1).show();
    }

    @Override
    public void onResume() {
        super.onResume();
        NetworkConnection.getInstance().addHandler(this);
        try {
            this.uri_template = new URITemplate(NetworkConnection.getInstance().config.getString("pastebin_uri_template"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onPause() {
        super.onPause();
        NetworkConnection.getInstance().removeHandler(this);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (this.adapter != null) {
            this.adapter.clear();
        }
    }

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt("page", this.page);
        this.adapter.saveInstanceState(outState);
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu2) {
        return false;
    }

    @Override
    public void onIRCEvent(int what, Object o) {
        switch (what) {
            case 104: {
                IRCCloudJSONObject obj = (IRCCloudJSONObject)o;
                if (obj.getInt("_reqid") != this.reqid) break;
                Log.d((String)"IRCCloud", (String)"Pastebin deleted successfully");
                this.reqid = -1;
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        PastebinsActivity.this.adapter.pastebins.remove(PastebinsActivity.this.pasteToDelete);
                        PastebinsActivity.this.adapter.notifyDataSetChanged();
                        PastebinsActivity.this.checkEmpty();
                        PastebinsActivity.this.pasteToDelete = null;
                    }
                });
                break;
            }
            case 103: {
                IRCCloudJSONObject obj = (IRCCloudJSONObject)o;
                if (this.reqid == -1 || obj.getInt("_reqid") != this.reqid) break;
                Crashlytics.log(6, "IRCCloud", "Delete failed: " + obj.toString());
                this.reqid = -1;
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        AlertDialog.Builder builder = new AlertDialog.Builder((Context)PastebinsActivity.this);
                        builder.setTitle("Error");
                        builder.setMessage("Unable to delete this pastebin.  Please try again shortly.");
                        builder.setPositiveButton("Close", null);
                        builder.show();
                    }
                });
                break;
            }
        }
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.finish();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    private void checkEmpty() {
        if (this.adapter.getCount() == 0 && !this.canLoadMore) {
            this.findViewById(16908298).setVisibility(8);
            TextView empty = (TextView)this.findViewById(16908292);
            empty.setVisibility(0);
            empty.setText((CharSequence)"You haven't created any pastebins yet.");
        } else {
            this.findViewById(16908298).setVisibility(0);
            this.findViewById(16908292).setVisibility(8);
        }
    }

    private class FetchPastebinsTask
    extends AsyncTaskEx<Void, Void, JSONObject> {
        private FetchPastebinsTask() {
        }

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            PastebinsActivity.this.canLoadMore = false;
        }

        protected JSONObject doInBackground(Void ... params) {
            try {
                Thread.currentThread().setPriority(1);
                return NetworkConnection.getInstance().pastebins(++PastebinsActivity.this.page);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }

        @Override
        protected void onPostExecute(JSONObject jsonObject) {
            block8: {
                if (jsonObject != null) {
                    try {
                        if (jsonObject.getBoolean("success")) {
                            JSONArray pastebins = jsonObject.getJSONArray("pastebins");
                            Log.e((String)"IRCCloud", (String)("Got " + pastebins.length() + " pastebins for page " + PastebinsActivity.this.page));
                            for (int i = 0; i < pastebins.length(); ++i) {
                                JSONObject pastebin = pastebins.getJSONObject(i);
                                PastebinsActivity.this.adapter.addPastebin(pastebin.getString("id"), pastebin.getString("name"), pastebin.getInt("lines"), new Date(pastebin.getLong("date") * 1000L), pastebin.getString("body"), pastebin.getBoolean("own_paste"));
                            }
                            PastebinsActivity.this.adapter.notifyDataSetChanged();
                            PastebinsActivity.this.canLoadMore = pastebins.length() > 0 && PastebinsActivity.this.adapter.getCount() < jsonObject.getInt("total");
                            if (!PastebinsActivity.this.canLoadMore) {
                                PastebinsActivity.this.footer.findViewById(2131624038).setVisibility(8);
                            }
                            break block8;
                        }
                        PastebinsActivity.this.page--;
                        Log.e((String)"IRCCloud", (String)("Failed: " + jsonObject.toString()));
                        if (jsonObject.has("message") && jsonObject.getString("message").equals("server_error")) {
                            PastebinsActivity.this.canLoadMore = true;
                            new FetchPastebinsTask().execute(new Void[]{null});
                            break block8;
                        }
                        PastebinsActivity.this.canLoadMore = false;
                    }
                    catch (JSONException e) {
                        PastebinsActivity.this.page--;
                        e.printStackTrace();
                    }
                } else {
                    PastebinsActivity.this.page--;
                    PastebinsActivity.this.canLoadMore = true;
                    new FetchPastebinsTask().execute(new Void[]{null});
                }
            }
            PastebinsActivity.this.checkEmpty();
        }
    }

    private class PastebinsAdapter
    extends BaseAdapter {
        private ArrayList<Pastebin> pastebins = new ArrayList();
        private View.OnClickListener deleteClickListener = new View.OnClickListener(){

            public void onClick(View view) {
                PastebinsActivity.this.pasteToDelete = (Pastebin)PastebinsAdapter.this.getItem((Integer)view.getTag());
                AlertDialog.Builder builder = new AlertDialog.Builder((Context)PastebinsActivity.this);
                builder.setTitle("Delete Pastebin");
                if (((PastebinsActivity)PastebinsActivity.this).pasteToDelete.name != null && ((PastebinsActivity)PastebinsActivity.this).pasteToDelete.name.length() > 0) {
                    builder.setMessage("Are you sure you want to delete '" + ((PastebinsActivity)PastebinsActivity.this).pasteToDelete.name + "'?");
                } else {
                    builder.setMessage("Are you sure you want to delete this pastebin?");
                }
                builder.setPositiveButton("Delete", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int i) {
                        PastebinsActivity.this.reqid = NetworkConnection.getInstance().delete_paste(((PastebinsActivity)PastebinsActivity.this).pasteToDelete.id);
                        PastebinsAdapter.this.pastebins.remove(PastebinsActivity.this.pasteToDelete);
                        PastebinsAdapter.this.notifyDataSetChanged();
                    }
                });
                builder.setNegativeButton("Cancel", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int i) {
                        dialogInterface.dismiss();
                        PastebinsActivity.this.pasteToDelete = null;
                    }
                });
                AlertDialog d = builder.create();
                d.setOwnerActivity(PastebinsActivity.this);
                d.show();
            }
        };

        private PastebinsAdapter() {
        }

        public void clear() {
            this.pastebins.clear();
            this.notifyDataSetInvalidated();
        }

        public void saveInstanceState(Bundle state) {
            state.putSerializable("adapter", (Serializable)this.pastebins.toArray(new Pastebin[this.pastebins.size()]));
        }

        public void addPastebin(String id2, String name, int lines, Date date, String body, boolean own_paste) {
            Pastebin p = new Pastebin();
            p.id = id2;
            p.name = name;
            p.lines = lines;
            p.date = date;
            p.body = body;
            p.own_paste = own_paste;
            try {
                p.url = PastebinsActivity.this.uri_template.toString(VariableMap.newBuilder().addScalarValue("id", p.id).addScalarValue("name", p.name).freeze());
            }
            catch (URITemplateException e) {
                e.printStackTrace();
            }
            this.addPastebin(p);
        }

        public void addPastebin(Pastebin p) {
            this.pastebins.add(p);
        }

        public int getCount() {
            return this.pastebins.size();
        }

        public Object getItem(int i) {
            return this.pastebins.get(i);
        }

        public long getItemId(int i) {
            return i;
        }

        public View getView(int i, View view, ViewGroup viewGroup) {
            ViewHolder holder;
            View row = view;
            if (row == null) {
                LayoutInflater inflater = PastebinsActivity.this.getLayoutInflater();
                row = inflater.inflate(2130903122, viewGroup, false);
                holder = new ViewHolder();
                holder.date = (TextView)row.findViewById(2131624194);
                holder.body = (TextView)row.findViewById(2131624201);
                holder.delete = (ImageButton)row.findViewById(2131624195);
                row.setTag((Object)holder);
            } else {
                holder = (ViewHolder)row.getTag();
            }
            try {
                Pastebin p = this.pastebins.get(i);
                if (p.date_formatted == null) {
                    p.date_formatted = "";
                    if (p.name != null && p.name.length() > 0) {
                        p.date_formatted = p.date_formatted + p.name + " \u2022 ";
                    }
                    p.date_formatted = p.date_formatted + p.lines + " line";
                    if (p.lines != 1) {
                        p.date_formatted = p.date_formatted + "s";
                    }
                    p.date_formatted = p.date_formatted + " \u2022 " + DateUtils.getRelativeTimeSpanString((long)p.date.getTime(), (long)System.currentTimeMillis(), (long)1000L, (int)0).toString();
                }
                holder.date.setText((CharSequence)p.date_formatted);
                holder.body.setText((CharSequence)p.body);
                holder.delete.setOnClickListener(this.deleteClickListener);
                holder.delete.setTag((Object)i);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return row;
        }

        private class ViewHolder {
            TextView date;
            TextView body;
            ImageButton delete;

            private ViewHolder() {
            }
        }
    }

    private static class Pastebin
    implements Serializable {
        private static final long serialVersionUID = 0L;
        String id;
        String name;
        String url;
        int lines;
        Date date;
        String date_formatted;
        String body;
        boolean own_paste;

        private Pastebin() {
        }
    }
}

