/*
 * Decompiled with CFR 0.152.
 */
package com.irccloud.android.activity;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.preference.CheckBoxPreference;
import android.preference.EditTextPreference;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceCategory;
import android.preference.PreferenceManager;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatCallback;
import android.support.v7.app.AppCompatDelegate;
import android.support.v7.view.ActionMode;
import android.support.v7.widget.Toolbar;
import android.util.Log;
import android.view.MenuItem;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;
import com.cgollner.unclouded.preferences.SwitchPreferenceCompat;
import com.crashlytics.android.Crashlytics;
import com.irccloud.android.AsyncTaskEx;
import com.irccloud.android.BuildConfig;
import com.irccloud.android.IRCCloudJSONObject;
import com.irccloud.android.NetworkConnection;
import com.irccloud.android.Notifications;
import com.irccloud.android.activity.ImgurAuthActivity;
import com.irccloud.android.data.EventsDataSource;
import com.irccloud.android.data.ServersDataSource;
import com.sonyericsson.extras.liveware.extension.util.notification.NotificationUtil;
import org.json.JSONException;
import org.json.JSONObject;

public class PreferencesActivity
extends PreferenceActivity
implements AppCompatCallback,
NetworkConnection.IRCEventHandler {
    NetworkConnection conn;
    SaveSettingsTask saveSettingsTask = null;
    SavePreferencesTask savePreferencesTask = null;
    int save_prefs_reqid = -1;
    int save_settings_reqid = -1;
    private AppCompatDelegate appCompatDelegate;
    Preference.OnPreferenceChangeListener settingstoggle = new Preference.OnPreferenceChangeListener(){

        public boolean onPreferenceChange(Preference preference, Object newValue) {
            if (PreferencesActivity.this.conn == null || PreferencesActivity.this.conn.getUserInfo() == null) {
                Toast.makeText((Context)PreferencesActivity.this, (CharSequence)"An error occurred while saving settings.  Please try again shortly", (int)0).show();
                return false;
            }
            if (preference.getKey().equals("name")) {
                PreferencesActivity.this.conn.getUserInfo().name = (String)newValue;
                PreferencesActivity.this.findPreference("name").setSummary((CharSequence)((String)newValue));
            } else if (preference.getKey().equals("email")) {
                PreferencesActivity.this.conn.getUserInfo().email = (String)newValue;
                PreferencesActivity.this.findPreference("email").setSummary((CharSequence)((String)newValue));
            } else if (preference.getKey().equals("highlights")) {
                PreferencesActivity.this.conn.getUserInfo().highlights = (String)newValue;
                PreferencesActivity.this.findPreference("highlights").setSummary((CharSequence)((String)newValue));
            } else if (preference.getKey().equals("autoaway")) {
                PreferencesActivity.this.conn.getUserInfo().auto_away = (Boolean)newValue;
            }
            if (PreferencesActivity.this.saveSettingsTask != null) {
                PreferencesActivity.this.saveSettingsTask.cancel(true);
            }
            PreferencesActivity.this.saveSettingsTask = new SaveSettingsTask();
            PreferencesActivity.this.saveSettingsTask.execute(new Void[]{null});
            return true;
        }
    };
    Preference.OnPreferenceChangeListener imageviewertoggle = new Preference.OnPreferenceChangeListener(){

        public boolean onPreferenceChange(Preference preference, Object newValue) {
            EventsDataSource.getInstance().clearCaches();
            return true;
        }
    };
    Preference.OnPreferenceChangeListener dashclocktoggle = new Preference.OnPreferenceChangeListener(){

        public boolean onPreferenceChange(Preference preference, Object newValue) {
            PreferencesActivity.this.sendBroadcast(new Intent("com.irccloud.android.dashclock.REFRESH"));
            return true;
        }
    };
    Preference.OnPreferenceChangeListener sonytoggle = new Preference.OnPreferenceChangeListener(){

        public boolean onPreferenceChange(Preference preference, Object newValue) {
            if (!((Boolean)newValue).booleanValue()) {
                NotificationUtil.deleteAllEvents((Context)PreferencesActivity.this);
            }
            return true;
        }
    };
    Preference.OnPreferenceChangeListener prefstoggle = new Preference.OnPreferenceChangeListener(){

        public boolean onPreferenceChange(Preference preference, Object newValue) {
            if (PreferencesActivity.this.conn == null || PreferencesActivity.this.conn.getUserInfo() == null) {
                Toast.makeText((Context)PreferencesActivity.this, (CharSequence)"An error occurred while saving settings.  Please try again shortly", (int)0).show();
                return false;
            }
            JSONObject prefs = PreferencesActivity.this.conn.getUserInfo().prefs;
            try {
                if (prefs == null) {
                    PreferencesActivity.this.conn.getUserInfo().prefs = prefs = new JSONObject();
                    Crashlytics.logException(new Exception("Users prefs was null, creating new object"));
                }
                if (preference.getKey().equals("emoji-disableconvert") || preference.getKey().equals("pastebin-disableprompt")) {
                    prefs.put(preference.getKey(), (Boolean)newValue == false);
                } else {
                    prefs.put(preference.getKey(), (Object)((Boolean)newValue));
                }
                if (PreferencesActivity.this.savePreferencesTask != null) {
                    PreferencesActivity.this.savePreferencesTask.cancel(true);
                }
                PreferencesActivity.this.savePreferencesTask = new SavePreferencesTask();
                PreferencesActivity.this.savePreferencesTask.execute(new Void[]{null});
            }
            catch (JSONException e) {
                Crashlytics.log(6, "IRCCloud", "Unable to set preference: " + preference.getKey());
                Crashlytics.logException(e);
                Toast.makeText((Context)PreferencesActivity.this, (CharSequence)"An error occurred while saving settings.  Please try again shortly", (int)0).show();
                return false;
            }
            return true;
        }
    };
    Preference.OnPreferenceChangeListener notificationstoggle = new Preference.OnPreferenceChangeListener(){

        public boolean onPreferenceChange(Preference preference, Object newValue) {
            switch (Integer.parseInt((String)newValue)) {
                case 0: {
                    PreferencesActivity.this.findPreference("notify_type").setSummary((CharSequence)"Disabled");
                    break;
                }
                case 1: {
                    PreferencesActivity.this.findPreference("notify_type").setSummary((CharSequence)"Enabled");
                    break;
                }
                case 2: {
                    PreferencesActivity.this.findPreference("notify_type").setSummary((CharSequence)"Only while active");
                }
            }
            if (Integer.parseInt((String)newValue) > 0) {
                PreferencesActivity.this.findPreference("notify_vibrate").setEnabled(true);
                PreferencesActivity.this.findPreference("notify_ringtone").setEnabled(true);
                PreferencesActivity.this.findPreference("notify_led_color").setEnabled(true);
            } else {
                PreferencesActivity.this.findPreference("notify_vibrate").setEnabled(false);
                PreferencesActivity.this.findPreference("notify_ringtone").setEnabled(false);
                PreferencesActivity.this.findPreference("notify_led_color").setEnabled(false);
                Notifications.getInstance().clear();
            }
            return true;
        }
    };
    Preference.OnPreferenceChangeListener ledtoggle = new Preference.OnPreferenceChangeListener(){

        public boolean onPreferenceChange(Preference preference, Object newValue) {
            switch (Integer.parseInt((String)newValue)) {
                case 0: {
                    PreferencesActivity.this.findPreference("notify_led_color").setSummary((CharSequence)"Disabled");
                    break;
                }
                case 1: {
                    PreferencesActivity.this.findPreference("notify_led_color").setSummary((CharSequence)"Default Color");
                    break;
                }
                case 2: {
                    PreferencesActivity.this.findPreference("notify_led_color").setSummary((CharSequence)"Blue");
                }
            }
            return true;
        }
    };
    Preference.OnPreferenceChangeListener photosizetoggle = new Preference.OnPreferenceChangeListener(){

        public boolean onPreferenceChange(Preference preference, Object newValue) {
            switch (Integer.parseInt((String)newValue)) {
                case 512: {
                    PreferencesActivity.this.findPreference("photo_size").setSummary((CharSequence)"Small");
                    break;
                }
                case 1024: {
                    PreferencesActivity.this.findPreference("photo_size").setSummary((CharSequence)"Medium");
                    break;
                }
                case 2048: {
                    PreferencesActivity.this.findPreference("photo_size").setSummary((CharSequence)"Large");
                    break;
                }
                case -1: {
                    PreferencesActivity.this.findPreference("photo_size").setSummary((CharSequence)"Original");
                }
            }
            return true;
        }
    };
    private Preference imgurPreference;
    Preference.OnPreferenceChangeListener imageservicetoggle = new Preference.OnPreferenceChangeListener(){

        public boolean onPreferenceChange(Preference preference, Object newValue) {
            if (newValue.equals("imgur")) {
                PreferenceCategory c = (PreferenceCategory)PreferencesActivity.this.findPreference("photos");
                c.addPreference(PreferencesActivity.this.imgurPreference);
            } else {
                PreferenceCategory c = (PreferenceCategory)PreferencesActivity.this.findPreference("photos");
                c.removePreference(PreferencesActivity.this.imgurPreference);
            }
            PreferencesActivity.this.findPreference("image_service").setSummary((CharSequence)((String)newValue));
            return true;
        }
    };
    Preference.OnPreferenceClickListener imgurClick = new Preference.OnPreferenceClickListener(){

        public boolean onPreferenceClick(Preference preference) {
            SharedPreferences.Editor editor = PreferencesActivity.this.getSharedPreferences("prefs", 0).edit();
            editor.remove("imgur_account_username");
            editor.remove("imgur_access_token");
            editor.remove("imgur_refresh_token");
            editor.remove("imgur_token_type");
            editor.remove("imgur_expires_in");
            editor.commit();
            PreferencesActivity.this.startActivity(new Intent((Context)PreferencesActivity.this, ImgurAuthActivity.class));
            return false;
        }
    };
    Preference.OnPreferenceClickListener licensesClick = new Preference.OnPreferenceClickListener(){

        public boolean onPreferenceClick(Preference preference) {
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)PreferencesActivity.this);
            View v = PreferencesActivity.this.getLayoutInflater().inflate(2130903088, null);
            TextView tv = (TextView)v.findViewById(2131624112);
            tv.setText((CharSequence)"IRCCloud\nCopyright (C) 2013 IRCCloud, Ltd.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\nhttp://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\nYou should have received a copy of the GNU General Public License\nalong with this program.  If not, see &lt;http://www.gnu.org/licenses/&gt;.\n\n\nHybiParser.java: draft-ietf-hybi-thewebsocketprotocol-13 parser\n\nBased on code from the faye project.\nhttps://github.com/faye/faye-websocket-node\nCopyright (c) 2009-2012 James Coglan\n\nPorted from Javascript to Java by Eric Butler <eric@codebutler.com>\n\n(The MIT License)\n\nPermission is hereby granted, free of charge, to any person obtaining\na copy of this software and associated documentation files (the\n\"Software\"), to deal in the Software without restriction, including\nwithout limitation the rights to use, copy, modify, merge, publish,\ndistribute, sublicense, and/or sell copies of the Software, and to\npermit persons to whom the Software is furnished to do so, subject to\nthe following conditions:\n\nThe above copyright notice and this permission notice shall be\nincluded in all copies or substantial portions of the Software.\n\nTHE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND,\nEXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF\nMERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND\nNONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE\nLIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION\nOF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION\nWITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.\n\n\nSony LiveWare library\nCopyright (c) 2011, Sony Ericsson Mobile Communications AB\nCopyright (C) 2012-2013 Sony Mobile Communications AB\n\nAll rights reserved.\n\nRedistribution and use in source and binary forms, with or without\nmodification, are permitted provided that the following conditions are met:\n\n* Redistributions of source code must retain the above copyright notice, this\n  list of conditions and the following disclaimer.\n\n* Redistributions in binary form must reproduce the above copyright notice,\n  this list of conditions and the following disclaimer in the documentation\n  and/or other materials provided with the distribution.\n\n* Neither the name of the Sony Ericsson Mobile Communications AB nor the names\n  of its contributors may be used to endorse or promote products derived from\n  this software without specific prior written permission.\n\nTHIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS \"AS IS\" AND\nANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED\nWARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE\nDISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE\nFOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL\nDAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR\nSERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER\nCAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,\nOR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\nOF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n\n\nAsyncTaskEx\nCopyright (c) 2008-2009 CommonsWare, LLC\nPortions (c) 2009 Google, Inc.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may\nnot use this file except in compliance with the License. You may obtain\na copy of the License at\nhttp://www.apache.org/licenses/LICENSE-2.0\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\nA subclass of the Android ListView component that enables drag\nand drop re-ordering of list items.\n\n\nDragSortListView\nCopyright 2012 Carl Bauer\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\nhttp://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\nJackson JSON Parser by FasterXML\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\nhttp://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\nSeekBarPreference by RoboBunny\n\nSwitchPreferenceCompat by Christian Gollner\n\nThe MIT License (MIT)\n\nCopyright (c) 2014 Andrew Chen\n\nPermission is hereby granted, free of charge, to any person obtaining a copy\nof this software and associated documentation files (the \"Software\"), to deal\nin the Software without restriction, including without limitation the rights\nto use, copy, modify, merge, publish, distribute, sublicense, and/or sell\ncopies of the Software, and to permit persons to whom the Software is\nfurnished to do so, subject to the following conditions:\n\nThe above copyright notice and this permission notice shall be included in all\ncopies or substantial portions of the Software.\n\nTHE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\nIMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\nFITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\nAUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\nLIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,\nOUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE\nSOFTWARE.\n\nFGE uri-template\nThis software is dual-licensed under:\n\n- the Lesser General Public License (LGPL) version 3.0 or, at your option, any\n  later version;\n- the Apache Software License (ASL) version 2.0.\n\nThe text of both licenses is included (under the names LGPL-3.0.txt and\nASL-2.0.txt respectively).\n\nDirect link to the sources:\n\n- LGPL 3.0: https://www.gnu.org/licenses/lgpl-3.0.txt\n- ASL 2.0: http://www.apache.org/licenses/LICENSE-2.0.txt");
            builder.setView(v);
            builder.setInverseBackgroundForced(Build.VERSION.SDK_INT < 11);
            builder.setNegativeButton("Close", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                }
            });
            AlertDialog d = builder.create();
            d.setOwnerActivity((Activity)PreferencesActivity.this);
            d.show();
            return false;
        }
    };
    Preference.OnPreferenceClickListener urlClick = new Preference.OnPreferenceClickListener(){

        public boolean onPreferenceClick(Preference preference) {
            Intent i = null;
            if (preference.getKey().equals("faq")) {
                i = new Intent("android.intent.action.VIEW", Uri.parse((String)"https://www.irccloud.com/faq"));
            }
            if (preference.getKey().equals("feedback")) {
                ServersDataSource.Server s = ServersDataSource.getInstance().getServer("irc.irccloud.com");
                i = s != null && s.ssl > 0 ? new Intent("android.intent.action.VIEW", Uri.parse((String)"ircs://irc.irccloud.com/%23feedback")) : new Intent("android.intent.action.VIEW", Uri.parse((String)"irc://irc.irccloud.com/%23feedback"));
            }
            if (preference.getKey().equals("subscriptions")) {
                i = new Intent("android.intent.action.VIEW", Uri.parse((String)"https://www.irccloud.com/#?/upgrade"));
            }
            if (preference.getKey().equals("changes")) {
                i = new Intent("android.intent.action.VIEW", Uri.parse((String)"https://www.irccloud.com/android-changelog.txt"));
            }
            if (i != null) {
                PreferencesActivity.this.startActivity(i);
            }
            return false;
        }
    };

    private AppCompatDelegate getDelegate() {
        if (this.appCompatDelegate == null) {
            this.appCompatDelegate = AppCompatDelegate.create((Activity)this, (AppCompatCallback)this);
        }
        return this.appCompatDelegate;
    }

    public void onStop() {
        super.onStop();
        this.getDelegate().onStop();
    }

    public void onDestroy() {
        super.onDestroy();
        this.getDelegate().onDestroy();
    }

    public void onCreate(Bundle icicle) {
        PreferenceCategory c;
        this.requestWindowFeature(7);
        super.onCreate(icicle);
        this.getDelegate().installViewFactory();
        this.getDelegate().onCreate(icicle);
        if (Build.VERSION.SDK_INT >= 21) {
            Bitmap cloud = BitmapFactory.decodeResource((Resources)this.getResources(), (int)2130837620);
            this.setTaskDescription(new ActivityManager.TaskDescription(this.getResources().getString(2131165254), cloud, -854020));
            cloud.recycle();
        }
        this.getWindow().setFeatureInt(7, 2130903072);
        Toolbar toolbar = (Toolbar)this.findViewById(2131624034);
        toolbar.setTitle(this.getTitle());
        toolbar.setNavigationIcon(2130837526);
        toolbar.setNavigationOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PreferencesActivity.this.finish();
            }
        });
        toolbar.setBackgroundDrawable(this.getResources().getDrawable(2130837566));
        if (Build.VERSION.SDK_INT >= 21) {
            toolbar.setElevation(0.0f);
        }
        this.conn = NetworkConnection.getInstance();
        this.addPreferencesFromResource(2131034114);
        this.addPreferencesFromResource(2131034118);
        this.addPreferencesFromResource(2131034117);
        this.addPreferencesFromResource(2131034121);
        this.addPreferencesFromResource(2131034119);
        this.addPreferencesFromResource(2131034115);
        this.findPreference("dashclock_showmsgs").setOnPreferenceChangeListener(this.dashclocktoggle);
        try {
            int pebbleVersion = this.getPackageManager().getPackageInfo((String)"com.getpebble.android", (int)0).versionCode;
            if (pebbleVersion < 553) {
                this.addPreferencesFromResource(2131034120);
            }
        }
        catch (Exception pebbleVersion) {
            // empty catch block
        }
        boolean foundSony = false;
        try {
            this.getPackageManager().getPackageInfo("com.sonyericsson.extras.liveware", 0);
            this.addPreferencesFromResource(2131034122);
            foundSony = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!foundSony) {
            try {
                this.getPackageManager().getPackageInfo("com.sonyericsson.extras.smartwatch", 0);
                this.addPreferencesFromResource(2131034122);
                foundSony = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!foundSony) {
            try {
                this.getPackageManager().getPackageInfo("com.sonyericsson.extras.liveview", 0);
                this.addPreferencesFromResource(2131034122);
                foundSony = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (foundSony) {
            this.findPreference("notify_sony").setOnPreferenceChangeListener(this.sonytoggle);
        }
        if (BuildConfig.DEBUG) {
            this.addPreferencesFromResource(2131034116);
        }
        this.addPreferencesFromResource(2131034113);
        this.findPreference("name").setOnPreferenceChangeListener(this.settingstoggle);
        this.findPreference("autoaway").setOnPreferenceChangeListener(this.settingstoggle);
        this.findPreference("time-24hr").setOnPreferenceChangeListener(this.prefstoggle);
        this.findPreference("time-seconds").setOnPreferenceChangeListener(this.prefstoggle);
        this.findPreference("mode-showsymbol").setOnPreferenceChangeListener(this.prefstoggle);
        this.findPreference("pastebin-disableprompt").setOnPreferenceChangeListener(this.prefstoggle);
        if (this.findPreference("emoji-disableconvert") != null) {
            this.findPreference("emoji-disableconvert").setOnPreferenceChangeListener(this.prefstoggle);
            this.findPreference("emoji-disableconvert").setSummary((CharSequence)":thumbsup: \u2192 \ud83d\udc4d");
        }
        this.findPreference("nick-colors").setOnPreferenceChangeListener(this.prefstoggle);
        this.findPreference("faq").setOnPreferenceClickListener(this.urlClick);
        this.findPreference("feedback").setOnPreferenceClickListener(this.urlClick);
        this.findPreference("licenses").setOnPreferenceClickListener(this.licensesClick);
        this.findPreference("imageviewer").setOnPreferenceChangeListener(this.imageviewertoggle);
        this.findPreference("imgur_account_username").setOnPreferenceClickListener(this.imgurClick);
        this.findPreference("notify_type").setOnPreferenceChangeListener(this.notificationstoggle);
        this.findPreference("notify_led_color").setOnPreferenceChangeListener(this.ledtoggle);
        this.findPreference("photo_size").setOnPreferenceChangeListener(this.photosizetoggle);
        this.imgurPreference = this.findPreference("imgur_account_username");
        if (NetworkConnection.getInstance().uploadsAvailable()) {
            if (!PreferenceManager.getDefaultSharedPreferences((Context)this).getString("image_service", "IRCCloud").equals("imgur")) {
                c = (PreferenceCategory)this.findPreference("photos");
                c.removePreference(this.imgurPreference);
            }
            this.findPreference("image_service").setOnPreferenceChangeListener(this.imageservicetoggle);
        } else {
            c = (PreferenceCategory)this.findPreference("photos");
            c.removePreference(this.findPreference("image_service"));
        }
        try {
            final String version = this.getPackageManager().getPackageInfo((String)this.getPackageName(), (int)0).versionName;
            this.findPreference("version").setSummary((CharSequence)version);
            this.findPreference("version").setOnPreferenceClickListener(new Preference.OnPreferenceClickListener(){

                public boolean onPreferenceClick(Preference preference) {
                    if (Build.VERSION.SDK_INT < 11) {
                        android.text.ClipboardManager clipboard = (android.text.ClipboardManager)PreferencesActivity.this.getSystemService("clipboard");
                        clipboard.setText((CharSequence)version);
                    } else {
                        ClipboardManager clipboard = (ClipboardManager)PreferencesActivity.this.getSystemService("clipboard");
                        ClipData clip = ClipData.newPlainText((CharSequence)"IRCCloud Version", (CharSequence)version);
                        clipboard.setPrimaryClip(clip);
                    }
                    Toast.makeText((Context)PreferencesActivity.this, (CharSequence)"Version number copied to clipboard", (int)0).show();
                    return false;
                }
            });
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.finish();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    public void onResume() {
        super.onResume();
        String session = this.getSharedPreferences("prefs", 0).getString("session_key", "");
        if (session != null && session.length() > 0) {
            this.conn = NetworkConnection.getInstance();
            this.conn.addHandler(this);
            this.overridePendingTransition(2130968588, 2130968587);
            if (this.conn.getUserInfo() != null) {
                this.findPreference("name").setSummary((CharSequence)this.conn.getUserInfo().name);
            } else {
                this.findPreference("name").setSummary((CharSequence)((EditTextPreference)this.findPreference("name")).getText());
            }
            this.findPreference("email").setOnPreferenceChangeListener(this.settingstoggle);
            if (this.conn.getUserInfo() != null) {
                this.findPreference("email").setSummary((CharSequence)this.conn.getUserInfo().email);
            } else {
                this.findPreference("email").setSummary((CharSequence)((EditTextPreference)this.findPreference("email")).getText());
            }
            this.findPreference("highlights").setOnPreferenceChangeListener(this.settingstoggle);
            if (this.conn.getUserInfo() != null) {
                this.findPreference("highlights").setSummary((CharSequence)this.conn.getUserInfo().highlights);
            } else {
                this.findPreference("highlights").setSummary((CharSequence)((EditTextPreference)this.findPreference("highlights")).getText());
            }
            switch (Integer.parseInt(PreferenceManager.getDefaultSharedPreferences((Context)this).getString("notify_type", "1"))) {
                case 0: {
                    this.findPreference("notify_type").setSummary((CharSequence)"Disabled");
                    break;
                }
                case 1: {
                    this.findPreference("notify_type").setSummary((CharSequence)"Enabled");
                    break;
                }
                case 2: {
                    this.findPreference("notify_type").setSummary((CharSequence)"Only while active");
                }
            }
            switch (Integer.parseInt(PreferenceManager.getDefaultSharedPreferences((Context)this).getString("notify_led_color", "1"))) {
                case 0: {
                    this.findPreference("notify_led_color").setSummary((CharSequence)"Disabled");
                    break;
                }
                case 1: {
                    this.findPreference("notify_led_color").setSummary((CharSequence)"Default Color");
                    break;
                }
                case 2: {
                    this.findPreference("notify_led_color").setSummary((CharSequence)"Blue");
                }
            }
            switch (Integer.parseInt(PreferenceManager.getDefaultSharedPreferences((Context)this).getString("photo_size", "1024"))) {
                case 512: {
                    this.findPreference("photo_size").setSummary((CharSequence)"Small");
                    break;
                }
                case 1024: {
                    this.findPreference("photo_size").setSummary((CharSequence)"Medium");
                    break;
                }
                case 2048: {
                    this.findPreference("photo_size").setSummary((CharSequence)"Large");
                    break;
                }
                case -1: {
                    this.findPreference("photo_size").setSummary((CharSequence)"Original");
                }
            }
            if (Integer.parseInt(PreferenceManager.getDefaultSharedPreferences((Context)this).getString("notify_type", "1")) > 0) {
                this.findPreference("notify_vibrate").setEnabled(true);
                this.findPreference("notify_ringtone").setEnabled(true);
                this.findPreference("notify_led_color").setEnabled(true);
            } else {
                this.findPreference("notify_vibrate").setEnabled(false);
                this.findPreference("notify_ringtone").setEnabled(false);
                this.findPreference("notify_led_color").setEnabled(false);
            }
            if (this.findPreference("imgur_account_username") != null) {
                this.findPreference("imgur_account_username").setSummary((CharSequence)this.getSharedPreferences("prefs", 0).getString("imgur_account_username", null));
            }
            if (this.findPreference("image_service") != null) {
                this.findPreference("image_service").setSummary((CharSequence)PreferenceManager.getDefaultSharedPreferences((Context)this).getString("image_service", "IRCCloud"));
            }
        } else {
            Toast.makeText((Context)this, (CharSequence)"You must login to the IRCCloud app first", (int)0).show();
            this.finish();
        }
    }

    public void onPause() {
        super.onPause();
        if (this.conn != null) {
            this.conn.removeHandler(this);
        }
        this.overridePendingTransition(2130968586, 2130968589);
    }

    @Override
    public void onIRCEvent(int what, Object obj) {
        switch (what) {
            case 104: {
                IRCCloudJSONObject o = (IRCCloudJSONObject)obj;
                if (!o.has("_reqid")) break;
                if (o.getInt("_reqid") == this.save_settings_reqid) {
                    this.save_settings_reqid = -1;
                    break;
                }
                if (o.getInt("_reqid") != this.save_prefs_reqid) break;
                this.save_prefs_reqid = -1;
                break;
            }
            case 103: {
                IRCCloudJSONObject o = (IRCCloudJSONObject)obj;
                if (!o.has("_reqid")) break;
                if (o.getInt("_reqid") == this.save_settings_reqid) {
                    this.save_settings_reqid = -1;
                    Log.e((String)"IRCCloud", (String)("Settings not updated: " + o.getString("message")));
                } else if (o.getInt("_reqid") == this.save_prefs_reqid) {
                    this.save_prefs_reqid = -1;
                    Log.e((String)"IRCCloud", (String)("Prefs not updated: " + o.getString("message")));
                }
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        Toast.makeText((Context)PreferencesActivity.this, (CharSequence)"An error occurred while saving settings.  Please try again.", (int)0).show();
                    }
                });
                break;
            }
            case 1: {
                final NetworkConnection.UserInfo userInfo = this.conn.getUserInfo();
                if (userInfo == null) break;
                final JSONObject prefs = userInfo.prefs;
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        ((EditTextPreference)PreferencesActivity.this.findPreference("name")).setText(userInfo.name);
                        PreferencesActivity.this.findPreference("name").setSummary((CharSequence)userInfo.name);
                        ((EditTextPreference)PreferencesActivity.this.findPreference("email")).setText(userInfo.email);
                        PreferencesActivity.this.findPreference("email").setSummary((CharSequence)userInfo.email);
                        ((EditTextPreference)PreferencesActivity.this.findPreference("highlights")).setText(userInfo.highlights);
                        PreferencesActivity.this.findPreference("highlights").setSummary((CharSequence)userInfo.highlights);
                        ((CheckBoxPreference)PreferencesActivity.this.findPreference("autoaway")).setChecked(userInfo.auto_away);
                        if (prefs != null) {
                            try {
                                ((SwitchPreferenceCompat)PreferencesActivity.this.findPreference("time-24hr")).setChecked(prefs.has("time-24hr") && prefs.get("time-24hr").getClass().equals(Boolean.class) && prefs.getBoolean("time-24hr"));
                                ((SwitchPreferenceCompat)PreferencesActivity.this.findPreference("time-seconds")).setChecked(prefs.has("time-seconds") && prefs.get("time-seconds").getClass().equals(Boolean.class) && prefs.getBoolean("time-seconds"));
                                ((SwitchPreferenceCompat)PreferencesActivity.this.findPreference("mode-showsymbol")).setChecked(prefs.has("mode-showsymbol") && prefs.get("mode-showsymbol").getClass().equals(Boolean.class) && prefs.getBoolean("mode-showsymbol"));
                                ((SwitchPreferenceCompat)PreferencesActivity.this.findPreference("pastebin-disableprompt")).setChecked(!prefs.has("pastebin-disableprompt") || !prefs.get("pastebin-disableprompt").getClass().equals(Boolean.class) || !prefs.getBoolean("pastebin-disableprompt"));
                                if (PreferencesActivity.this.findPreference("emoji-disableconvert") != null) {
                                    ((SwitchPreferenceCompat)PreferencesActivity.this.findPreference("emoji-disableconvert")).setChecked(!prefs.has("emoji-disableconvert") || !prefs.get("emoji-disableconvert").getClass().equals(Boolean.class) || !prefs.getBoolean("emoji-disableconvert"));
                                }
                            }
                            catch (JSONException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                });
            }
        }
    }

    @Override
    public void onSupportActionModeStarted(ActionMode mode) {
    }

    @Override
    public void onSupportActionModeFinished(ActionMode mode) {
    }

    @Override
    public ActionMode onWindowStartingSupportActionMode(ActionMode.Callback callback) {
        return null;
    }

    private class SaveSettingsTask
    extends AsyncTaskEx<Void, Void, Void> {
        private SaveSettingsTask() {
        }

        protected Void doInBackground(Void ... params) {
            NetworkConnection.UserInfo userInfo;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.isCancelled() && (userInfo = PreferencesActivity.this.conn.getUserInfo()) != null) {
                PreferencesActivity.this.save_settings_reqid = PreferencesActivity.this.conn.set_user_settings(userInfo.email, userInfo.name, userInfo.highlights, userInfo.auto_away);
            }
            return null;
        }

        @Override
        protected void onPostExecute(Void result) {
            PreferencesActivity.this.saveSettingsTask = null;
        }
    }

    private class SavePreferencesTask
    extends AsyncTaskEx<Void, Void, Void> {
        private SavePreferencesTask() {
        }

        protected Void doInBackground(Void ... params) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            PreferencesActivity.this.save_prefs_reqid = !this.isCancelled() && PreferencesActivity.this.conn.getUserInfo() != null && PreferencesActivity.this.conn.getUserInfo().prefs != null ? PreferencesActivity.this.conn.set_prefs(PreferencesActivity.this.conn.getUserInfo().prefs.toString()) : -1;
            EventsDataSource.getInstance().clearCaches();
            return null;
        }

        @Override
        protected void onPostExecute(Void result) {
            PreferencesActivity.this.savePreferencesTask = null;
        }
    }
}

