/*
 * Decompiled with CFR 0.152.
 */
package com.irccloud.android.activity;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.support.v4.app.NotificationManagerCompat;
import android.support.v7.app.AppCompatActivity;
import android.text.method.LinkMovementMethod;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.irccloud.android.CollapsedEventsList;
import com.irccloud.android.ColorFormatter;
import com.irccloud.android.IRCCloudApplication;
import com.irccloud.android.Notifications;
import com.irccloud.android.RemoteInputService;
import com.irccloud.android.data.ServersDataSource;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class QuickReplyActivity
extends AppCompatActivity {
    int cid;
    int bid;
    String to;
    SimpleDateFormat formatter = new SimpleDateFormat("h:mm a");
    CollapsedEventsList collapsedEventsList = new CollapsedEventsList();
    boolean nickColors;
    ServersDataSource.Server server;
    int timestamp_width = -1;
    private MessagesAdapter adapter = new MessagesAdapter();
    private SharedPreferences.OnSharedPreferenceChangeListener prefslistener = new SharedPreferences.OnSharedPreferenceChangeListener(){

        public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String s) {
            QuickReplyActivity.this.adapter.loadMessages(QuickReplyActivity.this.cid, QuickReplyActivity.this.bid);
        }
    };

    @Override
    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        this.cid = intent.getIntExtra("cid", -1);
        this.bid = intent.getIntExtra("bid", -1);
        this.to = intent.getStringExtra("to");
        this.server = new ServersDataSource.Server();
        this.server.cid = this.cid;
        this.setTitle("Reply to " + this.to + " (" + intent.getStringExtra("network") + ")");
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2130903078);
        if (!this.getIntent().hasExtra("cid") || !this.getIntent().hasExtra("bid")) {
            this.finish();
            return;
        }
        this.onNewIntent(this.getIntent());
        final ImageButton send = (ImageButton)this.findViewById(2131624074);
        final EditText message = (EditText)this.findViewById(2131624073);
        message.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView textView, int actionId, KeyEvent keyEvent) {
                if (actionId == 4 && message.getText() != null && message.getText().length() > 0) {
                    send.performClick();
                }
                return true;
            }
        });
        message.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View view, int keyCode, KeyEvent event) {
                if (event.getAction() == 0 && keyCode == 66 && message.getText() != null && message.getText().length() > 0) {
                    send.performClick();
                }
                return false;
            }
        });
        send.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (message.getText() != null && message.getText().length() > 0) {
                    Intent i = new Intent(RemoteInputService.ACTION_REPLY);
                    i.setComponent(new ComponentName(QuickReplyActivity.this.getPackageName(), RemoteInputService.class.getName()));
                    i.putExtras(QuickReplyActivity.this.getIntent());
                    i.putExtra("reply", message.getText().toString());
                    QuickReplyActivity.this.startService(i);
                    QuickReplyActivity.this.finish();
                }
            }
        });
        ListView listView = (ListView)this.findViewById(2131624078);
        listView.setAdapter((ListAdapter)this.adapter);
    }

    @Override
    protected void onResume() {
        super.onResume();
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)IRCCloudApplication.getInstance().getApplicationContext());
        prefs.registerOnSharedPreferenceChangeListener(this.prefslistener);
        this.nickColors = prefs.getBoolean("nick-colors", false);
        if (prefs.getBoolean("time-24hr", false)) {
            this.formatter = prefs.getBoolean("time-seconds", false) ? new SimpleDateFormat("H:mm:ss") : new SimpleDateFormat("H:mm");
        } else if (prefs.getBoolean("time-seconds", false)) {
            this.formatter = new SimpleDateFormat("h:mm:ss a");
        }
        this.adapter.loadMessages(this.cid, this.bid);
        NotificationManagerCompat.from((Context)this).cancel(this.bid);
        Notifications.getInstance().excludeBid(this.bid);
    }

    @Override
    protected void onPause() {
        super.onPause();
        PreferenceManager.getDefaultSharedPreferences((Context)IRCCloudApplication.getInstance().getApplicationContext()).unregisterOnSharedPreferenceChangeListener(this.prefslistener);
        Notifications.getInstance().excludeBid(-1);
    }

    private class MessagesAdapter
    extends BaseAdapter {
        private JSONArray msgs = new JSONArray();

        private MessagesAdapter() {
        }

        public void loadMessages(int cid, int bid) {
            JSONArray notifications;
            try {
                notifications = new JSONArray(PreferenceManager.getDefaultSharedPreferences((Context)IRCCloudApplication.getInstance().getApplicationContext()).getString("notifications_json", "[]"));
            }
            catch (JSONException e) {
                notifications = new JSONArray();
            }
            this.msgs = new JSONArray();
            try {
                for (int i = 0; i < notifications.length(); ++i) {
                    JSONObject n = notifications.getJSONObject(i);
                    if (n.getInt("cid") != cid || n.getInt("bid") != bid) continue;
                    this.msgs.put((Object)n);
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            this.notifyDataSetChanged();
        }

        public int getCount() {
            return this.msgs.length();
        }

        public Object getItem(int i) {
            try {
                return this.msgs.get(i);
            }
            catch (JSONException e) {
                e.printStackTrace();
                return null;
            }
        }

        public long getItemId(int i) {
            return i;
        }

        public View getView(int i, View view, ViewGroup viewGroup) {
            ViewHolder holder;
            View row = view;
            if (row == null) {
                LayoutInflater inflater = QuickReplyActivity.this.getLayoutInflater();
                row = inflater.inflate(2130903121, viewGroup, false);
                holder = new ViewHolder();
                holder.timestamp = (TextView)row.findViewById(2131624198);
                holder.message = (TextView)row.findViewById(2131624116);
                row.setTag((Object)holder);
            } else {
                holder = (ViewHolder)row.getTag();
            }
            try {
                JSONObject msg = this.msgs.getJSONObject(i);
                if (QuickReplyActivity.this.getWindowManager().getDefaultDisplay().getWidth() < 800) {
                    holder.timestamp.setVisibility(8);
                } else {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTimeInMillis(msg.getLong("eid") / 1000L);
                    if (QuickReplyActivity.this.timestamp_width == -1) {
                        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)IRCCloudApplication.getInstance().getApplicationContext());
                        String s = "88:88 88";
                        if (prefs.getBoolean("time-24hr", false)) {
                            s = prefs.getBoolean("time-seconds", false) ? "88:88:88" : "88:88";
                        } else if (prefs.getBoolean("time-seconds", false)) {
                            s = "88:88:88 88";
                        }
                        QuickReplyActivity.this.timestamp_width = (int)holder.timestamp.getPaint().measureText(s);
                    }
                    holder.timestamp.setMinWidth(QuickReplyActivity.this.timestamp_width);
                    holder.timestamp.setText((CharSequence)QuickReplyActivity.this.formatter.format(calendar.getTime()));
                }
                holder.message.setText((CharSequence)ColorFormatter.html_to_spanned("<b>" + ColorFormatter.irc_to_html(QuickReplyActivity.this.collapsedEventsList.formatNick(msg.getString("nick"), null, QuickReplyActivity.this.nickColors)) + "</b> " + msg.getString("message"), true, QuickReplyActivity.this.server));
                holder.message.setMovementMethod(LinkMovementMethod.getInstance());
                holder.message.setLinkTextColor(QuickReplyActivity.this.getResources().getColor(2131492921));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            return row;
        }

        private class ViewHolder {
            TextView timestamp;
            TextView message;

            private ViewHolder() {
            }
        }
    }
}

