/*
 * Decompiled with CFR 0.152.
 */
package com.irccloud.android.activity;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Typeface;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import com.irccloud.android.IRCCloudJSONObject;
import com.irccloud.android.NetworkConnection;
import com.irccloud.android.activity.MainActivity;
import com.irccloud.android.data.BuffersDataSource;
import com.irccloud.android.fragment.BuffersListFragment;
import java.util.Timer;
import java.util.TimerTask;

public class ShareChooserActivity
extends FragmentActivity
implements NetworkConnection.IRCEventHandler,
BuffersListFragment.OnBufferSelectedListener {
    private TextView errorMsg = null;
    private TextView connectingMsg = null;
    private ProgressBar progressBar = null;
    private static Timer countdownTimer = null;
    private TimerTask countdownTimerTask = null;
    private String error = null;
    private View connecting = null;
    private View buffersList = null;
    private NetworkConnection conn = null;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        countdownTimer = new Timer("share-chooser-countdown-timer");
        if (Build.VERSION.SDK_INT >= 21) {
            Bitmap cloud = BitmapFactory.decodeResource((Resources)this.getResources(), (int)2130837620);
            this.setTaskDescription(new ActivityManager.TaskDescription(this.getResources().getString(2131165254), cloud, -854020));
            cloud.recycle();
        }
        this.getWindow().requestFeature(1);
        this.setContentView(2130903080);
        this.connecting = this.findViewById(2131624063);
        this.errorMsg = (TextView)this.findViewById(2131624066);
        this.connectingMsg = (TextView)this.findViewById(2131624064);
        this.progressBar = (ProgressBar)this.findViewById(2131624065);
        BuffersListFragment f = (BuffersListFragment)this.getSupportFragmentManager().findFragmentById(2131624075);
        f.readOnly = true;
        this.buffersList = f.getView();
        this.buffersList.setVisibility(8);
        Typeface LatoRegular = Typeface.createFromAsset((AssetManager)this.getAssets(), (String)"Lato-Regular.ttf");
        LinearLayout IRCCloud = (LinearLayout)this.findViewById(2131624042);
        for (int i = 0; i < IRCCloud.getChildCount(); ++i) {
            View v = IRCCloud.getChildAt(i);
            if (!(v instanceof TextView)) continue;
            ((TextView)v).setTypeface(LatoRegular);
        }
    }

    @Override
    protected void onResume() {
        super.onResume();
        String session = this.getSharedPreferences("prefs", 0).getString("session_key", "");
        if (session != null && session.length() > 0) {
            this.conn = NetworkConnection.getInstance();
            this.conn.addHandler(this);
            if (this.conn.getState() == 0 || this.conn.getState() == 3) {
                this.conn.connect(session);
            } else {
                this.connecting.setVisibility(8);
                this.buffersList.setVisibility(0);
            }
        } else {
            Toast.makeText((Context)this, (CharSequence)"You must login to the IRCCloud app before sharing", (int)0).show();
            this.finish();
        }
    }

    @Override
    protected void onPause() {
        super.onPause();
        if (this.conn != null) {
            this.conn.removeHandler(this);
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (countdownTimer != null) {
            countdownTimer.cancel();
            countdownTimer = null;
        }
    }

    private void updateReconnecting() {
        if (this.conn.getState() == 2) {
            this.connectingMsg.setText((CharSequence)"Loading");
        } else if (this.conn.getState() == 1 || this.conn.getReconnectTimestamp() > 0L) {
            this.progressBar.setIndeterminate(true);
            if (this.conn.getState() == 0 && this.conn.getReconnectTimestamp() > 0L) {
                String plural = "";
                int seconds = (int)((this.conn.getReconnectTimestamp() - System.currentTimeMillis()) / 1000L);
                if (seconds != 1) {
                    plural = "s";
                }
                if (seconds < 1) {
                    this.connectingMsg.setText((CharSequence)"Connecting");
                    this.errorMsg.setVisibility(8);
                } else {
                    this.connectingMsg.setText((CharSequence)("Reconnecting in " + seconds + " second" + plural));
                    if (this.error != null) {
                        this.errorMsg.setText((CharSequence)this.error);
                        this.errorMsg.setVisibility(0);
                    }
                }
                if (countdownTimer != null) {
                    if (this.countdownTimerTask != null) {
                        this.countdownTimerTask.cancel();
                    }
                    this.countdownTimerTask = new TimerTask(){

                        @Override
                        public void run() {
                            if (ShareChooserActivity.this.conn.getState() == 0) {
                                ShareChooserActivity.this.runOnUiThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        ShareChooserActivity.this.updateReconnecting();
                                    }
                                });
                            }
                        }
                    };
                    countdownTimer.schedule(this.countdownTimerTask, 1000L);
                }
            } else {
                this.connectingMsg.setText((CharSequence)"Connecting");
                this.error = null;
                this.errorMsg.setVisibility(8);
            }
        } else {
            this.connectingMsg.setText((CharSequence)"Offline");
            this.progressBar.setIndeterminate(false);
            this.progressBar.setProgress(0);
        }
    }

    @Override
    public void onIRCEvent(int what, final Object obj) {
        switch (what) {
            case 999: {
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        ShareChooserActivity.this.errorMsg.setVisibility(0);
                        ShareChooserActivity.this.errorMsg.setText((CharSequence)obj.toString());
                    }
                });
                break;
            }
            case 105: {
                final float progress = ((Float)obj).floatValue();
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if ((float)ShareChooserActivity.this.progressBar.getProgress() < progress) {
                            ShareChooserActivity.this.progressBar.setIndeterminate(false);
                            ShareChooserActivity.this.progressBar.setProgress((int)progress);
                        }
                    }
                });
                break;
            }
            case 100: {
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        ShareChooserActivity.this.progressBar.setProgress(0);
                    }
                });
                break;
            }
            case 101: {
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        ShareChooserActivity.this.connecting.setVisibility(8);
                        ShareChooserActivity.this.buffersList.setVisibility(0);
                    }
                });
                break;
            }
            case 0: {
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        ShareChooserActivity.this.updateReconnecting();
                    }
                });
                break;
            }
            case 103: {
                final IRCCloudJSONObject o = (IRCCloudJSONObject)obj;
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ShareChooserActivity.this.error = o.getString("message");
                            if (ShareChooserActivity.this.error.equals("auth")) {
                                ShareChooserActivity.this.conn.logout();
                                ShareChooserActivity.this.finish();
                                return;
                            }
                            if (ShareChooserActivity.this.error.equals("set_shard")) {
                                ShareChooserActivity.this.conn.disconnect();
                                ((ShareChooserActivity)ShareChooserActivity.this).conn.ready = false;
                                SharedPreferences.Editor editor = ShareChooserActivity.this.getSharedPreferences("prefs", 0).edit();
                                editor.putString("session_key", o.getString("cookie"));
                                ShareChooserActivity.this.conn.connect(o.getString("cookie"));
                                editor.commit();
                                return;
                            }
                            if (ShareChooserActivity.this.error.equals("temp_unavailable")) {
                                ShareChooserActivity.this.error = "Your account is temporarily unavailable";
                            }
                            ShareChooserActivity.this.updateReconnecting();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        }
    }

    @Override
    public void onBufferSelected(int bid) {
        Intent i = new Intent((Context)this, MainActivity.class);
        i.setFlags(0x10000000);
        if (Build.VERSION.SDK_INT < 14) {
            i.addFlags(0x800000);
        }
        i.putExtra("bid", bid);
        if (this.getIntent() != null && this.getIntent().getData() != null) {
            i.setData(this.getIntent().getData());
        }
        if (this.getIntent() != null && this.getIntent().getExtras() != null) {
            for (String key : this.getIntent().getExtras().keySet()) {
                try {
                    if (key.equals("android.intent.extra.STREAM")) {
                        i.putExtra(key, this.getIntent().getParcelableExtra(key));
                        continue;
                    }
                    i.putExtra(key, this.getIntent().getStringExtra(key));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.startActivity(i);
        this.finish();
    }

    @Override
    public boolean onBufferLongClicked(BuffersDataSource.Buffer b) {
        return false;
    }

    @Override
    public void addButtonPressed(int cid) {
    }

    @Override
    public void addNetwork() {
    }

    @Override
    public void reorder() {
    }
}

