/*
 * Decompiled with CFR 0.152.
 */
package com.irccloud.android.activity;

import android.app.ActivityManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.net.http.HttpResponseCache;
import android.os.Build;
import android.os.Bundle;
import android.support.v7.app.AlertDialog;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.crashlytics.android.Crashlytics;
import com.github.fge.uritemplate.URITemplate;
import com.github.fge.uritemplate.vars.VariableMap;
import com.irccloud.android.AsyncTaskEx;
import com.irccloud.android.IRCCloudJSONObject;
import com.irccloud.android.NetworkConnection;
import com.irccloud.android.activity.BaseActivity;
import com.irccloud.android.activity.ImageViewerActivity;
import java.io.IOException;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class UploadsActivity
extends BaseActivity {
    private int page = 0;
    private int reqid = -1;
    private FilesAdapter adapter = new FilesAdapter();
    private boolean canLoadMore = true;
    private View footer;
    private URITemplate uri_template = null;
    private String to;
    private int cid = -1;
    private String msg;
    private final BlockingQueue<Runnable> mDecodeWorkQueue = new LinkedBlockingQueue<Runnable>();
    private static final int KEEP_ALIVE_TIME = 10;
    private static final TimeUnit KEEP_ALIVE_TIME_UNIT = TimeUnit.SECONDS;
    private final ThreadPoolExecutor mDownloadThreadPool = new ThreadPoolExecutor(4, 8, 10L, KEEP_ALIVE_TIME_UNIT, this.mDecodeWorkQueue);

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (Build.VERSION.SDK_INT >= 21) {
            Bitmap cloud = BitmapFactory.decodeResource((Resources)this.getResources(), (int)2130837620);
            this.setTaskDescription(new ActivityManager.TaskDescription(this.getResources().getString(2131165254), cloud, -854020));
            cloud.recycle();
        }
        if (Build.VERSION.SDK_INT >= 14) {
            try {
                java.io.File httpCacheDir = new java.io.File(this.getCacheDir(), "http");
                long httpCacheSize = 0xA00000L;
                HttpResponseCache.install((java.io.File)httpCacheDir, (long)httpCacheSize);
            }
            catch (IOException e) {
                Log.i((String)"IRCCloud", (String)("HTTP response cache installation failed:" + e));
            }
        }
        this.setContentView(2130903096);
        if (this.getSupportActionBar() != null) {
            this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
            this.getSupportActionBar().setHomeAsUpIndicator(2130837526);
            this.getSupportActionBar().setBackgroundDrawable(this.getResources().getDrawable(2130837566));
            this.getSupportActionBar().setElevation(0.0f);
        }
        if (savedInstanceState != null && savedInstanceState.containsKey("cid")) {
            File[] files;
            this.cid = savedInstanceState.getInt("cid");
            this.to = savedInstanceState.getString("to");
            this.msg = savedInstanceState.getString("msg");
            this.page = savedInstanceState.getInt("page");
            for (File f : files = (File[])savedInstanceState.getSerializable("adapter")) {
                this.adapter.addFile(f);
            }
            this.adapter.notifyDataSetChanged();
        }
        this.footer = this.getLayoutInflater().inflate(2130903099, null);
        ListView listView = (ListView)this.findViewById(16908298);
        listView.setAdapter((ListAdapter)this.adapter);
        listView.addFooterView(this.footer);
        listView.setOnScrollListener(new AbsListView.OnScrollListener(){

            public void onScrollStateChanged(AbsListView absListView, int i) {
            }

            public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
                if (UploadsActivity.this.canLoadMore && firstVisibleItem + visibleItemCount > totalItemCount - 4) {
                    UploadsActivity.this.canLoadMore = false;
                    new FetchFilesTask().execute(new Void[]{null});
                }
            }
        });
        listView.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> adapterView, View view, int i, long l) {
            }

            public void onNothingSelected(AdapterView<?> adapterView) {
            }
        });
        listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                final File f = (File)UploadsActivity.this.adapter.getItem(i);
                AlertDialog.Builder builder = new AlertDialog.Builder((Context)UploadsActivity.this);
                builder.setInverseBackgroundForced(Build.VERSION.SDK_INT < 11);
                final View v = UploadsActivity.this.getLayoutInflater().inflate(2130903093, null);
                final EditText messageinput = (EditText)v.findViewById(2131624116);
                messageinput.setText((CharSequence)UploadsActivity.this.msg);
                ImageView thumbnail = (ImageView)v.findViewById(2131624132);
                v.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                    public void onGlobalLayout() {
                        if (messageinput.hasFocus()) {
                            v.post(new Runnable(){

                                @Override
                                public void run() {
                                    v.scrollTo(0, v.getBottom());
                                }
                            });
                        }
                    }
                });
                if (f.mime_type.startsWith("image/")) {
                    try {
                        thumbnail.setImageBitmap(f.image);
                        thumbnail.setVisibility(0);
                        thumbnail.setOnClickListener(new View.OnClickListener(){

                            public void onClick(View view) {
                                Intent i = new Intent((Context)UploadsActivity.this, ImageViewerActivity.class);
                                i.setData(Uri.parse((String)f.url));
                                UploadsActivity.this.startActivity(i);
                            }
                        });
                        thumbnail.setClickable(true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    thumbnail.setVisibility(8);
                }
                ((TextView)v.findViewById(2131624133)).setText((CharSequence)f.metadata);
                v.findViewById(2131624115).setVisibility(8);
                v.findViewById(2131624114).setVisibility(8);
                builder.setTitle("Send A File To " + UploadsActivity.this.to);
                builder.setView(v);
                builder.setPositiveButton("Send", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        String message = messageinput.getText().toString();
                        if (message.length() > 0) {
                            message = message + " ";
                        }
                        message = message + f.url;
                        dialog.dismiss();
                        if (UploadsActivity.this.getParent() == null) {
                            UploadsActivity.this.setResult(-1);
                        } else {
                            UploadsActivity.this.getParent().setResult(-1);
                        }
                        UploadsActivity.this.finish();
                        NetworkConnection.getInstance().say(UploadsActivity.this.cid, UploadsActivity.this.to, message);
                    }
                });
                builder.setNegativeButton("Cancel", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        dialog.cancel();
                    }
                });
                AlertDialog d = builder.create();
                d.setOwnerActivity(UploadsActivity.this);
                d.getWindow().setSoftInputMode(16);
                d.show();
            }
        });
    }

    @Override
    public void onResume() {
        super.onResume();
        NetworkConnection.getInstance().addHandler(this);
        if (this.cid == -1) {
            this.cid = this.getIntent().getIntExtra("cid", -1);
            this.to = this.getIntent().getStringExtra("to");
            this.msg = this.getIntent().getStringExtra("msg");
        }
        try {
            this.uri_template = new URITemplate(NetworkConnection.getInstance().config.getString("file_uri_template"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onPause() {
        super.onPause();
        NetworkConnection.getInstance().removeHandler(this);
    }

    @Override
    protected void onDestroy() {
        HttpResponseCache cache;
        super.onDestroy();
        if (this.adapter != null) {
            this.adapter.clear();
        }
        if (this.mDownloadThreadPool != null) {
            this.mDownloadThreadPool.shutdownNow();
        }
        if (Build.VERSION.SDK_INT >= 14 && (cache = HttpResponseCache.getInstalled()) != null) {
            cache.flush();
        }
    }

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt("cid", this.cid);
        outState.putString("to", this.to);
        outState.putString("msg", this.msg);
        outState.putInt("page", this.page);
        this.adapter.saveInstanceState(outState);
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu2) {
        return false;
    }

    @Override
    public void onIRCEvent(int what, Object o) {
        switch (what) {
            case 104: {
                IRCCloudJSONObject obj = (IRCCloudJSONObject)o;
                if (obj.getInt("_reqid") != this.reqid) break;
                Log.d((String)"IRCCloud", (String)"File deleted successfully");
                this.reqid = -1;
                break;
            }
            case 103: {
                IRCCloudJSONObject obj = (IRCCloudJSONObject)o;
                if (this.reqid == -1 || obj.getInt("_reqid") != this.reqid) break;
                Crashlytics.log(6, "IRCCloud", "Delete failed: " + obj.toString());
                this.reqid = -1;
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        AlertDialog.Builder builder = new AlertDialog.Builder((Context)UploadsActivity.this);
                        builder.setTitle("Error");
                        builder.setMessage("Unable to delete file.  Please try again shortly.");
                        builder.setPositiveButton("Close", null);
                        builder.show();
                    }
                });
                break;
            }
        }
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.finish();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    private void checkEmpty() {
        if (this.adapter.getCount() == 0 && !this.canLoadMore) {
            this.findViewById(16908298).setVisibility(8);
            TextView empty = (TextView)this.findViewById(16908292);
            empty.setVisibility(0);
            empty.setText((CharSequence)"You haven't uploaded any files to IRCCloud yet.");
        } else {
            this.findViewById(16908298).setVisibility(0);
            this.findViewById(16908292).setVisibility(8);
        }
    }

    private class FetchFilesTask
    extends AsyncTaskEx<Void, Void, JSONObject> {
        private FetchFilesTask() {
        }

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            UploadsActivity.this.canLoadMore = false;
        }

        protected JSONObject doInBackground(Void ... params) {
            try {
                Thread.currentThread().setPriority(1);
                return NetworkConnection.getInstance().files(++UploadsActivity.this.page);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }

        @Override
        protected void onPostExecute(JSONObject jsonObject) {
            block8: {
                if (jsonObject != null) {
                    try {
                        if (jsonObject.getBoolean("success")) {
                            JSONArray files = jsonObject.getJSONArray("files");
                            Log.e((String)"IRCCloud", (String)("Got " + files.length() + " files for page " + UploadsActivity.this.page));
                            for (int i = 0; i < files.length(); ++i) {
                                JSONObject file = files.getJSONObject(i);
                                UploadsActivity.this.adapter.addFile(file.getString("id"), file.getString("name"), file.getString("mime_type"), file.getString("extension"), file.getInt("size"), new Date(file.getLong("date") * 1000L));
                            }
                            UploadsActivity.this.adapter.notifyDataSetChanged();
                            UploadsActivity.this.canLoadMore = files.length() > 0 && UploadsActivity.this.adapter.getCount() < jsonObject.getInt("total");
                            if (!UploadsActivity.this.canLoadMore) {
                                UploadsActivity.this.footer.findViewById(2131624038).setVisibility(8);
                            }
                            break block8;
                        }
                        UploadsActivity.this.page--;
                        Log.e((String)"IRCCloud", (String)("Failed: " + jsonObject.toString()));
                        if (jsonObject.has("message") && jsonObject.getString("message").equals("server_error")) {
                            UploadsActivity.this.canLoadMore = true;
                            new FetchFilesTask().execute(new Void[]{null});
                            break block8;
                        }
                        UploadsActivity.this.canLoadMore = false;
                    }
                    catch (JSONException e) {
                        UploadsActivity.this.page--;
                        e.printStackTrace();
                    }
                } else {
                    UploadsActivity.this.page--;
                    UploadsActivity.this.canLoadMore = true;
                    new FetchFilesTask().execute(new Void[]{null});
                }
            }
            UploadsActivity.this.checkEmpty();
        }
    }

    private class FilesAdapter
    extends BaseAdapter {
        private ArrayList<File> files = new ArrayList();
        private DateFormat dateFormat = DateFormat.getDateTimeInstance();
        private View.OnClickListener deleteClickListener = new View.OnClickListener(){

            public void onClick(View view) {
                final File f = (File)FilesAdapter.this.getItem((Integer)view.getTag());
                AlertDialog.Builder builder = new AlertDialog.Builder((Context)UploadsActivity.this);
                builder.setTitle("Delete File");
                if (f.name != null && f.name.length() > 0) {
                    builder.setMessage("Are you sure you want to delete '" + f.name + "'?");
                } else {
                    builder.setMessage("Are you sure you want to delete this file?");
                }
                builder.setPositiveButton("Delete", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int i) {
                        UploadsActivity.this.reqid = NetworkConnection.getInstance().deleteFile(f.id);
                        FilesAdapter.this.files.remove(f);
                        FilesAdapter.this.notifyDataSetChanged();
                        UploadsActivity.this.checkEmpty();
                    }
                });
                builder.setNegativeButton("Cancel", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int i) {
                        dialogInterface.dismiss();
                    }
                });
                AlertDialog d = builder.create();
                d.setOwnerActivity(UploadsActivity.this);
                d.show();
            }
        };

        private FilesAdapter() {
        }

        public void clear() {
            for (File f : this.files) {
                if (f.image != null && !f.image.isRecycled()) {
                    f.image.recycle();
                }
                f.image = null;
            }
            this.files.clear();
            this.notifyDataSetInvalidated();
        }

        public void saveInstanceState(Bundle state) {
            state.putSerializable("adapter", (Serializable)this.files.toArray(new File[this.files.size()]));
        }

        public void addFile(String id2, String name, String mime_type, String extension, int size, Date date) {
            File f = new File();
            f.id = id2;
            f.name = name;
            f.mime_type = mime_type;
            f.extension = extension;
            f.size = size;
            f.date = date;
            if (f.extension != null && f.extension.length() > 1 && f.extension.startsWith(".")) {
                f.extension = f.extension.substring(1).toUpperCase();
            }
            this.addFile(f);
        }

        public void addFile(final File f) {
            this.files.add(f);
            try {
                if (f.image == null && f.mime_type.startsWith("image/")) {
                    UploadsActivity.this.mDownloadThreadPool.execute(new Runnable(){

                        @Override
                        public void run() {
                            Thread.currentThread().setPriority(1);
                            try {
                                if (UploadsActivity.this.uri_template != null) {
                                    f.url = UploadsActivity.this.uri_template.toString(VariableMap.newBuilder().addScalarValue("id", f.id).addScalarValue("name", f.name).freeze());
                                    f.image = NetworkConnection.getInstance().fetchImage(UploadsActivity.this.uri_template.toURL(VariableMap.newBuilder().addScalarValue("id", f.id).addScalarValue("modifiers", "w320").freeze()), false);
                                }
                                if (f.image == null) {
                                    f.image_failed = true;
                                }
                            }
                            catch (Exception e) {
                                f.image_failed = true;
                                e.printStackTrace();
                            }
                            if (f.image_failed && (f.extension == null || f.extension.length() == 0)) {
                                f.extension = "IMAGE";
                            }
                            UploadsActivity.this.runOnUiThread(new Runnable(){

                                @Override
                                public void run() {
                                    FilesAdapter.this.notifyDataSetChanged();
                                }
                            });
                        }
                    });
                } else if (UploadsActivity.this.uri_template != null) {
                    f.url = UploadsActivity.this.uri_template.toString(VariableMap.newBuilder().addScalarValue("id", f.id).addScalarValue("name", f.name).freeze());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public int getCount() {
            return this.files.size();
        }

        public Object getItem(int i) {
            return this.files.get(i);
        }

        public long getItemId(int i) {
            return i;
        }

        public View getView(int i, View view, ViewGroup viewGroup) {
            ViewHolder holder;
            View row = view;
            if (row == null) {
                LayoutInflater inflater = UploadsActivity.this.getLayoutInflater();
                row = inflater.inflate(2130903118, viewGroup, false);
                holder = new ViewHolder();
                holder.date = (TextView)row.findViewById(2131624194);
                holder.image = (ImageView)row.findViewById(2131623990);
                holder.extension = (TextView)row.findViewById(2131624193);
                holder.name = (TextView)row.findViewById(2131624050);
                holder.metadata = (TextView)row.findViewById(2131624196);
                holder.progress = (ProgressBar)row.findViewById(2131624038);
                holder.delete = (ImageButton)row.findViewById(2131624195);
                row.setTag((Object)holder);
            } else {
                holder = (ViewHolder)row.getTag();
            }
            try {
                File f = this.files.get(i);
                if (f.date_formatted == null) {
                    f.date_formatted = this.dateFormat.format(f.date);
                }
                holder.date.setText((CharSequence)f.date_formatted);
                if (f.extension != null && f.extension.length() > 1) {
                    holder.extension.setText((CharSequence)f.extension);
                } else {
                    holder.extension.setText((CharSequence)"???");
                }
                holder.name.setText((CharSequence)f.name);
                if (f.metadata == null) {
                    if (f.size < 1024) {
                        f.metadata = f.size + " B";
                    } else {
                        int exp = (int)(Math.log(f.size) / Math.log(1024.0));
                        f.metadata = String.format("%.1f ", (double)f.size / Math.pow(1024.0, exp)) + "KMGTPE".charAt(exp - 1) + "B";
                    }
                    f.metadata = f.metadata + " \u2022 " + f.mime_type;
                }
                holder.metadata.setText((CharSequence)f.metadata);
                if (!f.image_failed && f.mime_type.startsWith("image/")) {
                    if (f.image != null) {
                        holder.progress.setVisibility(8);
                        holder.extension.setVisibility(8);
                        holder.image.setVisibility(0);
                        holder.image.setImageBitmap(f.image);
                    } else {
                        holder.extension.setVisibility(8);
                        holder.image.setVisibility(8);
                        holder.image.setImageBitmap(null);
                        holder.progress.setVisibility(0);
                    }
                } else {
                    holder.extension.setVisibility(0);
                    holder.image.setVisibility(8);
                    holder.progress.setVisibility(8);
                }
                holder.delete.setOnClickListener(this.deleteClickListener);
                holder.delete.setTag((Object)i);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return row;
        }

        private class ViewHolder {
            TextView date;
            ImageView image;
            TextView extension;
            TextView name;
            TextView metadata;
            ProgressBar progress;
            ImageButton delete;

            private ViewHolder() {
            }
        }
    }

    private static class File
    implements Serializable {
        private static final long serialVersionUID = 0L;
        String id;
        String name;
        String url;
        String mime_type;
        String extension;
        int size;
        Date date;
        String date_formatted;
        String metadata;
        transient Bitmap image;
        boolean image_failed;

        private File() {
        }
    }
}

