/*
 * Decompiled with CFR 0.152.
 */
package com.irccloud.android.data;

import android.util.SparseArray;
import com.irccloud.android.data.ChannelsDataSource;
import com.irccloud.android.data.EventsDataSource;
import com.irccloud.android.data.ServersDataSource;
import com.irccloud.android.data.UsersDataSource;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class BuffersDataSource {
    private ArrayList<Buffer> buffers = new ArrayList();
    private SparseArray<Buffer> buffers_indexed = new SparseArray();
    private Collator collator = Collator.getInstance();
    private static BuffersDataSource instance = null;
    public boolean dirty = true;

    public static synchronized BuffersDataSource getInstance() {
        if (instance == null) {
            instance = new BuffersDataSource();
        }
        return instance;
    }

    public BuffersDataSource() {
        this.collator.setStrength(1);
    }

    public void clear() {
        this.buffers.clear();
        this.buffers_indexed.clear();
    }

    public int count() {
        return this.buffers.size();
    }

    public int firstBid() {
        if (this.buffers_indexed.size() > 0) {
            return ((Buffer)this.buffers_indexed.valueAt((int)0)).bid;
        }
        return -1;
    }

    public synchronized Buffer createBuffer(int bid, int cid, long min_eid, long last_seen_eid, String name, String type, int archived, int deferred, int timeout) {
        Buffer b = this.getBuffer(bid);
        if (b == null) {
            b = new Buffer();
            this.buffers.add(b);
            this.buffers_indexed.put(bid, (Object)b);
        }
        b.bid = bid;
        b.cid = cid;
        b.min_eid = min_eid;
        b.last_seen_eid = last_seen_eid;
        b.name = name;
        b.type = type;
        b.archived = archived;
        b.deferred = deferred;
        b.timeout = timeout;
        b.valid = 1;
        this.dirty = true;
        b.unread = 0;
        b.highlights = 0;
        return b;
    }

    public synchronized void updateLastSeenEid(int bid, long last_seen_eid) {
        Buffer b = this.getBuffer(bid);
        if (b != null && b.last_seen_eid < last_seen_eid) {
            b.last_seen_eid = last_seen_eid;
        }
    }

    public synchronized void updateArchived(int bid, int archived) {
        Buffer b = this.getBuffer(bid);
        if (b != null) {
            b.archived = archived;
        }
        this.dirty = true;
    }

    public synchronized void updateTimeout(int bid, int timeout) {
        Buffer b = this.getBuffer(bid);
        if (b != null) {
            b.timeout = timeout;
        }
    }

    public synchronized void updateName(int bid, String name) {
        Buffer b = this.getBuffer(bid);
        if (b != null) {
            b.name = name;
        }
        this.dirty = true;
    }

    public synchronized void updateAway(int cid, String nick, String away_msg) {
        Buffer b = this.getBufferByName(cid, nick);
        if (b != null) {
            b.away_msg = away_msg;
        }
    }

    public synchronized void updateDraft(int bid, String draft) {
        Buffer b = this.getBuffer(bid);
        if (b != null) {
            b.draft = draft;
        }
    }

    public synchronized void deleteAllDataForBuffer(int bid) {
        Buffer b = this.getBuffer(bid);
        if (b != null) {
            if (b.type.equalsIgnoreCase("channel")) {
                ChannelsDataSource.getInstance().deleteChannel(bid);
                UsersDataSource.getInstance().deleteUsersForBuffer(b.bid);
            }
            EventsDataSource.getInstance().deleteEventsForBuffer(bid);
        }
        this.buffers.remove(b);
        this.buffers_indexed.remove(bid);
        this.dirty = true;
    }

    public synchronized Buffer getBuffer(int bid) {
        return (Buffer)this.buffers_indexed.get(bid);
    }

    public synchronized Buffer getBufferByName(int cid, String name) {
        for (Buffer b : this.buffers) {
            if (b.cid != cid || !b.name.equalsIgnoreCase(name)) continue;
            return b;
        }
        return null;
    }

    public synchronized ArrayList<Buffer> getBuffersForServer(int cid) {
        ArrayList<Buffer> list = new ArrayList<Buffer>();
        if (this.dirty) {
            try {
                Collections.sort(this.buffers, new comparator());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.dirty = false;
        }
        for (Buffer b : this.buffers) {
            if (b.cid != cid) continue;
            list.add(b);
        }
        return list;
    }

    public synchronized ArrayList<Buffer> getBuffers() {
        ArrayList<Buffer> list = new ArrayList<Buffer>();
        for (Buffer b : this.buffers) {
            list.add(b);
        }
        return list;
    }

    public synchronized void invalidate() {
        for (Buffer b : this.buffers) {
            b.valid = 0;
        }
    }

    public synchronized void purgeInvalidBIDs() {
        ArrayList<Buffer> buffersToRemove = new ArrayList<Buffer>();
        for (Buffer b : this.buffers) {
            if (b.valid != 0) continue;
            buffersToRemove.add(b);
        }
        for (Buffer b : buffersToRemove) {
            EventsDataSource.getInstance().deleteEventsForBuffer(b.bid);
            ChannelsDataSource.getInstance().deleteChannel(b.bid);
            UsersDataSource.getInstance().deleteUsersForBuffer(b.bid);
            this.buffers.remove(b);
            this.buffers_indexed.remove(b.bid);
            if (!b.type.equalsIgnoreCase("console")) continue;
            ServersDataSource.getInstance().deleteServer(b.cid);
        }
        this.dirty = true;
    }

    public class comparator
    implements Comparator<Buffer> {
        @Override
        public int compare(Buffer b1, Buffer b2) {
            if (b1.cid < b2.cid) {
                return -1;
            }
            if (b1.cid > b2.cid) {
                return 1;
            }
            if (b1.type.equals("console")) {
                return -1;
            }
            if (b2.type.equals("console")) {
                return 1;
            }
            if (b1.bid == b2.bid) {
                return 0;
            }
            int joined1 = 1;
            int joined2 = 1;
            ChannelsDataSource.Channel c = ChannelsDataSource.getInstance().getChannelForBuffer(b1.bid);
            if (c == null) {
                joined1 = 0;
            }
            if ((c = ChannelsDataSource.getInstance().getChannelForBuffer(b2.bid)) == null) {
                joined2 = 0;
            }
            if (b1.type.equals("conversation") && b2.type.equals("channel")) {
                return 1;
            }
            if (b1.type.equals("channel") && b2.type.equals("conversation")) {
                return -1;
            }
            if (joined1 != joined2) {
                return joined2 - joined1;
            }
            if (BuffersDataSource.this.collator.compare(b1.normalizedName(), b2.normalizedName()) == 0) {
                return b1.bid < b2.bid ? -1 : 1;
            }
            return BuffersDataSource.this.collator.compare(b1.normalizedName(), b2.normalizedName());
        }
    }

    public static class Buffer {
        public int bid;
        public int cid;
        public long min_eid;
        public long last_seen_eid;
        public String name;
        public String type;
        public int archived;
        public int deferred;
        public int timeout;
        public String away_msg;
        public String draft;
        public String chan_types;
        public int valid;
        public boolean scrolledUp;
        public int scrollPosition;
        public int scrollPositionOffset;
        public int unread;
        public int highlights;

        public String toString() {
            return "{cid:" + this.cid + ", bid:" + this.bid + ", name: " + this.name + ", type: " + this.type + ", archived: " + this.archived + "}";
        }

        public String normalizedName() {
            if (this.chan_types == null || this.chan_types.length() < 2) {
                ServersDataSource.Server s = ServersDataSource.getInstance().getServer(this.cid);
                this.chan_types = s != null && s.CHANTYPES != null && s.CHANTYPES.length() > 0 ? s.CHANTYPES : "#";
            }
            return this.name.replaceAll("^[" + this.chan_types + "]+", "");
        }
    }
}

