/*
 * Decompiled with CFR 0.152.
 */
package com.irccloud.android.data;

import android.util.SparseArray;
import com.fasterxml.jackson.databind.JsonNode;
import com.irccloud.android.ColorFormatter;
import com.irccloud.android.data.UsersDataSource;
import java.util.ArrayList;

public class ChannelsDataSource {
    private SparseArray<Channel> channels = new SparseArray();
    private static ChannelsDataSource instance = null;

    public static synchronized ChannelsDataSource getInstance() {
        if (instance == null) {
            instance = new ChannelsDataSource();
        }
        return instance;
    }

    public synchronized void clear() {
        this.channels.clear();
    }

    public synchronized Channel createChannel(int cid, int bid, String name, String topic_text, long topic_time, String topic_author, String type, long timestamp) {
        Channel c = this.getChannelForBuffer(bid);
        if (c == null) {
            c = new Channel();
            this.channels.put(bid, (Object)c);
        }
        c.cid = cid;
        c.bid = bid;
        c.name = name;
        c.topic_author = topic_author;
        c.topic_text = ColorFormatter.emojify(topic_text);
        c.topic_time = topic_time;
        c.type = type;
        c.timestamp = timestamp;
        c.valid = 1;
        c.key = false;
        c.mode = "";
        c.modes = new ArrayList();
        return c;
    }

    public synchronized void deleteChannel(int bid) {
        this.channels.remove(bid);
    }

    public synchronized void updateTopic(int bid, String topic_text, long topic_time, String topic_author) {
        Channel c = this.getChannelForBuffer(bid);
        if (c != null) {
            c.topic_text = ColorFormatter.emojify(topic_text);
            c.topic_time = topic_time;
            c.topic_author = topic_author;
        }
    }

    public synchronized void updateMode(int bid, String mode, JsonNode ops, boolean init) {
        Channel c = this.getChannelForBuffer(bid);
        if (c != null) {
            c.key = false;
            JsonNode add = ops.get("add");
            for (int i = 0; i < add.size(); ++i) {
                JsonNode m = add.get(i);
                c.addMode(m.get("mode").asText(), m.get("param").asText(), init);
            }
            JsonNode remove = ops.get("remove");
            for (int i = 0; i < remove.size(); ++i) {
                JsonNode m = remove.get(i);
                c.removeMode(m.get("mode").asText());
            }
            c.mode = mode;
        }
    }

    public synchronized void updateURL(int bid, String url) {
        Channel c = this.getChannelForBuffer(bid);
        if (c != null) {
            c.url = url;
        }
    }

    public synchronized void updateTimestamp(int bid, long timestamp) {
        Channel c = this.getChannelForBuffer(bid);
        if (c != null) {
            c.timestamp = timestamp;
        }
    }

    public synchronized Channel getChannelForBuffer(int bid) {
        return (Channel)this.channels.get(bid);
    }

    public synchronized ArrayList<Channel> getChannels() {
        ArrayList<Channel> list = new ArrayList<Channel>();
        for (int i = 0; i < this.channels.size(); ++i) {
            Channel c = (Channel)this.channels.valueAt(i);
            list.add(c);
        }
        return list;
    }

    public synchronized void invalidate() {
        for (int i = 0; i < this.channels.size(); ++i) {
            Channel c = (Channel)this.channels.valueAt(i);
            c.valid = 0;
        }
    }

    public synchronized void purgeInvalidChannels() {
        ArrayList<Channel> channelsToRemove = new ArrayList<Channel>();
        for (int i = 0; i < this.channels.size(); ++i) {
            Channel c = (Channel)this.channels.valueAt(i);
            if (c.valid != 0) continue;
            channelsToRemove.add(c);
        }
        for (Channel c : channelsToRemove) {
            UsersDataSource.getInstance().deleteUsersForBuffer(c.bid);
            this.channels.remove(c.bid);
        }
    }

    public static class Channel {
        public int cid;
        public int bid;
        public String name;
        public String topic_text;
        public long topic_time;
        public String topic_author;
        public String type;
        public String mode;
        public ArrayList<Mode> modes;
        public long timestamp;
        public String url;
        public int valid;
        public boolean key;

        public synchronized void addMode(String mode, String param, boolean init) {
            if (!init) {
                this.removeMode(mode);
            }
            if (mode.equals("k")) {
                this.key = true;
            }
            Mode m = new Mode();
            m.mode = mode;
            m.param = param;
            this.modes.add(m);
        }

        public synchronized void removeMode(String mode) {
            if (mode.equals("k")) {
                this.key = false;
            }
            for (Mode m : this.modes) {
                if (!m.mode.equals(mode)) continue;
                this.modes.remove(m);
                return;
            }
        }

        public synchronized boolean hasMode(String mode) {
            for (Mode m : this.modes) {
                if (!m.mode.equals(mode)) continue;
                return true;
            }
            return false;
        }

        public synchronized String paramForMode(String mode) {
            for (Mode m : this.modes) {
                if (!m.mode.equals(mode)) continue;
                return m.param;
            }
            return null;
        }
    }

    public static class Mode {
        public String mode;
        public String param;
    }
}

