/*
 * Decompiled with CFR 0.152.
 */
package com.irccloud.android.data;

import android.annotation.SuppressLint;
import android.text.Spanned;
import android.text.TextUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.irccloud.android.IRCCloudJSONObject;
import com.irccloud.android.Ignore;
import com.irccloud.android.data.ServersDataSource;
import java.util.HashMap;
import java.util.TimerTask;
import java.util.TreeMap;

@SuppressLint(value={"UseSparseArrays"})
public class EventsDataSource {
    private final HashMap<Integer, TreeMap<Long, Event>> events;
    private static EventsDataSource instance = null;
    public long highest_eid = -1L;
    private HashMap<String, Formatter> formatterMap = new HashMap<String, Formatter>(){
        {
            this.put("socket_closed", new Formatter(){

                @Override
                public void format(IRCCloudJSONObject event, Event e) {
                    e.from = "";
                    e.row_type = 3;
                    e.color = 2131492956;
                    e.linkify = false;
                    e.msg = event.has("pool_lost") ? "Connection pool lost" : (event.has("server_ping_timeout") ? "Server PING timed out" : (event.has("reason") && event.getString("reason").length() > 0 ? "Connection lost: " + EventsDataSource.this.reason(event.getString("reason")) : (event.has("abnormal") ? "Connection closed unexpectedly" : "")));
                }
            });
            this.put("user_channel_mode", new Formatter(){

                @Override
                public void format(IRCCloudJSONObject event, Event e) {
                    e.target_mode = event.getString("newmode");
                    e.chan = event.getString("channel");
                }
            });
            this.put("buffer_me_msg", new Formatter(){

                @Override
                public void format(IRCCloudJSONObject event, Event e) {
                    e.nick = e.from;
                    e.from = "";
                }
            });
            this.put("nickname_in_use", new Formatter(){

                @Override
                public void format(IRCCloudJSONObject event, Event e) {
                    e.from = event.getString("nick");
                    e.msg = "is already in use";
                    e.bg_color = 2131492904;
                }
            });
            this.put("unhandled_line", new Formatter(){

                @Override
                public void format(IRCCloudJSONObject event, Event e) {
                    e.from = "";
                    StringBuilder msg = new StringBuilder();
                    if (event.has("command")) {
                        msg.append(event.getString("command")).append(" ");
                    }
                    if (event.has("raw")) {
                        msg.append(event.getString("raw"));
                    } else {
                        msg.append(event.getString("msg"));
                    }
                    e.msg = msg.toString();
                    e.bg_color = 2131492904;
                }
            });
            this.put("unparsed_line", this.get("unhandled_line"));
            this.put("connecting_cancelled", new Formatter(){

                @Override
                public void format(IRCCloudJSONObject event, Event e) {
                    e.from = "";
                    e.msg = "Cancelled";
                    e.bg_color = 2131492904;
                }
            });
            this.put("connecting_failed", new Formatter(){

                @Override
                public void format(IRCCloudJSONObject event, Event e) {
                    e.row_type = 3;
                    e.color = 2131492956;
                    e.from = "";
                    e.linkify = false;
                    String reason = EventsDataSource.this.reason(event.getString("reason"));
                    e.msg = reason != null ? "Failed to connect: " + reason : "Failed to connect.";
                }
            });
            this.put("quit_server", new Formatter(){

                @Override
                public void format(IRCCloudJSONObject event, Event e) {
                    e.from = "";
                    e.msg = "\u21d0 You disconnected";
                    e.color = 2131492956;
                    e.self = false;
                }
            });
            this.put("self_details", new Formatter(){

                @Override
                public void format(IRCCloudJSONObject event, Event e) {
                    e.from = "";
                    e.msg = "<pre>Your hostmask: <b>" + event.getString("usermask") + "</b></pre>";
                    e.bg_color = 2131492950;
                    e.linkify = false;
                }
            });
            this.put("myinfo", new Formatter(){

                @Override
                public void format(IRCCloudJSONObject event, Event e) {
                    e.from = "";
                    StringBuilder msg = new StringBuilder();
                    msg.append("Host: ").append(event.getString("server")).append("\n");
                    msg.append("IRCd: ").append(event.getString("version")).append("\n");
                    msg.append("User modes: ").append(event.getString("user_modes")).append("\n");
                    msg.append("Channel modes: ").append(event.getString("channel_modes")).append("\n");
                    if (event.has("rest") && event.getString("rest").length() > 0) {
                        msg.append("Parametric channel modes: ").append(event.getString("rest")).append("\n");
                    }
                    e.msg = "<pre>" + TextUtils.htmlEncode((String)msg.toString()) + "</pre>";
                    e.bg_color = 2131492950;
                    e.linkify = false;
                }
            });
            this.put("user_mode", new Formatter(){

                @Override
                public void format(IRCCloudJSONObject event, Event e) {
                    e.from = "";
                    e.msg = "<pre>Your user mode is: <b>+" + event.getString("newmode") + "</b></pre>";
                    e.bg_color = 2131492950;
                }
            });
            this.put("your_unique_id", new Formatter(){

                @Override
                public void format(IRCCloudJSONObject event, Event e) {
                    e.from = "";
                    e.msg = "<pre>Your unique ID is: <b>" + event.getString("unique_id") + "</b></pre>";
                    e.bg_color = 2131492950;
                }
            });
            this.put("kill", new Formatter(){

                @Override
                public void format(IRCCloudJSONObject event, Event e) {
                    e.from = "";
                    e.msg = "You were killed";
                    if (event.has("from")) {
                        e.msg = e.msg + " by " + event.getString("from");
                    }
                    if (event.has("killer_hostmask")) {
                        e.msg = e.msg + " (" + event.getString("killer_hostmask") + ")";
                    }
                    if (event.has("reason")) {
                        e.msg = e.msg + ": " + TextUtils.htmlEncode((String)event.getString("reason"));
                    }
                    e.bg_color = 2131492950;
                    e.linkify = false;
                }
            });
            this.put("banned", new Formatter(){

                @Override
                public void format(IRCCloudJSONObject event, Event e) {
                    e.from = "";
                    e.msg = "You were banned";
                    if (event.has("server")) {
                        e.msg = e.msg + " from " + event.getString("server");
                    }
                    if (event.has("reason")) {
                        e.msg = e.msg + ": " + TextUtils.htmlEncode((String)event.getString("reason"));
                    }
                    e.bg_color = 2131492950;
                    e.linkify = false;
                }
            });
            this.put("channel_topic", new Formatter(){

                @Override
                public void format(IRCCloudJSONObject event, Event e) {
                    e.from = event.has("author") ? event.getString("author") : event.getString("server");
                    e.msg = event.getString("topic") != null && event.getString("topic").length() > 0 ? "set the topic: " + TextUtils.htmlEncode((String)event.getString("topic")) : "cleared the topic";
                    e.bg_color = 2131492950;
                }
            });
            this.put("channel_mode", new Formatter(){

                @Override
                public void format(IRCCloudJSONObject event, Event e) {
                    e.nick = e.from;
                    e.from = "";
                    e.msg = "Channel mode set to: <b>" + event.getString("diff") + "</b>";
                    e.bg_color = 2131492950;
                    e.linkify = false;
                    e.self = false;
                }
            });
            this.put("channel_mode_is", new Formatter(){

                @Override
                public void format(IRCCloudJSONObject event, Event e) {
                    e.from = "";
                    e.msg = event.getString("diff") != null && event.getString("diff").length() > 0 ? "Channel mode is: <b>" + event.getString("diff") + "</b>" : "No channel mode";
                    e.bg_color = 2131492950;
                    e.linkify = false;
                }
            });
            this.put("kicked_channel", new Formatter(){

                @Override
                public void format(IRCCloudJSONObject event, Event e) {
                    e.from = "";
                    e.from_mode = null;
                    e.old_nick = event.getString("nick");
                    e.nick = event.getString("kicker");
                    e.hostmask = event.getString("kicker_hostmask");
                    e.color = 2131492956;
                    e.linkify = false;
                    if (e.self) {
                        e.row_type = 3;
                    }
                }
            });
            this.put("you_kicked_channel", this.get("kicked_channel"));
            this.put("channel_mode_list_change", new Formatter(){

                @Override
                public void format(IRCCloudJSONObject event, Event e) {
                    boolean unknown = true;
                    ObjectNode ops = event.getJsonObject("ops");
                    if (ops != null) {
                        JsonNode remove;
                        JsonNode add = ((JsonNode)ops).get("add");
                        if (add != null && add.size() > 0) {
                            JsonNode op = add.get(0);
                            if (op.get("mode").asText().equals("b")) {
                                e.nick = e.from;
                                e.from = "";
                                e.msg = "banned <b>" + op.get("param").asText() + "</b> (<font color=#808080>+b</font>)";
                                unknown = false;
                            } else if (op.get("mode").asText().equals("e")) {
                                e.nick = e.from;
                                e.from = "";
                                e.msg = "exempted <b>" + op.get("param").asText() + "</b> from bans (<font color=#808080>+e</font>)";
                                unknown = false;
                            } else if (op.get("mode").asText().equals("q")) {
                                if (op.get("param").asText().contains("@") || op.get("param").asText().contains("$")) {
                                    e.nick = e.from;
                                    e.from = "";
                                    e.msg = "quieted <b>" + op.get("param").asText() + "</b> (<font color=#808080>+q</font>)";
                                } else {
                                    e.type = "user_channel_mode";
                                    e.chan = event.getString("channel");
                                    e.nick = op.get("param").asText();
                                }
                                unknown = false;
                            } else if (op.get("mode").asText().equals("I")) {
                                e.nick = e.from;
                                e.from = "";
                                e.msg = "added <b>" + op.get("param").asText() + "</b> to the invite list (<font color=#808080>+I</font>)";
                                unknown = false;
                            }
                        }
                        if ((remove = ((JsonNode)ops).get("remove")) != null && remove.size() > 0) {
                            JsonNode op = remove.get(0);
                            if (op.get("mode").asText().equals("b")) {
                                e.nick = e.from;
                                e.from = "";
                                e.msg = "un-banned <b>" + op.get("param").asText() + "</b> (<font color=#808080>-b</font>)";
                                unknown = false;
                            } else if (op.get("mode").asText().equals("e")) {
                                e.nick = e.from;
                                e.from = "";
                                e.msg = "un-exempted <b>" + op.get("param").asText() + "</b> from bans (<font color=#808080>-e</font>)";
                                unknown = false;
                            } else if (op.get("mode").asText().equals("q")) {
                                if (op.get("param").asText().contains("@") || op.get("param").asText().contains("$")) {
                                    e.nick = e.from;
                                    e.from = "";
                                    e.msg = "un-quieted <b>" + op.get("param").asText() + "</b> (<font color=#808080>-q</font>)";
                                } else {
                                    e.type = "user_channel_mode";
                                    e.chan = event.getString("channel");
                                    e.nick = op.get("param").asText();
                                }
                                unknown = false;
                            } else if (op.get("mode").asText().equals("I")) {
                                e.nick = e.from;
                                e.from = "";
                                e.msg = "removed <b>" + op.get("param").asText() + "</b> from the invite list (<font color=#808080>-I</font>)";
                                unknown = false;
                            }
                        }
                    }
                    if (unknown) {
                        e.nick = e.from;
                        e.from = "";
                        e.msg = "set channel mode: <b>" + event.getString("diff") + "</b>";
                    }
                    e.bg_color = 2131492950;
                    e.linkify = false;
                    e.self = false;
                }
            });
            this.put("motd_response", new Formatter(){

                @Override
                public void format(IRCCloudJSONObject event, Event e) {
                    JsonNode lines = event.getJsonNode("lines");
                    e.from = "";
                    if (lines != null) {
                        StringBuilder builder = new StringBuilder("<pre>");
                        if (event.has("start")) {
                            builder.append(event.getString("start")).append("<br/>");
                        }
                        for (int i = 0; i < lines.size(); ++i) {
                            builder.append(TextUtils.htmlEncode((String)lines.get(i).asText()).replace("  ", " &nbsp;")).append("<br/>");
                        }
                        builder.append("</pre>");
                        e.msg = builder.toString();
                    }
                    e.bg_color = 2131492946;
                }
            });
            this.put("server_motd", this.get("motd_response"));
            this.put("info_response", this.get("motd_response"));
            this.put("notice", new Formatter(){

                @Override
                public void format(IRCCloudJSONObject event, Event e) {
                    e.chan = event.getString("target");
                    e.msg = "<pre>" + e.msg.replace("  ", " &nbsp;") + "</pre>";
                    e.bg_color = 2131492931;
                }
            });
            this.put("newsflash", new Formatter(){

                @Override
                public void format(IRCCloudJSONObject event, Event e) {
                    e.msg = "<pre>" + e.msg + "</pre>";
                    e.bg_color = 2131492931;
                }
            });
            this.put("invited", new Formatter(){

                @Override
                public void format(IRCCloudJSONObject event, Event e) {
                    e.from = event.getString("inviter");
                    e.msg = "<pre>invited " + event.getString("invitee") + " to join " + event.getString("channel") + "</pre>";
                    e.bg_color = 2131492931;
                }
            });
            this.put("generic_server_info", new Formatter(){

                @Override
                public void format(IRCCloudJSONObject event, Event e) {
                    e.msg = "<pre>" + e.msg + "</pre>";
                    e.bg_color = 2131492931;
                }
            });
            this.put("rehashed_config", new Formatter(){

                @Override
                public void format(IRCCloudJSONObject event, Event e) {
                    e.msg = "Rehashed config: " + event.getString("file") + "(" + e.msg + ")";
                    e.msg = "<pre>" + e.msg + "</pre>";
                    e.bg_color = 2131492931;
                }
            });
            this.put("knock", new Formatter(){

                @Override
                public void format(IRCCloudJSONObject event, Event e) {
                    if (e.nick != null && e.nick.length() > 0) {
                        e.from = e.nick;
                        if (e.hostmask != null && e.hostmask.length() > 0) {
                            e.msg = e.msg + " (" + e.hostmask + ")";
                        }
                    } else {
                        e.msg = event.getString("userhost") + " " + e.msg;
                    }
                    e.msg = "<pre>" + e.msg + "</pre>";
                    e.bg_color = 2131492931;
                }
            });
            this.put("hidden_host_set", new Formatter(){

                @Override
                public void format(IRCCloudJSONObject event, Event e) {
                    e.bg_color = 2131492950;
                    e.linkify = false;
                    e.from = "";
                    e.msg = "<b>" + event.getString("hidden_host") + "</b> " + e.msg;
                }
            });
            this.put("inviting_to_channel", new Formatter(){

                @Override
                public void format(IRCCloudJSONObject event, Event e) {
                    e.from = "";
                    e.msg = "You invited " + event.getString("recipient") + " to join " + event.getString("channel");
                    e.bg_color = 2131492931;
                }
            });
            this.put("channel_invite", new Formatter(){

                @Override
                public void format(IRCCloudJSONObject event, Event e) {
                    e.msg = "<pre>Invite to join " + event.getString("channel") + "</pre>";
                    e.old_nick = event.getString("channel");
                    e.bg_color = 2131492931;
                }
            });
            this.put("callerid", new Formatter(){

                @Override
                public void format(IRCCloudJSONObject event, Event e) {
                    e.from = e.nick;
                    e.msg = "<pre>" + e.msg + "</pre>";
                    e.highlight = true;
                    e.linkify = false;
                    e.hostmask = event.getString("usermask");
                }
            });
            this.put("target_callerid", new Formatter(){

                @Override
                public void format(IRCCloudJSONObject event, Event e) {
                    e.from = event.getString("target_nick");
                    e.msg = "<pre>" + e.msg + "</pre>";
                    e.bg_color = 2131492904;
                }
            });
            this.put("target_notified", new Formatter(){

                @Override
                public void format(IRCCloudJSONObject event, Event e) {
                    e.from = event.getString("target_nick");
                    e.msg = "<pre>" + e.msg + "</pre>";
                    e.bg_color = 2131492904;
                }
            });
            this.put("link_channel", new Formatter(){

                @Override
                public void format(IRCCloudJSONObject event, Event e) {
                    if (event.has("invalid_chan")) {
                        e.msg = event.has("valid_chan") ? event.getString("invalid_chan") + " \u2192 " + event.getString("valid_chan") + " " + e.msg : event.getString("invalid_chan") + " " + e.msg;
                    }
                    e.bg_color = 2131492904;
                }
            });
            String[] statuses = new String[]{"server_motdstart", "server_welcome", "server_motd", "server_endofmotd", "server_nomotd", "server_luserclient", "server_luserop", "server_luserconns", "server_luserme", "server_n_local", "server_luserchannels", "server_n_global", "server_yourhost", "server_created", "server_luserunknown", "server_snomask", "starircd_welcome", "zurna_motd", "wait", "logged_in_as", "btn_metadata_set", "sasl_success", "you_are_operator", "codepage", "logged_out", "nick_locked", "text", "admin_info"};
            Formatter statusFormatter = new Formatter(){

                @Override
                public void format(IRCCloudJSONObject event, Event e) {
                    e.bg_color = 2131492950;
                    e.msg = "<pre>" + e.msg + "</pre>";
                    e.from = "";
                    if (!e.type.equals("server_motd") && !e.type.equals("zurna_motd")) {
                        e.linkify = false;
                    }
                }
            };
            for (String status : statuses) {
                this.put(status, statusFormatter);
            }
            String[] stats = new String[]{"stats", "statslinkinfo", "statscommands", "statscline", "statsnline", "statsiline", "statskline", "statsqline", "statsyline", "statsbline", "statsgline", "statstline", "statseline", "statsvline", "statslline", "statsuptime", "statsoline", "statshline", "statssline", "statsuline", "statsdebug", "endofstats"};
            Formatter statsFormatter = new Formatter(){

                @Override
                public void format(IRCCloudJSONObject event, Event e) {
                    e.from = "";
                    if (event.has("parts") && event.getString("parts").length() > 0) {
                        e.msg = event.getString("parts") + ": " + e.msg;
                    }
                    e.bg_color = 2131492950;
                    e.linkify = false;
                    e.msg = "<pre>" + e.msg + "</pre>";
                }
            };
            for (String stat : stats) {
                this.put(stat, statsFormatter);
            }
            String[] caps = new String[]{"cap_ls", "cap_req", "cap_ack", "cap_raw"};
            Formatter capsFormatter = new Formatter(){

                @Override
                public void format(IRCCloudJSONObject event, Event e) {
                    e.from = "";
                    e.bg_color = 2131492950;
                    e.linkify = false;
                    switch (e.type) {
                        case "cap_ls": {
                            e.msg = "<b>CAP</b> Server supports: ";
                            break;
                        }
                        case "cap_req": {
                            e.msg = "<b>CAP</b> Requesting: ";
                            break;
                        }
                        case "cap_ack": {
                            e.msg = "<b>CAP</b> Acknowledged: ";
                            break;
                        }
                        case "cap_raw": {
                            e.msg = "<b>CAP</b> " + event.getString("line");
                        }
                    }
                    JsonNode caps = event.getJsonNode("caps");
                    if (caps != null) {
                        for (int i = 0; i < caps.size(); ++i) {
                            if (i > 0) {
                                e.msg = e.msg + " | ";
                            }
                            e.msg = e.msg + caps.get(i).asText();
                        }
                    }
                    e.msg = "<pre>" + e.msg + "</pre>";
                }
            };
            for (String cap : caps) {
                this.put(cap, capsFormatter);
            }
            String[] helps = new String[]{"help_topics_start", "help_topics", "help_topics_end", "helphdr", "helpop", "helptlr", "helphlp", "helpfwd", "helpign"};
            Formatter helpsFormatter = new Formatter(){

                @Override
                public void format(IRCCloudJSONObject event, Event e) {
                    e.bg_color = 2131492950;
                    e.msg = "<pre>" + e.msg + "</pre>";
                    e.from = "";
                }
            };
            for (String help : helps) {
                this.put(help, helpsFormatter);
            }
            String[] errors = new String[]{"too_fast", "sasl_fail", "sasl_too_long", "sasl_aborted", "sasl_already", "no_bots", "msg_services", "bad_ping", "not_for_halfops", "ambiguous_error_message", "list_syntax", "who_syntax"};
            Formatter errorFormatter = new Formatter(){

                @Override
                public void format(IRCCloudJSONObject event, Event e) {
                    e.from = "";
                    e.bg_color = 2131492904;
                }
            };
            for (String error : errors) {
                this.put(error, errorFormatter);
            }
            this.put("version", new Formatter(){

                @Override
                public void format(IRCCloudJSONObject event, Event e) {
                    e.from = "";
                    e.msg = "<pre><b>" + event.getString("server_version") + "</b> " + event.getString("comments") + "</pre>";
                    e.bg_color = 2131492950;
                    e.linkify = false;
                }
            });
            this.put("services_down", new Formatter(){

                @Override
                public void format(IRCCloudJSONObject event, Event e) {
                    e.from = event.getString("services_name");
                    e.bg_color = 2131492904;
                }
            });
            this.put("unknown_umode", new Formatter(){

                @Override
                public void format(IRCCloudJSONObject event, Event e) {
                    e.from = "";
                    if (event.has("flag")) {
                        e.msg = "<b>" + event.getString("flag") + "</b> " + e.msg;
                    }
                    e.bg_color = 2131492904;
                }
            });
            this.put("kill_deny", new Formatter(){

                @Override
                public void format(IRCCloudJSONObject event, Event e) {
                    e.from = event.getString("channel");
                    e.bg_color = 2131492904;
                }
            });
            this.put("chan_own_priv_needed", new Formatter(){

                @Override
                public void format(IRCCloudJSONObject event, Event e) {
                    e.from = event.getString("channel");
                    e.bg_color = 2131492904;
                }
            });
            this.put("chan_forbidden", new Formatter(){

                @Override
                public void format(IRCCloudJSONObject event, Event e) {
                    e.from = event.getString("channel");
                    e.bg_color = 2131492904;
                }
            });
            this.put("list_usage", new Formatter(){

                @Override
                public void format(IRCCloudJSONObject event, Event e) {
                    e.msg = "<pre>" + e.msg + "</pre>";
                    e.bg_color = 2131492931;
                }
            });
            this.put("time", new Formatter(){

                @Override
                public void format(IRCCloudJSONObject event, Event e) {
                    e.bg_color = 2131492950;
                    e.msg = "<pre>" + event.getString("time_string");
                    if (event.has("time_stamp") && event.getString("time_stamp").length() > 0) {
                        e.msg = e.msg + " (" + event.getString("time_stamp") + ")";
                    }
                    e.msg = e.msg + " \u2014 <b>" + event.getString("time_server") + "</b></pre>";
                    e.linkify = false;
                }
            });
            this.put("watch_status", new Formatter(){

                @Override
                public void format(IRCCloudJSONObject event, Event e) {
                    e.bg_color = 2131492950;
                    e.from = event.getString("watch_nick");
                    e.msg = "<pre>" + e.msg + " (" + event.getString("username") + "@" + event.getString("userhost") + ")</pre>";
                    e.linkify = false;
                }
            });
            this.put("sqline_nick", new Formatter(){

                @Override
                public void format(IRCCloudJSONObject event, Event e) {
                    e.bg_color = 2131492950;
                    e.from = event.getString("charset");
                    e.msg = "<pre>" + e.msg + "</pre>";
                }
            });
        }
    };

    public static synchronized EventsDataSource getInstance() {
        if (instance == null) {
            instance = new EventsDataSource();
        }
        return instance;
    }

    public EventsDataSource() {
        this.events = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        HashMap<Integer, TreeMap<Long, Event>> hashMap = this.events;
        synchronized (hashMap) {
            this.events.clear();
            this.highest_eid = -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(Event event) {
        HashMap<Integer, TreeMap<Long, Event>> hashMap = this.events;
        synchronized (hashMap) {
            if (!this.events.containsKey(event.bid)) {
                this.events.put(event.bid, new TreeMap());
            }
            this.events.get(event.bid).put(event.eid, event);
        }
    }

    private String reason(String reason) {
        if (reason != null) {
            if (reason.equalsIgnoreCase("pool_lost")) {
                return "Connection pool failed";
            }
            if (reason.equalsIgnoreCase("no_pool")) {
                return "No available connection pools";
            }
            if (reason.equalsIgnoreCase("enetdown")) {
                return "Network down";
            }
            if (reason.equalsIgnoreCase("etimedout") || reason.equalsIgnoreCase("timeout")) {
                return "Timed out";
            }
            if (reason.equalsIgnoreCase("ehostunreach")) {
                return "Host unreachable";
            }
            if (reason.equalsIgnoreCase("econnrefused")) {
                return "Connection refused";
            }
            if (reason.equalsIgnoreCase("nxdomain")) {
                return "Invalid hostname";
            }
            if (reason.equalsIgnoreCase("server_ping_timeout")) {
                return "PING timeout";
            }
            if (reason.equalsIgnoreCase("ssl_certificate_error")) {
                return "SSL certificate error";
            }
            if (reason.equalsIgnoreCase("ssl_error")) {
                return "SSL error";
            }
            if (reason.equalsIgnoreCase("crash")) {
                return "Connection crashed";
            }
        }
        return reason;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Event addEvent(IRCCloudJSONObject event) {
        HashMap<Integer, TreeMap<Long, Event>> hashMap = this.events;
        synchronized (hashMap) {
            Formatter f;
            Event e;
            if (!this.events.containsKey(event.bid())) {
                this.events.put(event.bid(), new TreeMap());
            }
            if ((e = this.getEvent(event.eid(), event.bid())) == null) {
                e = new Event();
                this.events.get(event.bid()).put(event.eid(), e);
            }
            e.cid = event.cid();
            e.bid = event.bid();
            e.eid = event.eid();
            e.type = event.type();
            e.msg = event.getString("msg");
            e.hostmask = event.getString("hostmask");
            e.from = event.getString("from");
            e.from_mode = event.getString("from_mode");
            e.chan = event.getString("chan");
            e.nick = event.has("newnick") ? event.getString("newnick") : (event.has("nick") ? event.getString("nick") : null);
            e.old_nick = event.getString("oldnick");
            e.server = event.getString("server");
            e.diff = event.getString("diff");
            e.highlight = event.getBoolean("highlight");
            e.self = event.getBoolean("self");
            e.to_chan = event.getBoolean("to_chan");
            e.to_buffer = event.getBoolean("to_buffer");
            e.ops = event.getJsonNode("ops");
            e.color = 2131492976;
            e.bg_color = 2131492930;
            e.row_type = 0;
            e.html = null;
            e.group_msg = null;
            e.linkify = true;
            e.target_mode = null;
            e.pending = false;
            e.failed = false;
            e.command = null;
            e.day = -1;
            e.entities = event.getJsonNode("entities");
            e.reqid = event.has("reqid") ? event.getInt("reqid") : -1;
            if (e.from != null) {
                e.from = TextUtils.htmlEncode((String)e.from);
            }
            if (e.msg != null) {
                e.msg = TextUtils.htmlEncode((String)e.msg);
            }
            if ((f = this.formatterMap.get(e.type)) != null) {
                f.format(event, e);
            }
            if (event.has("value") && !event.type().startsWith("cap_")) {
                e.msg = "<pre>" + event.getString("value") + " " + e.msg + "</pre>";
            }
            if (e.highlight) {
                e.bg_color = 2131492912;
            }
            if (e.self) {
                e.bg_color = 2131492946;
            }
            if (this.highest_eid < event.eid()) {
                this.highest_eid = event.eid();
            }
            return e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSizeOfBuffer(int bid) {
        HashMap<Integer, TreeMap<Long, Event>> hashMap = this.events;
        synchronized (hashMap) {
            if (this.events.containsKey(bid)) {
                return this.events.get(bid).size();
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Event getEvent(long eid, int bid) {
        HashMap<Integer, TreeMap<Long, Event>> hashMap = this.events;
        synchronized (hashMap) {
            if (this.events.containsKey(bid)) {
                return this.events.get(bid).get(eid);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteEvent(long eid, int bid) {
        HashMap<Integer, TreeMap<Long, Event>> hashMap = this.events;
        synchronized (hashMap) {
            if (this.events.containsKey(bid) && this.events.get(bid).containsKey(eid)) {
                this.events.get(bid).remove(eid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteEventsForBuffer(int bid) {
        HashMap<Integer, TreeMap<Long, Event>> hashMap = this.events;
        synchronized (hashMap) {
            if (this.events.containsKey(bid)) {
                this.events.remove(bid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeMap<Long, Event> getEventsForBuffer(int bid) {
        HashMap<Integer, TreeMap<Long, Event>> hashMap = this.events;
        synchronized (hashMap) {
            if (this.events.containsKey(bid)) {
                return this.events.get(bid);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long lastEidForBuffer(int bid) {
        HashMap<Integer, TreeMap<Long, Event>> hashMap = this.events;
        synchronized (hashMap) {
            Long[] eids;
            if (this.events.containsKey(bid) && (eids = this.events.get(bid).keySet().toArray(new Long[this.events.get(bid).keySet().size()])).length > 0) {
                return eids[eids.length - 1];
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pruneEvents(int bid) {
        HashMap<Integer, TreeMap<Long, Event>> hashMap = this.events;
        synchronized (hashMap) {
            TreeMap<Long, Event> e = this.events.get(bid);
            while (e != null && e.size() > 50 && e.firstKey() != null) {
                e.remove(e.firstKey());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clearCaches() {
        HashMap<Integer, TreeMap<Long, Event>> hashMap = this.events;
        synchronized (hashMap) {
            for (int bid : this.events.keySet()) {
                if (!this.events.containsKey(bid)) continue;
                for (Event e : this.events.get(bid).values()) {
                    e.timestamp = null;
                    e.html = null;
                    e.formatted = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Event findPendingEventForReqid(int bid, int reqid) {
        HashMap<Integer, TreeMap<Long, Event>> hashMap = this.events;
        synchronized (hashMap) {
            for (Event e : this.events.get(bid).values()) {
                if (e.reqid != reqid || !e.pending && !e.failed) continue;
                return e;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clearPendingEvents(int bid) {
        Event[] eventArray = this.events;
        synchronized (this.events) {
            Event[] i = this.events.get(bid).values().toArray(new Event[this.events.get(bid).values().size()]);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (Event e : i) {
                if (!e.pending && !e.failed) continue;
                if (e.expiration_timer != null) {
                    try {
                        e.expiration_timer.cancel();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    e.expiration_timer = null;
                }
                this.deleteEvent(e.eid, e.bid);
            }
            return;
        }
    }

    public static interface Formatter {
        public void format(IRCCloudJSONObject var1, Event var2);
    }

    public static class Event {
        public int cid;
        public int bid;
        public long eid;
        public String timestamp;
        public String type;
        public String msg;
        public String hostmask;
        public String from;
        public String from_mode;
        public String nick;
        public String old_nick;
        public String server;
        public String diff;
        public String html;
        public String chan;
        public boolean highlight;
        public boolean self;
        public boolean to_chan;
        public boolean to_buffer;
        public int color;
        public int bg_color;
        public JsonNode ops;
        public long group_eid;
        public int row_type;
        public String group_msg;
        public boolean linkify;
        public String target_mode;
        public int reqid;
        public boolean pending;
        public boolean failed;
        public String command;
        public int day;
        public Spanned formatted;
        public String contentDescription;
        public JsonNode entities;
        public TimerTask expiration_timer;

        public String toString() {
            return "{cid: " + this.cid + " bid: " + this.bid + " eid: " + this.eid + " type: " + this.type + " timestamp: " + this.timestamp + " from: " + this.from + " msg: " + this.msg + " html: " + this.html + " group_eid: " + this.group_eid + " group_msg: " + this.group_msg + " pending: " + this.pending + "}";
        }

        public synchronized boolean isImportant(String buffer_type) {
            if (this.self) {
                return false;
            }
            if (this.type == null) {
                return false;
            }
            Ignore ignore = new Ignore();
            ServersDataSource.Server s = ServersDataSource.getInstance().getServer(this.cid);
            if (s != null) {
                ignore.setIgnores(s.ignores);
                String from = this.from;
                if (from == null || from.length() == 0) {
                    from = this.nick;
                }
                if (ignore.match(from + "!" + this.hostmask)) {
                    return false;
                }
            }
            if (this.type.equals("notice") || this.type.equalsIgnoreCase("channel_invite")) {
                if (this.from == null || this.from.length() == 0) {
                    return false;
                }
                if (buffer_type.equalsIgnoreCase("console") && (this.to_chan || this.to_buffer)) {
                    return false;
                }
            }
            return this.type.equals("buffer_msg") || this.type.equals("buffer_me_msg") || this.type.equals("notice") || this.type.equals("channel_invite") || this.type.equals("callerid") || this.type.equals("wallops");
        }
    }
}

