/*
 * Decompiled with CFR 0.152.
 */
package com.irccloud.android.data;

import android.util.SparseArray;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.irccloud.android.Notifications;
import com.irccloud.android.data.BuffersDataSource;
import java.util.ArrayList;

public class ServersDataSource {
    private SparseArray<Server> servers = new SparseArray();
    private static ServersDataSource instance = null;

    public static synchronized ServersDataSource getInstance() {
        if (instance == null) {
            instance = new ServersDataSource();
        }
        return instance;
    }

    public void clear() {
        this.servers.clear();
    }

    public Server createServer(int cid, String name, String hostname, int port, String nick, String status, long lag, int ssl, String realname, String server_pass, String nickserv_pass, String join_commands, ObjectNode fail_info, String away, JsonNode ignores, int order) {
        Server s = this.getServer(cid);
        if (s == null) {
            s = new Server();
            this.servers.put(cid, (Object)s);
        }
        s.cid = cid;
        s.name = name;
        s.hostname = hostname;
        s.port = port;
        s.nick = nick;
        s.status = status;
        s.lag = lag;
        s.ssl = ssl;
        s.realname = realname;
        s.server_pass = server_pass;
        s.nickserv_pass = nickserv_pass;
        s.join_commands = join_commands;
        s.fail_info = fail_info;
        s.away = away;
        s.usermask = "";
        s.mode = "";
        s.order = order;
        s.isupport = new ObjectMapper().createObjectNode();
        if (s.name == null || s.name.length() == 0) {
            s.name = s.hostname;
        }
        if (ignores != null) {
            this.updateIgnores(cid, ignores);
        }
        return s;
    }

    public int count() {
        return this.servers.size();
    }

    public void updateLag(int cid, long lag) {
        Server s = this.getServer(cid);
        if (s != null) {
            s.lag = lag;
        }
    }

    public void updateNick(int cid, String nick) {
        Server s = this.getServer(cid);
        if (s != null) {
            s.nick = nick;
        }
    }

    public void updateStatus(int cid, String status, ObjectNode fail_info) {
        Server s = this.getServer(cid);
        if (s != null) {
            s.status = status;
            s.fail_info = fail_info;
        }
    }

    public void updateAway(int cid, String away) {
        Server s = this.getServer(cid);
        if (s != null) {
            s.away = away;
        }
    }

    public void updateUsermask(int cid, String usermask) {
        Server s = this.getServer(cid);
        if (s != null) {
            s.usermask = usermask;
        }
    }

    public void updateMode(int cid, String mode) {
        Server s = this.getServer(cid);
        if (s != null) {
            s.mode = mode;
        }
    }

    public void updateUserModes(int cid, String modes) {
        Server s;
        if (modes != null && modes.length() == 5 && modes.charAt(0) != 'q' && (s = this.getServer(cid)) != null) {
            s.MODE_OWNER = modes.substring(0, 1);
        }
    }

    public void updateIsupport(int cid, ObjectNode params) {
        Server s = this.getServer(cid);
        if (s != null) {
            if (params != null && !params.isArray()) {
                s.isupport.putAll(params);
            } else {
                s.isupport = new ObjectMapper().createObjectNode();
            }
            if (s.isupport.has("PREFIX")) {
                s.PREFIX = (ObjectNode)s.isupport.get("PREFIX");
            } else {
                s.PREFIX = new ObjectMapper().createObjectNode();
                s.PREFIX.put(s.MODE_OPER, "!");
                s.PREFIX.put(s.MODE_OWNER, "~");
                s.PREFIX.put(s.MODE_ADMIN, "&");
                s.PREFIX.put(s.MODE_OP, "@");
                s.PREFIX.put(s.MODE_HALFOP, "%");
                s.PREFIX.put(s.MODE_VOICED, "+");
            }
            s.CHANTYPES = s.isupport.has("CHANTYPES") ? s.isupport.get("CHANTYPES").asText() : null;
        }
    }

    public void updateIgnores(int cid, JsonNode ignores) {
        Server s = this.getServer(cid);
        if (s != null) {
            s.raw_ignores = ignores;
            s.ignores = new ArrayList();
            for (int i = 0; i < ignores.size(); ++i) {
                String mask = ignores.get(i).asText().toLowerCase().replace("\\", "\\\\").replace("(", "\\(").replace(")", "\\)").replace("[", "\\[").replace("]", "\\]").replace("{", "\\{").replace("}", "\\}").replace("-", "\\-").replace("^", "\\^").replace("$", "\\$").replace("|", "\\|").replace("+", "\\+").replace("?", "\\?").replace(".", "\\.").replace(",", "\\,").replace("#", "\\#").replace("*", ".*").replace("!~", "!");
                if (!mask.contains("!")) {
                    mask = mask.contains("@") ? ".*!" + mask : mask + "!.*";
                }
                if (!mask.contains("@")) {
                    mask = mask.contains("!") ? mask.replace("!", "!.*@") : mask + "@.*";
                }
                if (mask.equals(".*!.*@.*")) continue;
                s.ignores.add(mask);
            }
        }
    }

    public void deleteServer(int cid) {
        this.servers.remove(cid);
    }

    public void deleteAllDataForServer(int cid) {
        Server s = this.getServer(cid);
        if (s != null) {
            ArrayList<BuffersDataSource.Buffer> buffersToRemove = new ArrayList<BuffersDataSource.Buffer>();
            for (BuffersDataSource.Buffer b : BuffersDataSource.getInstance().getBuffersForServer(cid)) {
                buffersToRemove.add(b);
            }
            for (BuffersDataSource.Buffer b : buffersToRemove) {
                BuffersDataSource.getInstance().deleteAllDataForBuffer(b.bid);
                Notifications.getInstance().deleteNotificationsForBid(b.bid);
            }
            this.servers.remove(cid);
        }
    }

    public synchronized SparseArray<Server> getServers() {
        return this.servers;
    }

    public Server getServer(int cid) {
        return (Server)this.servers.get(cid);
    }

    public Server getServer(String hostname) {
        for (int i = 0; i < this.servers.size(); ++i) {
            Server s = (Server)this.servers.valueAt(i);
            if (!s.hostname.equalsIgnoreCase(hostname)) continue;
            return s;
        }
        return null;
    }

    public Server getServer(String hostname, int port) {
        for (int i = 0; i < this.servers.size(); ++i) {
            Server s = (Server)this.servers.valueAt(i);
            if (!s.hostname.equalsIgnoreCase(hostname) || s.port != port) continue;
            return s;
        }
        return null;
    }

    public Server getServer(String hostname, boolean ssl) {
        for (int i = 0; i < this.servers.size(); ++i) {
            Server s = (Server)this.servers.valueAt(i);
            if (!s.hostname.equalsIgnoreCase(hostname) || (ssl || s.ssl != 0) && (!ssl || s.ssl <= 0)) continue;
            return s;
        }
        return null;
    }

    public static class Server
    implements Comparable<Server> {
        public int cid;
        public String name;
        public String hostname;
        public int port;
        public String nick;
        public String status;
        public long lag;
        public int ssl;
        public String realname;
        public String server_pass;
        public String nickserv_pass;
        public String join_commands;
        public ObjectNode fail_info;
        public String away;
        public String usermask;
        public String mode;
        public ObjectNode isupport;
        public JsonNode raw_ignores;
        public ArrayList<String> ignores;
        public int order;
        public String CHANTYPES;
        public ObjectNode PREFIX;
        public String MODE_OPER = "Y";
        public String MODE_OWNER = "q";
        public String MODE_ADMIN = "a";
        public String MODE_OP = "o";
        public String MODE_HALFOP = "h";
        public String MODE_VOICED = "v";

        @Override
        public int compareTo(Server another) {
            if (this.order != another.order) {
                return Integer.valueOf(this.order).compareTo(another.order);
            }
            return Integer.valueOf(this.cid).compareTo(another.cid);
        }
    }
}

