/*
 * Decompiled with CFR 0.152.
 */
package com.irccloud.android.data;

import android.annotation.SuppressLint;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.TreeMap;

@SuppressLint(value={"UseSparseArrays"})
public class UsersDataSource {
    private HashMap<Integer, TreeMap<String, User>> users;
    private Collator collator;
    private static UsersDataSource instance = null;
    private Comparator<String> comparator = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return UsersDataSource.this.collator.compare(o1, o2);
        }
    };

    public static synchronized UsersDataSource getInstance() {
        if (instance == null) {
            instance = new UsersDataSource();
        }
        return instance;
    }

    public UsersDataSource() {
        this.users = new HashMap();
        this.collator = Collator.getInstance();
        this.collator.setStrength(1);
    }

    public synchronized void clear() {
        this.users.clear();
    }

    public synchronized User createUser(int cid, int bid, String nick, String hostmask, String mode, int away) {
        return this.createUser(cid, bid, nick, hostmask, mode, away, true);
    }

    public synchronized User createUser(int cid, int bid, String nick, String hostmask, String mode, int away, boolean find_old) {
        User u = null;
        if (find_old) {
            u = this.getUser(bid, nick);
        }
        if (u == null) {
            u = new User();
            if (!this.users.containsKey(bid)) {
                this.users.put(bid, new TreeMap(this.comparator));
            }
            this.users.get(bid).put(nick.toLowerCase(), u);
        }
        u.cid = cid;
        u.bid = bid;
        u.nick = nick;
        u.nick_lowercase = nick.toLowerCase();
        u.hostmask = hostmask;
        u.mode = mode;
        u.away = away;
        u.joined = 1;
        return u;
    }

    public synchronized void deleteUser(int bid, String nick) {
        if (this.users.containsKey(bid)) {
            this.users.get(bid).remove(nick.toLowerCase());
        }
    }

    public synchronized void deleteUsersForBuffer(int bid) {
        this.users.remove(bid);
    }

    public synchronized void updateNick(int bid, String old_nick, String new_nick) {
        User u = this.getUser(bid, old_nick);
        if (u != null) {
            u.nick = new_nick;
            u.nick_lowercase = new_nick.toLowerCase();
            u.old_nick = old_nick;
            this.users.get(bid).remove(old_nick.toLowerCase());
            this.users.get(bid).put(new_nick.toLowerCase(), u);
        }
    }

    public synchronized void updateAway(int bid, String nick, int away) {
        User u = this.getUser(bid, nick);
        if (u != null) {
            u.away = away;
        }
    }

    public synchronized void updateHostmask(int bid, String nick, String hostmask) {
        User u = this.getUser(bid, nick);
        if (u != null) {
            u.hostmask = hostmask;
        }
    }

    public synchronized void updateMode(int bid, String nick, String mode) {
        User u = this.getUser(bid, nick);
        if (u != null) {
            u.mode = mode;
        }
    }

    public synchronized void updateAwayMsg(int bid, String nick, int away, String away_msg) {
        User u = this.getUser(bid, nick);
        if (u != null) {
            u.away = away;
            u.away_msg = away_msg;
        }
    }

    public synchronized ArrayList<User> getUsersForBuffer(int bid) {
        ArrayList<User> list = new ArrayList<User>();
        if (this.users.containsKey(bid)) {
            for (User u : this.users.get(bid).values()) {
                list.add(u);
            }
        }
        return list;
    }

    public synchronized User getUser(int bid, String nick) {
        if (nick != null && this.users.containsKey(bid) && this.users.get(bid).containsKey(nick.toLowerCase())) {
            return this.users.get(bid).get(nick.toLowerCase());
        }
        return null;
    }

    public synchronized User findUserOnConnection(int cid, String nick) {
        for (Integer bid : this.users.keySet()) {
            if (!this.users.get(bid).containsKey(nick.toLowerCase()) || this.users.get((Object)bid).get((Object)nick.toLowerCase()).cid != cid) continue;
            return this.users.get(bid).get(nick.toLowerCase());
        }
        return null;
    }

    public static class User {
        public int cid;
        public int bid;
        public String nick;
        public String old_nick = null;
        public String nick_lowercase;
        public String hostmask;
        public String mode;
        public int away;
        public String away_msg;
        public int joined;
        public long last_mention = -1L;
    }
}

