/*
 * Decompiled with CFR 0.152.
 */
package com.irccloud.android.fragment;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentActivity;
import android.support.v7.app.AlertDialog;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.fasterxml.jackson.databind.JsonNode;
import com.irccloud.android.IRCCloudApplication;
import com.irccloud.android.IRCCloudJSONObject;
import com.irccloud.android.NetworkConnection;
import com.irccloud.android.data.ServersDataSource;
import com.squareup.leakcanary.RefWatcher;

public class AcceptListFragment
extends DialogFragment {
    JsonNode acceptList;
    int cid;
    IRCCloudJSONObject event;
    AcceptListAdapter adapter;
    NetworkConnection conn;
    ListView listView;

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        FragmentActivity ctx = this.getActivity();
        LayoutInflater inflater = (LayoutInflater)ctx.getSystemService("layout_inflater");
        View v = inflater.inflate(2130903096, null);
        this.listView = (ListView)v.findViewById(16908298);
        TextView empty = (TextView)v.findViewById(16908292);
        empty.setText((CharSequence)"No accepted nicks.\n\nYou can accept someone by tapping their message request or by using /accept.");
        this.listView.setEmptyView((View)empty);
        if (savedInstanceState != null && savedInstanceState.containsKey("cid")) {
            this.cid = savedInstanceState.getInt("cid");
            this.event = new IRCCloudJSONObject(savedInstanceState.getString("event"));
            this.acceptList = this.event.getJsonNode("nicks");
            this.adapter = new AcceptListAdapter(this);
            this.listView.setAdapter((ListAdapter)this.adapter);
        }
        ServersDataSource.Server s = ServersDataSource.getInstance().getServer(this.cid);
        String network = s.name;
        if (network == null || network.length() == 0) {
            network = s.hostname;
        }
        AlertDialog d = new AlertDialog.Builder((Context)ctx).setInverseBackgroundForced(Build.VERSION.SDK_INT < 11).setTitle("Accept list for " + network).setView(v).setPositiveButton("Add Nickname", new AddClickListener()).setNegativeButton("Close", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        }).create();
        d.getWindow().setSoftInputMode(16);
        return d;
    }

    @Override
    public void onSaveInstanceState(Bundle state) {
        state.putInt("cid", this.cid);
        state.putString("event", this.event.toString());
    }

    @Override
    public void setArguments(Bundle args) {
        this.cid = args.getInt("cid", 0);
        this.event = new IRCCloudJSONObject(args.getString("event"));
        this.acceptList = this.event.getJsonNode("nicks");
        if (this.getActivity() != null && this.cid > 0 && this.listView != null) {
            this.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (AcceptListFragment.this.adapter == null) {
                        AcceptListFragment.this.adapter = new AcceptListAdapter(AcceptListFragment.this);
                        AcceptListFragment.this.listView.setAdapter((ListAdapter)AcceptListFragment.this.adapter);
                    } else {
                        AcceptListFragment.this.adapter.notifyDataSetChanged();
                    }
                }
            });
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        this.conn = NetworkConnection.getInstance();
        if (this.cid > 0) {
            this.adapter = new AcceptListAdapter(this);
            this.listView.setAdapter((ListAdapter)this.adapter);
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        RefWatcher refWatcher = IRCCloudApplication.getRefWatcher((Context)this.getActivity());
        refWatcher.watch(this);
    }

    class AddClickListener
    implements DialogInterface.OnClickListener {
        AddClickListener() {
        }

        public void onClick(DialogInterface d, int which) {
            FragmentActivity ctx = AcceptListFragment.this.getActivity();
            ServersDataSource s = ServersDataSource.getInstance();
            ServersDataSource.Server server = s.getServer(AcceptListFragment.this.cid);
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)ctx);
            builder.setInverseBackgroundForced(Build.VERSION.SDK_INT < 11);
            LayoutInflater inflater = (LayoutInflater)ctx.getSystemService("layout_inflater");
            View view = inflater.inflate(2130903091, null);
            TextView prompt = (TextView)view.findViewById(2131624120);
            final EditText input = (EditText)view.findViewById(2131624121);
            input.setHint((CharSequence)"nickname");
            prompt.setText((CharSequence)"Accept messages from this nickname");
            builder.setTitle(server.name + " (" + server.hostname + ":" + server.port + ")");
            builder.setView(view);
            builder.setPositiveButton("Accept", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    AcceptListFragment.this.conn.say(AcceptListFragment.this.cid, null, "/accept " + input.getText().toString());
                    AcceptListFragment.this.conn.say(AcceptListFragment.this.cid, null, "/accept *");
                    dialog.dismiss();
                }
            });
            builder.setNegativeButton("Cancel", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                }
            });
            AlertDialog dialog = builder.create();
            dialog.setOwnerActivity(AcceptListFragment.this.getActivity());
            dialog.getWindow().setSoftInputMode(5);
            dialog.show();
        }
    }

    private class AcceptListAdapter
    extends BaseAdapter {
        private DialogFragment ctx;
        View.OnClickListener removeClickListener = new View.OnClickListener(){

            public void onClick(View v) {
                Integer position = (Integer)v.getTag();
                try {
                    AcceptListFragment.this.conn.say(AcceptListFragment.this.cid, null, "/accept -" + AcceptListFragment.this.acceptList.get(position).asText());
                    AcceptListFragment.this.conn.say(AcceptListFragment.this.cid, null, "/accept *");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };

        public AcceptListAdapter(DialogFragment context) {
            this.ctx = context;
        }

        public int getCount() {
            return AcceptListFragment.this.acceptList.size();
        }

        public Object getItem(int pos) {
            try {
                return AcceptListFragment.this.acceptList.get(pos);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public long getItemId(int pos) {
            return pos;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            ViewHolder holder;
            View row = convertView;
            if (row != null && ((ViewHolder)row.getTag()).position != position) {
                row = null;
            }
            if (row == null) {
                LayoutInflater inflater = this.ctx.getLayoutInflater(null);
                row = inflater.inflate(2130903113, null);
                holder = new ViewHolder();
                holder.position = position;
                holder.user = (TextView)row.findViewById(2131624186);
                holder.removeBtn = (Button)row.findViewById(2131624187);
                row.setTag((Object)holder);
            } else {
                holder = (ViewHolder)row.getTag();
            }
            try {
                holder.user.setText((CharSequence)AcceptListFragment.this.acceptList.get(position).asText());
                holder.removeBtn.setOnClickListener(this.removeClickListener);
                holder.removeBtn.setTag((Object)position);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return row;
        }

        private class ViewHolder {
            int position;
            TextView user;
            Button removeBtn;

            private ViewHolder() {
            }
        }
    }
}

