/*
 * Decompiled with CFR 0.152.
 */
package com.irccloud.android.fragment;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentActivity;
import android.support.v7.app.AlertDialog;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import com.irccloud.android.IRCCloudApplication;
import com.irccloud.android.NetworkConnection;
import com.irccloud.android.activity.EditConnectionActivity;
import com.irccloud.android.data.ServersDataSource;
import com.irccloud.android.fragment.EditConnectionFragment;
import com.squareup.leakcanary.RefWatcher;
import java.util.ArrayList;

public class AddChannelFragment
extends DialogFragment {
    SparseArray<ServersDataSource.Server> servers;
    Spinner spinner;
    TextView channels;
    int defaultCid = -1;

    public void setDefaultCid(int cid) {
        this.defaultCid = cid;
    }

    @Override
    public void onResume() {
        int pos = 0;
        super.onResume();
        this.servers = ServersDataSource.getInstance().getServers();
        ArrayList<String> servernames = new ArrayList<String>();
        for (int i = 0; i < this.servers.size(); ++i) {
            servernames.add(((ServersDataSource.Server)this.servers.valueAt((int)i)).name);
            if (((ServersDataSource.Server)this.servers.valueAt((int)i)).cid != this.defaultCid) continue;
            pos = i;
        }
        ArrayAdapter adapter = new ArrayAdapter((Context)this.getActivity(), 17367048, 16908308, (Object[])servernames.toArray(new String[servernames.size()]));
        adapter.setDropDownViewResource(0x1090009);
        this.spinner.setAdapter((SpinnerAdapter)adapter);
        this.spinner.setSelection(pos);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        RefWatcher refWatcher = IRCCloudApplication.getRefWatcher((Context)this.getActivity());
        refWatcher.watch(this);
    }

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        FragmentActivity ctx = this.getActivity();
        LayoutInflater inflater = (LayoutInflater)ctx.getSystemService("layout_inflater");
        View v = inflater.inflate(2130903082, null);
        this.spinner = (Spinner)v.findViewById(2131624087);
        this.channels = (TextView)v.findViewById(2131624089);
        this.channels.setText((CharSequence)"");
        this.channels.append((CharSequence)"#");
        Button b = (Button)v.findViewById(2131624088);
        b.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!AddChannelFragment.this.getActivity().getResources().getBoolean(2131361795)) {
                    Intent i = new Intent((Context)AddChannelFragment.this.getActivity(), EditConnectionActivity.class);
                    AddChannelFragment.this.startActivity(i);
                } else {
                    EditConnectionFragment newFragment = new EditConnectionFragment();
                    newFragment.show(AddChannelFragment.this.getActivity().getSupportFragmentManager(), "editconnection");
                }
            }
        });
        return new AlertDialog.Builder((Context)ctx).setTitle("Join A Channel").setInverseBackgroundForced(Build.VERSION.SDK_INT < 11).setView(v).setPositiveButton("Join", new DoneClickListener()).setNegativeButton("Cancel", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        }).create();
    }

    class DoneClickListener
    implements DialogInterface.OnClickListener {
        DoneClickListener() {
        }

        public void onClick(DialogInterface dialog, int which) {
            int pos = AddChannelFragment.this.spinner.getSelectedItemPosition();
            if (pos >= 0 && pos < AddChannelFragment.this.servers.size()) {
                int cid = ((ServersDataSource.Server)AddChannelFragment.this.servers.valueAt((int)AddChannelFragment.this.spinner.getSelectedItemPosition())).cid;
                String[] splitchannels = AddChannelFragment.this.channels.getText().toString().split(",");
                for (int i = 0; i < splitchannels.length; ++i) {
                    String[] channelandkey = splitchannels[i].split(" ");
                    if (channelandkey.length > 1) {
                        NetworkConnection.getInstance().join(cid, channelandkey[0].trim(), channelandkey[1]);
                        continue;
                    }
                    NetworkConnection.getInstance().join(cid, channelandkey[0].trim(), "");
                }
                AddChannelFragment.this.dismiss();
            }
        }
    }
}

