/*
 * Decompiled with CFR 0.152.
 */
package com.irccloud.android.fragment;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentActivity;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.SwitchCompat;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Toast;
import com.crashlytics.android.Crashlytics;
import com.irccloud.android.IRCCloudApplication;
import com.irccloud.android.NetworkConnection;
import com.squareup.leakcanary.RefWatcher;
import org.json.JSONException;
import org.json.JSONObject;

@SuppressLint(value={"ValidFragment"})
public class BufferOptionsFragment
extends DialogFragment {
    SwitchCompat unread;
    SwitchCompat joinpart;
    SwitchCompat collapse;
    SwitchCompat expandDisco;
    int cid;
    int bid;
    String type;

    public BufferOptionsFragment() {
        this.bid = -1;
        this.cid = -1;
        this.type = null;
    }

    public BufferOptionsFragment(int cid, int bid, String type) {
        this.cid = cid;
        this.bid = bid;
        this.type = type;
    }

    public JSONObject updatePref(JSONObject prefs, SwitchCompat control, String key) throws JSONException {
        if (!control.isChecked()) {
            JSONObject map = prefs.has(key) ? prefs.getJSONObject(key) : new JSONObject();
            map.put(String.valueOf(this.bid), true);
            prefs.put(key, (Object)map);
        } else if (prefs.has(key)) {
            JSONObject map = prefs.getJSONObject(key);
            map.remove(String.valueOf(this.bid));
            prefs.put(key, (Object)map);
        }
        return prefs;
    }

    @Override
    public void onResume() {
        super.onResume();
        try {
            if (NetworkConnection.getInstance().getUserInfo() != null) {
                JSONObject prefs = NetworkConnection.getInstance().getUserInfo().prefs;
                if (prefs != null) {
                    JSONObject expandMap;
                    if (prefs.has("buffer-hideJoinPart")) {
                        JSONObject hiddenMap = prefs.getJSONObject("buffer-hideJoinPart");
                        if (hiddenMap.has(String.valueOf(this.bid)) && hiddenMap.getBoolean(String.valueOf(this.bid))) {
                            this.joinpart.setChecked(false);
                        } else {
                            this.joinpart.setChecked(true);
                        }
                    } else {
                        this.joinpart.setChecked(true);
                    }
                    if (prefs.has("buffer-disableTrackUnread")) {
                        JSONObject unreadMap = prefs.getJSONObject("buffer-disableTrackUnread");
                        if (unreadMap.has(String.valueOf(this.bid)) && unreadMap.getBoolean(String.valueOf(this.bid))) {
                            this.unread.setChecked(false);
                        } else {
                            this.unread.setChecked(true);
                        }
                    } else {
                        this.unread.setChecked(true);
                    }
                    if (prefs.has("buffer-expandJoinPart")) {
                        expandMap = prefs.getJSONObject("buffer-expandJoinPart");
                        if (expandMap.has(String.valueOf(this.bid)) && expandMap.getBoolean(String.valueOf(this.bid))) {
                            this.collapse.setChecked(false);
                        } else {
                            this.collapse.setChecked(true);
                        }
                    } else {
                        this.collapse.setChecked(true);
                    }
                    if (prefs.has("buffer-expandDisco")) {
                        expandMap = prefs.getJSONObject("buffer-expandDisco");
                        if (expandMap.has(String.valueOf(this.bid)) && expandMap.getBoolean(String.valueOf(this.bid))) {
                            this.expandDisco.setChecked(false);
                        } else {
                            this.expandDisco.setChecked(true);
                        }
                    } else {
                        this.expandDisco.setChecked(true);
                    }
                } else {
                    this.joinpart.setChecked(true);
                    this.unread.setChecked(true);
                    this.collapse.setChecked(true);
                    this.expandDisco.setChecked(true);
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        FragmentActivity ctx = this.getActivity();
        LayoutInflater inflater = (LayoutInflater)ctx.getSystemService("layout_inflater");
        View v = inflater.inflate(2130903083, null);
        this.unread = (SwitchCompat)v.findViewById(2131624090);
        this.joinpart = (SwitchCompat)v.findViewById(2131624091);
        this.collapse = (SwitchCompat)v.findViewById(2131624092);
        this.expandDisco = (SwitchCompat)v.findViewById(2131624093);
        if (savedInstanceState != null && this.bid == -1 && savedInstanceState.containsKey("bid")) {
            this.bid = savedInstanceState.getInt("bid");
            this.cid = savedInstanceState.getInt("cid");
            this.type = savedInstanceState.getString("type");
        }
        if (this.type != null && this.type.equalsIgnoreCase("console")) {
            this.joinpart.setVisibility(8);
            this.collapse.setVisibility(8);
        } else {
            this.expandDisco.setVisibility(8);
        }
        return new AlertDialog.Builder((Context)ctx).setInverseBackgroundForced(Build.VERSION.SDK_INT < 11).setTitle("Display Options").setView(v).setPositiveButton("Save", new SaveClickListener()).setNegativeButton("Cancel", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        }).create();
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt("bid", this.bid);
        outState.putInt("cid", this.cid);
        outState.putString("type", this.type);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        RefWatcher refWatcher = IRCCloudApplication.getRefWatcher((Context)this.getActivity());
        refWatcher.watch(this);
    }

    class SaveClickListener
    implements DialogInterface.OnClickListener {
        SaveClickListener() {
        }

        public void onClick(DialogInterface dialog, int which) {
            JSONObject prefs = null;
            try {
                if (NetworkConnection.getInstance().getUserInfo() != null) {
                    prefs = NetworkConnection.getInstance().getUserInfo().prefs;
                    if (prefs == null) {
                        prefs = new JSONObject();
                        Crashlytics.logException(new Exception("Users prefs was null, creating new object"));
                    }
                    prefs = BufferOptionsFragment.this.updatePref(prefs, BufferOptionsFragment.this.unread, "buffer-disableTrackUnread");
                    if (!BufferOptionsFragment.this.type.equalsIgnoreCase("console")) {
                        prefs = BufferOptionsFragment.this.updatePref(prefs, BufferOptionsFragment.this.joinpart, "buffer-hideJoinPart");
                        prefs = BufferOptionsFragment.this.updatePref(prefs, BufferOptionsFragment.this.collapse, "buffer-expandJoinPart");
                    } else {
                        prefs = BufferOptionsFragment.this.updatePref(prefs, BufferOptionsFragment.this.expandDisco, "buffer-expandDisco");
                    }
                    NetworkConnection.getInstance().set_prefs(prefs.toString());
                } else {
                    Toast.makeText((Context)BufferOptionsFragment.this.getActivity(), (CharSequence)"An error occurred while saving preferences.  Please try again shortly", (int)0).show();
                }
            }
            catch (Exception e) {
                Crashlytics.logException(e);
                Toast.makeText((Context)BufferOptionsFragment.this.getActivity(), (CharSequence)"An error occurred while saving preferences.  Please try again shortly", (int)0).show();
            }
            BufferOptionsFragment.this.dismiss();
        }
    }
}

