/*
 * Decompiled with CFR 0.152.
 */
package com.irccloud.android.fragment;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.os.Bundle;
import android.support.v4.app.ListFragment;
import android.util.DisplayMetrics;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.crashlytics.android.Crashlytics;
import com.fasterxml.jackson.databind.JsonNode;
import com.irccloud.android.AsyncTaskEx;
import com.irccloud.android.IRCCloudApplication;
import com.irccloud.android.IRCCloudJSONObject;
import com.irccloud.android.NetworkConnection;
import com.irccloud.android.data.BuffersDataSource;
import com.irccloud.android.data.ChannelsDataSource;
import com.irccloud.android.data.EventsDataSource;
import com.irccloud.android.data.ServersDataSource;
import com.irccloud.android.fragment.AddChannelFragment;
import com.squareup.leakcanary.RefWatcher;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class BuffersListFragment
extends ListFragment
implements NetworkConnection.IRCEventHandler {
    private static final int TYPE_SERVER = 0;
    private static final int TYPE_CHANNEL = 1;
    private static final int TYPE_CONVERSATION = 2;
    private static final int TYPE_ARCHIVES_HEADER = 3;
    private static final int TYPE_JOIN_CHANNEL = 4;
    private static final int TYPE_ADD_NETWORK = 5;
    private static final int TYPE_REORDER = 6;
    NetworkConnection conn;
    BufferListAdapter adapter;
    OnBufferSelectedListener mListener;
    View view;
    ListView listView = null;
    LinearLayout topUnreadIndicator = null;
    LinearLayout topUnreadIndicatorColor = null;
    LinearLayout topUnreadIndicatorBorder = null;
    LinearLayout bottomUnreadIndicator = null;
    LinearLayout bottomUnreadIndicatorColor = null;
    LinearLayout bottomUnreadIndicatorBorder = null;
    int selected_bid = -1;
    RefreshTask refreshTask = null;
    private boolean ready = false;
    public boolean readOnly = false;
    int firstUnreadPosition = -1;
    int lastUnreadPosition = -1;
    int firstHighlightPosition = -1;
    int lastHighlightPosition = -1;
    int firstFailurePosition = -1;
    int lastFailurePosition = -1;
    SparseBooleanArray mExpandArchives = new SparseBooleanArray();

    public void setSelectedBid(int bid) {
        int last_bid = this.selected_bid;
        this.selected_bid = bid;
        if (this.adapter != null) {
            BuffersDataSource.Buffer b = BuffersDataSource.getInstance().getBuffer(last_bid);
            if (b != null) {
                this.adapter.updateBuffer(b);
            }
            if ((b = BuffersDataSource.getInstance().getBuffer(bid)) != null) {
                this.adapter.updateBuffer(b);
            }
            this.adapter.showProgress(this.adapter.positionForBid(bid));
        } else {
            Crashlytics.log(5, "IRCCloud", "BufferListFragment: Request to set BID but I don't have an adapter yet, refreshing");
            RefreshTask t = new RefreshTask();
            t.doInBackground(new Void[]{null});
            t.onPostExecute(null);
            Crashlytics.log(3, "IRCCloud", "Done");
        }
    }

    private void updateUnreadIndicators(int first, int last) {
        if (this.readOnly) {
            if (this.topUnreadIndicator != null) {
                this.topUnreadIndicator.setVisibility(8);
            }
            if (this.bottomUnreadIndicator != null) {
                this.bottomUnreadIndicator.setVisibility(8);
            }
        } else {
            if (this.topUnreadIndicator != null) {
                if (this.firstFailurePosition != -1 && first > this.firstFailurePosition) {
                    this.topUnreadIndicator.setVisibility(0);
                    this.topUnreadIndicatorColor.setBackgroundResource(2130837725);
                    this.topUnreadIndicatorBorder.setBackgroundResource(2130837724);
                } else {
                    this.topUnreadIndicator.setVisibility(8);
                }
                if (this.firstUnreadPosition != -1 && first > this.firstUnreadPosition) {
                    this.topUnreadIndicator.setVisibility(0);
                    this.topUnreadIndicatorColor.setBackgroundResource(2130837731);
                    this.topUnreadIndicatorBorder.setBackgroundResource(2130837734);
                }
                if (this.lastHighlightPosition != -1 && first > this.lastHighlightPosition || this.firstHighlightPosition != -1 && first > this.firstHighlightPosition) {
                    this.topUnreadIndicator.setVisibility(0);
                    this.topUnreadIndicatorColor.setBackgroundResource(2130837721);
                    this.topUnreadIndicatorBorder.setBackgroundResource(2130837720);
                }
            }
            if (this.bottomUnreadIndicator != null) {
                if (this.lastFailurePosition != -1 && last < this.lastFailurePosition) {
                    this.bottomUnreadIndicator.setVisibility(0);
                    this.bottomUnreadIndicatorColor.setBackgroundResource(2130837725);
                    this.bottomUnreadIndicatorBorder.setBackgroundResource(2130837724);
                } else {
                    this.bottomUnreadIndicator.setVisibility(8);
                }
                if (this.lastUnreadPosition != -1 && last < this.lastUnreadPosition) {
                    this.bottomUnreadIndicator.setVisibility(0);
                    this.bottomUnreadIndicatorColor.setBackgroundResource(2130837731);
                    this.bottomUnreadIndicatorBorder.setBackgroundResource(2130837734);
                }
                if (this.firstHighlightPosition != -1 && last < this.firstHighlightPosition || this.lastHighlightPosition != -1 && last < this.lastHighlightPosition) {
                    this.bottomUnreadIndicator.setVisibility(0);
                    this.bottomUnreadIndicatorColor.setBackgroundResource(2130837721);
                    this.bottomUnreadIndicatorBorder.setBackgroundResource(2130837720);
                }
            }
        }
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.conn = NetworkConnection.getInstance();
        this.view = inflater.inflate(2130903081, null);
        this.topUnreadIndicator = (LinearLayout)this.view.findViewById(2131624081);
        this.topUnreadIndicator.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int scrollTo = BuffersListFragment.this.adapter.unreadPositionAbove(BuffersListFragment.this.getListView().getFirstVisiblePosition());
                if (scrollTo > 0) {
                    BuffersListFragment.this.getListView().setSelection(scrollTo - 1);
                } else {
                    BuffersListFragment.this.getListView().setSelection(0);
                }
                BuffersListFragment.this.updateUnreadIndicators(BuffersListFragment.this.getListView().getFirstVisiblePosition(), BuffersListFragment.this.getListView().getLastVisiblePosition());
            }
        });
        this.topUnreadIndicatorColor = (LinearLayout)this.view.findViewById(2131624083);
        this.topUnreadIndicatorBorder = (LinearLayout)this.view.findViewById(2131624082);
        this.bottomUnreadIndicator = (LinearLayout)this.view.findViewById(2131624084);
        this.bottomUnreadIndicator.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int offset = BuffersListFragment.this.getListView().getLastVisiblePosition() - BuffersListFragment.this.getListView().getFirstVisiblePosition();
                int scrollTo = BuffersListFragment.this.adapter.unreadPositionBelow(BuffersListFragment.this.getListView().getLastVisiblePosition()) - offset + 2;
                if (scrollTo < BuffersListFragment.this.adapter.getCount()) {
                    BuffersListFragment.this.getListView().setSelection(scrollTo);
                } else {
                    BuffersListFragment.this.getListView().setSelection(BuffersListFragment.this.adapter.getCount() - 1);
                }
                BuffersListFragment.this.updateUnreadIndicators(BuffersListFragment.this.getListView().getFirstVisiblePosition(), BuffersListFragment.this.getListView().getLastVisiblePosition());
            }
        });
        this.bottomUnreadIndicatorColor = (LinearLayout)this.view.findViewById(2131624086);
        this.bottomUnreadIndicatorBorder = (LinearLayout)this.view.findViewById(2131624085);
        this.listView = (ListView)this.view.findViewById(16908298);
        this.listView.setOnScrollListener(new AbsListView.OnScrollListener(){

            public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
                BuffersListFragment.this.updateUnreadIndicators(firstVisibleItem, firstVisibleItem + visibleItemCount - 1);
            }

            public void onScrollStateChanged(AbsListView view, int scrollState) {
            }
        });
        this.listView.setOnItemLongClickListener(new AdapterView.OnItemLongClickListener(){

            public boolean onItemLongClick(AdapterView<?> arg0, View arg1, int pos, long id2) {
                return BuffersListFragment.this.mListener.onBufferLongClicked(BuffersDataSource.getInstance().getBuffer(BuffersListFragment.this.adapter.data.get((int)pos).bid));
            }
        });
        this.ready = NetworkConnection.getInstance().ready;
        if (this.ready) {
            if (savedInstanceState != null && savedInstanceState.containsKey("expandedArchives")) {
                ArrayList expandedArchives = savedInstanceState.getIntegerArrayList("expandedArchives");
                for (Integer cid : expandedArchives) {
                    this.mExpandArchives.put(cid.intValue(), true);
                }
            }
            this.refreshTask = new RefreshTask();
            this.refreshTask.doInBackground(new Void[]{null});
            this.refreshTask.onPostExecute(null);
            if (savedInstanceState != null && savedInstanceState.containsKey("scrollPosition")) {
                this.listView.setSelection(savedInstanceState.getInt("scrollPosition"));
            }
        }
        return this.view;
    }

    @Override
    public void onSaveInstanceState(Bundle state) {
        if (this.adapter != null && this.adapter.data != null && this.adapter.data.size() > 0) {
            ArrayList<Integer> expandedArchives = new ArrayList<Integer>();
            SparseArray<ServersDataSource.Server> servers = ServersDataSource.getInstance().getServers();
            for (int i = 0; i < servers.size(); ++i) {
                ServersDataSource.Server s = (ServersDataSource.Server)servers.valueAt(i);
                if (!this.mExpandArchives.get(s.cid, false)) continue;
                expandedArchives.add(s.cid);
            }
            state.putIntegerArrayList("expandedArchives", expandedArchives);
            if (this.listView != null) {
                state.putInt("scrollPosition", this.listView.getFirstVisiblePosition());
            }
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        this.conn.addHandler(this);
        this.ready = this.conn.ready;
        if (this.adapter != null) {
            this.adapter.showProgress(-1);
        }
        this.refresh();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        RefWatcher refWatcher = IRCCloudApplication.getRefWatcher((Context)this.getActivity());
        refWatcher.watch(this);
    }

    @Override
    public void onPause() {
        super.onPause();
        if (this.conn != null) {
            this.conn.removeHandler(this);
        }
    }

    @Override
    public void onAttach(Activity activity) {
        super.onAttach(activity);
        try {
            this.mListener = (OnBufferSelectedListener)activity;
        }
        catch (ClassCastException e) {
            throw new ClassCastException(activity.toString() + " must implement OnBufferSelectedListener");
        }
    }

    @Override
    public void onListItemClick(ListView l, View v, int position, long id2) {
        BufferListEntry e = (BufferListEntry)this.adapter.getItem(position);
        switch (e.type) {
            case 5: {
                this.mListener.addNetwork();
                return;
            }
            case 6: {
                this.mListener.reorder();
                return;
            }
            case 3: {
                this.mExpandArchives.put(e.cid, !this.mExpandArchives.get(e.cid, false));
                this.refresh();
                return;
            }
            case 4: {
                AddChannelFragment newFragment = new AddChannelFragment();
                newFragment.setDefaultCid(e.cid);
                newFragment.show(this.getActivity().getSupportFragmentManager(), "dialog");
                this.mListener.addButtonPressed(e.cid);
                return;
            }
        }
        this.adapter.showProgress(position);
        this.mListener.onBufferSelected(e.bid);
    }

    @Override
    public void onIRCEvent(int what, Object obj) {
        IRCCloudJSONObject object = null;
        try {
            object = (IRCCloudJSONObject)obj;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        EventsDataSource.Event event = null;
        try {
            event = (EventsDataSource.Event)obj;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        switch (what) {
            case 23: {
                BuffersDataSource.Buffer b = BuffersDataSource.getInstance().getBuffer(object.bid());
                if (b == null || this.adapter == null) break;
                this.adapter.updateBuffer(b);
                break;
            }
            case 18: {
                if (this.adapter == null) break;
                ArrayList<BuffersDataSource.Buffer> buffers = BuffersDataSource.getInstance().getBuffersForServer(object.cid());
                for (BuffersDataSource.Buffer buffer : buffers) {
                    this.adapter.updateBuffer(buffer);
                }
                break;
            }
            case 5: {
                BuffersDataSource.Buffer b;
                if (this.adapter == null || event.bid == this.selected_bid || (b = BuffersDataSource.getInstance().getBuffer(event.bid)) == null || !event.isImportant(b.type)) break;
                this.adapter.updateBuffer(b);
                break;
            }
            case 6: {
                if (this.adapter == null) break;
                JsonNode seenEids = object.getJsonNode("seenEids");
                Iterator<Map.Entry<String, JsonNode>> iterator = seenEids.fields();
                int count = 0;
                while (iterator.hasNext()) {
                    Map.Entry<String, JsonNode> entry = iterator.next();
                    JsonNode eids = entry.getValue();
                    Iterator<Map.Entry<String, JsonNode>> j = eids.fields();
                    while (j.hasNext()) {
                        Map.Entry<String, JsonNode> eidentry = j.next();
                        Integer bid = Integer.valueOf(eidentry.getKey());
                        BuffersDataSource.Buffer b = BuffersDataSource.getInstance().getBuffer(bid);
                        if (b != null) {
                            this.adapter.updateBuffer(b);
                        }
                        ++count;
                    }
                }
                if (count <= true) break;
                this.getActivity().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        BuffersListFragment.this.refresh();
                    }
                });
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 22: {
                if (!object.type().startsWith("you_") || this.getActivity() == null) break;
                this.getActivity().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        BuffersListFragment.this.refresh();
                    }
                });
                break;
            }
            case 1: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 999: {
                break;
            }
            case 0: {
                if (this.getActivity() == null) break;
                this.getActivity().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (BuffersListFragment.this.adapter != null) {
                            BuffersListFragment.this.adapter.notifyDataSetChanged();
                        }
                    }
                });
                break;
            }
            case 100: {
                if (this.refreshTask == null) break;
                this.refreshTask.cancel(true);
                break;
            }
            case 101: {
                this.ready = true;
                if (obj != null && this.adapter != null) {
                    Integer bid = (Integer)obj;
                    BuffersDataSource.Buffer b = BuffersDataSource.getInstance().getBuffer(bid);
                    if (b == null) break;
                    this.adapter.updateBuffer(b);
                    break;
                }
                if (this.getActivity() == null) break;
                this.getActivity().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (BuffersListFragment.this.refreshTask != null) {
                            BuffersListFragment.this.refreshTask.cancel(true);
                        }
                        Crashlytics.log(3, "IRCCloud", "Refreshing buffers list");
                        RefreshTask t = new RefreshTask();
                        t.doInBackground(new Void[]{null});
                        t.onPostExecute(null);
                        Crashlytics.log(3, "IRCCloud", "Done");
                    }
                });
                break;
            }
            default: {
                Crashlytics.log(5, "IRCCloud", "Slow event: " + what);
                if (this.getActivity() == null) break;
                this.getActivity().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        BuffersListFragment.this.refresh();
                    }
                });
            }
        }
    }

    public void refresh() {
        if (this.refreshTask != null) {
            this.refreshTask.cancel(true);
        }
        this.refreshTask = new RefreshTask();
        this.refreshTask.execute(new Void[]{null});
    }

    public Resources getSafeResources() {
        return IRCCloudApplication.getInstance().getApplicationContext().getResources();
    }

    public static interface OnBufferSelectedListener {
        public void onBufferSelected(int var1);

        public boolean onBufferLongClicked(BuffersDataSource.Buffer var1);

        public void addButtonPressed(int var1);

        public void addNetwork();

        public void reorder();
    }

    private class RefreshTask
    extends AsyncTaskEx<Void, Void, Void> {
        ArrayList<BufferListEntry> entries = new ArrayList();

        private RefreshTask() {
        }

        protected synchronized Void doInBackground(Void ... params) {
            if (!BuffersListFragment.this.ready || this.isCancelled()) {
                Crashlytics.log(5, "IRCCloud", "BuffersListFragment not ready or cancelled");
                return null;
            }
            SparseArray<ServersDataSource.Server> serversArray = ServersDataSource.getInstance().getServers();
            ArrayList<Object> servers = new ArrayList<Object>();
            for (int i = 0; i < serversArray.size(); ++i) {
                servers.add(serversArray.valueAt(i));
            }
            Collections.sort(servers);
            if (BuffersListFragment.this.adapter == null) {
                Crashlytics.log(3, "IRCCloud", "Created new BufferListAdapter");
                BuffersListFragment.this.adapter = new BufferListAdapter(BuffersListFragment.this);
            }
            BuffersListFragment.this.firstUnreadPosition = -1;
            BuffersListFragment.this.lastUnreadPosition = -1;
            BuffersListFragment.this.firstHighlightPosition = -1;
            BuffersListFragment.this.lastHighlightPosition = -1;
            BuffersListFragment.this.firstFailurePosition = -1;
            BuffersListFragment.this.lastFailurePosition = -1;
            int position = 0;
            JSONObject channelDisabledMap = null;
            JSONObject bufferDisabledMap = null;
            if (BuffersListFragment.this.conn != null && BuffersListFragment.this.conn.getUserInfo() != null && BuffersListFragment.this.conn.getUserInfo().prefs != null) {
                try {
                    if (BuffersListFragment.this.conn.getUserInfo().prefs.has("channel-disableTrackUnread")) {
                        channelDisabledMap = BuffersListFragment.this.conn.getUserInfo().prefs.getJSONObject("channel-disableTrackUnread");
                    }
                    if (BuffersListFragment.this.conn.getUserInfo().prefs.has("buffer-disableTrackUnread")) {
                        bufferDisabledMap = BuffersListFragment.this.conn.getUserInfo().prefs.getJSONObject("buffer-disableTrackUnread");
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            for (ServersDataSource.Server server : servers) {
                int type;
                if (this.isCancelled()) {
                    return null;
                }
                int archiveCount = 0;
                ArrayList<BuffersDataSource.Buffer> buffers = BuffersDataSource.getInstance().getBuffersForServer(server.cid);
                for (int j = 0; j < buffers.size(); ++j) {
                    if (this.isCancelled()) {
                        return null;
                    }
                    BuffersDataSource.Buffer b = buffers.get(j);
                    if (!b.type.equalsIgnoreCase("console")) continue;
                    int unread = 0;
                    int highlights = 0;
                    if (BuffersListFragment.this.conn.getState() == 2 && BuffersListFragment.this.conn.ready) {
                        unread = b.unread;
                        highlights = b.highlights;
                    }
                    if (server.name.length() == 0) {
                        server.name = server.hostname;
                    }
                    try {
                        if (b.bid == BuffersListFragment.this.selected_bid || bufferDisabledMap != null && bufferDisabledMap.has(String.valueOf(b.bid)) && bufferDisabledMap.getBoolean(String.valueOf(b.bid))) {
                            unread = 0;
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    this.entries.add(BuffersListFragment.this.adapter.buildItem(b.cid, b.bid, 0, server.name, 0, unread, highlights, b.last_seen_eid, b.min_eid, 1, b.archived, server.status, 0, server.ssl, buffers.size(), "Network " + server.name, server.fail_info));
                    if (unread > 0 && BuffersListFragment.this.firstUnreadPosition == -1) {
                        BuffersListFragment.this.firstUnreadPosition = position;
                    }
                    if (unread > 0 && (BuffersListFragment.this.lastUnreadPosition == -1 || BuffersListFragment.this.lastUnreadPosition < position)) {
                        BuffersListFragment.this.lastUnreadPosition = position;
                    }
                    if (highlights > 0 && BuffersListFragment.this.firstHighlightPosition == -1) {
                        BuffersListFragment.this.firstHighlightPosition = position;
                    }
                    if (highlights > 0 && (BuffersListFragment.this.lastHighlightPosition == -1 || BuffersListFragment.this.lastHighlightPosition < position)) {
                        BuffersListFragment.this.lastHighlightPosition = position;
                    }
                    if (server.fail_info != null && server.fail_info.has("type")) {
                        if (BuffersListFragment.this.firstFailurePosition == -1) {
                            BuffersListFragment.this.firstFailurePosition = position;
                        }
                        if (BuffersListFragment.this.lastFailurePosition == -1 || BuffersListFragment.this.lastFailurePosition < position) {
                            BuffersListFragment.this.lastFailurePosition = position;
                        }
                    }
                    ++position;
                    break;
                }
                for (BuffersDataSource.Buffer b : buffers) {
                    if (this.isCancelled()) {
                        return null;
                    }
                    type = -1;
                    int key = 0;
                    int joined = 1;
                    if (b.type.equalsIgnoreCase("channel")) {
                        type = 1;
                        ChannelsDataSource.Channel c = ChannelsDataSource.getInstance().getChannelForBuffer(b.bid);
                        if (c == null) {
                            joined = 0;
                        }
                        if (c != null && c.key) {
                            key = 1;
                        }
                    } else if (b.type.equalsIgnoreCase("conversation")) {
                        type = 2;
                    }
                    if (type > 0 && b.archived == 0) {
                        int unread = 0;
                        int highlights = 0;
                        String contentDescription = null;
                        if (BuffersListFragment.this.conn.getState() == 2 && BuffersListFragment.this.conn.ready) {
                            unread = b.unread;
                            highlights = b.highlights;
                        }
                        try {
                            if (b.type.equalsIgnoreCase("channel")) {
                                contentDescription = "Channel " + b.normalizedName();
                                if (b.bid == BuffersListFragment.this.selected_bid || channelDisabledMap != null && channelDisabledMap.has(String.valueOf(b.bid)) && channelDisabledMap.getBoolean(String.valueOf(b.bid))) {
                                    unread = 0;
                                }
                            } else {
                                contentDescription = "Conversation with " + b.normalizedName();
                                if (b.bid == BuffersListFragment.this.selected_bid || bufferDisabledMap != null && bufferDisabledMap.has(String.valueOf(b.bid)) && bufferDisabledMap.getBoolean(String.valueOf(b.bid))) {
                                    unread = 0;
                                }
                                if (b.type.equalsIgnoreCase("conversation") && bufferDisabledMap != null && bufferDisabledMap.has(String.valueOf(b.bid)) && bufferDisabledMap.getBoolean(String.valueOf(b.bid))) {
                                    highlights = 0;
                                }
                            }
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                        }
                        this.entries.add(BuffersListFragment.this.adapter.buildItem(b.cid, b.bid, type, b.name, key, unread, highlights, b.last_seen_eid, b.min_eid, joined, b.archived, server.status, b.timeout, server.ssl, 0, contentDescription, null));
                        if (unread > 0 && BuffersListFragment.this.firstUnreadPosition == -1) {
                            BuffersListFragment.this.firstUnreadPosition = position;
                        }
                        if (unread > 0 && (BuffersListFragment.this.lastUnreadPosition == -1 || BuffersListFragment.this.lastUnreadPosition < position)) {
                            BuffersListFragment.this.lastUnreadPosition = position;
                        }
                        if (highlights > 0 && BuffersListFragment.this.firstHighlightPosition == -1) {
                            BuffersListFragment.this.firstHighlightPosition = position;
                        }
                        if (highlights > 0 && (BuffersListFragment.this.lastHighlightPosition == -1 || BuffersListFragment.this.lastHighlightPosition < position)) {
                            BuffersListFragment.this.lastHighlightPosition = position;
                        }
                        ++position;
                    }
                    if (type <= 0 || b.archived <= 0) continue;
                    ++archiveCount;
                }
                if (archiveCount > 0) {
                    this.entries.add(BuffersListFragment.this.adapter.buildItem(server.cid, 0, 3, "Archives", 0, 0, 0, 0L, 0L, 0, 1, server.status, 0, server.ssl, 0, "Archives", null));
                    ++position;
                    if (BuffersListFragment.this.mExpandArchives.get(server.cid, false)) {
                        for (BuffersDataSource.Buffer b : buffers) {
                            type = -1;
                            String contentDescription = null;
                            if (b.archived != 1) continue;
                            if (b.type.equalsIgnoreCase("channel")) {
                                type = 1;
                                contentDescription = "Channel: " + b.normalizedName();
                            } else if (b.type.equalsIgnoreCase("conversation")) {
                                type = 2;
                                contentDescription = "Conversation with " + b.normalizedName();
                            }
                            if (type <= 0) continue;
                            this.entries.add(BuffersListFragment.this.adapter.buildItem(b.cid, b.bid, type, b.name, 0, 0, 0, b.last_seen_eid, b.min_eid, 0, b.archived, server.status, 0, server.ssl, 0, contentDescription, null));
                            ++position;
                        }
                    }
                }
                if (buffers.size() != 1 || BuffersListFragment.this.readOnly) continue;
                this.entries.add(BuffersListFragment.this.adapter.buildItem(server.cid, 0, 4, "Join a channel\u2026", 0, 0, 0, 0L, 0L, 0, 1, server.status, 0, server.ssl, 0, "Join a channel", null));
            }
            if (!BuffersListFragment.this.readOnly) {
                this.entries.add(BuffersListFragment.this.adapter.buildItem(0, 0, 5, "Add a network", 0, 0, 0, 0L, 0L, 0, 1, "connected_ready", 0, 0, 0, "Add a network", null));
                this.entries.add(BuffersListFragment.this.adapter.buildItem(0, 0, 6, "Reorder", 0, 0, 0, 0L, 0L, 0, 1, "connected_ready", 0, 0, 0, "Reorder", null));
            }
            Crashlytics.log(3, "IRCCloud", "Buffers list adapter contains " + this.entries.size() + " entries");
            return null;
        }

        @Override
        protected void onPostExecute(Void result) {
            if (this.isCancelled()) {
                Crashlytics.log(5, "IRCCloud", "BuffersListFragment: OnPostExecute: This refresh task was cancelled");
                return;
            }
            BuffersListFragment.this.refreshTask = null;
            if (BuffersListFragment.this.adapter == null) {
                return;
            }
            BuffersListFragment.this.adapter.setItems(this.entries);
            if (BuffersListFragment.this.getListAdapter() == null && this.entries.size() > 0) {
                BuffersListFragment.this.setListAdapter((ListAdapter)BuffersListFragment.this.adapter);
            } else {
                BuffersListFragment.this.adapter.notifyDataSetChanged();
            }
            if (BuffersListFragment.this.listView != null) {
                BuffersListFragment.this.updateUnreadIndicators(BuffersListFragment.this.listView.getFirstVisiblePosition(), BuffersListFragment.this.listView.getLastVisiblePosition());
            } else {
                Crashlytics.log(5, "IRCCloud", "BuffersListFragment: OnPostExecute: The activity isn't ready yet, will retry");
                BuffersListFragment.this.refreshTask = new RefreshTask();
                BuffersListFragment.this.refreshTask.execute(new Void[]{null});
            }
            if (BuffersListFragment.this.selected_bid > 0) {
                BuffersListFragment.this.adapter.showProgress(BuffersListFragment.this.adapter.positionForBid(BuffersListFragment.this.selected_bid));
            }
        }
    }

    private class BufferListAdapter
    extends BaseAdapter {
        ArrayList<BufferListEntry> data;
        private ListFragment ctx;
        int progressRow = -1;
        private int eightdp = 0;

        public void showProgress(int row) {
            this.progressRow = row;
            this.notifyDataSetChanged();
        }

        public int positionForBid(int bid) {
            for (int i = 0; i < this.data.size(); ++i) {
                BufferListEntry e = this.data.get(i);
                if (e.bid != bid) continue;
                return i;
            }
            return -1;
        }

        public BufferListAdapter(ListFragment context) {
            this.ctx = context;
            this.data = new ArrayList();
            this.eightdp = (int)TypedValue.applyDimension((int)1, (float)8.0f, (DisplayMetrics)BuffersListFragment.this.getSafeResources().getDisplayMetrics());
        }

        public void setItems(ArrayList<BufferListEntry> items) {
            this.data = items;
        }

        public void updateBuffer(BuffersDataSource.Buffer b) {
            block42: {
                block35: {
                    block40: {
                        BufferListEntry j;
                        int pos;
                        block41: {
                            BufferListEntry e;
                            block39: {
                                block38: {
                                    int highlights;
                                    block37: {
                                        block36: {
                                            pos = this.positionForBid(b.bid);
                                            if (pos < 0 || this.data == null || pos >= this.data.size()) break block35;
                                            e = this.data.get(pos);
                                            JSONObject channelDisabledMap = null;
                                            JSONObject bufferDisabledMap = null;
                                            if (BuffersListFragment.this.conn != null && BuffersListFragment.this.conn.getUserInfo() != null && BuffersListFragment.this.conn.getUserInfo().prefs != null) {
                                                try {
                                                    if (BuffersListFragment.this.conn.getUserInfo().prefs.has("channel-disableTrackUnread")) {
                                                        channelDisabledMap = BuffersListFragment.this.conn.getUserInfo().prefs.getJSONObject("channel-disableTrackUnread");
                                                    }
                                                    if (BuffersListFragment.this.conn.getUserInfo().prefs.has("buffer-disableTrackUnread")) {
                                                        bufferDisabledMap = BuffersListFragment.this.conn.getUserInfo().prefs.getJSONObject("buffer-disableTrackUnread");
                                                    }
                                                }
                                                catch (JSONException e1) {
                                                    e1.printStackTrace();
                                                }
                                            }
                                            int unread = 0;
                                            highlights = 0;
                                            if (BuffersListFragment.this.conn.getState() == 2 && BuffersListFragment.this.conn.ready) {
                                                unread = b.unread;
                                                highlights = b.highlights;
                                            }
                                            try {
                                                if (b.type.equalsIgnoreCase("channel")) {
                                                    if (b.bid == BuffersListFragment.this.selected_bid || channelDisabledMap != null && channelDisabledMap.has(String.valueOf(b.bid)) && channelDisabledMap.getBoolean(String.valueOf(b.bid))) {
                                                        unread = 0;
                                                    }
                                                    if (b.bid == BuffersListFragment.this.selected_bid) {
                                                        highlights = 0;
                                                    }
                                                } else {
                                                    if (b.bid == BuffersListFragment.this.selected_bid || bufferDisabledMap != null && bufferDisabledMap.has(String.valueOf(b.bid)) && bufferDisabledMap.getBoolean(String.valueOf(b.bid))) {
                                                        unread = 0;
                                                    }
                                                    if (b.bid == BuffersListFragment.this.selected_bid || b.type.equalsIgnoreCase("conversation") && bufferDisabledMap != null && bufferDisabledMap.has(String.valueOf(b.bid)) && bufferDisabledMap.getBoolean(String.valueOf(b.bid))) {
                                                        highlights = 0;
                                                    }
                                                }
                                            }
                                            catch (JSONException e1) {
                                                e1.printStackTrace();
                                            }
                                            e.unread = unread;
                                            e.highlights = highlights;
                                            ServersDataSource.Server s = ServersDataSource.getInstance().getServer(e.cid);
                                            if (s != null) {
                                                e.status = s.status;
                                                e.fail_info = s.fail_info;
                                            }
                                            if (b.type.equalsIgnoreCase("channel")) {
                                                ChannelsDataSource.Channel c = ChannelsDataSource.getInstance().getChannelForBuffer(b.bid);
                                                if (c == null) {
                                                    e.joined = 0;
                                                    e.key = 0;
                                                } else {
                                                    e.key = c.key ? 1 : 0;
                                                }
                                            }
                                            if (unread <= 0) break block36;
                                            if (BuffersListFragment.this.firstUnreadPosition == -1 || BuffersListFragment.this.firstUnreadPosition > pos) {
                                                BuffersListFragment.this.firstUnreadPosition = pos;
                                            }
                                            if (BuffersListFragment.this.lastUnreadPosition != -1 && BuffersListFragment.this.lastUnreadPosition >= pos) break block37;
                                            BuffersListFragment.this.lastUnreadPosition = pos;
                                            break block37;
                                        }
                                        if (BuffersListFragment.this.firstUnreadPosition == pos) {
                                            BuffersListFragment.this.firstUnreadPosition = -1;
                                            for (int i = 0; i < this.data.size(); ++i) {
                                                if (this.data.get((int)i).unread <= 0) continue;
                                                BuffersListFragment.this.firstUnreadPosition = i;
                                                break;
                                            }
                                        }
                                        if (BuffersListFragment.this.lastUnreadPosition == pos) {
                                            BuffersListFragment.this.lastUnreadPosition = -1;
                                            for (int i = pos; i >= 0; --i) {
                                                if (this.data.get((int)i).unread <= 0) continue;
                                                BuffersListFragment.this.lastUnreadPosition = i;
                                                break;
                                            }
                                        }
                                    }
                                    if (highlights <= 0) break block38;
                                    if (BuffersListFragment.this.firstHighlightPosition == -1 || BuffersListFragment.this.firstHighlightPosition > pos) {
                                        BuffersListFragment.this.firstHighlightPosition = pos;
                                    }
                                    if (BuffersListFragment.this.lastHighlightPosition != -1 && BuffersListFragment.this.lastHighlightPosition >= pos) break block39;
                                    BuffersListFragment.this.lastHighlightPosition = pos;
                                    break block39;
                                }
                                if (BuffersListFragment.this.firstHighlightPosition == pos) {
                                    BuffersListFragment.this.firstHighlightPosition = -1;
                                    for (int i = 0; i < this.data.size(); ++i) {
                                        if (this.data.get((int)i).highlights <= 0) continue;
                                        BuffersListFragment.this.firstHighlightPosition = i;
                                        break;
                                    }
                                }
                                if (BuffersListFragment.this.lastHighlightPosition == pos) {
                                    BuffersListFragment.this.lastHighlightPosition = -1;
                                    for (int i = pos; i >= 0; --i) {
                                        if (this.data.get((int)i).highlights <= 0) continue;
                                        BuffersListFragment.this.lastHighlightPosition = i;
                                        break;
                                    }
                                }
                            }
                            if (e.type != 0) break block40;
                            if (e.fail_info == null || !e.fail_info.has("type")) break block41;
                            if (BuffersListFragment.this.firstFailurePosition == -1 || BuffersListFragment.this.firstFailurePosition > pos) {
                                BuffersListFragment.this.firstFailurePosition = pos;
                            }
                            if (BuffersListFragment.this.lastFailurePosition != -1 && BuffersListFragment.this.lastFailurePosition >= pos) break block40;
                            BuffersListFragment.this.lastFailurePosition = pos;
                            break block40;
                        }
                        if (BuffersListFragment.this.firstFailurePosition == pos) {
                            BuffersListFragment.this.firstFailurePosition = -1;
                            for (int i = 0; i < this.data.size(); ++i) {
                                j = this.data.get(i);
                                if (j.type != 0 || j.fail_info == null || !j.fail_info.has("type")) continue;
                                BuffersListFragment.this.firstFailurePosition = i;
                                break;
                            }
                        }
                        if (BuffersListFragment.this.lastFailurePosition == pos) {
                            BuffersListFragment.this.lastFailurePosition = -1;
                            for (int i = pos; i >= 0; --i) {
                                j = this.data.get(i);
                                if (j.type != 0 || j.fail_info == null || !j.fail_info.has("type")) continue;
                                BuffersListFragment.this.lastFailurePosition = i;
                                break;
                            }
                        }
                    }
                    if (BuffersListFragment.this.getActivity() != null) {
                        BuffersListFragment.this.getActivity().runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                BufferListAdapter.this.notifyDataSetChanged();
                                if (BuffersListFragment.this.listView != null) {
                                    BuffersListFragment.this.updateUnreadIndicators(BuffersListFragment.this.listView.getFirstVisiblePosition(), BuffersListFragment.this.listView.getLastVisiblePosition());
                                }
                            }
                        });
                    }
                    break block42;
                }
                if (BuffersListFragment.this.getActivity() != null) {
                    BuffersListFragment.this.getActivity().runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            BuffersListFragment.this.refresh();
                        }
                    });
                }
            }
        }

        int unreadPositionAbove(int pos) {
            if (pos > 0) {
                for (int i = pos - 1; i >= 0; --i) {
                    BufferListEntry e = this.data.get(i);
                    if (e.unread <= 0 && e.highlights <= 0 && (e.type != 0 || e.fail_info == null || !e.fail_info.has("type"))) continue;
                    return i;
                }
            }
            return 0;
        }

        int unreadPositionBelow(int pos) {
            if (pos >= 0) {
                for (int i = pos; i < this.data.size(); ++i) {
                    BufferListEntry e = this.data.get(i);
                    if (e.unread <= 0 && e.highlights <= 0 && (e.type != 0 || e.fail_info == null || !e.fail_info.has("type"))) continue;
                    return i;
                }
            }
            return this.data.size() - 1;
        }

        public BufferListEntry buildItem(int cid, int bid, int type, String name, int key, int unread, int highlights, long last_seen_eid, long min_eid, int joined, int archived, String status, int timeout, int ssl, int count, String contentDescription, JsonNode fail_info) {
            BufferListEntry e = new BufferListEntry();
            e.cid = cid;
            e.bid = bid;
            e.type = type;
            e.name = name;
            e.key = key;
            e.unread = unread;
            e.highlights = highlights;
            e.last_seen_eid = last_seen_eid;
            e.min_eid = min_eid;
            e.joined = joined;
            e.archived = archived;
            e.status = status;
            e.timeout = timeout;
            e.ssl = ssl;
            e.count = count;
            e.contentDescription = contentDescription;
            e.fail_info = fail_info;
            return e;
        }

        public int getCount() {
            return this.data.size();
        }

        public Object getItem(int position) {
            if (position < this.data.size()) {
                return this.data.get(position);
            }
            return null;
        }

        public long getItemId(int position) {
            if (position < this.data.size()) {
                BufferListEntry e = this.data.get(position);
                return e.bid;
            }
            return -1L;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            LinearLayout.LayoutParams lp;
            ViewHolder holder;
            BufferListEntry e = this.data.get(position);
            View row = convertView;
            if (row == null) {
                LayoutInflater inflater = this.ctx.getLayoutInflater(null);
                row = inflater.inflate(2130903116, null);
                holder = new ViewHolder();
                holder.label = (TextView)row.findViewById(2131624189);
                holder.highlights = (TextView)row.findViewById(2131624190);
                holder.unread = (LinearLayout)row.findViewById(2131624090);
                holder.bufferbg = (LinearLayout)row.findViewById(2131624188);
                holder.icon = (ImageView)row.findViewById(2131623993);
                holder.progress = (ProgressBar)row.findViewById(2131624191);
                holder.addBtn = (ImageButton)row.findViewById(2131624088);
                holder.type = e.type;
                row.setTag((Object)holder);
            } else {
                holder = (ViewHolder)row.getTag();
            }
            row.setContentDescription((CharSequence)e.contentDescription);
            holder.label.setText((CharSequence)e.name);
            if (e.type == 3) {
                holder.label.setTypeface(null);
                holder.label.setTextColor(BuffersListFragment.this.getSafeResources().getColorStateList(2131492970));
                holder.unread.setBackgroundDrawable(null);
            } else if (e.type == 4) {
                holder.label.setTypeface(null);
                holder.label.setTextColor(BuffersListFragment.this.getSafeResources().getColorStateList(2131492974));
                holder.unread.setBackgroundDrawable(null);
            } else if (e.archived == 1 && holder.bufferbg != null) {
                holder.label.setTypeface(null);
                holder.label.setTextColor(BuffersListFragment.this.getSafeResources().getColorStateList(2131492969));
                holder.unread.setBackgroundDrawable(null);
            } else if (e.type == 1 && e.joined == 0 || !e.status.equals("connected_ready")) {
                if (BuffersListFragment.this.selected_bid == e.bid) {
                    holder.label.setTypeface(null, 1);
                    holder.unread.setBackgroundResource(2130837731);
                } else {
                    holder.label.setTypeface(null);
                    holder.unread.setBackgroundDrawable(null);
                }
                holder.label.setTextColor(BuffersListFragment.this.getSafeResources().getColorStateList(2131492973));
            } else if (e.unread > 0 && !BuffersListFragment.this.readOnly || BuffersListFragment.this.selected_bid == e.bid) {
                holder.label.setTypeface(null, 1);
                holder.label.setTextColor(BuffersListFragment.this.getSafeResources().getColorStateList(2131492975));
                holder.unread.setBackgroundResource(2130837731);
                row.setContentDescription((CharSequence)(row.getContentDescription() + ", unread"));
            } else {
                holder.label.setTypeface(null);
                holder.label.setTextColor(BuffersListFragment.this.getSafeResources().getColorStateList(2131492968));
                holder.unread.setBackgroundDrawable(null);
            }
            if (holder.icon != null) {
                if (e.type == 4) {
                    holder.icon.setImageResource(2130837567);
                    holder.icon.setVisibility(0);
                } else if (e.type == 5) {
                    holder.icon.setImageResource(2130837707);
                    holder.icon.setVisibility(0);
                } else if (e.type == 6) {
                    holder.icon.setImageResource(2130837676);
                    holder.icon.setVisibility(0);
                } else if (e.type == 0) {
                    if (e.ssl > 0) {
                        holder.icon.setImageResource(2130837708);
                    } else {
                        holder.icon.setImageResource(2130837706);
                    }
                    holder.icon.setVisibility(0);
                } else if (e.key > 0) {
                    holder.icon.setImageResource(2130837631);
                    holder.icon.setVisibility(0);
                } else {
                    holder.icon.setVisibility(4);
                }
            }
            if (holder.progress != null) {
                if (this.progressRow == position || e.timeout > 0 || e.type == 0 && !e.status.equals("connected_ready") && !e.status.equals("quitting") && !e.status.equals("disconnected")) {
                    if (BuffersListFragment.this.selected_bid == -1 || this.progressRow != position) {
                        holder.progress.setVisibility(0);
                        if (holder.bufferbg != null) {
                            holder.bufferbg.setSelected(false);
                        }
                    } else {
                        if (holder.bufferbg != null) {
                            holder.bufferbg.setSelected(true);
                        }
                        holder.progress.setVisibility(8);
                    }
                } else {
                    holder.progress.setVisibility(8);
                    if (e.type != 3 && holder.bufferbg != null) {
                        holder.bufferbg.setSelected(false);
                    }
                }
            }
            if (holder.bufferbg != null) {
                if (e.type == 3) {
                    if (BuffersListFragment.this.mExpandArchives.get(e.cid, false)) {
                        holder.bufferbg.setBackgroundResource(2130837681);
                        holder.bufferbg.setSelected(true);
                        row.setContentDescription((CharSequence)(e.contentDescription + ". Double-tap to collapse."));
                    } else {
                        holder.bufferbg.setBackgroundResource(2130837680);
                        holder.bufferbg.setSelected(false);
                        row.setContentDescription((CharSequence)(e.contentDescription + ". Double-tap to expand."));
                    }
                } else if (e.type == 0) {
                    if (e.status.equals("waiting_to_retry") || e.status.equals("pool_unavailable") || e.status.equals("disconnected") && e.fail_info != null && e.fail_info.has("type")) {
                        holder.bufferbg.setBackgroundResource(2130837689);
                        holder.label.setTextColor(BuffersListFragment.this.getSafeResources().getColorStateList(2131492972));
                        if (e.bid == BuffersListFragment.this.selected_bid) {
                            holder.unread.setBackgroundResource(2130837733);
                        }
                    } else {
                        holder.bufferbg.setBackgroundResource(2130837685);
                        if (e.status.equals("connected_ready")) {
                            holder.label.setTextColor(BuffersListFragment.this.getSafeResources().getColorStateList(2131492968));
                        } else {
                            holder.label.setTextColor(BuffersListFragment.this.getSafeResources().getColorStateList(2131492973));
                        }
                    }
                } else if (e.type == 5 || e.type == 6) {
                    holder.bufferbg.setBackgroundResource(2130837685);
                } else if (e.type == 4) {
                    holder.bufferbg.setBackgroundResource(2130837683);
                } else if (e.archived == 1) {
                    holder.bufferbg.setBackgroundResource(2130837681);
                } else {
                    holder.bufferbg.setBackgroundResource(2130837680);
                }
            }
            if (holder.highlights != null) {
                if (e.highlights > 0) {
                    holder.highlights.setVisibility(0);
                    holder.highlights.setText((CharSequence)String.valueOf(e.highlights));
                    row.setContentDescription((CharSequence)(row.getContentDescription() + ", " + e.highlights + " highlights"));
                } else {
                    holder.highlights.setVisibility(8);
                    holder.highlights.setText((CharSequence)"");
                }
            }
            if (holder.addBtn != null) {
                if (e.count > 1 && !BuffersListFragment.this.readOnly) {
                    holder.addBtn.setVisibility(0);
                    holder.addBtn.setTag((Object)e);
                    holder.addBtn.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            BufferListEntry e = (BufferListEntry)v.getTag();
                            AddChannelFragment newFragment = new AddChannelFragment();
                            newFragment.setDefaultCid(e.cid);
                            newFragment.show(BuffersListFragment.this.getActivity().getSupportFragmentManager(), "dialog");
                            BuffersListFragment.this.mListener.addButtonPressed(e.cid);
                        }
                    });
                } else {
                    holder.addBtn.setVisibility(8);
                }
            }
            if ((lp = (LinearLayout.LayoutParams)holder.unread.getLayoutParams()) != null) {
                if (e.type == 0 || e.type == 5 || e.type == 6) {
                    lp.setMargins(0, this.eightdp, this.eightdp, 0);
                    row.setMinimumHeight(this.eightdp * 7);
                } else {
                    lp.setMargins(0, 0, this.eightdp, 0);
                    row.setMinimumHeight(this.eightdp * 6);
                }
                holder.unread.setLayoutParams((ViewGroup.LayoutParams)lp);
            }
            return row;
        }

        private class ViewHolder {
            int type;
            TextView label;
            TextView highlights;
            LinearLayout unread;
            LinearLayout bufferbg;
            ImageView icon;
            ProgressBar progress;
            ImageButton addBtn;

            private ViewHolder() {
            }
        }
    }

    private static class BufferListEntry
    implements Serializable {
        private static final long serialVersionUID = 1848168221883194028L;
        int cid;
        int bid;
        int type;
        int unread;
        int highlights;
        int key;
        long last_seen_eid;
        long min_eid;
        int joined;
        int archived;
        int timeout;
        String name;
        String status;
        JsonNode fail_info;
        int ssl;
        int count;
        String contentDescription;

        private BufferListEntry() {
        }
    }
}

